import * as ecs from 'aws-cdk-lib/aws-ecs';
import { Construct } from 'constructs';
import * as agent from './ecs-cloudwatch-agent';
import * as sdk from './ecs-sdk-instrumentation';
import * as inst from './instrumentation-versions';
/**
 * Interface for instrumentation properties.
 */
export interface InstrumentationProps {
    /**
     * The version of the instrumentation.
     */
    readonly sdkVersion: inst.InstrumentationVersion;
    /**
     * The runtime platform of the instrumentation.
     *
     * @default - the runtime platform specified through the input TaskDefinition.
     */
    readonly runtimePlatform?: ecs.RuntimePlatform;
}
/**
 * Interface for Application Signals properties.
 */
export interface ApplicationSignalsIntegrationProps {
    /**
     * The name of the service.
     *
     * @default - task definition family name
     */
    readonly serviceName?: string;
    /**
     * The task definition to integrate Application Signals into.
     *
     * [disable-awslint:ref-via-interface]
     */
    readonly taskDefinition: ecs.TaskDefinition;
    /**
     * The instrumentation properties.
     */
    readonly instrumentation: InstrumentationProps;
    /**
     * The environment variables to override.
     *
     * @default - no environment variables to override.
     */
    readonly overrideEnvironments?: sdk.EnvironmentExtension[];
    /**
     * The CloudWatch Agent properties.
     *
     * @default - a basic agent sidecar container with latest public image
     */
    readonly cloudWatchAgentSidecar?: agent.CloudWatchAgentOptions;
}
/**
 * Class for integrating Application Signals into an ECS task definition.
 */
export declare class ApplicationSignalsIntegration extends Construct {
    private sdkInjector?;
    private mountVolumeName;
    private cloudWatchAgentSidecar?;
    constructor(scope: Construct, id: string, props: ApplicationSignalsIntegrationProps);
    private mutateTaskDefinition;
}
