"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudWatchAgentIntegration = exports.CloudWatchAgentVersion = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ecs = require("aws-cdk-lib/aws-ecs");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const constructs_1 = require("constructs");
/**
 * Provides version information and image selection for CloudWatch Agent.
 */
class CloudWatchAgentVersion {
    /**
     * Gets the appropriate CloudWatch Agent image based on the operating system.
     * @param operatingSystemFamily - The ECS operating system family
     * @returns The CloudWatch Agent image URI
     */
    static getCloudWatchAgentImage(operatingSystemFamily) {
        let cloudWatchAgentImage = CloudWatchAgentVersion.CLOUDWATCH_AGENT_IMAGE;
        if (operatingSystemFamily) {
            switch (operatingSystemFamily) {
                case ecs.OperatingSystemFamily.WINDOWS_SERVER_2019_CORE:
                case ecs.OperatingSystemFamily.WINDOWS_SERVER_2019_FULL:
                    cloudWatchAgentImage = CloudWatchAgentVersion.CLOUDWATCH_AGENT_IMAGE_WIN2019;
                    break;
                case ecs.OperatingSystemFamily.WINDOWS_SERVER_2022_CORE:
                case ecs.OperatingSystemFamily.WINDOWS_SERVER_2022_FULL:
                    cloudWatchAgentImage = CloudWatchAgentVersion.CLOUDWATCH_AGENT_IMAGE_WIN2022;
                    break;
            }
        }
        return cloudWatchAgentImage;
    }
}
exports.CloudWatchAgentVersion = CloudWatchAgentVersion;
_a = JSII_RTTI_SYMBOL_1;
CloudWatchAgentVersion[_a] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.CloudWatchAgentVersion", version: "2.209.1-alpha.0" };
/**
 * Default CloudWatch Agent image for Linux.
 */
CloudWatchAgentVersion.CLOUDWATCH_AGENT_IMAGE = 'public.ecr.aws/cloudwatch-agent/cloudwatch-agent:latest';
/**
 * CloudWatch Agent image for Windows Server 2019.
 */
CloudWatchAgentVersion.CLOUDWATCH_AGENT_IMAGE_WIN2019 = 'public.ecr.aws/cloudwatch-agent/cloudwatch-agent:latest-windowsservercore2019';
/**
 * CloudWatch Agent image for Windows Server 2022.
 */
CloudWatchAgentVersion.CLOUDWATCH_AGENT_IMAGE_WIN2022 = 'public.ecr.aws/cloudwatch-agent/cloudwatch-agent:latest-windowsservercore2022';
/**
 * A construct that adds CloudWatch Agent as a container to an ECS task definition.
 */
class CloudWatchAgentIntegration extends constructs_1.Construct {
    /**
     * Creates a new CloudWatch Agent integration.
     * @param scope - The construct scope
     * @param id - The construct ID
     * @param props - Configuration properties
     */
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationsignals_alpha_CloudWatchAgentIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CloudWatchAgentIntegration);
            }
            throw error;
        }
        props.taskDefinition.taskRole.addManagedPolicy(aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('CloudWatchAgentServerPolicy'));
        this.agentContainer = props.taskDefinition.addContainer(props.containerName, {
            image: ecs.ContainerImage.fromRegistry(CloudWatchAgentVersion.getCloudWatchAgentImage(props.operatingSystemFamily)),
            cpu: props.cpu,
            essential: props.essential ? props.essential : true,
            memoryLimitMiB: props.memoryLimitMiB,
            memoryReservationMiB: props.memoryReservationMiB,
            logging: props.enableLogging ? new ecs.AwsLogDriver({
                streamPrefix: props.containerName,
            }) : undefined,
            user: '0:1338',
            portMappings: props.portMappings,
            environment: {
                CW_CONFIG_CONTENT: props.agentConfig ? props.agentConfig : JSON.stringify(CloudWatchAgentIntegration.DEFAULT_CONFIG),
            },
        });
    }
}
exports.CloudWatchAgentIntegration = CloudWatchAgentIntegration;
_b = JSII_RTTI_SYMBOL_1;
CloudWatchAgentIntegration[_b] = { fqn: "@aws-cdk/aws-applicationsignals-alpha.CloudWatchAgentIntegration", version: "2.209.1-alpha.0" };
CloudWatchAgentIntegration.DEFAULT_CONFIG = {
    logs: {
        metrics_collected: {
            application_signals: {
                enabled: true,
            },
        },
    },
    traces: {
        traces_collected: {
            application_signals: {
                enabled: true,
            },
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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