# shrtcodes

![example workflow name](https://github.com/Peter554/shrtcodes/workflows/CI/badge.svg)

`pip install shrtcodes`

Simple shortcodes for Python.

## Example:

A toy example:

```
# example.txt
Hello!

{% img http://cutedogs.com/dog123.jpg "A very cute dog" %}

Foo bar baz...

{% repeat 3 %}
Woop
{% / %}

Bye!
```

```py
from shrtcodes import Shrtcodes


shortcodes = Shrtcodes()


@shortcodes.register_inline("img")
def handle_img(src, alt):
    return f'<img src="{src}" alt="{alt}"/>'


@shortcodes.register_block("repeat")
def handle_repeat(block, n):
    return block * int(n)


with open("example.txt") as f:
    print(shortcodes.process_text(f.read()))
```

Output:

```
Hello!

<img src="http://cutedogs.com/dog123.jpg" alt="A very cute dog"/>

Foo bar baz...

Woop
Woop
Woop

Bye!
```

A more useful example would be the generation of this README itself.
See [`/create_readme.py`](/create_readme.py) and [`/README.template.md`](/README.template.md).
