<a href="#readme">![Cactool](https://i.imgur.com/XooF3N8.png)</a>

# Cactool
<p align="center">
 <a href="https://badge.fury.io/py/Cactool">
  <img src="https://badge.fury.io/py/Cactool.svg" alt="PyPI version">
 </a>
  <a href="https://cactool.readthedocs.io">
  <img src="https://readthedocs.org/projects/cactool/badge/?version=latest&style=flat" alt="docs">
 </a>
  <a href="https://github.com/mkenney/software-guides/blob/master/STABILITY-BADGES.md#beta">
  <img src="https://img.shields.io/badge/stability-beta-33bbff.svg" alt="stability-beta">
 </a>
  <a href="">
  <img src="https://github.com/cactool/cactool/workflows/CodeQL/badge.svg" alt="CodeQL">
 </a>
 <a href="https://doi.org/10.5281/zenodo.6070205">
   <img src="https://zenodo.org/badge/DOI/10.5281/zenodo.6070205.svg" alt="DOI">
 </a>
</p>

# Introduction
Cactool is a platform developed for researchers to collaboratively and manually code pre-existing datasets of social media posts for content and discourse analysis. After the initial setup, getting started is easy: import a csv of social media URLs; set your coding variables; and grant access to your coders who can get started right away.
 
- **No more coding via spreadsheets** Coding is undertaken via your browser (tested working on Chrome, Firefox, Edge, & Safari) with posts visible as they would be on the social media platform. This allows your coders to evaluate social media content in their native format.
- **Simple Import and Export** Take your pre-existing social media URLs from software such as [NodeXL]( https://www.smrfoundation.org/nodexl/), or API Scrapers such as [Tweepy]( https://www.tweepy.org/) and import them as a CSV list. When done, you can export your data via CSV to whatever analysis software you desire.
- **Works for multiple social media platforms** Cactool currently works with URLs from Twitter, Instagram, YouTube, & TikTok.
- **Manage Multiple Datasets** Want to split your project by source/themes? You can manage multiple concurrent datasets at the same time.
- **Built for collaboration** Cactool comes pre-packaged with user management; codes attributed are attributed to each coder for coder reliability calculation (such as [ReCal](http://dfreelon.org/utils/recalfront/)). Multiple people can be coding at the same time without sharing documents. No need to worry about version control or splitting up data.
- **Code on the Go** Cactool is mobile friendly and can be accessed remotely (we recommend using a VPN to connect, see our tutorial for why). This provides researchers interested in social media content and spaciality new avenues of research.
 
# Documentation
Easy to follow installation instructions and user guides can be found via the documentation on [Read the Docs](https://cactool.readthedocs.io)

# Installation and usage
## 1. Install Cactool
```bash
pip install cactool
```
## 2. Start the website
```bash
cactool
```
# Credits
The project’s Principle Investigator is [Dr Liam McLoughlin]( https://www.research.manchester.ac.uk/portal/liam.mcloughlin.html), *Lecturer in Politics at the University of Manchester*, and the development was undertaken by [Sam Ezeh](https://github.com/dignissimus)
## Citations
### Bibtex
```bibtex
@software{McLoughlin_Ezeh_2022,
  title = {{Cactool: An easy way to collaboratively code social media posts for manual content and discourse analysis (BETA)}},
  author  = {McLoughlin, Liam and Ezeh, Sam},
  year  = {2022},
  doi = {10.5281/zenodo.6070206},
  url = {https://github.com/cactool/cactool},
  license = {MIT}
}
```
### APA
```
McLoughlin, L., & Ezeh, S. (2022). Cactool: An easy way to collaboratively code social media posts for manual content and discourse analysis (BETA). [Computer software]. URL:https://github.com/cactool/cactool
```

# Images
![projects](https://user-images.githubusercontent.com/18627392/149658748-f480a750-2a05-4aad-83bd-c30cdbe86891.png)
