# generated by datamodel-codegen:
#   filename:  arbejdstimer-configuration-schema.json
#   timestamp: 2021-12-29T17:22:42+00:00

from __future__ import annotations

from datetime import date
from enum import Enum
from typing import Annotated, List, Optional

from pydantic import BaseModel, Field


class Application(Enum):
    arbejdstimer = 'arbejdstimer'


class Operator(Enum):
    and_ = 'and'
    or_ = 'or'
    xor = 'xor'


class WorkingHoursTypeItem(BaseModel):
    __root__: Annotated[int, Field(ge=0.0, le=23.0)]


class WorkingHoursType(BaseModel):
    __root__: Annotated[
        List[WorkingHoursTypeItem],
        Field(
            description='Inclusive range of 24 hour start and end integer values.',
            max_items=2,
            min_items=2,
            title='Working Hours',
        ),
    ]


class Dates(BaseModel):
    __root__: Annotated[
        List[date],
        Field(
            description='Two dates are an inclusive range and 1, 3, or more dates represent a set of dates.',
            min_items=1,
            title='Dates - Range or Set',
        ),
    ]


class HolidaysTypeItem(BaseModel):
    label: Annotated[Optional[str], Field(examples=['public holiday'])] = ''
    at: Dates


class HolidaysType(BaseModel):
    __root__: Annotated[
        List[HolidaysTypeItem],
        Field(
            description='Optionally labeled dates of non-working days.',
            min_items=0,
            title='Holidays',
        ),
    ]


class Arbejdstimer(BaseModel):
    api: Annotated[
        Optional[int],
        Field(
            description='API version of the application this configuration targets.',
            title='API Version',
        ),
    ] = 1
    application: Annotated[
        Optional[Application],
        Field(
            description='Name of the application this configuration targets.',
            title='Application Name',
        ),
    ] = 'arbejdstimer'  # type: ignore
    operator: Annotated[
        Operator,
        Field(
            description='Logic combining the given specific values with the application defaults.',
            title='Logic for Combination with Default Values',
        ),
    ]
    holidays: Optional[HolidaysType] = None
    working_hours: Optional[WorkingHoursType] = None
