"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaitForResourceSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const non_retriable_exception_1 = require("../../domain/non-retriable-exception");
const assert_aws_resource_simulation_1 = require("./assert-aws-resource-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep impl for aws:waitForAwsResourceProperty
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-waitForAwsResourceProperty.html
 */
class WaitForResourceSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:waitForAwsResourceProperty';
        this.waitForResourceStep = step;
        this.props = props;
    }
    /**
     * As is the case in an SSM Automation execution, this will continue to sleep/execute until desired value is found.
     * This function will throw if the timeoutSeconds is exceeded and the desired value is still not received from AWS.
     */
    executeStep(inputs) {
        var lastError = undefined;
        for (var endTime = Date.now() + this.waitForResourceStep.timeoutSeconds * 1000; endTime > Date.now();) {
            try {
                return new assert_aws_resource_simulation_1.AssertAwsResourceSimulation(this.waitForResourceStep, this.props).executeStep(inputs);
            }
            catch (error) {
                if (error instanceof non_retriable_exception_1.NonRetriableException) {
                    throw error;
                }
                console.log(`Received exception when hitting AWS API ${this.waitForResourceStep.service.namespace}.${this.waitForResourceStep.pascalCaseApi}. ` +
                    `Will try again in ${this.waitForResourceStep.sleepIntervalMillis} millis: ${JSON.stringify(error.message)}`);
                lastError = error;
                if (endTime > Date.now()) {
                    this.props.sleepHook.sleep(this.waitForResourceStep.sleepIntervalMillis);
                }
            }
        }
        if (lastError != undefined) {
            throw new Error(lastError.message);
        }
        throw new Error('Execution time exceeded timeout: timeout set to '
            + this.waitForResourceStep.timeoutSeconds + ' but did not get desired response in that time.');
    }
}
exports.WaitForResourceSimulation = WaitForResourceSimulation;
_a = JSII_RTTI_SYMBOL_1;
WaitForResourceSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.WaitForResourceSimulation", version: "0.0.29" };
//# sourceMappingURL=data:application/json;base64,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