"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvokeWebhookSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation for [aws:invokeWebhook](https://docs.aws.amazon.com/systems-manager/latest/userguide/invoke-webhook.html)
 */
class InvokeWebhookSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:invokeWebhook';
        this.invokeWebhookStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const integrationName = this.invokeWebhookStep.integrationName.resolveToString(inputs);
        const body = this.invokeWebhookStep.body?.resolveToString(inputs);
        const result = this.props.webhook.invoke({
            integrationName: integrationName,
            body: body,
        });
        return {
            Response: result.response,
            ResponseCode: result.responseCode,
        };
    }
}
exports.InvokeWebhookSimulation = InvokeWebhookSimulation;
_a = JSII_RTTI_SYMBOL_1;
InvokeWebhookSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.InvokeWebhookSimulation", version: "0.0.29" };
//# sourceMappingURL=data:application/json;base64,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