import { AutomationStep } from '../../parent-steps/automation-step';
import { BranchStep } from '../../parent-steps/automation/branch-step';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * AutomationStep implementation of aws:branch
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-branch.html
 */
export declare class BranchSimulation extends AutomationSimulationBase {
    readonly action: string;
    private branchStep;
    constructor(step: BranchStep);
    /**
       * Overrides invoke because control flow of execution is different than standard steps.
       * Will traverse the choices until one evaluated to true; will skip to that choice.
       */
    nextStep(inputs: Record<string, any>): AutomationStep | undefined;
    private findStep;
    private getFallbackStep;
    /**
       * noop. The logic performed in the branch branchStep happens in the invoke() function.
       */
    executeStep(_inputs: {
        [name: string]: any;
    }): {
        [name: string]: any;
    };
}
