import { IApproveHook } from '../../interface/approve-hook';
import { ApproveStep } from '../../parent-steps/automation/approve-step';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * Properties for ApproveStep
 */
export interface ApproveSimulationProps {
    /**
       * (Optional) Approve hook to be called to pause the execution.
       * To mock this implementation either inject an instance of IApproveHook or use the provided MockApprove class.
       * @default ApproveHook instance. ApproveHook may not work in exported JSII languages. Override interface as needed.
       */
    readonly approveHook: IApproveHook;
}
/**
 * AutomationStep implementation for aws:approve
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-approve.html
 */
export declare class ApproveSimulation extends AutomationSimulationBase {
    readonly action = "aws:approve";
    readonly approveHook: IApproveHook;
    private approveStep;
    constructor(step: ApproveStep, props: ApproveSimulationProps);
    /**
       * May perform a real approval ask based on the params used during instance creation.
       */
    executeStep(inputs: Record<string, any>): Record<string, any>;
    private requestApproval;
    /**
       * Override to mock the date the reviewer approved
       */
    protected provideDate(): Date;
}
