import { Construct } from 'constructs';
import { Platform } from '../../domain/platform';
import { IRunDocumentLocation } from '../../interface/run-document-location';
import { IStringMapVariable } from '../../interface/variables/string-map-variable';
import { CommandStep, CommandStepProps } from '../command-step';
/**
 * Properties for Run Document step
 */
export interface RunDocumentStepProps extends CommandStepProps {
    /**
     * Document info containing document type and document path.
     * Can be of type LocalRunDocument or SsmRunDocument.
     */
    readonly stepDocument: IRunDocumentLocation;
    /**
     * Parameters for the document.
     */
    readonly documentParameters?: IStringMapVariable;
}
/**
 * CommandStep implementation for aws:runDocument
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-rundocument
 */
export declare class RunDocumentStep extends CommandStep {
    readonly stepDocument: IRunDocumentLocation;
    readonly documentParameters?: IStringMapVariable;
    readonly platforms: Platform[];
    readonly action = "aws:runDocument";
    constructor(scope: Construct, id: string, props: RunDocumentStepProps);
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
