# coding: utf-8

"""
    Arm API

       This documents the Arm Virtual Hosting REST API.  For other examples and API clients such as python or javascript please see [API Clients (python/javascript)](https://github.com/ARM-software/avh-api).   For a guide on using this interface please see [API Quickstart](https://intercom.help/arm-avh/en/articles/6134791-quickstart-for-the-api-docs)   ## Links   - [API Quickstart](https://intercom.help/arm-avh/en/articles/6134791-quickstart-for-the-api-docs)   - [API Clients (python/javascript)](https://github.com/arm-software/avh-api)     # noqa: E501

    The version of the OpenAPI document: 3.15.0-15704
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from avh_api_async.configuration import Configuration


class KernelTask(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'kernel_id': 'str',
        'name': 'str',
        'pid': 'int',
        'threads': 'list[KernelThread]'
    }

    attribute_map = {
        'kernel_id': 'kernelId',
        'name': 'name',
        'pid': 'pid',
        'threads': 'threads'
    }

    def __init__(self, kernel_id=None, name=None, pid=None, threads=None, local_vars_configuration=None):  # noqa: E501
        """KernelTask - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._kernel_id = None
        self._name = None
        self._pid = None
        self._threads = None
        self.discriminator = None

        self.kernel_id = kernel_id
        self.name = name
        self.pid = pid
        self.threads = threads

    @property
    def kernel_id(self):
        """Gets the kernel_id of this KernelTask.  # noqa: E501

        Kernel Task ID  # noqa: E501

        :return: The kernel_id of this KernelTask.  # noqa: E501
        :rtype: str
        """
        return self._kernel_id

    @kernel_id.setter
    def kernel_id(self, kernel_id):
        """Sets the kernel_id of this KernelTask.

        Kernel Task ID  # noqa: E501

        :param kernel_id: The kernel_id of this KernelTask.  # noqa: E501
        :type kernel_id: str
        """

        self._kernel_id = kernel_id

    @property
    def name(self):
        """Gets the name of this KernelTask.  # noqa: E501

        Thread name  # noqa: E501

        :return: The name of this KernelTask.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this KernelTask.

        Thread name  # noqa: E501

        :param name: The name of this KernelTask.  # noqa: E501
        :type name: str
        """

        self._name = name

    @property
    def pid(self):
        """Gets the pid of this KernelTask.  # noqa: E501

        Process ID of task  # noqa: E501

        :return: The pid of this KernelTask.  # noqa: E501
        :rtype: int
        """
        return self._pid

    @pid.setter
    def pid(self, pid):
        """Sets the pid of this KernelTask.

        Process ID of task  # noqa: E501

        :param pid: The pid of this KernelTask.  # noqa: E501
        :type pid: int
        """

        self._pid = pid

    @property
    def threads(self):
        """Gets the threads of this KernelTask.  # noqa: E501

          # noqa: E501

        :return: The threads of this KernelTask.  # noqa: E501
        :rtype: list[KernelThread]
        """
        return self._threads

    @threads.setter
    def threads(self, threads):
        """Sets the threads of this KernelTask.

          # noqa: E501

        :param threads: The threads of this KernelTask.  # noqa: E501
        :type threads: list[KernelThread]
        """

        self._threads = threads

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KernelTask):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, KernelTask):
            return True

        return self.to_dict() != other.to_dict()
