# coding: utf-8

"""
    Arm API

       This documents the Arm Virtual Hosting REST API.  For other examples and API clients such as python or javascript please see [API Clients (python/javascript)](https://github.com/ARM-software/avh-api).   For a guide on using this interface please see [API Quickstart](https://intercom.help/arm-avh/en/articles/6134791-quickstart-for-the-api-docs)   ## Links   - [API Quickstart](https://intercom.help/arm-avh/en/articles/6134791-quickstart-for-the-api-docs)   - [API Clients (python/javascript)](https://github.com/arm-software/avh-api)     # noqa: E501

    The version of the OpenAPI document: 3.15.0-15704
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from avh_api_async.configuration import Configuration


class Extension(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'identifier': 'str',
        'enabled': 'bool',
        'created_at': 'str',
        'updated_at': 'str',
        'image_id': 'str',
        'state': 'str',
        'flavors': 'list[object]'
    }

    attribute_map = {
        'identifier': 'identifier',
        'enabled': 'enabled',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'image_id': 'imageId',
        'state': 'state',
        'flavors': 'flavors'
    }

    def __init__(self, identifier=None, enabled=None, created_at=None, updated_at=None, image_id=None, state=None, flavors=None, local_vars_configuration=None):  # noqa: E501
        """Extension - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._identifier = None
        self._enabled = None
        self._created_at = None
        self._updated_at = None
        self._image_id = None
        self._state = None
        self._flavors = None
        self.discriminator = None

        self.identifier = identifier
        self.enabled = enabled
        self.created_at = created_at
        self.updated_at = updated_at
        self.image_id = image_id
        self.state = state
        self.flavors = flavors

    @property
    def identifier(self):
        """Gets the identifier of this Extension.  # noqa: E501

        Identifier  # noqa: E501

        :return: The identifier of this Extension.  # noqa: E501
        :rtype: str
        """
        return self._identifier

    @identifier.setter
    def identifier(self, identifier):
        """Sets the identifier of this Extension.

        Identifier  # noqa: E501

        :param identifier: The identifier of this Extension.  # noqa: E501
        :type identifier: str
        """

        self._identifier = identifier

    @property
    def enabled(self):
        """Gets the enabled of this Extension.  # noqa: E501

        If true, instances requiring this extension can be created or started  # noqa: E501

        :return: The enabled of this Extension.  # noqa: E501
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """Sets the enabled of this Extension.

        If true, instances requiring this extension can be created or started  # noqa: E501

        :param enabled: The enabled of this Extension.  # noqa: E501
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def created_at(self):
        """Gets the created_at of this Extension.  # noqa: E501

        Created Date in ISO-8601 format e.g. 2022-05-06T02:39:23.000Z  # noqa: E501

        :return: The created_at of this Extension.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Extension.

        Created Date in ISO-8601 format e.g. 2022-05-06T02:39:23.000Z  # noqa: E501

        :param created_at: The created_at of this Extension.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Extension.  # noqa: E501

        Updated Date in ISO-8601 format e.g. 2022-05-06T02:39:23.000Z  # noqa: E501

        :return: The updated_at of this Extension.  # noqa: E501
        :rtype: str
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Extension.

        Updated Date in ISO-8601 format e.g. 2022-05-06T02:39:23.000Z  # noqa: E501

        :param updated_at: The updated_at of this Extension.  # noqa: E501
        :type updated_at: str
        """

        self._updated_at = updated_at

    @property
    def image_id(self):
        """Gets the image_id of this Extension.  # noqa: E501

        Image Id  # noqa: E501

        :return: The image_id of this Extension.  # noqa: E501
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this Extension.

        Image Id  # noqa: E501

        :param image_id: The image_id of this Extension.  # noqa: E501
        :type image_id: str
        """

        self._image_id = image_id

    @property
    def state(self):
        """Gets the state of this Extension.  # noqa: E501

        State  # noqa: E501

        :return: The state of this Extension.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this Extension.

        State  # noqa: E501

        :param state: The state of this Extension.  # noqa: E501
        :type state: str
        """

        self._state = state

    @property
    def flavors(self):
        """Gets the flavors of this Extension.  # noqa: E501

        Array of Flavor definitions  # noqa: E501

        :return: The flavors of this Extension.  # noqa: E501
        :rtype: list[object]
        """
        return self._flavors

    @flavors.setter
    def flavors(self, flavors):
        """Sets the flavors of this Extension.

        Array of Flavor definitions  # noqa: E501

        :param flavors: The flavors of this Extension.  # noqa: E501
        :type flavors: list[object]
        """

        self._flavors = flavors

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Extension):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Extension):
            return True

        return self.to_dict() != other.to_dict()
