# avh-api-async

  This documents the Arm Virtual Hosting REST API.  For other examples and API clients such as python or javascript please see [API Clients (python/javascript)](https://github.com/ARM-software/avh-api).
  For a guide on using this interface please see [API Quickstart](https://intercom.help/arm-avh/en/articles/6134791-quickstart-for-the-api-docs)
  ## Links
  - [API Quickstart](https://intercom.help/arm-avh/en/articles/6134791-quickstart-for-the-api-docs)
  - [API Clients (python/javascript)](https://github.com/arm-software/avh-api)
  

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 3.15.0-15704
- Package version: 1.0.2
- Build package: org.openapitools.codegen.languages.PythonLegacyClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import avh_api_async
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import avh_api_async
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import avh_api_async
from avh_api_async.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://app.avh.arm.com/api
# See configuration.py for a list of all supported configuration parameters.
configuration = avh_api_async.Configuration(
    host = "https://app.avh.arm.com/api"
)



# Enter a context with an instance of the API client
with avh_api_async.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = avh_api_async.ArmApi(api_client)
    trial_email = 'trial_email_example' # str | Trial Email

    try:
        # Get Trial Status
        api_response = api_instance.trial_status(trial_email)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ArmApi->trial_status: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://app.avh.arm.com/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ArmApi* | [**trial_status**](docs/ArmApi.md#trial_status) | **GET** /v1/billing/trial-status/{trialEmail} | Get Trial Status
*ArmApi* | [**v1_add_project_key**](docs/ArmApi.md#v1_add_project_key) | **POST** /v1/projects/{projectId}/keys | Add Project Authorized Key
*ArmApi* | [**v1_add_team_role_to_project**](docs/ArmApi.md#v1_add_team_role_to_project) | **PUT** /v1/roles/projects/{projectId}/teams/{teamId}/roles/{roleId} | Add team role to project
*ArmApi* | [**v1_add_user_role_to_project**](docs/ArmApi.md#v1_add_user_role_to_project) | **PUT** /v1/roles/projects/{projectId}/users/{userId}/roles/{roleId} | Add user role to project
*ArmApi* | [**v1_add_user_to_team**](docs/ArmApi.md#v1_add_user_to_team) | **PUT** /v1/teams/{teamId}/users/{userId} | Add user to team
*ArmApi* | [**v1_auth_login**](docs/ArmApi.md#v1_auth_login) | **POST** /v1/auth/login | Log In
*ArmApi* | [**v1_btrace_preauthorize**](docs/ArmApi.md#v1_btrace_preauthorize) | **GET** /v1/instances/{instanceId}/btrace-authorize | Pre-authorize an btrace download
*ArmApi* | [**v1_clear_core_trace**](docs/ArmApi.md#v1_clear_core_trace) | **DELETE** /v1/instances/{instanceId}/strace | Clear CoreTrace logs
*ArmApi* | [**v1_clear_hyper_trace**](docs/ArmApi.md#v1_clear_hyper_trace) | **DELETE** /v1/instances/{instanceId}/btrace | Clear HyperTrace logs
*ArmApi* | [**v1_clear_hyper_trace_hooks**](docs/ArmApi.md#v1_clear_hyper_trace_hooks) | **POST** /v1/instances/{instanceId}/hooks/clear | Clear Hooks on an instance
*ArmApi* | [**v1_clear_instance_panics**](docs/ArmApi.md#v1_clear_instance_panics) | **DELETE** /v1/instances/{instanceId}/panics | Clear Panics
*ArmApi* | [**v1_create_hook**](docs/ArmApi.md#v1_create_hook) | **POST** /v1/instances/{instanceId}/hooks | Create hypervisor hook for Instance
*ArmApi* | [**v1_create_image**](docs/ArmApi.md#v1_create_image) | **POST** /v1/images | Create a new Image
*ArmApi* | [**v1_create_instance**](docs/ArmApi.md#v1_create_instance) | **POST** /v1/instances | Create Instance
*ArmApi* | [**v1_create_project**](docs/ArmApi.md#v1_create_project) | **POST** /v1/projects | Create a Project
*ArmApi* | [**v1_create_snapshot**](docs/ArmApi.md#v1_create_snapshot) | **POST** /v1/instances/{instanceId}/snapshots | Create Instance Snapshot
*ArmApi* | [**v1_create_subscriber_invite**](docs/ArmApi.md#v1_create_subscriber_invite) | **POST** /v1/billing/invites | Create Subscriber Invite
*ArmApi* | [**v1_delete_hook**](docs/ArmApi.md#v1_delete_hook) | **DELETE** /v1/hooks/{hookId} | Delete an existing hypervisor hook
*ArmApi* | [**v1_delete_image**](docs/ArmApi.md#v1_delete_image) | **DELETE** /v2/images/{imageId} | Delete Image
*ArmApi* | [**v1_delete_instance**](docs/ArmApi.md#v1_delete_instance) | **DELETE** /v1/instances/{instanceId} | Remove Instance
*ArmApi* | [**v1_delete_instance_snapshot**](docs/ArmApi.md#v1_delete_instance_snapshot) | **DELETE** /v1/instances/{instanceId}/snapshots/{snapshotId} | Delete a Snapshot
*ArmApi* | [**v1_delete_project**](docs/ArmApi.md#v1_delete_project) | **DELETE** /v1/projects/{projectId} | Delete a Project
*ArmApi* | [**v1_delete_snapshot**](docs/ArmApi.md#v1_delete_snapshot) | **DELETE** /v1/snapshots/{snapshotId} | Delete a Snapshot
*ArmApi* | [**v1_disable_expose_port**](docs/ArmApi.md#v1_disable_expose_port) | **POST** /v1/instances/{instanceId}/exposeport/disable | Disable an exposed port on an instance for device access.
*ArmApi* | [**v1_enable_expose_port**](docs/ArmApi.md#v1_enable_expose_port) | **POST** /v1/instances/{instanceId}/exposeport/enable | Enable an exposed port on an instance for device access.
*ArmApi* | [**v1_execute_hyper_trace_hooks**](docs/ArmApi.md#v1_execute_hyper_trace_hooks) | **POST** /v1/instances/{instanceId}/hooks/execute | Execute Hooks on an instance
*ArmApi* | [**v1_get_hook_by_id**](docs/ArmApi.md#v1_get_hook_by_id) | **GET** /v1/hooks/{hookId} | Get hypervisor hook by id
*ArmApi* | [**v1_get_hooks**](docs/ArmApi.md#v1_get_hooks) | **GET** /v1/instances/{instanceId}/hooks | Get all hypervisor hooks for Instance
*ArmApi* | [**v1_get_image**](docs/ArmApi.md#v1_get_image) | **GET** /v1/images/{imageId} | Get Image Metadata
*ArmApi* | [**v1_get_images**](docs/ArmApi.md#v1_get_images) | **GET** /v1/images | Get all Images Metadata
*ArmApi* | [**v1_get_instance**](docs/ArmApi.md#v1_get_instance) | **GET** /v1/instances/{instanceId} | Get Instance
*ArmApi* | [**v1_get_instance_console**](docs/ArmApi.md#v1_get_instance_console) | **GET** /v1/instances/{instanceId}/console | Get console websocket URL
*ArmApi* | [**v1_get_instance_console_log**](docs/ArmApi.md#v1_get_instance_console_log) | **GET** /v1/instances/{instanceId}/consoleLog | Get Console Log
*ArmApi* | [**v1_get_instance_gpios**](docs/ArmApi.md#v1_get_instance_gpios) | **GET** /v1/instances/{instanceId}/gpios | Get Instance GPIOs
*ArmApi* | [**v1_get_instance_panics**](docs/ArmApi.md#v1_get_instance_panics) | **GET** /v1/instances/{instanceId}/panics | Get Panics
*ArmApi* | [**v1_get_instance_peripherals**](docs/ArmApi.md#v1_get_instance_peripherals) | **GET** /v1/instances/{instanceId}/peripherals | Get Instance Peripherals
*ArmApi* | [**v1_get_instance_quick_connect_command**](docs/ArmApi.md#v1_get_instance_quick_connect_command) | **GET** /v1/instances/{instanceId}/quickConnectCommand | Recommended SSH Command for Quick Connect
*ArmApi* | [**v1_get_instance_screenshot**](docs/ArmApi.md#v1_get_instance_screenshot) | **GET** /v1/instances/{instanceId}/screenshot.{format} | Get Instance Screenshot
*ArmApi* | [**v1_get_instance_snapshot**](docs/ArmApi.md#v1_get_instance_snapshot) | **GET** /v1/instances/{instanceId}/snapshots/{snapshotId} | Get Instance Snapshot
*ArmApi* | [**v1_get_instance_snapshots**](docs/ArmApi.md#v1_get_instance_snapshots) | **GET** /v1/instances/{instanceId}/snapshots | Get Instance Snapshots
*ArmApi* | [**v1_get_instance_state**](docs/ArmApi.md#v1_get_instance_state) | **GET** /v1/instances/{instanceId}/state | Get state of Instance
*ArmApi* | [**v1_get_instances**](docs/ArmApi.md#v1_get_instances) | **GET** /v1/instances | Get Instances
*ArmApi* | [**v1_get_model_software**](docs/ArmApi.md#v1_get_model_software) | **GET** /v1/models/{model}/software | Get Software for Model
*ArmApi* | [**v1_get_models**](docs/ArmApi.md#v1_get_models) | **GET** /v1/models | Get Supported Models
*ArmApi* | [**v1_get_project**](docs/ArmApi.md#v1_get_project) | **GET** /v1/projects/{projectId} | Get a Project
*ArmApi* | [**v1_get_project_instances**](docs/ArmApi.md#v1_get_project_instances) | **GET** /v1/projects/{projectId}/instances | Get Instances in Project
*ArmApi* | [**v1_get_project_keys**](docs/ArmApi.md#v1_get_project_keys) | **GET** /v1/projects/{projectId}/keys | Get Project Authorized Keys
*ArmApi* | [**v1_get_project_vpn_config**](docs/ArmApi.md#v1_get_project_vpn_config) | **GET** /v1/projects/{projectId}/vpnconfig/{format} | Get Project VPN Configuration
*ArmApi* | [**v1_get_projects**](docs/ArmApi.md#v1_get_projects) | **GET** /v1/projects | Get Projects
*ArmApi* | [**v1_get_snapshot**](docs/ArmApi.md#v1_get_snapshot) | **GET** /v1/snapshots/{snapshotId} | Get Snapshot
*ArmApi* | [**v1_kcrange**](docs/ArmApi.md#v1_kcrange) | **GET** /v1/instances/{instanceId}/btrace-kcrange | Get Kernel extension ranges
*ArmApi* | [**v1_list_threads**](docs/ArmApi.md#v1_list_threads) | **GET** /v1/instances/{instanceId}/strace/thread-list | Get Running Threads (CoreTrace)
*ArmApi* | [**v1_media_play**](docs/ArmApi.md#v1_media_play) | **POST** /v1/instances/{instanceId}/media/play | Start playing media
*ArmApi* | [**v1_media_stop**](docs/ArmApi.md#v1_media_stop) | **POST** /v1/instances/{instanceId}/media/stop | Stop playing media
*ArmApi* | [**v1_patch_instance**](docs/ArmApi.md#v1_patch_instance) | **PATCH** /v1/instances/{instanceId} | Update Instance
*ArmApi* | [**v1_pause_instance**](docs/ArmApi.md#v1_pause_instance) | **POST** /v1/instances/{instanceId}/pause | Pause an Instance
*ArmApi* | [**v1_post_instance_input**](docs/ArmApi.md#v1_post_instance_input) | **POST** /v1/instances/{instanceId}/input | Provide Instance Input
*ArmApi* | [**v1_ready**](docs/ArmApi.md#v1_ready) | **GET** /v1/ready | API Status
*ArmApi* | [**v1_reboot_instance**](docs/ArmApi.md#v1_reboot_instance) | **POST** /v1/instances/{instanceId}/reboot | Reboot an Instance
*ArmApi* | [**v1_remove_project_key**](docs/ArmApi.md#v1_remove_project_key) | **DELETE** /v1/projects/{projectId}/keys/{keyId} | Delete Project Authorized Key
*ArmApi* | [**v1_remove_team_role_from_project**](docs/ArmApi.md#v1_remove_team_role_from_project) | **DELETE** /v1/roles/projects/{projectId}/teams/{teamId}/roles/{roleId} | Remove team role from project
*ArmApi* | [**v1_remove_user_from_team**](docs/ArmApi.md#v1_remove_user_from_team) | **DELETE** /v1/teams/{teamId}/users/{userId} | Remove user from team
*ArmApi* | [**v1_remove_user_role_from_project**](docs/ArmApi.md#v1_remove_user_role_from_project) | **DELETE** /v1/roles/projects/{projectId}/users/{userId}/roles/{roleId} | Remove user role from project
*ArmApi* | [**v1_rename_instance_snapshot**](docs/ArmApi.md#v1_rename_instance_snapshot) | **PATCH** /v1/instances/{instanceId}/snapshots/{snapshotId} | Rename a Snapshot
*ArmApi* | [**v1_restore_instance_snapshot**](docs/ArmApi.md#v1_restore_instance_snapshot) | **POST** /v1/instances/{instanceId}/snapshots/{snapshotId}/restore | Restore a Snapshot
*ArmApi* | [**v1_roles**](docs/ArmApi.md#v1_roles) | **GET** /v1/roles | Get all roles
*ArmApi* | [**v1_set_instance_gpios**](docs/ArmApi.md#v1_set_instance_gpios) | **PUT** /v1/instances/{instanceId}/gpios | Set Instance GPIOs
*ArmApi* | [**v1_set_instance_peripherals**](docs/ArmApi.md#v1_set_instance_peripherals) | **PUT** /v1/instances/{instanceId}/peripherals | Set Instance Peripherals
*ArmApi* | [**v1_set_instance_state**](docs/ArmApi.md#v1_set_instance_state) | **PUT** /v1/instances/{instanceId}/state | Set state of Instance
*ArmApi* | [**v1_snapshot_rename**](docs/ArmApi.md#v1_snapshot_rename) | **PATCH** /v1/snapshots/{snapshotId} | Rename a Snapshot
*ArmApi* | [**v1_start_core_trace**](docs/ArmApi.md#v1_start_core_trace) | **POST** /v1/instances/{instanceId}/strace/enable | Start CoreTrace on an instance
*ArmApi* | [**v1_start_hyper_trace**](docs/ArmApi.md#v1_start_hyper_trace) | **POST** /v1/instances/{instanceId}/btrace/enable | Start HyperTrace on an instance
*ArmApi* | [**v1_start_instance**](docs/ArmApi.md#v1_start_instance) | **POST** /v1/instances/{instanceId}/start | Start an Instance
*ArmApi* | [**v1_start_network_monitor**](docs/ArmApi.md#v1_start_network_monitor) | **POST** /v1/instances/{instanceId}/sslsplit/enable | Start Network Monitor on an instance.
*ArmApi* | [**v1_stop_core_trace**](docs/ArmApi.md#v1_stop_core_trace) | **POST** /v1/instances/{instanceId}/strace/disable | Stop CoreTrace on an instance.
*ArmApi* | [**v1_stop_hyper_trace**](docs/ArmApi.md#v1_stop_hyper_trace) | **POST** /v1/instances/{instanceId}/btrace/disable | Stop HyperTrace on an instance.
*ArmApi* | [**v1_stop_instance**](docs/ArmApi.md#v1_stop_instance) | **POST** /v1/instances/{instanceId}/stop | Stop an Instance
*ArmApi* | [**v1_stop_network_monitor**](docs/ArmApi.md#v1_stop_network_monitor) | **POST** /v1/instances/{instanceId}/sslsplit/disable | Stop Network Monitor on an instance.
*ArmApi* | [**v1_team_change**](docs/ArmApi.md#v1_team_change) | **PATCH** /v1/teams/{teamId} | Update team
*ArmApi* | [**v1_team_create**](docs/ArmApi.md#v1_team_create) | **POST** /v1/teams | Create team
*ArmApi* | [**v1_team_delete**](docs/ArmApi.md#v1_team_delete) | **DELETE** /v1/teams/{teamId} | Delete team
*ArmApi* | [**v1_teams**](docs/ArmApi.md#v1_teams) | **GET** /v1/teams | Get teams
*ArmApi* | [**v1_unpause_instance**](docs/ArmApi.md#v1_unpause_instance) | **POST** /v1/instances/{instanceId}/unpause | Unpause an Instance
*ArmApi* | [**v1_update_hook**](docs/ArmApi.md#v1_update_hook) | **PUT** /v1/hooks/{hookId} | Update an existing hypervisor hook
*ArmApi* | [**v1_update_project**](docs/ArmApi.md#v1_update_project) | **PATCH** /v1/projects/{projectId} | Update a Project
*ArmApi* | [**v1_update_project_settings**](docs/ArmApi.md#v1_update_project_settings) | **PATCH** /v1/projects/{projectId}/settings | Change Project Settings
*ArmApi* | [**v1_upload_image_data**](docs/ArmApi.md#v1_upload_image_data) | **POST** /v1/images/{imageId} | Upload Image Data
*ArmApi* | [**v1_web_player_allowed_domains**](docs/ArmApi.md#v1_web_player_allowed_domains) | **GET** /v1/webplayer/allowedDomains | Retrieve the list of allowed domains for all Web Player sessions
*ArmApi* | [**v1_web_player_create_session**](docs/ArmApi.md#v1_web_player_create_session) | **POST** /v1/webplayer | Create a new Web Player Session
*ArmApi* | [**v1_web_player_destroy_session**](docs/ArmApi.md#v1_web_player_destroy_session) | **DELETE** /v1/webplayer/{sessionId} | Tear down a Web Player Session
*ArmApi* | [**v1_web_player_list_sessions**](docs/ArmApi.md#v1_web_player_list_sessions) | **GET** /v1/webplayer | List all Web Player sessions
*ArmApi* | [**v1_web_player_session_info**](docs/ArmApi.md#v1_web_player_session_info) | **GET** /v1/webplayer/{sessionId} | Retrieve Web Player Session Information


## Documentation For Models

 - [Address](docs/Address.md)
 - [AgentApp](docs/AgentApp.md)
 - [AgentAppReadyResponse](docs/AgentAppReadyResponse.md)
 - [AgentAppStatus](docs/AgentAppStatus.md)
 - [AgentAppsList](docs/AgentAppsList.md)
 - [AgentAppsStatusList](docs/AgentAppsStatusList.md)
 - [AgentError](docs/AgentError.md)
 - [AgentIcons](docs/AgentIcons.md)
 - [AgentInstallBody](docs/AgentInstallBody.md)
 - [AgentProfilesReturn](docs/AgentProfilesReturn.md)
 - [AgentSystemAdbAuth](docs/AgentSystemAdbAuth.md)
 - [AgentSystemGetPropBody](docs/AgentSystemGetPropBody.md)
 - [AgentValueReturn](docs/AgentValueReturn.md)
 - [AgreedAck](docs/AgreedAck.md)
 - [ApiConflictError](docs/ApiConflictError.md)
 - [ApiError](docs/ApiError.md)
 - [ApiInternalConsistencyError](docs/ApiInternalConsistencyError.md)
 - [ApiNotFoundError](docs/ApiNotFoundError.md)
 - [ApiToken](docs/ApiToken.md)
 - [Bit](docs/Bit.md)
 - [BtraceEnableOptions](docs/BtraceEnableOptions.md)
 - [Button](docs/Button.md)
 - [CouponOptions](docs/CouponOptions.md)
 - [CreateTeam](docs/CreateTeam.md)
 - [CreatedBy](docs/CreatedBy.md)
 - [Credentials](docs/Credentials.md)
 - [DomainOptions](docs/DomainOptions.md)
 - [Extension](docs/Extension.md)
 - [Features](docs/Features.md)
 - [FileChanges](docs/FileChanges.md)
 - [Firmware](docs/Firmware.md)
 - [GpioStateDefinition](docs/GpioStateDefinition.md)
 - [GpiosState](docs/GpiosState.md)
 - [GrantTrialRequestResponse](docs/GrantTrialRequestResponse.md)
 - [Hook](docs/Hook.md)
 - [Image](docs/Image.md)
 - [Instance](docs/Instance.md)
 - [InstanceBootOptions](docs/InstanceBootOptions.md)
 - [InstanceBootOptionsAdditionalTag](docs/InstanceBootOptionsAdditionalTag.md)
 - [InstanceConsoleEndpoint](docs/InstanceConsoleEndpoint.md)
 - [InstanceCreateOptions](docs/InstanceCreateOptions.md)
 - [InstanceInput](docs/InstanceInput.md)
 - [InstanceNetmonState](docs/InstanceNetmonState.md)
 - [InstanceReturn](docs/InstanceReturn.md)
 - [InstanceServices](docs/InstanceServices.md)
 - [InstanceStartOptions](docs/InstanceStartOptions.md)
 - [InstanceState](docs/InstanceState.md)
 - [InstanceStopOptions](docs/InstanceStopOptions.md)
 - [Invitation](docs/Invitation.md)
 - [InviteRevokeParams](docs/InviteRevokeParams.md)
 - [InviteRevokeParamsIds](docs/InviteRevokeParamsIds.md)
 - [Kcrange](docs/Kcrange.md)
 - [KernelTask](docs/KernelTask.md)
 - [KernelThread](docs/KernelThread.md)
 - [MediaPlayBody](docs/MediaPlayBody.md)
 - [Model](docs/Model.md)
 - [ModelSoftware](docs/ModelSoftware.md)
 - [PasswordChangeBody](docs/PasswordChangeBody.md)
 - [PasswordResetBody](docs/PasswordResetBody.md)
 - [PatchInstanceOptions](docs/PatchInstanceOptions.md)
 - [PeripheralsData](docs/PeripheralsData.md)
 - [Plan](docs/Plan.md)
 - [Project](docs/Project.md)
 - [ProjectKey](docs/ProjectKey.md)
 - [ProjectQuota](docs/ProjectQuota.md)
 - [ProjectSettings](docs/ProjectSettings.md)
 - [ProjectUsage](docs/ProjectUsage.md)
 - [RateInfo](docs/RateInfo.md)
 - [ResetLinkBody](docs/ResetLinkBody.md)
 - [Role](docs/Role.md)
 - [RotateBody](docs/RotateBody.md)
 - [Snapshot](docs/Snapshot.md)
 - [SnapshotCreationOptions](docs/SnapshotCreationOptions.md)
 - [SnapshotStatus](docs/SnapshotStatus.md)
 - [SubscriberInvite](docs/SubscriberInvite.md)
 - [Team](docs/Team.md)
 - [TeamCreate](docs/TeamCreate.md)
 - [TextInput](docs/TextInput.md)
 - [Token](docs/Token.md)
 - [TouchCurveInput](docs/TouchCurveInput.md)
 - [TouchInput](docs/TouchInput.md)
 - [Trial](docs/Trial.md)
 - [TrialExtension](docs/TrialExtension.md)
 - [TrialRequestMetadata](docs/TrialRequestMetadata.md)
 - [TrialRequestOptions](docs/TrialRequestOptions.md)
 - [UpdateExtension](docs/UpdateExtension.md)
 - [User](docs/User.md)
 - [UserError](docs/UserError.md)
 - [V1CreateHookParameters](docs/V1CreateHookParameters.md)
 - [V1LoadExtensionParameters](docs/V1LoadExtensionParameters.md)
 - [V1SetStateBody](docs/V1SetStateBody.md)
 - [ValidationError](docs/ValidationError.md)
 - [VolumeOptions](docs/VolumeOptions.md)
 - [VpnDefinition](docs/VpnDefinition.md)
 - [WebPlayerCreateSessionRequest](docs/WebPlayerCreateSessionRequest.md)
 - [WebPlayerSession](docs/WebPlayerSession.md)


## Documentation For Authorization


## BearerAuth

- **Type**: Bearer authentication (ApiToken or JWT)


## Author




