# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BaremetalServerArgs', 'BaremetalServer']

@pulumi.input_type
class BaremetalServerArgs:
    def __init__(__self__, *,
                 offer: pulumi.Input[str],
                 os: pulumi.Input[str],
                 ssh_key_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BaremetalServer resource.
        :param pulumi.Input[str] offer: The offer name or UUID of the baremetal server.
               Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-334154) to find the right offer.
        :param pulumi.Input[str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-87598a) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
               > **Important:** Updates to `ssh_key_ids` will reinstall the server.
        :param pulumi.Input[str] description: A description for the server.
        :param pulumi.Input[str] hostname: The hostname of the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "os", os)
        pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Input[str]:
        """
        The offer name or UUID of the baremetal server.
        Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-334154) to find the right offer.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: pulumi.Input[str]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter
    def os(self) -> pulumi.Input[str]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-87598a) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: pulumi.Input[str]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of SSH keys allowed to connect to the server.
        > **Important:** Updates to `ssh_key_ids` will reinstall the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _BaremetalServerState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 ips: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 offer_id: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 os_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BaremetalServer resources.
        :param pulumi.Input[str] description: A description for the server.
        :param pulumi.Input[str] domain: The domain of the server.
        :param pulumi.Input[str] hostname: The hostname of the server.
        :param pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpArgs']]] ips: (List of) The IPs of the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] offer: The offer name or UUID of the baremetal server.
               Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-334154) to find the right offer.
        :param pulumi.Input[str] offer_id: The ID of the offer.
        :param pulumi.Input[str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-87598a) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[str] os_id: The ID of the os.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
               > **Important:** Updates to `ssh_key_ids` will reinstall the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if ips is not None:
            pulumi.set(__self__, "ips", ips)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if offer_id is not None:
            pulumi.set(__self__, "offer_id", offer_id)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if os is not None:
            pulumi.set(__self__, "os", os)
        if os_id is not None:
            pulumi.set(__self__, "os_id", os_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if ssh_key_ids is not None:
            pulumi.set(__self__, "ssh_key_ids", ssh_key_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of the server.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpArgs']]]]:
        """
        (List of) The IPs of the server.
        """
        return pulumi.get(self, "ips")

    @ips.setter
    def ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BaremetalServerIpArgs']]]]):
        pulumi.set(self, "ips", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def offer(self) -> Optional[pulumi.Input[str]]:
        """
        The offer name or UUID of the baremetal server.
        Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-334154) to find the right offer.
        """
        return pulumi.get(self, "offer")

    @offer.setter
    def offer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer", value)

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the offer.
        """
        return pulumi.get(self, "offer_id")

    @offer_id.setter
    def offer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "offer_id", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def os(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-87598a) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @os.setter
    def os(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os", value)

    @property
    @pulumi.getter(name="osId")
    def os_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the os.
        """
        return pulumi.get(self, "os_id")

    @os_id.setter
    def os_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of SSH keys allowed to connect to the server.
        > **Important:** Updates to `ssh_key_ids` will reinstall the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @ssh_key_ids.setter
    def ssh_key_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_key_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class BaremetalServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Compute Baremetal servers. For more information, see [the documentation](https://developers.scaleway.com/en/products/baremetal/api).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_scaleway as scaleway
        import pulumi_scaleway as scaleway

        main = scaleway.get_account_ssh_key(name="main")
        base = scaleway.BaremetalServer("base",
            zone="fr-par-2",
            offer="GP-BM1-S",
            os="d17d6872-0412-45d9-a198-af82c34d3c5c",
            ssh_key_ids=[main.id])
        ```

        ## Import

        Baremetal servers can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/baremetalServer:BaremetalServer web fr-par-2/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description for the server.
        :param pulumi.Input[str] hostname: The hostname of the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] offer: The offer name or UUID of the baremetal server.
               Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-334154) to find the right offer.
        :param pulumi.Input[str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-87598a) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
               > **Important:** Updates to `ssh_key_ids` will reinstall the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BaremetalServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Compute Baremetal servers. For more information, see [the documentation](https://developers.scaleway.com/en/products/baremetal/api).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import lbrlabs_scaleway as scaleway
        import pulumi_scaleway as scaleway

        main = scaleway.get_account_ssh_key(name="main")
        base = scaleway.BaremetalServer("base",
            zone="fr-par-2",
            offer="GP-BM1-S",
            os="d17d6872-0412-45d9-a198-af82c34d3c5c",
            ssh_key_ids=[main.id])
        ```

        ## Import

        Baremetal servers can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/baremetalServer:BaremetalServer web fr-par-2/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param BaremetalServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BaremetalServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 offer: Optional[pulumi.Input[str]] = None,
                 os: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BaremetalServerArgs.__new__(BaremetalServerArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["name"] = name
            if offer is None and not opts.urn:
                raise TypeError("Missing required property 'offer'")
            __props__.__dict__["offer"] = offer
            if os is None and not opts.urn:
                raise TypeError("Missing required property 'os'")
            __props__.__dict__["os"] = os
            __props__.__dict__["project_id"] = project_id
            if ssh_key_ids is None and not opts.urn:
                raise TypeError("Missing required property 'ssh_key_ids'")
            __props__.__dict__["ssh_key_ids"] = ssh_key_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["domain"] = None
            __props__.__dict__["ips"] = None
            __props__.__dict__["offer_id"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["os_id"] = None
        super(BaremetalServer, __self__).__init__(
            'scaleway:index/baremetalServer:BaremetalServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            ips: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerIpArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            offer: Optional[pulumi.Input[str]] = None,
            offer_id: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            os: Optional[pulumi.Input[str]] = None,
            os_id: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            ssh_key_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'BaremetalServer':
        """
        Get an existing BaremetalServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: A description for the server.
        :param pulumi.Input[str] domain: The domain of the server.
        :param pulumi.Input[str] hostname: The hostname of the server.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BaremetalServerIpArgs']]]] ips: (List of) The IPs of the server.
        :param pulumi.Input[str] name: The name of the server.
        :param pulumi.Input[str] offer: The offer name or UUID of the baremetal server.
               Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-334154) to find the right offer.
        :param pulumi.Input[str] offer_id: The ID of the offer.
        :param pulumi.Input[str] organization_id: The organization ID the server is associated with.
        :param pulumi.Input[str] os: The UUID of the os to install on the server.
               Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-87598a) to find the right OS ID.
               > **Important:** Updates to `os` will reinstall the server.
        :param pulumi.Input[str] os_id: The ID of the os.
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the server is associated with.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_key_ids: List of SSH keys allowed to connect to the server.
               > **Important:** Updates to `ssh_key_ids` will reinstall the server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the server.
        :param pulumi.Input[str] zone: `zone`) The zone in which the server should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BaremetalServerState.__new__(_BaremetalServerState)

        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["ips"] = ips
        __props__.__dict__["name"] = name
        __props__.__dict__["offer"] = offer
        __props__.__dict__["offer_id"] = offer_id
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["os"] = os
        __props__.__dict__["os_id"] = os_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["ssh_key_ids"] = ssh_key_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return BaremetalServer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the server.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain of the server.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[str]]:
        """
        The hostname of the server.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def ips(self) -> pulumi.Output[Sequence['outputs.BaremetalServerIp']]:
        """
        (List of) The IPs of the server.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def offer(self) -> pulumi.Output[str]:
        """
        The offer name or UUID of the baremetal server.
        Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-334154) to find the right offer.
        """
        return pulumi.get(self, "offer")

    @property
    @pulumi.getter(name="offerId")
    def offer_id(self) -> pulumi.Output[str]:
        """
        The ID of the offer.
        """
        return pulumi.get(self, "offer_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID the server is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def os(self) -> pulumi.Output[str]:
        """
        The UUID of the os to install on the server.
        Use [this endpoint](https://developers.scaleway.com/en/products/baremetal/api/#get-87598a) to find the right OS ID.
        > **Important:** Updates to `os` will reinstall the server.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter(name="osId")
    def os_id(self) -> pulumi.Output[str]:
        """
        The ID of the os.
        """
        return pulumi.get(self, "os_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the server is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="sshKeyIds")
    def ssh_key_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of SSH keys allowed to connect to the server.
        > **Important:** Updates to `ssh_key_ids` will reinstall the server.
        """
        return pulumi.get(self, "ssh_key_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags associated with the server.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        `zone`) The zone in which the server should be created.
        """
        return pulumi.get(self, "zone")

