# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetRegistryNamespaceResult',
    'AwaitableGetRegistryNamespaceResult',
    'get_registry_namespace',
    'get_registry_namespace_output',
]

@pulumi.output_type
class GetRegistryNamespaceResult:
    """
    A collection of values returned by getRegistryNamespace.
    """
    def __init__(__self__, description=None, endpoint=None, id=None, is_public=None, name=None, namespace_id=None, organization_id=None, project_id=None, region=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if endpoint and not isinstance(endpoint, str):
            raise TypeError("Expected argument 'endpoint' to be a str")
        pulumi.set(__self__, "endpoint", endpoint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_public and not isinstance(is_public, bool):
            raise TypeError("Expected argument 'is_public' to be a bool")
        pulumi.set(__self__, "is_public", is_public)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace_id and not isinstance(namespace_id, str):
            raise TypeError("Expected argument 'namespace_id' to be a str")
        pulumi.set(__self__, "namespace_id", namespace_id)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint of the Registry Namespace.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> bool:
        """
        The Namespace Privacy Policy: whether or not the images are public.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[str]:
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization ID the namespace is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


class AwaitableGetRegistryNamespaceResult(GetRegistryNamespaceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryNamespaceResult(
            description=self.description,
            endpoint=self.endpoint,
            id=self.id,
            is_public=self.is_public,
            name=self.name,
            namespace_id=self.namespace_id,
            organization_id=self.organization_id,
            project_id=self.project_id,
            region=self.region)


def get_registry_namespace(name: Optional[str] = None,
                           namespace_id: Optional[str] = None,
                           region: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryNamespaceResult:
    """
    Gets information about a registry namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_namespace = scaleway.get_registry_namespace(namespace_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str name: The namespace name.
           Only one of `name` and `namespace_id` should be specified.
    :param str namespace_id: The namespace id.
           Only one of `name` and `namespace_id` should be specified.
    :param str region: `region`) The region in which the namespace exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespaceId'] = namespace_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getRegistryNamespace:getRegistryNamespace', __args__, opts=opts, typ=GetRegistryNamespaceResult).value

    return AwaitableGetRegistryNamespaceResult(
        description=__ret__.description,
        endpoint=__ret__.endpoint,
        id=__ret__.id,
        is_public=__ret__.is_public,
        name=__ret__.name,
        namespace_id=__ret__.namespace_id,
        organization_id=__ret__.organization_id,
        project_id=__ret__.project_id,
        region=__ret__.region)


@_utilities.lift_output_func(get_registry_namespace)
def get_registry_namespace_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                                  namespace_id: Optional[pulumi.Input[Optional[str]]] = None,
                                  region: Optional[pulumi.Input[Optional[str]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegistryNamespaceResult]:
    """
    Gets information about a registry namespace.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_namespace = scaleway.get_registry_namespace(namespace_id="11111111-1111-1111-1111-111111111111")
    ```


    :param str name: The namespace name.
           Only one of `name` and `namespace_id` should be specified.
    :param str namespace_id: The namespace id.
           Only one of `name` and `namespace_id` should be specified.
    :param str region: `region`) The region in which the namespace exists.
    """
    ...
