import setuptools

with open("README.rst", "r") as fh:
    long_description = fh.read()
    
version={}
with open("dmodelspy/version.py") as fp:
    exec(fp.read(),version)

setuptools.setup(
    name="dmodelspy",
    version=version['__version__'],
    author="Wayne Crawford",
    author_email="crawford@ipgp.fr",
    description="Python port of dMODELS",
    long_description=long_description,
    long_description_content_type="text/x-rst; charset=UTF-8",
    url="https://github.com/WayneCrawford/dmodelspy",
    packages=setuptools.find_packages(),
    include_package_data=True,
    install_requires=[
          'numpy>=1.1',
          'scipy>=1.4',
          'matplotlib>=3.0',
          'pandas>=1.1'
      ],
    entry_points={},
    python_requires='>=3.7',
    setup_requires=["pytest-runner"],
    tests_require=["pytest"],
    classifiers=(
        "Development Status :: 4 - Beta",
        "Environment :: Console",
        "Intended Audience :: Science/Research",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: GNU General Public License v3 (GPLv3)",
        "Natural Language :: English",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Topic :: Scientific/Engineering",
        "Topic :: Scientific/Engineering :: Physics"
    ),
    keywords='geodesy'
)
