from metapub import PubMedFetcher
from scidownl.scihub import *
import os
from util import Diff, checkDir
import json
import ncbi
from download import pdfDownload

class Article:
    def __init__(self, pmid, query):
        self.pmid = pmid
        self.query = query
    
    def fetcher(self):
        fetch = PubMedFetcher()
        article = fetch.article_by_pmid(self.pmid)
        self.article = article
        self.doi = article.doi

    def format_json(self):
        data = {}
        citedby = ncbi.getCitedby(self.pmid)
        refer = ncbi.getReferences(self.pmid)
        data.update({'pmid':self.pmid,
                    'authors':self.article.authors,
                    'year':self.article.year,
                    'title':self.article.title, 
                    'abstract':self.article.abstract})
        if refer: data.update(refer)
        if citedby: data.update(citedby)
        if self.query:
            save_path = checkDir('./datasets_query/json/{}'.format(self.query))
        else:
            save_path = checkDir('./datasets_id/json/{}'.format(self.query))
        with open('{}/{}.json'.format(save_path, self.pmid), 'w') as j_out:
            json.dump(data, j_out)

    def download(self):
        if not os.path.isfile("./pdf/{}.pdf".format(self.pmid)):
            pdfDownload(self.pmid, self.doi)
            # pdf_dir = checkDir('./pdf')
            # old_dir = os.listdir(pdf_dir)
            # sci = SciHub(doi, pdf_dir).download(choose_scihub_url_index=3)
            # new_dir = os.listdir(pdf_dir)
            # pdfname = Diff(old_dir, new_dir)[0]
            # source = os.path.join(pdf_dir, pdfname)
            # os.rename(source, os.path.join(pdf_dir, '{}.pdf'.format(self.pmid)))