# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixFirewallInstanceArgs', 'AviatrixFirewallInstance']

@pulumi.input_type
class AviatrixFirewallInstanceArgs:
    def __init__(__self__, *,
                 egress_subnet: pulumi.Input[str],
                 firewall_image: pulumi.Input[str],
                 firewall_name: pulumi.Input[str],
                 firewall_size: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 bootstrap_bucket_name: Optional[pulumi.Input[str]] = None,
                 bootstrap_storage_name: Optional[pulumi.Input[str]] = None,
                 container_folder: Optional[pulumi.Input[str]] = None,
                 egress_vpc_id: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 file_share_folder: Optional[pulumi.Input[str]] = None,
                 firenet_gw_name: Optional[pulumi.Input[str]] = None,
                 firewall_image_id: Optional[pulumi.Input[str]] = None,
                 firewall_image_version: Optional[pulumi.Input[str]] = None,
                 iam_role: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 management_subnet: Optional[pulumi.Input[str]] = None,
                 management_vpc_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 sas_url_config: Optional[pulumi.Input[str]] = None,
                 sas_url_license: Optional[pulumi.Input[str]] = None,
                 share_directory: Optional[pulumi.Input[str]] = None,
                 sic_key: Optional[pulumi.Input[str]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 storage_access_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AviatrixFirewallInstance resource.
        :param pulumi.Input[str] egress_subnet: Egress Interface Subnet. Select the subnet whose name contains “FW-ingress-egress”. For GCP, `egress_subnet` must be in the form `cidr~~region~~name`.
        :param pulumi.Input[str] firewall_image: One of the AWS/Azure/GCP AMIs from various vendors such as Palo Alto Networks.
        :param pulumi.Input[str] firewall_name: Name of the firewall instance to be created.
        :param pulumi.Input[str] firewall_size: Instance size of the firewall. Example: "m5.xlarge".
        :param pulumi.Input[str] vpc_id: VPC ID of the Security VPC. For GCP, `vpc_id` must be in the form vpc_id~-~gcloud_project_id.
        :param pulumi.Input[str] availability_domain: Availability domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        :param pulumi.Input[str] bootstrap_bucket_name: Only available for AWS and GCP. For GCP, only Palo Alto Networks VM-Series deployment can use this attribute. In advanced mode, specify a bootstrap bucket name where the initial configuration and policy file is stored.
        :param pulumi.Input[str] bootstrap_storage_name: Advanced option. Bootstrap storage name. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series/Fortinet Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] container_folder: Advanced option. Container folder. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] egress_vpc_id: Egress VPC ID. Required for GCP. Available as of provider version R2.18.1+.
        :param pulumi.Input[str] fault_domain: Fault domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        :param pulumi.Input[str] file_share_folder: Advanced option. File share folder. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] firenet_gw_name: Name of the primary FireNet gateway. **Required for all FireNet deployments that do not utilize the TGW-Integrated FireNet with AWS Native GWLB VPC.**
        :param pulumi.Input[str] firewall_image_id: Firewall image ID. Applicable to AWS and Azure only. For AWS, please use AMI ID. For Azure, the format is “Publisher:Offer:Plan:Version”. Available as of provider version R2.19+.
        :param pulumi.Input[str] firewall_image_version: Version of firewall image. If not specified, Controller will automatically select the latest version available.
        :param pulumi.Input[str] iam_role: Only available for AWS. In advanced mode, create an IAM Role on the AWS account that launched the FireNet gateway. Create a policy to attach to the role. The policy is to allow access to "Bootstrap Bucket".
        :param pulumi.Input[str] key_name: Applicable to AWS deployment only. AWS Key Pair name. If not provided a Key Pair will be generated.
        :param pulumi.Input[str] management_subnet: Management Interface Subnet. Select the subnet whose name contains “gateway and firewall management”. For GCP, `management_subnet` must be in the form `cidr~~region~~name`. Required for Palo Alto Networks VM-Series and OCI Check Point firewalls. Otherwise, it must be empty.
        :param pulumi.Input[str] management_vpc_id: Management VPC ID. Only used for GCP firewall. Required for Palo Alto Networks VM-Series, and required to be empty for Check Point or Fortinet series. Available as of provider version R2.18.1+.
        :param pulumi.Input[str] password: Applicable to Azure or AzureGov deployment only.
        :param pulumi.Input[str] sas_url_config: Advanced option. SAS URL Config. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] sas_url_license: Advanced option. SAS URL License. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] share_directory: Advanced option. Share directory. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] sic_key: Advanced option. Sic key. Applicable to Check Point Series deployment only.
        :param pulumi.Input[str] ssh_public_key: Applicable to Azure or AzureGov deployment only.
        :param pulumi.Input[str] storage_access_key: Advanced option. Storage access key. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Mapping of key value pairs of tags for a firewall instance. Only available for AWS, AWSGov, GCP and Azure firewall instances. For AWS, AWSGov and Azure allowed characters are: letters, spaces, and numbers plus the following special characters: + - = . _ : @. For GCP allowed characters are: lowercase letters, numbers, "-" and "_". Example: {"key1" = "value1", "key2" = "value2"}.
        :param pulumi.Input[str] user_data: Advanced option. User Data. Applicable to Check Point Series and Fortinet Series deployment only. Type: String.
        :param pulumi.Input[str] username: Applicable to Azure or AzureGov deployment only. "admin" as a username is not accepted.
        :param pulumi.Input[str] zone: Availability Zone. Required if creating a Firewall Instance with a Native AWS GWLB-enabled VPC. Applicable to AWS, Azure, and GCP only. Available as of provider version R2.17+.
        """
        pulumi.set(__self__, "egress_subnet", egress_subnet)
        pulumi.set(__self__, "firewall_image", firewall_image)
        pulumi.set(__self__, "firewall_name", firewall_name)
        pulumi.set(__self__, "firewall_size", firewall_size)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if bootstrap_bucket_name is not None:
            pulumi.set(__self__, "bootstrap_bucket_name", bootstrap_bucket_name)
        if bootstrap_storage_name is not None:
            pulumi.set(__self__, "bootstrap_storage_name", bootstrap_storage_name)
        if container_folder is not None:
            pulumi.set(__self__, "container_folder", container_folder)
        if egress_vpc_id is not None:
            pulumi.set(__self__, "egress_vpc_id", egress_vpc_id)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if file_share_folder is not None:
            pulumi.set(__self__, "file_share_folder", file_share_folder)
        if firenet_gw_name is not None:
            pulumi.set(__self__, "firenet_gw_name", firenet_gw_name)
        if firewall_image_id is not None:
            pulumi.set(__self__, "firewall_image_id", firewall_image_id)
        if firewall_image_version is not None:
            pulumi.set(__self__, "firewall_image_version", firewall_image_version)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if management_subnet is not None:
            pulumi.set(__self__, "management_subnet", management_subnet)
        if management_vpc_id is not None:
            pulumi.set(__self__, "management_vpc_id", management_vpc_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if sas_url_config is not None:
            pulumi.set(__self__, "sas_url_config", sas_url_config)
        if sas_url_license is not None:
            pulumi.set(__self__, "sas_url_license", sas_url_license)
        if share_directory is not None:
            pulumi.set(__self__, "share_directory", share_directory)
        if sic_key is not None:
            pulumi.set(__self__, "sic_key", sic_key)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if storage_access_key is not None:
            pulumi.set(__self__, "storage_access_key", storage_access_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="egressSubnet")
    def egress_subnet(self) -> pulumi.Input[str]:
        """
        Egress Interface Subnet. Select the subnet whose name contains “FW-ingress-egress”. For GCP, `egress_subnet` must be in the form `cidr~~region~~name`.
        """
        return pulumi.get(self, "egress_subnet")

    @egress_subnet.setter
    def egress_subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "egress_subnet", value)

    @property
    @pulumi.getter(name="firewallImage")
    def firewall_image(self) -> pulumi.Input[str]:
        """
        One of the AWS/Azure/GCP AMIs from various vendors such as Palo Alto Networks.
        """
        return pulumi.get(self, "firewall_image")

    @firewall_image.setter
    def firewall_image(self, value: pulumi.Input[str]):
        pulumi.set(self, "firewall_image", value)

    @property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> pulumi.Input[str]:
        """
        Name of the firewall instance to be created.
        """
        return pulumi.get(self, "firewall_name")

    @firewall_name.setter
    def firewall_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "firewall_name", value)

    @property
    @pulumi.getter(name="firewallSize")
    def firewall_size(self) -> pulumi.Input[str]:
        """
        Instance size of the firewall. Example: "m5.xlarge".
        """
        return pulumi.get(self, "firewall_size")

    @firewall_size.setter
    def firewall_size(self, value: pulumi.Input[str]):
        pulumi.set(self, "firewall_size", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID of the Security VPC. For GCP, `vpc_id` must be in the form vpc_id~-~gcloud_project_id.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Availability domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="bootstrapBucketName")
    def bootstrap_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Only available for AWS and GCP. For GCP, only Palo Alto Networks VM-Series deployment can use this attribute. In advanced mode, specify a bootstrap bucket name where the initial configuration and policy file is stored.
        """
        return pulumi.get(self, "bootstrap_bucket_name")

    @bootstrap_bucket_name.setter
    def bootstrap_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_bucket_name", value)

    @property
    @pulumi.getter(name="bootstrapStorageName")
    def bootstrap_storage_name(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Bootstrap storage name. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series/Fortinet Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "bootstrap_storage_name")

    @bootstrap_storage_name.setter
    def bootstrap_storage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_storage_name", value)

    @property
    @pulumi.getter(name="containerFolder")
    def container_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Container folder. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "container_folder")

    @container_folder.setter
    def container_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_folder", value)

    @property
    @pulumi.getter(name="egressVpcId")
    def egress_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Egress VPC ID. Required for GCP. Available as of provider version R2.18.1+.
        """
        return pulumi.get(self, "egress_vpc_id")

    @egress_vpc_id.setter
    def egress_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_vpc_id", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Fault domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="fileShareFolder")
    def file_share_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. File share folder. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "file_share_folder")

    @file_share_folder.setter
    def file_share_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_folder", value)

    @property
    @pulumi.getter(name="firenetGwName")
    def firenet_gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the primary FireNet gateway. **Required for all FireNet deployments that do not utilize the TGW-Integrated FireNet with AWS Native GWLB VPC.**
        """
        return pulumi.get(self, "firenet_gw_name")

    @firenet_gw_name.setter
    def firenet_gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firenet_gw_name", value)

    @property
    @pulumi.getter(name="firewallImageId")
    def firewall_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Firewall image ID. Applicable to AWS and Azure only. For AWS, please use AMI ID. For Azure, the format is “Publisher:Offer:Plan:Version”. Available as of provider version R2.19+.
        """
        return pulumi.get(self, "firewall_image_id")

    @firewall_image_id.setter
    def firewall_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_image_id", value)

    @property
    @pulumi.getter(name="firewallImageVersion")
    def firewall_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of firewall image. If not specified, Controller will automatically select the latest version available.
        """
        return pulumi.get(self, "firewall_image_version")

    @firewall_image_version.setter
    def firewall_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_image_version", value)

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[str]]:
        """
        Only available for AWS. In advanced mode, create an IAM Role on the AWS account that launched the FireNet gateway. Create a policy to attach to the role. The policy is to allow access to "Bootstrap Bucket".
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable to AWS deployment only. AWS Key Pair name. If not provided a Key Pair will be generated.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="managementSubnet")
    def management_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Management Interface Subnet. Select the subnet whose name contains “gateway and firewall management”. For GCP, `management_subnet` must be in the form `cidr~~region~~name`. Required for Palo Alto Networks VM-Series and OCI Check Point firewalls. Otherwise, it must be empty.
        """
        return pulumi.get(self, "management_subnet")

    @management_subnet.setter
    def management_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_subnet", value)

    @property
    @pulumi.getter(name="managementVpcId")
    def management_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Management VPC ID. Only used for GCP firewall. Required for Palo Alto Networks VM-Series, and required to be empty for Check Point or Fortinet series. Available as of provider version R2.18.1+.
        """
        return pulumi.get(self, "management_vpc_id")

    @management_vpc_id.setter
    def management_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_vpc_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable to Azure or AzureGov deployment only.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sasUrlConfig")
    def sas_url_config(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. SAS URL Config. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "sas_url_config")

    @sas_url_config.setter
    def sas_url_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url_config", value)

    @property
    @pulumi.getter(name="sasUrlLicense")
    def sas_url_license(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. SAS URL License. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "sas_url_license")

    @sas_url_license.setter
    def sas_url_license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url_license", value)

    @property
    @pulumi.getter(name="shareDirectory")
    def share_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Share directory. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "share_directory")

    @share_directory.setter
    def share_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_directory", value)

    @property
    @pulumi.getter(name="sicKey")
    def sic_key(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Sic key. Applicable to Check Point Series deployment only.
        """
        return pulumi.get(self, "sic_key")

    @sic_key.setter
    def sic_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sic_key", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable to Azure or AzureGov deployment only.
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Storage access key. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "storage_access_key")

    @storage_access_key.setter
    def storage_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_access_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of key value pairs of tags for a firewall instance. Only available for AWS, AWSGov, GCP and Azure firewall instances. For AWS, AWSGov and Azure allowed characters are: letters, spaces, and numbers plus the following special characters: + - = . _ : @. For GCP allowed characters are: lowercase letters, numbers, "-" and "_". Example: {"key1" = "value1", "key2" = "value2"}.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. User Data. Applicable to Check Point Series and Fortinet Series deployment only. Type: String.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable to Azure or AzureGov deployment only. "admin" as a username is not accepted.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Zone. Required if creating a Firewall Instance with a Native AWS GWLB-enabled VPC. Applicable to AWS, Azure, and GCP only. Available as of provider version R2.17+.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _AviatrixFirewallInstanceState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 bootstrap_bucket_name: Optional[pulumi.Input[str]] = None,
                 bootstrap_storage_name: Optional[pulumi.Input[str]] = None,
                 cloud_type: Optional[pulumi.Input[int]] = None,
                 container_folder: Optional[pulumi.Input[str]] = None,
                 egress_interface: Optional[pulumi.Input[str]] = None,
                 egress_subnet: Optional[pulumi.Input[str]] = None,
                 egress_vpc_id: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 file_share_folder: Optional[pulumi.Input[str]] = None,
                 firenet_gw_name: Optional[pulumi.Input[str]] = None,
                 firewall_image: Optional[pulumi.Input[str]] = None,
                 firewall_image_id: Optional[pulumi.Input[str]] = None,
                 firewall_image_version: Optional[pulumi.Input[str]] = None,
                 firewall_name: Optional[pulumi.Input[str]] = None,
                 firewall_size: Optional[pulumi.Input[str]] = None,
                 gcp_vpc_id: Optional[pulumi.Input[str]] = None,
                 iam_role: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 lan_interface: Optional[pulumi.Input[str]] = None,
                 management_interface: Optional[pulumi.Input[str]] = None,
                 management_subnet: Optional[pulumi.Input[str]] = None,
                 management_vpc_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 sas_url_config: Optional[pulumi.Input[str]] = None,
                 sas_url_license: Optional[pulumi.Input[str]] = None,
                 share_directory: Optional[pulumi.Input[str]] = None,
                 sic_key: Optional[pulumi.Input[str]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 storage_access_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AviatrixFirewallInstance resources.
        :param pulumi.Input[str] availability_domain: Availability domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        :param pulumi.Input[str] bootstrap_bucket_name: Only available for AWS and GCP. For GCP, only Palo Alto Networks VM-Series deployment can use this attribute. In advanced mode, specify a bootstrap bucket name where the initial configuration and policy file is stored.
        :param pulumi.Input[str] bootstrap_storage_name: Advanced option. Bootstrap storage name. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series/Fortinet Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[int] cloud_type: Cloud Type.
        :param pulumi.Input[str] container_folder: Advanced option. Container folder. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] egress_interface: ID of Egress Interface created.
        :param pulumi.Input[str] egress_subnet: Egress Interface Subnet. Select the subnet whose name contains “FW-ingress-egress”. For GCP, `egress_subnet` must be in the form `cidr~~region~~name`.
        :param pulumi.Input[str] egress_vpc_id: Egress VPC ID. Required for GCP. Available as of provider version R2.18.1+.
        :param pulumi.Input[str] fault_domain: Fault domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        :param pulumi.Input[str] file_share_folder: Advanced option. File share folder. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] firenet_gw_name: Name of the primary FireNet gateway. **Required for all FireNet deployments that do not utilize the TGW-Integrated FireNet with AWS Native GWLB VPC.**
        :param pulumi.Input[str] firewall_image: One of the AWS/Azure/GCP AMIs from various vendors such as Palo Alto Networks.
        :param pulumi.Input[str] firewall_image_id: Firewall image ID. Applicable to AWS and Azure only. For AWS, please use AMI ID. For Azure, the format is “Publisher:Offer:Plan:Version”. Available as of provider version R2.19+.
        :param pulumi.Input[str] firewall_image_version: Version of firewall image. If not specified, Controller will automatically select the latest version available.
        :param pulumi.Input[str] firewall_name: Name of the firewall instance to be created.
        :param pulumi.Input[str] firewall_size: Instance size of the firewall. Example: "m5.xlarge".
        :param pulumi.Input[str] gcp_vpc_id: GCP Only. The current VPC ID.
        :param pulumi.Input[str] iam_role: Only available for AWS. In advanced mode, create an IAM Role on the AWS account that launched the FireNet gateway. Create a policy to attach to the role. The policy is to allow access to "Bootstrap Bucket".
        :param pulumi.Input[str] instance_id: ID of the firewall instance created.
        :param pulumi.Input[str] key_name: Applicable to AWS deployment only. AWS Key Pair name. If not provided a Key Pair will be generated.
        :param pulumi.Input[str] lan_interface: ID of Lan Interface created.
        :param pulumi.Input[str] management_interface: ID of Management Interface created.
        :param pulumi.Input[str] management_subnet: Management Interface Subnet. Select the subnet whose name contains “gateway and firewall management”. For GCP, `management_subnet` must be in the form `cidr~~region~~name`. Required for Palo Alto Networks VM-Series and OCI Check Point firewalls. Otherwise, it must be empty.
        :param pulumi.Input[str] management_vpc_id: Management VPC ID. Only used for GCP firewall. Required for Palo Alto Networks VM-Series, and required to be empty for Check Point or Fortinet series. Available as of provider version R2.18.1+.
        :param pulumi.Input[str] password: Applicable to Azure or AzureGov deployment only.
        :param pulumi.Input[str] public_ip: Management Public IP.
        :param pulumi.Input[str] sas_url_config: Advanced option. SAS URL Config. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] sas_url_license: Advanced option. SAS URL License. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] share_directory: Advanced option. Share directory. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] sic_key: Advanced option. Sic key. Applicable to Check Point Series deployment only.
        :param pulumi.Input[str] ssh_public_key: Applicable to Azure or AzureGov deployment only.
        :param pulumi.Input[str] storage_access_key: Advanced option. Storage access key. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Mapping of key value pairs of tags for a firewall instance. Only available for AWS, AWSGov, GCP and Azure firewall instances. For AWS, AWSGov and Azure allowed characters are: letters, spaces, and numbers plus the following special characters: + - = . _ : @. For GCP allowed characters are: lowercase letters, numbers, "-" and "_". Example: {"key1" = "value1", "key2" = "value2"}.
        :param pulumi.Input[str] user_data: Advanced option. User Data. Applicable to Check Point Series and Fortinet Series deployment only. Type: String.
        :param pulumi.Input[str] username: Applicable to Azure or AzureGov deployment only. "admin" as a username is not accepted.
        :param pulumi.Input[str] vpc_id: VPC ID of the Security VPC. For GCP, `vpc_id` must be in the form vpc_id~-~gcloud_project_id.
        :param pulumi.Input[str] zone: Availability Zone. Required if creating a Firewall Instance with a Native AWS GWLB-enabled VPC. Applicable to AWS, Azure, and GCP only. Available as of provider version R2.17+.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if bootstrap_bucket_name is not None:
            pulumi.set(__self__, "bootstrap_bucket_name", bootstrap_bucket_name)
        if bootstrap_storage_name is not None:
            pulumi.set(__self__, "bootstrap_storage_name", bootstrap_storage_name)
        if cloud_type is not None:
            pulumi.set(__self__, "cloud_type", cloud_type)
        if container_folder is not None:
            pulumi.set(__self__, "container_folder", container_folder)
        if egress_interface is not None:
            pulumi.set(__self__, "egress_interface", egress_interface)
        if egress_subnet is not None:
            pulumi.set(__self__, "egress_subnet", egress_subnet)
        if egress_vpc_id is not None:
            pulumi.set(__self__, "egress_vpc_id", egress_vpc_id)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if file_share_folder is not None:
            pulumi.set(__self__, "file_share_folder", file_share_folder)
        if firenet_gw_name is not None:
            pulumi.set(__self__, "firenet_gw_name", firenet_gw_name)
        if firewall_image is not None:
            pulumi.set(__self__, "firewall_image", firewall_image)
        if firewall_image_id is not None:
            pulumi.set(__self__, "firewall_image_id", firewall_image_id)
        if firewall_image_version is not None:
            pulumi.set(__self__, "firewall_image_version", firewall_image_version)
        if firewall_name is not None:
            pulumi.set(__self__, "firewall_name", firewall_name)
        if firewall_size is not None:
            pulumi.set(__self__, "firewall_size", firewall_size)
        if gcp_vpc_id is not None:
            pulumi.set(__self__, "gcp_vpc_id", gcp_vpc_id)
        if iam_role is not None:
            pulumi.set(__self__, "iam_role", iam_role)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if lan_interface is not None:
            pulumi.set(__self__, "lan_interface", lan_interface)
        if management_interface is not None:
            pulumi.set(__self__, "management_interface", management_interface)
        if management_subnet is not None:
            pulumi.set(__self__, "management_subnet", management_subnet)
        if management_vpc_id is not None:
            pulumi.set(__self__, "management_vpc_id", management_vpc_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if sas_url_config is not None:
            pulumi.set(__self__, "sas_url_config", sas_url_config)
        if sas_url_license is not None:
            pulumi.set(__self__, "sas_url_license", sas_url_license)
        if share_directory is not None:
            pulumi.set(__self__, "share_directory", share_directory)
        if sic_key is not None:
            pulumi.set(__self__, "sic_key", sic_key)
        if ssh_public_key is not None:
            pulumi.set(__self__, "ssh_public_key", ssh_public_key)
        if storage_access_key is not None:
            pulumi.set(__self__, "storage_access_key", storage_access_key)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Availability domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="bootstrapBucketName")
    def bootstrap_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Only available for AWS and GCP. For GCP, only Palo Alto Networks VM-Series deployment can use this attribute. In advanced mode, specify a bootstrap bucket name where the initial configuration and policy file is stored.
        """
        return pulumi.get(self, "bootstrap_bucket_name")

    @bootstrap_bucket_name.setter
    def bootstrap_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_bucket_name", value)

    @property
    @pulumi.getter(name="bootstrapStorageName")
    def bootstrap_storage_name(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Bootstrap storage name. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series/Fortinet Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "bootstrap_storage_name")

    @bootstrap_storage_name.setter
    def bootstrap_storage_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bootstrap_storage_name", value)

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> Optional[pulumi.Input[int]]:
        """
        Cloud Type.
        """
        return pulumi.get(self, "cloud_type")

    @cloud_type.setter
    def cloud_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cloud_type", value)

    @property
    @pulumi.getter(name="containerFolder")
    def container_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Container folder. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "container_folder")

    @container_folder.setter
    def container_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_folder", value)

    @property
    @pulumi.getter(name="egressInterface")
    def egress_interface(self) -> Optional[pulumi.Input[str]]:
        """
        ID of Egress Interface created.
        """
        return pulumi.get(self, "egress_interface")

    @egress_interface.setter
    def egress_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_interface", value)

    @property
    @pulumi.getter(name="egressSubnet")
    def egress_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Egress Interface Subnet. Select the subnet whose name contains “FW-ingress-egress”. For GCP, `egress_subnet` must be in the form `cidr~~region~~name`.
        """
        return pulumi.get(self, "egress_subnet")

    @egress_subnet.setter
    def egress_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_subnet", value)

    @property
    @pulumi.getter(name="egressVpcId")
    def egress_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Egress VPC ID. Required for GCP. Available as of provider version R2.18.1+.
        """
        return pulumi.get(self, "egress_vpc_id")

    @egress_vpc_id.setter
    def egress_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_vpc_id", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Fault domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="fileShareFolder")
    def file_share_folder(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. File share folder. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "file_share_folder")

    @file_share_folder.setter
    def file_share_folder(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_share_folder", value)

    @property
    @pulumi.getter(name="firenetGwName")
    def firenet_gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the primary FireNet gateway. **Required for all FireNet deployments that do not utilize the TGW-Integrated FireNet with AWS Native GWLB VPC.**
        """
        return pulumi.get(self, "firenet_gw_name")

    @firenet_gw_name.setter
    def firenet_gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firenet_gw_name", value)

    @property
    @pulumi.getter(name="firewallImage")
    def firewall_image(self) -> Optional[pulumi.Input[str]]:
        """
        One of the AWS/Azure/GCP AMIs from various vendors such as Palo Alto Networks.
        """
        return pulumi.get(self, "firewall_image")

    @firewall_image.setter
    def firewall_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_image", value)

    @property
    @pulumi.getter(name="firewallImageId")
    def firewall_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Firewall image ID. Applicable to AWS and Azure only. For AWS, please use AMI ID. For Azure, the format is “Publisher:Offer:Plan:Version”. Available as of provider version R2.19+.
        """
        return pulumi.get(self, "firewall_image_id")

    @firewall_image_id.setter
    def firewall_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_image_id", value)

    @property
    @pulumi.getter(name="firewallImageVersion")
    def firewall_image_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of firewall image. If not specified, Controller will automatically select the latest version available.
        """
        return pulumi.get(self, "firewall_image_version")

    @firewall_image_version.setter
    def firewall_image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_image_version", value)

    @property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the firewall instance to be created.
        """
        return pulumi.get(self, "firewall_name")

    @firewall_name.setter
    def firewall_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_name", value)

    @property
    @pulumi.getter(name="firewallSize")
    def firewall_size(self) -> Optional[pulumi.Input[str]]:
        """
        Instance size of the firewall. Example: "m5.xlarge".
        """
        return pulumi.get(self, "firewall_size")

    @firewall_size.setter
    def firewall_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_size", value)

    @property
    @pulumi.getter(name="gcpVpcId")
    def gcp_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        GCP Only. The current VPC ID.
        """
        return pulumi.get(self, "gcp_vpc_id")

    @gcp_vpc_id.setter
    def gcp_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gcp_vpc_id", value)

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> Optional[pulumi.Input[str]]:
        """
        Only available for AWS. In advanced mode, create an IAM Role on the AWS account that launched the FireNet gateway. Create a policy to attach to the role. The policy is to allow access to "Bootstrap Bucket".
        """
        return pulumi.get(self, "iam_role")

    @iam_role.setter
    def iam_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_role", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the firewall instance created.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable to AWS deployment only. AWS Key Pair name. If not provided a Key Pair will be generated.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="lanInterface")
    def lan_interface(self) -> Optional[pulumi.Input[str]]:
        """
        ID of Lan Interface created.
        """
        return pulumi.get(self, "lan_interface")

    @lan_interface.setter
    def lan_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lan_interface", value)

    @property
    @pulumi.getter(name="managementInterface")
    def management_interface(self) -> Optional[pulumi.Input[str]]:
        """
        ID of Management Interface created.
        """
        return pulumi.get(self, "management_interface")

    @management_interface.setter
    def management_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_interface", value)

    @property
    @pulumi.getter(name="managementSubnet")
    def management_subnet(self) -> Optional[pulumi.Input[str]]:
        """
        Management Interface Subnet. Select the subnet whose name contains “gateway and firewall management”. For GCP, `management_subnet` must be in the form `cidr~~region~~name`. Required for Palo Alto Networks VM-Series and OCI Check Point firewalls. Otherwise, it must be empty.
        """
        return pulumi.get(self, "management_subnet")

    @management_subnet.setter
    def management_subnet(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_subnet", value)

    @property
    @pulumi.getter(name="managementVpcId")
    def management_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Management VPC ID. Only used for GCP firewall. Required for Palo Alto Networks VM-Series, and required to be empty for Check Point or Fortinet series. Available as of provider version R2.18.1+.
        """
        return pulumi.get(self, "management_vpc_id")

    @management_vpc_id.setter
    def management_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_vpc_id", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable to Azure or AzureGov deployment only.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Management Public IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="sasUrlConfig")
    def sas_url_config(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. SAS URL Config. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "sas_url_config")

    @sas_url_config.setter
    def sas_url_config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url_config", value)

    @property
    @pulumi.getter(name="sasUrlLicense")
    def sas_url_license(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. SAS URL License. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "sas_url_license")

    @sas_url_license.setter
    def sas_url_license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sas_url_license", value)

    @property
    @pulumi.getter(name="shareDirectory")
    def share_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Share directory. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "share_directory")

    @share_directory.setter
    def share_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "share_directory", value)

    @property
    @pulumi.getter(name="sicKey")
    def sic_key(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Sic key. Applicable to Check Point Series deployment only.
        """
        return pulumi.get(self, "sic_key")

    @sic_key.setter
    def sic_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sic_key", value)

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable to Azure or AzureGov deployment only.
        """
        return pulumi.get(self, "ssh_public_key")

    @ssh_public_key.setter
    def ssh_public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssh_public_key", value)

    @property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Storage access key. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "storage_access_key")

    @storage_access_key.setter
    def storage_access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_access_key", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Mapping of key value pairs of tags for a firewall instance. Only available for AWS, AWSGov, GCP and Azure firewall instances. For AWS, AWSGov and Azure allowed characters are: letters, spaces, and numbers plus the following special characters: + - = . _ : @. For GCP allowed characters are: lowercase letters, numbers, "-" and "_". Example: {"key1" = "value1", "key2" = "value2"}.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. User Data. Applicable to Check Point Series and Fortinet Series deployment only. Type: String.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Applicable to Azure or AzureGov deployment only. "admin" as a username is not accepted.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        VPC ID of the Security VPC. For GCP, `vpc_id` must be in the form vpc_id~-~gcloud_project_id.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        Availability Zone. Required if creating a Firewall Instance with a Native AWS GWLB-enabled VPC. Applicable to AWS, Azure, and GCP only. Available as of provider version R2.17+.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class AviatrixFirewallInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 bootstrap_bucket_name: Optional[pulumi.Input[str]] = None,
                 bootstrap_storage_name: Optional[pulumi.Input[str]] = None,
                 container_folder: Optional[pulumi.Input[str]] = None,
                 egress_subnet: Optional[pulumi.Input[str]] = None,
                 egress_vpc_id: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 file_share_folder: Optional[pulumi.Input[str]] = None,
                 firenet_gw_name: Optional[pulumi.Input[str]] = None,
                 firewall_image: Optional[pulumi.Input[str]] = None,
                 firewall_image_id: Optional[pulumi.Input[str]] = None,
                 firewall_image_version: Optional[pulumi.Input[str]] = None,
                 firewall_name: Optional[pulumi.Input[str]] = None,
                 firewall_size: Optional[pulumi.Input[str]] = None,
                 iam_role: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 management_subnet: Optional[pulumi.Input[str]] = None,
                 management_vpc_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 sas_url_config: Optional[pulumi.Input[str]] = None,
                 sas_url_license: Optional[pulumi.Input[str]] = None,
                 share_directory: Optional[pulumi.Input[str]] = None,
                 sic_key: Optional[pulumi.Input[str]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 storage_access_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The **aviatrix_firewall_instance** resource allows the creation and management of Aviatrix Firewall Instances.

        This resource is used in [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Aviatrix Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions, in conjunction with other resources that may include, and are not limited to: **firenet**, **firewall_instance_association**, **aws_tgw** and **transit_gateway** resources.

        ## Import

        **firewall_instance** can be imported using the `instance_id`. For Azure or AzureGov FireNet instances, the value will be the `firewall_name` concatenated with a ":" and the Resource Group of the `vpc_id` set for that instance. e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixFirewallInstance:AviatrixFirewallInstance test instance_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: Availability domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        :param pulumi.Input[str] bootstrap_bucket_name: Only available for AWS and GCP. For GCP, only Palo Alto Networks VM-Series deployment can use this attribute. In advanced mode, specify a bootstrap bucket name where the initial configuration and policy file is stored.
        :param pulumi.Input[str] bootstrap_storage_name: Advanced option. Bootstrap storage name. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series/Fortinet Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] container_folder: Advanced option. Container folder. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] egress_subnet: Egress Interface Subnet. Select the subnet whose name contains “FW-ingress-egress”. For GCP, `egress_subnet` must be in the form `cidr~~region~~name`.
        :param pulumi.Input[str] egress_vpc_id: Egress VPC ID. Required for GCP. Available as of provider version R2.18.1+.
        :param pulumi.Input[str] fault_domain: Fault domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        :param pulumi.Input[str] file_share_folder: Advanced option. File share folder. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] firenet_gw_name: Name of the primary FireNet gateway. **Required for all FireNet deployments that do not utilize the TGW-Integrated FireNet with AWS Native GWLB VPC.**
        :param pulumi.Input[str] firewall_image: One of the AWS/Azure/GCP AMIs from various vendors such as Palo Alto Networks.
        :param pulumi.Input[str] firewall_image_id: Firewall image ID. Applicable to AWS and Azure only. For AWS, please use AMI ID. For Azure, the format is “Publisher:Offer:Plan:Version”. Available as of provider version R2.19+.
        :param pulumi.Input[str] firewall_image_version: Version of firewall image. If not specified, Controller will automatically select the latest version available.
        :param pulumi.Input[str] firewall_name: Name of the firewall instance to be created.
        :param pulumi.Input[str] firewall_size: Instance size of the firewall. Example: "m5.xlarge".
        :param pulumi.Input[str] iam_role: Only available for AWS. In advanced mode, create an IAM Role on the AWS account that launched the FireNet gateway. Create a policy to attach to the role. The policy is to allow access to "Bootstrap Bucket".
        :param pulumi.Input[str] key_name: Applicable to AWS deployment only. AWS Key Pair name. If not provided a Key Pair will be generated.
        :param pulumi.Input[str] management_subnet: Management Interface Subnet. Select the subnet whose name contains “gateway and firewall management”. For GCP, `management_subnet` must be in the form `cidr~~region~~name`. Required for Palo Alto Networks VM-Series and OCI Check Point firewalls. Otherwise, it must be empty.
        :param pulumi.Input[str] management_vpc_id: Management VPC ID. Only used for GCP firewall. Required for Palo Alto Networks VM-Series, and required to be empty for Check Point or Fortinet series. Available as of provider version R2.18.1+.
        :param pulumi.Input[str] password: Applicable to Azure or AzureGov deployment only.
        :param pulumi.Input[str] sas_url_config: Advanced option. SAS URL Config. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] sas_url_license: Advanced option. SAS URL License. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] share_directory: Advanced option. Share directory. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] sic_key: Advanced option. Sic key. Applicable to Check Point Series deployment only.
        :param pulumi.Input[str] ssh_public_key: Applicable to Azure or AzureGov deployment only.
        :param pulumi.Input[str] storage_access_key: Advanced option. Storage access key. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Mapping of key value pairs of tags for a firewall instance. Only available for AWS, AWSGov, GCP and Azure firewall instances. For AWS, AWSGov and Azure allowed characters are: letters, spaces, and numbers plus the following special characters: + - = . _ : @. For GCP allowed characters are: lowercase letters, numbers, "-" and "_". Example: {"key1" = "value1", "key2" = "value2"}.
        :param pulumi.Input[str] user_data: Advanced option. User Data. Applicable to Check Point Series and Fortinet Series deployment only. Type: String.
        :param pulumi.Input[str] username: Applicable to Azure or AzureGov deployment only. "admin" as a username is not accepted.
        :param pulumi.Input[str] vpc_id: VPC ID of the Security VPC. For GCP, `vpc_id` must be in the form vpc_id~-~gcloud_project_id.
        :param pulumi.Input[str] zone: Availability Zone. Required if creating a Firewall Instance with a Native AWS GWLB-enabled VPC. Applicable to AWS, Azure, and GCP only. Available as of provider version R2.17+.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixFirewallInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_firewall_instance** resource allows the creation and management of Aviatrix Firewall Instances.

        This resource is used in [Aviatrix FireNet](https://docs.aviatrix.com/HowTos/firewall_network_faq.html) and [Aviatrix Transit FireNet](https://docs.aviatrix.com/HowTos/transit_firenet_faq.html) solutions, in conjunction with other resources that may include, and are not limited to: **firenet**, **firewall_instance_association**, **aws_tgw** and **transit_gateway** resources.

        ## Import

        **firewall_instance** can be imported using the `instance_id`. For Azure or AzureGov FireNet instances, the value will be the `firewall_name` concatenated with a ":" and the Resource Group of the `vpc_id` set for that instance. e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixFirewallInstance:AviatrixFirewallInstance test instance_id
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixFirewallInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixFirewallInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 bootstrap_bucket_name: Optional[pulumi.Input[str]] = None,
                 bootstrap_storage_name: Optional[pulumi.Input[str]] = None,
                 container_folder: Optional[pulumi.Input[str]] = None,
                 egress_subnet: Optional[pulumi.Input[str]] = None,
                 egress_vpc_id: Optional[pulumi.Input[str]] = None,
                 fault_domain: Optional[pulumi.Input[str]] = None,
                 file_share_folder: Optional[pulumi.Input[str]] = None,
                 firenet_gw_name: Optional[pulumi.Input[str]] = None,
                 firewall_image: Optional[pulumi.Input[str]] = None,
                 firewall_image_id: Optional[pulumi.Input[str]] = None,
                 firewall_image_version: Optional[pulumi.Input[str]] = None,
                 firewall_name: Optional[pulumi.Input[str]] = None,
                 firewall_size: Optional[pulumi.Input[str]] = None,
                 iam_role: Optional[pulumi.Input[str]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 management_subnet: Optional[pulumi.Input[str]] = None,
                 management_vpc_id: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 sas_url_config: Optional[pulumi.Input[str]] = None,
                 sas_url_license: Optional[pulumi.Input[str]] = None,
                 share_directory: Optional[pulumi.Input[str]] = None,
                 sic_key: Optional[pulumi.Input[str]] = None,
                 ssh_public_key: Optional[pulumi.Input[str]] = None,
                 storage_access_key: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixFirewallInstanceArgs.__new__(AviatrixFirewallInstanceArgs)

            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["bootstrap_bucket_name"] = bootstrap_bucket_name
            __props__.__dict__["bootstrap_storage_name"] = bootstrap_storage_name
            __props__.__dict__["container_folder"] = container_folder
            if egress_subnet is None and not opts.urn:
                raise TypeError("Missing required property 'egress_subnet'")
            __props__.__dict__["egress_subnet"] = egress_subnet
            __props__.__dict__["egress_vpc_id"] = egress_vpc_id
            __props__.__dict__["fault_domain"] = fault_domain
            __props__.__dict__["file_share_folder"] = file_share_folder
            __props__.__dict__["firenet_gw_name"] = firenet_gw_name
            if firewall_image is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_image'")
            __props__.__dict__["firewall_image"] = firewall_image
            __props__.__dict__["firewall_image_id"] = firewall_image_id
            __props__.__dict__["firewall_image_version"] = firewall_image_version
            if firewall_name is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_name'")
            __props__.__dict__["firewall_name"] = firewall_name
            if firewall_size is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_size'")
            __props__.__dict__["firewall_size"] = firewall_size
            __props__.__dict__["iam_role"] = iam_role
            __props__.__dict__["key_name"] = None if key_name is None else pulumi.Output.secret(key_name)
            __props__.__dict__["management_subnet"] = management_subnet
            __props__.__dict__["management_vpc_id"] = management_vpc_id
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["sas_url_config"] = sas_url_config
            __props__.__dict__["sas_url_license"] = sas_url_license
            __props__.__dict__["share_directory"] = share_directory
            __props__.__dict__["sic_key"] = None if sic_key is None else pulumi.Output.secret(sic_key)
            __props__.__dict__["ssh_public_key"] = None if ssh_public_key is None else pulumi.Output.secret(ssh_public_key)
            __props__.__dict__["storage_access_key"] = None if storage_access_key is None else pulumi.Output.secret(storage_access_key)
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["username"] = username
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["zone"] = zone
            __props__.__dict__["cloud_type"] = None
            __props__.__dict__["egress_interface"] = None
            __props__.__dict__["gcp_vpc_id"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["lan_interface"] = None
            __props__.__dict__["management_interface"] = None
            __props__.__dict__["public_ip"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["keyName", "password", "sicKey", "sshPublicKey", "storageAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AviatrixFirewallInstance, __self__).__init__(
            'aviatrix:index/aviatrixFirewallInstance:AviatrixFirewallInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            bootstrap_bucket_name: Optional[pulumi.Input[str]] = None,
            bootstrap_storage_name: Optional[pulumi.Input[str]] = None,
            cloud_type: Optional[pulumi.Input[int]] = None,
            container_folder: Optional[pulumi.Input[str]] = None,
            egress_interface: Optional[pulumi.Input[str]] = None,
            egress_subnet: Optional[pulumi.Input[str]] = None,
            egress_vpc_id: Optional[pulumi.Input[str]] = None,
            fault_domain: Optional[pulumi.Input[str]] = None,
            file_share_folder: Optional[pulumi.Input[str]] = None,
            firenet_gw_name: Optional[pulumi.Input[str]] = None,
            firewall_image: Optional[pulumi.Input[str]] = None,
            firewall_image_id: Optional[pulumi.Input[str]] = None,
            firewall_image_version: Optional[pulumi.Input[str]] = None,
            firewall_name: Optional[pulumi.Input[str]] = None,
            firewall_size: Optional[pulumi.Input[str]] = None,
            gcp_vpc_id: Optional[pulumi.Input[str]] = None,
            iam_role: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            lan_interface: Optional[pulumi.Input[str]] = None,
            management_interface: Optional[pulumi.Input[str]] = None,
            management_subnet: Optional[pulumi.Input[str]] = None,
            management_vpc_id: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            sas_url_config: Optional[pulumi.Input[str]] = None,
            sas_url_license: Optional[pulumi.Input[str]] = None,
            share_directory: Optional[pulumi.Input[str]] = None,
            sic_key: Optional[pulumi.Input[str]] = None,
            ssh_public_key: Optional[pulumi.Input[str]] = None,
            storage_access_key: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'AviatrixFirewallInstance':
        """
        Get an existing AviatrixFirewallInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: Availability domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        :param pulumi.Input[str] bootstrap_bucket_name: Only available for AWS and GCP. For GCP, only Palo Alto Networks VM-Series deployment can use this attribute. In advanced mode, specify a bootstrap bucket name where the initial configuration and policy file is stored.
        :param pulumi.Input[str] bootstrap_storage_name: Advanced option. Bootstrap storage name. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series/Fortinet Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[int] cloud_type: Cloud Type.
        :param pulumi.Input[str] container_folder: Advanced option. Container folder. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] egress_interface: ID of Egress Interface created.
        :param pulumi.Input[str] egress_subnet: Egress Interface Subnet. Select the subnet whose name contains “FW-ingress-egress”. For GCP, `egress_subnet` must be in the form `cidr~~region~~name`.
        :param pulumi.Input[str] egress_vpc_id: Egress VPC ID. Required for GCP. Available as of provider version R2.18.1+.
        :param pulumi.Input[str] fault_domain: Fault domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        :param pulumi.Input[str] file_share_folder: Advanced option. File share folder. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] firenet_gw_name: Name of the primary FireNet gateway. **Required for all FireNet deployments that do not utilize the TGW-Integrated FireNet with AWS Native GWLB VPC.**
        :param pulumi.Input[str] firewall_image: One of the AWS/Azure/GCP AMIs from various vendors such as Palo Alto Networks.
        :param pulumi.Input[str] firewall_image_id: Firewall image ID. Applicable to AWS and Azure only. For AWS, please use AMI ID. For Azure, the format is “Publisher:Offer:Plan:Version”. Available as of provider version R2.19+.
        :param pulumi.Input[str] firewall_image_version: Version of firewall image. If not specified, Controller will automatically select the latest version available.
        :param pulumi.Input[str] firewall_name: Name of the firewall instance to be created.
        :param pulumi.Input[str] firewall_size: Instance size of the firewall. Example: "m5.xlarge".
        :param pulumi.Input[str] gcp_vpc_id: GCP Only. The current VPC ID.
        :param pulumi.Input[str] iam_role: Only available for AWS. In advanced mode, create an IAM Role on the AWS account that launched the FireNet gateway. Create a policy to attach to the role. The policy is to allow access to "Bootstrap Bucket".
        :param pulumi.Input[str] instance_id: ID of the firewall instance created.
        :param pulumi.Input[str] key_name: Applicable to AWS deployment only. AWS Key Pair name. If not provided a Key Pair will be generated.
        :param pulumi.Input[str] lan_interface: ID of Lan Interface created.
        :param pulumi.Input[str] management_interface: ID of Management Interface created.
        :param pulumi.Input[str] management_subnet: Management Interface Subnet. Select the subnet whose name contains “gateway and firewall management”. For GCP, `management_subnet` must be in the form `cidr~~region~~name`. Required for Palo Alto Networks VM-Series and OCI Check Point firewalls. Otherwise, it must be empty.
        :param pulumi.Input[str] management_vpc_id: Management VPC ID. Only used for GCP firewall. Required for Palo Alto Networks VM-Series, and required to be empty for Check Point or Fortinet series. Available as of provider version R2.18.1+.
        :param pulumi.Input[str] password: Applicable to Azure or AzureGov deployment only.
        :param pulumi.Input[str] public_ip: Management Public IP.
        :param pulumi.Input[str] sas_url_config: Advanced option. SAS URL Config. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] sas_url_license: Advanced option. SAS URL License. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        :param pulumi.Input[str] share_directory: Advanced option. Share directory. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[str] sic_key: Advanced option. Sic key. Applicable to Check Point Series deployment only.
        :param pulumi.Input[str] ssh_public_key: Applicable to Azure or AzureGov deployment only.
        :param pulumi.Input[str] storage_access_key: Advanced option. Storage access key. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Mapping of key value pairs of tags for a firewall instance. Only available for AWS, AWSGov, GCP and Azure firewall instances. For AWS, AWSGov and Azure allowed characters are: letters, spaces, and numbers plus the following special characters: + - = . _ : @. For GCP allowed characters are: lowercase letters, numbers, "-" and "_". Example: {"key1" = "value1", "key2" = "value2"}.
        :param pulumi.Input[str] user_data: Advanced option. User Data. Applicable to Check Point Series and Fortinet Series deployment only. Type: String.
        :param pulumi.Input[str] username: Applicable to Azure or AzureGov deployment only. "admin" as a username is not accepted.
        :param pulumi.Input[str] vpc_id: VPC ID of the Security VPC. For GCP, `vpc_id` must be in the form vpc_id~-~gcloud_project_id.
        :param pulumi.Input[str] zone: Availability Zone. Required if creating a Firewall Instance with a Native AWS GWLB-enabled VPC. Applicable to AWS, Azure, and GCP only. Available as of provider version R2.17+.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixFirewallInstanceState.__new__(_AviatrixFirewallInstanceState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["bootstrap_bucket_name"] = bootstrap_bucket_name
        __props__.__dict__["bootstrap_storage_name"] = bootstrap_storage_name
        __props__.__dict__["cloud_type"] = cloud_type
        __props__.__dict__["container_folder"] = container_folder
        __props__.__dict__["egress_interface"] = egress_interface
        __props__.__dict__["egress_subnet"] = egress_subnet
        __props__.__dict__["egress_vpc_id"] = egress_vpc_id
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["file_share_folder"] = file_share_folder
        __props__.__dict__["firenet_gw_name"] = firenet_gw_name
        __props__.__dict__["firewall_image"] = firewall_image
        __props__.__dict__["firewall_image_id"] = firewall_image_id
        __props__.__dict__["firewall_image_version"] = firewall_image_version
        __props__.__dict__["firewall_name"] = firewall_name
        __props__.__dict__["firewall_size"] = firewall_size
        __props__.__dict__["gcp_vpc_id"] = gcp_vpc_id
        __props__.__dict__["iam_role"] = iam_role
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["lan_interface"] = lan_interface
        __props__.__dict__["management_interface"] = management_interface
        __props__.__dict__["management_subnet"] = management_subnet
        __props__.__dict__["management_vpc_id"] = management_vpc_id
        __props__.__dict__["password"] = password
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["sas_url_config"] = sas_url_config
        __props__.__dict__["sas_url_license"] = sas_url_license
        __props__.__dict__["share_directory"] = share_directory
        __props__.__dict__["sic_key"] = sic_key
        __props__.__dict__["ssh_public_key"] = ssh_public_key
        __props__.__dict__["storage_access_key"] = storage_access_key
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["username"] = username
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone"] = zone
        return AviatrixFirewallInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        Availability domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="bootstrapBucketName")
    def bootstrap_bucket_name(self) -> pulumi.Output[Optional[str]]:
        """
        Only available for AWS and GCP. For GCP, only Palo Alto Networks VM-Series deployment can use this attribute. In advanced mode, specify a bootstrap bucket name where the initial configuration and policy file is stored.
        """
        return pulumi.get(self, "bootstrap_bucket_name")

    @property
    @pulumi.getter(name="bootstrapStorageName")
    def bootstrap_storage_name(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. Bootstrap storage name. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series/Fortinet Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "bootstrap_storage_name")

    @property
    @pulumi.getter(name="cloudType")
    def cloud_type(self) -> pulumi.Output[int]:
        """
        Cloud Type.
        """
        return pulumi.get(self, "cloud_type")

    @property
    @pulumi.getter(name="containerFolder")
    def container_folder(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. Container folder. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "container_folder")

    @property
    @pulumi.getter(name="egressInterface")
    def egress_interface(self) -> pulumi.Output[str]:
        """
        ID of Egress Interface created.
        """
        return pulumi.get(self, "egress_interface")

    @property
    @pulumi.getter(name="egressSubnet")
    def egress_subnet(self) -> pulumi.Output[str]:
        """
        Egress Interface Subnet. Select the subnet whose name contains “FW-ingress-egress”. For GCP, `egress_subnet` must be in the form `cidr~~region~~name`.
        """
        return pulumi.get(self, "egress_subnet")

    @property
    @pulumi.getter(name="egressVpcId")
    def egress_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        Egress VPC ID. Required for GCP. Available as of provider version R2.18.1+.
        """
        return pulumi.get(self, "egress_vpc_id")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[str]:
        """
        Fault domain. Required and valid only for OCI. Available as of provider version R2.19.3.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="fileShareFolder")
    def file_share_folder(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. File share folder. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "file_share_folder")

    @property
    @pulumi.getter(name="firenetGwName")
    def firenet_gw_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the primary FireNet gateway. **Required for all FireNet deployments that do not utilize the TGW-Integrated FireNet with AWS Native GWLB VPC.**
        """
        return pulumi.get(self, "firenet_gw_name")

    @property
    @pulumi.getter(name="firewallImage")
    def firewall_image(self) -> pulumi.Output[str]:
        """
        One of the AWS/Azure/GCP AMIs from various vendors such as Palo Alto Networks.
        """
        return pulumi.get(self, "firewall_image")

    @property
    @pulumi.getter(name="firewallImageId")
    def firewall_image_id(self) -> pulumi.Output[str]:
        """
        Firewall image ID. Applicable to AWS and Azure only. For AWS, please use AMI ID. For Azure, the format is “Publisher:Offer:Plan:Version”. Available as of provider version R2.19+.
        """
        return pulumi.get(self, "firewall_image_id")

    @property
    @pulumi.getter(name="firewallImageVersion")
    def firewall_image_version(self) -> pulumi.Output[str]:
        """
        Version of firewall image. If not specified, Controller will automatically select the latest version available.
        """
        return pulumi.get(self, "firewall_image_version")

    @property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> pulumi.Output[str]:
        """
        Name of the firewall instance to be created.
        """
        return pulumi.get(self, "firewall_name")

    @property
    @pulumi.getter(name="firewallSize")
    def firewall_size(self) -> pulumi.Output[str]:
        """
        Instance size of the firewall. Example: "m5.xlarge".
        """
        return pulumi.get(self, "firewall_size")

    @property
    @pulumi.getter(name="gcpVpcId")
    def gcp_vpc_id(self) -> pulumi.Output[str]:
        """
        GCP Only. The current VPC ID.
        """
        return pulumi.get(self, "gcp_vpc_id")

    @property
    @pulumi.getter(name="iamRole")
    def iam_role(self) -> pulumi.Output[Optional[str]]:
        """
        Only available for AWS. In advanced mode, create an IAM Role on the AWS account that launched the FireNet gateway. Create a policy to attach to the role. The policy is to allow access to "Bootstrap Bucket".
        """
        return pulumi.get(self, "iam_role")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        ID of the firewall instance created.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        Applicable to AWS deployment only. AWS Key Pair name. If not provided a Key Pair will be generated.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="lanInterface")
    def lan_interface(self) -> pulumi.Output[str]:
        """
        ID of Lan Interface created.
        """
        return pulumi.get(self, "lan_interface")

    @property
    @pulumi.getter(name="managementInterface")
    def management_interface(self) -> pulumi.Output[str]:
        """
        ID of Management Interface created.
        """
        return pulumi.get(self, "management_interface")

    @property
    @pulumi.getter(name="managementSubnet")
    def management_subnet(self) -> pulumi.Output[Optional[str]]:
        """
        Management Interface Subnet. Select the subnet whose name contains “gateway and firewall management”. For GCP, `management_subnet` must be in the form `cidr~~region~~name`. Required for Palo Alto Networks VM-Series and OCI Check Point firewalls. Otherwise, it must be empty.
        """
        return pulumi.get(self, "management_subnet")

    @property
    @pulumi.getter(name="managementVpcId")
    def management_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        Management VPC ID. Only used for GCP firewall. Required for Palo Alto Networks VM-Series, and required to be empty for Check Point or Fortinet series. Available as of provider version R2.18.1+.
        """
        return pulumi.get(self, "management_vpc_id")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Applicable to Azure or AzureGov deployment only.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        Management Public IP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="sasUrlConfig")
    def sas_url_config(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. SAS URL Config. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "sas_url_config")

    @property
    @pulumi.getter(name="sasUrlLicense")
    def sas_url_license(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. SAS URL License. Applicable to Azure or AzureGov and Fortinet Series deployment only.
        """
        return pulumi.get(self, "sas_url_license")

    @property
    @pulumi.getter(name="shareDirectory")
    def share_directory(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. Share directory. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "share_directory")

    @property
    @pulumi.getter(name="sicKey")
    def sic_key(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. Sic key. Applicable to Check Point Series deployment only.
        """
        return pulumi.get(self, "sic_key")

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> pulumi.Output[Optional[str]]:
        """
        Applicable to Azure or AzureGov deployment only.
        """
        return pulumi.get(self, "ssh_public_key")

    @property
    @pulumi.getter(name="storageAccessKey")
    def storage_access_key(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. Storage access key. Applicable to Azure or AzureGov and Palo Alto Networks VM-Series deployment only. Available as of provider version R2.17.1+.
        """
        return pulumi.get(self, "storage_access_key")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Mapping of key value pairs of tags for a firewall instance. Only available for AWS, AWSGov, GCP and Azure firewall instances. For AWS, AWSGov and Azure allowed characters are: letters, spaces, and numbers plus the following special characters: + - = . _ : @. For GCP allowed characters are: lowercase letters, numbers, "-" and "_". Example: {"key1" = "value1", "key2" = "value2"}.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced option. User Data. Applicable to Check Point Series and Fortinet Series deployment only. Type: String.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[str]]:
        """
        Applicable to Azure or AzureGov deployment only. "admin" as a username is not accepted.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        VPC ID of the Security VPC. For GCP, `vpc_id` must be in the form vpc_id~-~gcloud_project_id.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        Availability Zone. Required if creating a Firewall Instance with a Native AWS GWLB-enabled VPC. Applicable to AWS, Azure, and GCP only. Available as of provider version R2.17+.
        """
        return pulumi.get(self, "zone")

