# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'AviatrixAppDomainSelectorArgs',
    'AviatrixAppDomainSelectorMatchExpressionArgs',
    'AviatrixAwsTgwSecurityDomainArgs',
    'AviatrixAwsTgwSecurityDomainAttachedVpcArgs',
    'AviatrixAwsTgwVpnConnVpnTunnelDataArgs',
    'AviatrixFirenetFirewallInstanceAssociationArgs',
    'AviatrixFirewallPolicyArgs',
    'AviatrixFirewallTagCidrListArgs',
    'AviatrixFqdnDomainNameArgs',
    'AviatrixFqdnGwFilterTagListArgs',
    'AviatrixGatewayDnatConnectionPolicyArgs',
    'AviatrixGatewayDnatDnatPolicyArgs',
    'AviatrixGatewayDnatInterfacePolicyArgs',
    'AviatrixGatewaySnatConnectionPolicyArgs',
    'AviatrixGatewaySnatInterfacePolicyArgs',
    'AviatrixGatewaySnatSnatPolicyArgs',
    'AviatrixMicrosegPolicyListPolicyArgs',
    'AviatrixMicrosegPolicyListPolicyPortRangeArgs',
    'AviatrixPrivateModeLbProxyArgs',
    'AviatrixSite2CloudCaCertTagCaCertificateArgs',
    'AviatrixTransitGatewayBgpLanInterfaceArgs',
    'AviatrixTransitGatewayHaBgpLanInterfaceArgs',
    'AviatrixVpcPrivateSubnetArgs',
    'AviatrixVpcPublicSubnetArgs',
    'AviatrixVpcSubnetArgs',
    'AviatrixVpnProfilePolicyArgs',
    'ProviderIgnoreTagsArgs',
    'GetAviatrixFirenetFirewallInstanceAssociationArgs',
]

@pulumi.input_type
class AviatrixAppDomainSelectorArgs:
    def __init__(__self__, *,
                 match_expressions: pulumi.Input[Sequence[pulumi.Input['AviatrixAppDomainSelectorMatchExpressionArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixAppDomainSelectorMatchExpressionArgs']]] match_expressions: List of match expressions. The App Domain will be a union of all resources matched by each `match_expressions`.`match_expressions` blocks cannot be empty.
        """
        pulumi.set(__self__, "match_expressions", match_expressions)

    @property
    @pulumi.getter(name="matchExpressions")
    def match_expressions(self) -> pulumi.Input[Sequence[pulumi.Input['AviatrixAppDomainSelectorMatchExpressionArgs']]]:
        """
        List of match expressions. The App Domain will be a union of all resources matched by each `match_expressions`.`match_expressions` blocks cannot be empty.
        """
        return pulumi.get(self, "match_expressions")

    @match_expressions.setter
    def match_expressions(self, value: pulumi.Input[Sequence[pulumi.Input['AviatrixAppDomainSelectorMatchExpressionArgs']]]):
        pulumi.set(self, "match_expressions", value)


@pulumi.input_type
class AviatrixAppDomainSelectorMatchExpressionArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[str]] = None,
                 account_name: Optional[pulumi.Input[str]] = None,
                 cidr: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 res_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] account_id: - Account ID this expression matches.
        :param pulumi.Input[str] account_name: - Account name this expression matches.
        :param pulumi.Input[str] cidr: - CIDR block or IP Address this expression matches. `cidr` cannot be used with any other filters in the same `match_expressions` block.
        :param pulumi.Input[str] region: - Region this expression matches.
        :param pulumi.Input[str] res_id: - Resource ID this expression matches.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: - Map of tags this expression matches.
        :param pulumi.Input[str] type: - Type of resource this expression matches. Must be one of "vm", "vpc" or "subnet". `type` is required when `cidr` is not used.
        :param pulumi.Input[str] zone: - Zone this expression matches.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if res_id is not None:
            pulumi.set(__self__, "res_id", res_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[str]]:
        """
        - Account ID this expression matches.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_id", value)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[str]]:
        """
        - Account name this expression matches.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_name", value)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        - CIDR block or IP Address this expression matches. `cidr` cannot be used with any other filters in the same `match_expressions` block.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        - Region this expression matches.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resId")
    def res_id(self) -> Optional[pulumi.Input[str]]:
        """
        - Resource ID this expression matches.
        """
        return pulumi.get(self, "res_id")

    @res_id.setter
    def res_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "res_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        - Map of tags this expression matches.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        - Type of resource this expression matches. Must be one of "vm", "vpc" or "subnet". `type` is required when `cidr` is not used.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        - Zone this expression matches.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class AviatrixAwsTgwSecurityDomainArgs:
    def __init__(__self__, *,
                 security_domain_name: pulumi.Input[str],
                 attached_vpcs: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainAttachedVpcArgs']]]] = None,
                 aviatrix_firewall: Optional[pulumi.Input[bool]] = None,
                 connected_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 native_egress: Optional[pulumi.Input[bool]] = None,
                 native_firewall: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] security_domain_name: Three default domains ("Aviatrix_Edge_Domain", "Default_Domain" and "Shared_Service_Domain") are required with AWS TGW's creation.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainAttachedVpcArgs']]] attached_vpcs: A list of VPCs attached to the domain (name: `security_domain_name`) together with its creation. This list needs to be null for "Aviatrix_Edge_Domain".
        :param pulumi.Input[bool] aviatrix_firewall: Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] connected_domains: A list of domains connected to the domain (name: `security_domain_name`) together with its creation.
        :param pulumi.Input[bool] native_egress: Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        :param pulumi.Input[bool] native_firewall: Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        """
        pulumi.set(__self__, "security_domain_name", security_domain_name)
        if attached_vpcs is not None:
            warnings.warn("""Please set `manage_vpc_attachment` to false, and use the standalone aviatrix_aws_tgw_vpc_attachment resource instead.""", DeprecationWarning)
            pulumi.log.warn("""attached_vpcs is deprecated: Please set `manage_vpc_attachment` to false, and use the standalone aviatrix_aws_tgw_vpc_attachment resource instead.""")
        if attached_vpcs is not None:
            pulumi.set(__self__, "attached_vpcs", attached_vpcs)
        if aviatrix_firewall is not None:
            pulumi.set(__self__, "aviatrix_firewall", aviatrix_firewall)
        if connected_domains is not None:
            pulumi.set(__self__, "connected_domains", connected_domains)
        if native_egress is not None:
            pulumi.set(__self__, "native_egress", native_egress)
        if native_firewall is not None:
            pulumi.set(__self__, "native_firewall", native_firewall)

    @property
    @pulumi.getter(name="securityDomainName")
    def security_domain_name(self) -> pulumi.Input[str]:
        """
        Three default domains ("Aviatrix_Edge_Domain", "Default_Domain" and "Shared_Service_Domain") are required with AWS TGW's creation.
        """
        return pulumi.get(self, "security_domain_name")

    @security_domain_name.setter
    def security_domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_domain_name", value)

    @property
    @pulumi.getter(name="attachedVpcs")
    def attached_vpcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainAttachedVpcArgs']]]]:
        """
        A list of VPCs attached to the domain (name: `security_domain_name`) together with its creation. This list needs to be null for "Aviatrix_Edge_Domain".
        """
        return pulumi.get(self, "attached_vpcs")

    @attached_vpcs.setter
    def attached_vpcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixAwsTgwSecurityDomainAttachedVpcArgs']]]]):
        pulumi.set(self, "attached_vpcs", value)

    @property
    @pulumi.getter(name="aviatrixFirewall")
    def aviatrix_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as an Aviatrix Firewall Domain for the Aviatrix Firewall Network. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "aviatrix_firewall")

    @aviatrix_firewall.setter
    def aviatrix_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "aviatrix_firewall", value)

    @property
    @pulumi.getter(name="connectedDomains")
    def connected_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of domains connected to the domain (name: `security_domain_name`) together with its creation.
        """
        return pulumi.get(self, "connected_domains")

    @connected_domains.setter
    def connected_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "connected_domains", value)

    @property
    @pulumi.getter(name="nativeEgress")
    def native_egress(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as a native egress domain (for non-Aviatrix Firewall Network-based central Internet bound traffic). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "native_egress")

    @native_egress.setter
    def native_egress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_egress", value)

    @property
    @pulumi.getter(name="nativeFirewall")
    def native_firewall(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true if the security domain is to be used as a native firewall domain (for non-Aviatrix Firewall Network-based firewall traffic inspection). Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "native_firewall")

    @native_firewall.setter
    def native_firewall(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "native_firewall", value)


@pulumi.input_type
class AviatrixAwsTgwSecurityDomainAttachedVpcArgs:
    def __init__(__self__, *,
                 vpc_account_name: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 vpc_region: pulumi.Input[str],
                 customized_route_advertisement: Optional[pulumi.Input[str]] = None,
                 customized_routes: Optional[pulumi.Input[str]] = None,
                 disable_local_route_propagation: Optional[pulumi.Input[bool]] = None,
                 route_tables: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] vpc_account_name: Cloud account name of the VPC in the Aviatrix controller.
        :param pulumi.Input[str] vpc_id: VPC ID of the VPC to be attached to the security domain
        :param pulumi.Input[str] vpc_region: Region of the VPC, needs to be consistent with AWS TGW's region.
        :param pulumi.Input[str] customized_route_advertisement: Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW. Example: "10.8.0.0/16,10.9.0.0/16,10.10.0.0/16".
        :param pulumi.Input[str] customized_routes: Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table targeting the TGW. Example: "10.8.0.0/16,10.9.0.0/16,10.10.0.0/16".
        :param pulumi.Input[bool] disable_local_route_propagation: Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same security domain. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] route_tables: Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be propagated to these route tables. Example: "rtb-212ff547,rtb-045397874c170c745".
        :param pulumi.Input[str] subnets: Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, the Aviatrix Controller automatically selects a subnet representing each AZ for the VPC attachment. Example: "subnet-214f5646,subnet-085e8c81a89d70846".
        """
        pulumi.set(__self__, "vpc_account_name", vpc_account_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vpc_region", vpc_region)
        if customized_route_advertisement is not None:
            pulumi.set(__self__, "customized_route_advertisement", customized_route_advertisement)
        if customized_routes is not None:
            pulumi.set(__self__, "customized_routes", customized_routes)
        if disable_local_route_propagation is not None:
            pulumi.set(__self__, "disable_local_route_propagation", disable_local_route_propagation)
        if route_tables is not None:
            pulumi.set(__self__, "route_tables", route_tables)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="vpcAccountName")
    def vpc_account_name(self) -> pulumi.Input[str]:
        """
        Cloud account name of the VPC in the Aviatrix controller.
        """
        return pulumi.get(self, "vpc_account_name")

    @vpc_account_name.setter
    def vpc_account_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_account_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID of the VPC to be attached to the security domain
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcRegion")
    def vpc_region(self) -> pulumi.Input[str]:
        """
        Region of the VPC, needs to be consistent with AWS TGW's region.
        """
        return pulumi.get(self, "vpc_region")

    @vpc_region.setter
    def vpc_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_region", value)

    @property
    @pulumi.getter(name="customizedRouteAdvertisement")
    def customized_route_advertisement(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Customized route(s) to be advertised to other VPCs that are connected to the same TGW. Example: "10.8.0.0/16,10.9.0.0/16,10.10.0.0/16".
        """
        return pulumi.get(self, "customized_route_advertisement")

    @customized_route_advertisement.setter
    def customized_route_advertisement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_route_advertisement", value)

    @property
    @pulumi.getter(name="customizedRoutes")
    def customized_routes(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Customized Spoke VPC Routes. It allows the admin to enter non-RFC1918 routes in the VPC route table targeting the TGW. Example: "10.8.0.0/16,10.9.0.0/16,10.10.0.0/16".
        """
        return pulumi.get(self, "customized_routes")

    @customized_routes.setter
    def customized_routes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customized_routes", value)

    @property
    @pulumi.getter(name="disableLocalRoutePropagation")
    def disable_local_route_propagation(self) -> Optional[pulumi.Input[bool]]:
        """
        Advanced option. If set to true, it disables automatic route propagation of this VPC to other VPCs within the same security domain. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "disable_local_route_propagation")

    @disable_local_route_propagation.setter
    def disable_local_route_propagation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_local_route_propagation", value)

    @property
    @pulumi.getter(name="routeTables")
    def route_tables(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. Route tables separated by ',' to participate in TGW Orchestrator, i.e., learned routes will be propagated to these route tables. Example: "rtb-212ff547,rtb-045397874c170c745".
        """
        return pulumi.get(self, "route_tables")

    @route_tables.setter
    def route_tables(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_tables", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced option. VPC subnets separated by ',' to attach to the VPC. If left blank, the Aviatrix Controller automatically selects a subnet representing each AZ for the VPC attachment. Example: "subnet-214f5646,subnet-085e8c81a89d70846".
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class AviatrixAwsTgwVpnConnVpnTunnelDataArgs:
    def __init__(__self__, *,
                 last_status_change_time: Optional[pulumi.Input[str]] = None,
                 route_count: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_message: Optional[pulumi.Input[str]] = None,
                 tgw_asn: Optional[pulumi.Input[str]] = None,
                 tunnel_name: Optional[pulumi.Input[str]] = None,
                 vpn_inside_address: Optional[pulumi.Input[str]] = None,
                 vpn_outside_address: Optional[pulumi.Input[str]] = None):
        if last_status_change_time is not None:
            pulumi.set(__self__, "last_status_change_time", last_status_change_time)
        if route_count is not None:
            pulumi.set(__self__, "route_count", route_count)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)
        if tgw_asn is not None:
            pulumi.set(__self__, "tgw_asn", tgw_asn)
        if tunnel_name is not None:
            pulumi.set(__self__, "tunnel_name", tunnel_name)
        if vpn_inside_address is not None:
            pulumi.set(__self__, "vpn_inside_address", vpn_inside_address)
        if vpn_outside_address is not None:
            pulumi.set(__self__, "vpn_outside_address", vpn_outside_address)

    @property
    @pulumi.getter(name="lastStatusChangeTime")
    def last_status_change_time(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "last_status_change_time")

    @last_status_change_time.setter
    def last_status_change_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_status_change_time", value)

    @property
    @pulumi.getter(name="routeCount")
    def route_count(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "route_count")

    @route_count.setter
    def route_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "route_count", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_message", value)

    @property
    @pulumi.getter(name="tgwAsn")
    def tgw_asn(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tgw_asn")

    @tgw_asn.setter
    def tgw_asn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tgw_asn", value)

    @property
    @pulumi.getter(name="tunnelName")
    def tunnel_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tunnel_name")

    @tunnel_name.setter
    def tunnel_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tunnel_name", value)

    @property
    @pulumi.getter(name="vpnInsideAddress")
    def vpn_inside_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpn_inside_address")

    @vpn_inside_address.setter
    def vpn_inside_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_inside_address", value)

    @property
    @pulumi.getter(name="vpnOutsideAddress")
    def vpn_outside_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpn_outside_address")

    @vpn_outside_address.setter
    def vpn_outside_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpn_outside_address", value)


@pulumi.input_type
class AviatrixFirenetFirewallInstanceAssociationArgs:
    def __init__(__self__, *,
                 firenet_gw_name: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 attached: Optional[pulumi.Input[bool]] = None,
                 egress_interface: Optional[pulumi.Input[str]] = None,
                 firewall_name: Optional[pulumi.Input[str]] = None,
                 lan_interface: Optional[pulumi.Input[str]] = None,
                 management_interface: Optional[pulumi.Input[str]] = None,
                 vendor_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] firenet_gw_name: Name of the primary FireNet gateway.
        :param pulumi.Input[str] instance_id: ID of Firewall instance.
        :param pulumi.Input[bool] attached: Switch to attach/detach firewall instance to/from FireNet. Valid values: true, false. Default value: false.
        :param pulumi.Input[str] egress_interface: Egress interface ID. **Required if it is a firewall instance.**
        :param pulumi.Input[str] firewall_name: Firewall instance name. **Required if it is a firewall instance.**
        :param pulumi.Input[str] lan_interface: Lan interface ID. **Required if it is a firewall instance or FQDN gateway in Azure.**
        :param pulumi.Input[str] management_interface: Management interface ID. **Required if it is a firewall instance.**
        :param pulumi.Input[str] vendor_type: Type of firewall. Valid values: "Generic", "fqdn_gateway". Default value: "Generic". Value "fqdn_gateway" is required for FQDN gateway.
        """
        pulumi.set(__self__, "firenet_gw_name", firenet_gw_name)
        pulumi.set(__self__, "instance_id", instance_id)
        if attached is not None:
            pulumi.set(__self__, "attached", attached)
        if egress_interface is not None:
            pulumi.set(__self__, "egress_interface", egress_interface)
        if firewall_name is not None:
            pulumi.set(__self__, "firewall_name", firewall_name)
        if lan_interface is not None:
            pulumi.set(__self__, "lan_interface", lan_interface)
        if management_interface is not None:
            pulumi.set(__self__, "management_interface", management_interface)
        if vendor_type is not None:
            pulumi.set(__self__, "vendor_type", vendor_type)

    @property
    @pulumi.getter(name="firenetGwName")
    def firenet_gw_name(self) -> pulumi.Input[str]:
        """
        Name of the primary FireNet gateway.
        """
        return pulumi.get(self, "firenet_gw_name")

    @firenet_gw_name.setter
    def firenet_gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "firenet_gw_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        ID of Firewall instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def attached(self) -> Optional[pulumi.Input[bool]]:
        """
        Switch to attach/detach firewall instance to/from FireNet. Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "attached")

    @attached.setter
    def attached(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "attached", value)

    @property
    @pulumi.getter(name="egressInterface")
    def egress_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Egress interface ID. **Required if it is a firewall instance.**
        """
        return pulumi.get(self, "egress_interface")

    @egress_interface.setter
    def egress_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_interface", value)

    @property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> Optional[pulumi.Input[str]]:
        """
        Firewall instance name. **Required if it is a firewall instance.**
        """
        return pulumi.get(self, "firewall_name")

    @firewall_name.setter
    def firewall_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "firewall_name", value)

    @property
    @pulumi.getter(name="lanInterface")
    def lan_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Lan interface ID. **Required if it is a firewall instance or FQDN gateway in Azure.**
        """
        return pulumi.get(self, "lan_interface")

    @lan_interface.setter
    def lan_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lan_interface", value)

    @property
    @pulumi.getter(name="managementInterface")
    def management_interface(self) -> Optional[pulumi.Input[str]]:
        """
        Management interface ID. **Required if it is a firewall instance.**
        """
        return pulumi.get(self, "management_interface")

    @management_interface.setter
    def management_interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_interface", value)

    @property
    @pulumi.getter(name="vendorType")
    def vendor_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of firewall. Valid values: "Generic", "fqdn_gateway". Default value: "Generic". Value "fqdn_gateway" is required for FQDN gateway.
        """
        return pulumi.get(self, "vendor_type")

    @vendor_type.setter
    def vendor_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor_type", value)


@pulumi.input_type
class AviatrixFirewallPolicyArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 dst_ip: pulumi.Input[str],
                 port: pulumi.Input[str],
                 src_ip: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 log_enabled: Optional[pulumi.Input[bool]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        :param pulumi.Input[str] dst_ip: Destination address, a valid IPv4 address or tag name such "HR" or "marketing" etc. Example: "10.30.0.0/16". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        :param pulumi.Input[str] port: A single port or a range of port numbers. Example: "25", "25:1024".
        :param pulumi.Input[str] src_ip: Source address, a valid IPv4 address or tag name such "HR" or "marketing" etc. Example: "10.30.0.0/16". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        :param pulumi.Input[str] description: Description of the policy. Example: "This is policy no.1".
        :param pulumi.Input[bool] log_enabled: Valid values: true, false. Default value: false.
        :param pulumi.Input[str] protocol: : Valid values: "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp". Default value: "all".
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "dst_ip", dst_ip)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "src_ip", src_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if log_enabled is not None:
            pulumi.set(__self__, "log_enabled", log_enabled)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Valid values: "allow", "deny" and "force-drop" (in stateful firewall rule to allow immediate packet dropping on established sessions).
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="dstIp")
    def dst_ip(self) -> pulumi.Input[str]:
        """
        Destination address, a valid IPv4 address or tag name such "HR" or "marketing" etc. Example: "10.30.0.0/16". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        return pulumi.get(self, "dst_ip")

    @dst_ip.setter
    def dst_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "dst_ip", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        A single port or a range of port numbers. Example: "25", "25:1024".
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="srcIp")
    def src_ip(self) -> pulumi.Input[str]:
        """
        Source address, a valid IPv4 address or tag name such "HR" or "marketing" etc. Example: "10.30.0.0/16". The **aviatrix_firewall_tag** resource should be created prior to using the tag name.
        """
        return pulumi.get(self, "src_ip")

    @src_ip.setter
    def src_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "src_ip", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the policy. Example: "This is policy no.1".
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="logEnabled")
    def log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Valid values: true, false. Default value: false.
        """
        return pulumi.get(self, "log_enabled")

    @log_enabled.setter
    def log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "log_enabled", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        : Valid values: "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp". Default value: "all".
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class AviatrixFirewallTagCidrListArgs:
    def __init__(__self__, *,
                 cidr: pulumi.Input[str],
                 cidr_tag_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] cidr: CIDR address to filter. Example: "10.88.88.88/32".
        :param pulumi.Input[str] cidr_tag_name: A name to identify the CIDR. Example: "policy1".
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "cidr_tag_name", cidr_tag_name)

    @property
    @pulumi.getter
    def cidr(self) -> pulumi.Input[str]:
        """
        CIDR address to filter. Example: "10.88.88.88/32".
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter(name="cidrTagName")
    def cidr_tag_name(self) -> pulumi.Input[str]:
        """
        A name to identify the CIDR. Example: "policy1".
        """
        return pulumi.get(self, "cidr_tag_name")

    @cidr_tag_name.setter
    def cidr_tag_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cidr_tag_name", value)


@pulumi.input_type
class AviatrixFqdnDomainNameArgs:
    def __init__(__self__, *,
                 fqdn: pulumi.Input[str],
                 port: pulumi.Input[str],
                 proto: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] fqdn: FQDN. Example: "facebook.com".
        :param pulumi.Input[str] port: Port. Example "25".
        :param pulumi.Input[str] proto: Protocol. Valid values: "all", "tcp", "udp", "icmp".
        :param pulumi.Input[str] action: What action should happen to matching requests. Possible values are: 'Base Policy', 'Allow' or 'Deny'. Defaults to 'Base Policy' if no value provided.
               * For protocol "all", port must be set to "all".
               * For protocol “icmp”, port must be set to “ping”.
        """
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "proto", proto)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @property
    @pulumi.getter
    def fqdn(self) -> pulumi.Input[str]:
        """
        FQDN. Example: "facebook.com".
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: pulumi.Input[str]):
        pulumi.set(self, "fqdn", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        Port. Example "25".
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def proto(self) -> pulumi.Input[str]:
        """
        Protocol. Valid values: "all", "tcp", "udp", "icmp".
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: pulumi.Input[str]):
        pulumi.set(self, "proto", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        What action should happen to matching requests. Possible values are: 'Base Policy', 'Allow' or 'Deny'. Defaults to 'Base Policy' if no value provided.
        * For protocol "all", port must be set to "all".
        * For protocol “icmp”, port must be set to “ping”.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)


@pulumi.input_type
class AviatrixFqdnGwFilterTagListArgs:
    def __init__(__self__, *,
                 gw_name: pulumi.Input[str],
                 source_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] gw_name: Name of the gateway to attach to the specific tag.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_ip_lists: List of source IPs in the VPC qualified for a specific tag.
        """
        pulumi.set(__self__, "gw_name", gw_name)
        if source_ip_lists is not None:
            pulumi.set(__self__, "source_ip_lists", source_ip_lists)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Name of the gateway to attach to the specific tag.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter(name="sourceIpLists")
    def source_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of source IPs in the VPC qualified for a specific tag.
        """
        return pulumi.get(self, "source_ip_lists")

    @source_ip_lists.setter
    def source_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_ip_lists", value)


@pulumi.input_type
class AviatrixGatewayDnatConnectionPolicyArgs:
    def __init__(__self__, *,
                 apply_route_entry: Optional[pulumi.Input[bool]] = None,
                 connection: Optional[pulumi.Input[str]] = None,
                 dnat_ips: Optional[pulumi.Input[str]] = None,
                 dnat_port: Optional[pulumi.Input[str]] = None,
                 dst_cidr: Optional[pulumi.Input[str]] = None,
                 dst_port: Optional[pulumi.Input[str]] = None,
                 exclude_rtb: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 mark: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 src_cidr: Optional[pulumi.Input[str]] = None,
                 src_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] apply_route_entry: This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.19.2+.
        :param pulumi.Input[str] connection: This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        :param pulumi.Input[str] dnat_ips: This is a rule field that specifies the translated destination IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        :param pulumi.Input[str] dnat_port: This is a rule field that specifies the translated destination port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        :param pulumi.Input[str] dst_cidr: This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] dst_port: This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] exclude_rtb: This field specifies which VPC private route table will not be programmed with the default route entry.
        :param pulumi.Input[str] interface: This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        :param pulumi.Input[str] mark: This is a rule field that specifies a tag or mark of a TCP session when all qualifier conditions meet. When not specified, this field is not used.
        :param pulumi.Input[str] protocol: This is a qualifier condition that specifies a destination port protocol where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_cidr: This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_port: This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        if apply_route_entry is not None:
            pulumi.set(__self__, "apply_route_entry", apply_route_entry)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if dnat_ips is not None:
            pulumi.set(__self__, "dnat_ips", dnat_ips)
        if dnat_port is not None:
            pulumi.set(__self__, "dnat_port", dnat_port)
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if exclude_rtb is not None:
            pulumi.set(__self__, "exclude_rtb", exclude_rtb)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mark is not None:
            pulumi.set(__self__, "mark", mark)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_port is not None:
            pulumi.set(__self__, "src_port", src_port)

    @property
    @pulumi.getter(name="applyRouteEntry")
    def apply_route_entry(self) -> Optional[pulumi.Input[bool]]:
        """
        This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.19.2+.
        """
        return pulumi.get(self, "apply_route_entry")

    @apply_route_entry.setter
    def apply_route_entry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_route_entry", value)

    @property
    @pulumi.getter
    def connection(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection", value)

    @property
    @pulumi.getter(name="dnatIps")
    def dnat_ips(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the translated destination IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        """
        return pulumi.get(self, "dnat_ips")

    @dnat_ips.setter
    def dnat_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dnat_ips", value)

    @property
    @pulumi.getter(name="dnatPort")
    def dnat_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the translated destination port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        """
        return pulumi.get(self, "dnat_port")

    @dnat_port.setter
    def dnat_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dnat_port", value)

    @property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_cidr")

    @dst_cidr.setter
    def dst_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_cidr", value)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter(name="excludeRtb")
    def exclude_rtb(self) -> Optional[pulumi.Input[str]]:
        """
        This field specifies which VPC private route table will not be programmed with the default route entry.
        """
        return pulumi.get(self, "exclude_rtb")

    @exclude_rtb.setter
    def exclude_rtb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_rtb", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mark(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies a tag or mark of a TCP session when all qualifier conditions meet. When not specified, this field is not used.
        """
        return pulumi.get(self, "mark")

    @mark.setter
    def mark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mark", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port protocol where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_cidr")

    @src_cidr.setter
    def src_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_cidr", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_port", value)


@pulumi.input_type
class AviatrixGatewayDnatDnatPolicyArgs:
    def __init__(__self__, *,
                 apply_route_entry: Optional[pulumi.Input[bool]] = None,
                 connection: Optional[pulumi.Input[str]] = None,
                 dnat_ips: Optional[pulumi.Input[str]] = None,
                 dnat_port: Optional[pulumi.Input[str]] = None,
                 dst_cidr: Optional[pulumi.Input[str]] = None,
                 dst_port: Optional[pulumi.Input[str]] = None,
                 exclude_rtb: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 mark: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 src_cidr: Optional[pulumi.Input[str]] = None,
                 src_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] apply_route_entry: This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.19.2+.
        :param pulumi.Input[str] connection: This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        :param pulumi.Input[str] dnat_ips: This is a rule field that specifies the translated destination IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        :param pulumi.Input[str] dnat_port: This is a rule field that specifies the translated destination port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        :param pulumi.Input[str] dst_cidr: This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] dst_port: This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] exclude_rtb: This field specifies which VPC private route table will not be programmed with the default route entry.
        :param pulumi.Input[str] interface: This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        :param pulumi.Input[str] mark: This is a rule field that specifies a tag or mark of a TCP session when all qualifier conditions meet. When not specified, this field is not used.
        :param pulumi.Input[str] protocol: This is a qualifier condition that specifies a destination port protocol where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_cidr: This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_port: This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        if apply_route_entry is not None:
            pulumi.set(__self__, "apply_route_entry", apply_route_entry)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if dnat_ips is not None:
            pulumi.set(__self__, "dnat_ips", dnat_ips)
        if dnat_port is not None:
            pulumi.set(__self__, "dnat_port", dnat_port)
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if exclude_rtb is not None:
            pulumi.set(__self__, "exclude_rtb", exclude_rtb)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mark is not None:
            pulumi.set(__self__, "mark", mark)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_port is not None:
            pulumi.set(__self__, "src_port", src_port)

    @property
    @pulumi.getter(name="applyRouteEntry")
    def apply_route_entry(self) -> Optional[pulumi.Input[bool]]:
        """
        This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.19.2+.
        """
        return pulumi.get(self, "apply_route_entry")

    @apply_route_entry.setter
    def apply_route_entry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_route_entry", value)

    @property
    @pulumi.getter
    def connection(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection", value)

    @property
    @pulumi.getter(name="dnatIps")
    def dnat_ips(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the translated destination IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        """
        return pulumi.get(self, "dnat_ips")

    @dnat_ips.setter
    def dnat_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dnat_ips", value)

    @property
    @pulumi.getter(name="dnatPort")
    def dnat_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the translated destination port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        """
        return pulumi.get(self, "dnat_port")

    @dnat_port.setter
    def dnat_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dnat_port", value)

    @property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_cidr")

    @dst_cidr.setter
    def dst_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_cidr", value)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter(name="excludeRtb")
    def exclude_rtb(self) -> Optional[pulumi.Input[str]]:
        """
        This field specifies which VPC private route table will not be programmed with the default route entry.
        """
        return pulumi.get(self, "exclude_rtb")

    @exclude_rtb.setter
    def exclude_rtb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_rtb", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mark(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies a tag or mark of a TCP session when all qualifier conditions meet. When not specified, this field is not used.
        """
        return pulumi.get(self, "mark")

    @mark.setter
    def mark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mark", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port protocol where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_cidr")

    @src_cidr.setter
    def src_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_cidr", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_port", value)


@pulumi.input_type
class AviatrixGatewayDnatInterfacePolicyArgs:
    def __init__(__self__, *,
                 apply_route_entry: Optional[pulumi.Input[bool]] = None,
                 connection: Optional[pulumi.Input[str]] = None,
                 dnat_ips: Optional[pulumi.Input[str]] = None,
                 dnat_port: Optional[pulumi.Input[str]] = None,
                 dst_cidr: Optional[pulumi.Input[str]] = None,
                 dst_port: Optional[pulumi.Input[str]] = None,
                 exclude_rtb: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 mark: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 src_cidr: Optional[pulumi.Input[str]] = None,
                 src_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] apply_route_entry: This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.19.2+.
        :param pulumi.Input[str] connection: This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        :param pulumi.Input[str] dnat_ips: This is a rule field that specifies the translated destination IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        :param pulumi.Input[str] dnat_port: This is a rule field that specifies the translated destination port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        :param pulumi.Input[str] dst_cidr: This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] dst_port: This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] exclude_rtb: This field specifies which VPC private route table will not be programmed with the default route entry.
        :param pulumi.Input[str] interface: This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        :param pulumi.Input[str] mark: This is a rule field that specifies a tag or mark of a TCP session when all qualifier conditions meet. When not specified, this field is not used.
        :param pulumi.Input[str] protocol: This is a qualifier condition that specifies a destination port protocol where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_cidr: This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_port: This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        if apply_route_entry is not None:
            pulumi.set(__self__, "apply_route_entry", apply_route_entry)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if dnat_ips is not None:
            pulumi.set(__self__, "dnat_ips", dnat_ips)
        if dnat_port is not None:
            pulumi.set(__self__, "dnat_port", dnat_port)
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if exclude_rtb is not None:
            pulumi.set(__self__, "exclude_rtb", exclude_rtb)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mark is not None:
            pulumi.set(__self__, "mark", mark)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_port is not None:
            pulumi.set(__self__, "src_port", src_port)

    @property
    @pulumi.getter(name="applyRouteEntry")
    def apply_route_entry(self) -> Optional[pulumi.Input[bool]]:
        """
        This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.19.2+.
        """
        return pulumi.get(self, "apply_route_entry")

    @apply_route_entry.setter
    def apply_route_entry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_route_entry", value)

    @property
    @pulumi.getter
    def connection(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection", value)

    @property
    @pulumi.getter(name="dnatIps")
    def dnat_ips(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the translated destination IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        """
        return pulumi.get(self, "dnat_ips")

    @dnat_ips.setter
    def dnat_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dnat_ips", value)

    @property
    @pulumi.getter(name="dnatPort")
    def dnat_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the translated destination port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule field must be specified for this rule to take effect.
        """
        return pulumi.get(self, "dnat_port")

    @dnat_port.setter
    def dnat_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dnat_port", value)

    @property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_cidr")

    @dst_cidr.setter
    def dst_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_cidr", value)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter(name="excludeRtb")
    def exclude_rtb(self) -> Optional[pulumi.Input[str]]:
        """
        This field specifies which VPC private route table will not be programmed with the default route entry.
        """
        return pulumi.get(self, "exclude_rtb")

    @exclude_rtb.setter
    def exclude_rtb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_rtb", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mark(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies a tag or mark of a TCP session when all qualifier conditions meet. When not specified, this field is not used.
        """
        return pulumi.get(self, "mark")

    @mark.setter
    def mark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mark", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port protocol where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_cidr")

    @src_cidr.setter
    def src_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_cidr", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_port", value)


@pulumi.input_type
class AviatrixGatewaySnatConnectionPolicyArgs:
    def __init__(__self__, *,
                 apply_route_entry: Optional[pulumi.Input[bool]] = None,
                 connection: Optional[pulumi.Input[str]] = None,
                 dst_cidr: Optional[pulumi.Input[str]] = None,
                 dst_port: Optional[pulumi.Input[str]] = None,
                 exclude_rtb: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 mark: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 snat_ips: Optional[pulumi.Input[str]] = None,
                 snat_port: Optional[pulumi.Input[str]] = None,
                 src_cidr: Optional[pulumi.Input[str]] = None,
                 src_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] apply_route_entry: This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.21.0+.
        :param pulumi.Input[str] connection: This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        :param pulumi.Input[str] dst_cidr: This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] dst_port: This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] exclude_rtb: This field specifies which VPC private route table will not be programmed with the default route entry.
        :param pulumi.Input[str] interface: This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        :param pulumi.Input[str] mark: This is a qualifier condition that specifies a tag or mark of a TCP session where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] protocol: This is a qualifier condition that specifies a destination port protocol where the rule applies. Valid values: 'all', 'tcp', 'udp', 'icmp'. 'Default: 'all'.
        :param pulumi.Input[str] snat_ips: This is a rule field that specifies the changed source IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        :param pulumi.Input[str] snat_port: This is a rule field that specifies the changed source port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        :param pulumi.Input[str] src_cidr: This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_port: This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        if apply_route_entry is not None:
            pulumi.set(__self__, "apply_route_entry", apply_route_entry)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if exclude_rtb is not None:
            pulumi.set(__self__, "exclude_rtb", exclude_rtb)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mark is not None:
            pulumi.set(__self__, "mark", mark)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if snat_ips is not None:
            pulumi.set(__self__, "snat_ips", snat_ips)
        if snat_port is not None:
            pulumi.set(__self__, "snat_port", snat_port)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_port is not None:
            pulumi.set(__self__, "src_port", src_port)

    @property
    @pulumi.getter(name="applyRouteEntry")
    def apply_route_entry(self) -> Optional[pulumi.Input[bool]]:
        """
        This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.21.0+.
        """
        return pulumi.get(self, "apply_route_entry")

    @apply_route_entry.setter
    def apply_route_entry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_route_entry", value)

    @property
    @pulumi.getter
    def connection(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection", value)

    @property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_cidr")

    @dst_cidr.setter
    def dst_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_cidr", value)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter(name="excludeRtb")
    def exclude_rtb(self) -> Optional[pulumi.Input[str]]:
        """
        This field specifies which VPC private route table will not be programmed with the default route entry.
        """
        return pulumi.get(self, "exclude_rtb")

    @exclude_rtb.setter
    def exclude_rtb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_rtb", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mark(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a tag or mark of a TCP session where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "mark")

    @mark.setter
    def mark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mark", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port protocol where the rule applies. Valid values: 'all', 'tcp', 'udp', 'icmp'. 'Default: 'all'.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="snatIps")
    def snat_ips(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the changed source IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        """
        return pulumi.get(self, "snat_ips")

    @snat_ips.setter
    def snat_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_ips", value)

    @property
    @pulumi.getter(name="snatPort")
    def snat_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the changed source port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        """
        return pulumi.get(self, "snat_port")

    @snat_port.setter
    def snat_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_port", value)

    @property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_cidr")

    @src_cidr.setter
    def src_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_cidr", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_port", value)


@pulumi.input_type
class AviatrixGatewaySnatInterfacePolicyArgs:
    def __init__(__self__, *,
                 apply_route_entry: Optional[pulumi.Input[bool]] = None,
                 connection: Optional[pulumi.Input[str]] = None,
                 dst_cidr: Optional[pulumi.Input[str]] = None,
                 dst_port: Optional[pulumi.Input[str]] = None,
                 exclude_rtb: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 mark: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 snat_ips: Optional[pulumi.Input[str]] = None,
                 snat_port: Optional[pulumi.Input[str]] = None,
                 src_cidr: Optional[pulumi.Input[str]] = None,
                 src_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] apply_route_entry: This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.21.0+.
        :param pulumi.Input[str] connection: This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        :param pulumi.Input[str] dst_cidr: This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] dst_port: This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] exclude_rtb: This field specifies which VPC private route table will not be programmed with the default route entry.
        :param pulumi.Input[str] interface: This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        :param pulumi.Input[str] mark: This is a qualifier condition that specifies a tag or mark of a TCP session where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] protocol: This is a qualifier condition that specifies a destination port protocol where the rule applies. Valid values: 'all', 'tcp', 'udp', 'icmp'. 'Default: 'all'.
        :param pulumi.Input[str] snat_ips: This is a rule field that specifies the changed source IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        :param pulumi.Input[str] snat_port: This is a rule field that specifies the changed source port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        :param pulumi.Input[str] src_cidr: This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_port: This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        if apply_route_entry is not None:
            pulumi.set(__self__, "apply_route_entry", apply_route_entry)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if exclude_rtb is not None:
            pulumi.set(__self__, "exclude_rtb", exclude_rtb)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mark is not None:
            pulumi.set(__self__, "mark", mark)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if snat_ips is not None:
            pulumi.set(__self__, "snat_ips", snat_ips)
        if snat_port is not None:
            pulumi.set(__self__, "snat_port", snat_port)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_port is not None:
            pulumi.set(__self__, "src_port", src_port)

    @property
    @pulumi.getter(name="applyRouteEntry")
    def apply_route_entry(self) -> Optional[pulumi.Input[bool]]:
        """
        This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.21.0+.
        """
        return pulumi.get(self, "apply_route_entry")

    @apply_route_entry.setter
    def apply_route_entry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_route_entry", value)

    @property
    @pulumi.getter
    def connection(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection", value)

    @property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_cidr")

    @dst_cidr.setter
    def dst_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_cidr", value)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter(name="excludeRtb")
    def exclude_rtb(self) -> Optional[pulumi.Input[str]]:
        """
        This field specifies which VPC private route table will not be programmed with the default route entry.
        """
        return pulumi.get(self, "exclude_rtb")

    @exclude_rtb.setter
    def exclude_rtb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_rtb", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mark(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a tag or mark of a TCP session where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "mark")

    @mark.setter
    def mark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mark", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port protocol where the rule applies. Valid values: 'all', 'tcp', 'udp', 'icmp'. 'Default: 'all'.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="snatIps")
    def snat_ips(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the changed source IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        """
        return pulumi.get(self, "snat_ips")

    @snat_ips.setter
    def snat_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_ips", value)

    @property
    @pulumi.getter(name="snatPort")
    def snat_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the changed source port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        """
        return pulumi.get(self, "snat_port")

    @snat_port.setter
    def snat_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_port", value)

    @property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_cidr")

    @src_cidr.setter
    def src_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_cidr", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_port", value)


@pulumi.input_type
class AviatrixGatewaySnatSnatPolicyArgs:
    def __init__(__self__, *,
                 apply_route_entry: Optional[pulumi.Input[bool]] = None,
                 connection: Optional[pulumi.Input[str]] = None,
                 dst_cidr: Optional[pulumi.Input[str]] = None,
                 dst_port: Optional[pulumi.Input[str]] = None,
                 exclude_rtb: Optional[pulumi.Input[str]] = None,
                 interface: Optional[pulumi.Input[str]] = None,
                 mark: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 snat_ips: Optional[pulumi.Input[str]] = None,
                 snat_port: Optional[pulumi.Input[str]] = None,
                 src_cidr: Optional[pulumi.Input[str]] = None,
                 src_port: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] apply_route_entry: This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.21.0+.
        :param pulumi.Input[str] connection: This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        :param pulumi.Input[str] dst_cidr: This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] dst_port: This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] exclude_rtb: This field specifies which VPC private route table will not be programmed with the default route entry.
        :param pulumi.Input[str] interface: This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        :param pulumi.Input[str] mark: This is a qualifier condition that specifies a tag or mark of a TCP session where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] protocol: This is a qualifier condition that specifies a destination port protocol where the rule applies. Valid values: 'all', 'tcp', 'udp', 'icmp'. 'Default: 'all'.
        :param pulumi.Input[str] snat_ips: This is a rule field that specifies the changed source IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        :param pulumi.Input[str] snat_port: This is a rule field that specifies the changed source port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        :param pulumi.Input[str] src_cidr: This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        :param pulumi.Input[str] src_port: This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        if apply_route_entry is not None:
            pulumi.set(__self__, "apply_route_entry", apply_route_entry)
        if connection is not None:
            pulumi.set(__self__, "connection", connection)
        if dst_cidr is not None:
            pulumi.set(__self__, "dst_cidr", dst_cidr)
        if dst_port is not None:
            pulumi.set(__self__, "dst_port", dst_port)
        if exclude_rtb is not None:
            pulumi.set(__self__, "exclude_rtb", exclude_rtb)
        if interface is not None:
            pulumi.set(__self__, "interface", interface)
        if mark is not None:
            pulumi.set(__self__, "mark", mark)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if snat_ips is not None:
            pulumi.set(__self__, "snat_ips", snat_ips)
        if snat_port is not None:
            pulumi.set(__self__, "snat_port", snat_port)
        if src_cidr is not None:
            pulumi.set(__self__, "src_cidr", src_cidr)
        if src_port is not None:
            pulumi.set(__self__, "src_port", src_port)

    @property
    @pulumi.getter(name="applyRouteEntry")
    def apply_route_entry(self) -> Optional[pulumi.Input[bool]]:
        """
        This is an option to program the route entry 'DST CIDR pointing to Aviatrix Gateway' into Cloud platform routing table. Type: Boolean. Default: True. Available as of provider version R2.21.0+.
        """
        return pulumi.get(self, "apply_route_entry")

    @apply_route_entry.setter
    def apply_route_entry(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_route_entry", value)

    @property
    @pulumi.getter
    def connection(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output connection where the rule applies. Default value: "None".
        """
        return pulumi.get(self, "connection")

    @connection.setter
    def connection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection", value)

    @property
    @pulumi.getter(name="dstCidr")
    def dst_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_cidr")

    @dst_cidr.setter
    def dst_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_cidr", value)

    @property
    @pulumi.getter(name="dstPort")
    def dst_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "dst_port")

    @dst_port.setter
    def dst_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dst_port", value)

    @property
    @pulumi.getter(name="excludeRtb")
    def exclude_rtb(self) -> Optional[pulumi.Input[str]]:
        """
        This field specifies which VPC private route table will not be programmed with the default route entry.
        """
        return pulumi.get(self, "exclude_rtb")

    @exclude_rtb.setter
    def exclude_rtb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exclude_rtb", value)

    @property
    @pulumi.getter
    def interface(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies output interface where the rule applies. When not specified, this field is not used. Must be empty when `connection` is set.
        """
        return pulumi.get(self, "interface")

    @interface.setter
    def interface(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interface", value)

    @property
    @pulumi.getter
    def mark(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a tag or mark of a TCP session where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "mark")

    @mark.setter
    def mark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mark", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a destination port protocol where the rule applies. Valid values: 'all', 'tcp', 'udp', 'icmp'. 'Default: 'all'.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="snatIps")
    def snat_ips(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the changed source IP address when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        """
        return pulumi.get(self, "snat_ips")

    @snat_ips.setter
    def snat_ips(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_ips", value)

    @property
    @pulumi.getter(name="snatPort")
    def snat_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a rule field that specifies the changed source port when all specified qualifier conditions meet. When not specified, this field is not used. One of the rule fields must be specified for this rule to take effect.
        """
        return pulumi.get(self, "snat_port")

    @snat_port.setter
    def snat_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snat_port", value)

    @property
    @pulumi.getter(name="srcCidr")
    def src_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source IP address range where the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_cidr")

    @src_cidr.setter
    def src_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_cidr", value)

    @property
    @pulumi.getter(name="srcPort")
    def src_port(self) -> Optional[pulumi.Input[str]]:
        """
        This is a qualifier condition that specifies a source port that the rule applies. When not specified, this field is not used.
        """
        return pulumi.get(self, "src_port")

    @src_port.setter
    def src_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "src_port", value)


@pulumi.input_type
class AviatrixMicrosegPolicyListPolicyArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 dst_app_domains: pulumi.Input[Sequence[pulumi.Input[str]]],
                 name: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 src_app_domains: pulumi.Input[Sequence[pulumi.Input[str]]],
                 logging: Optional[pulumi.Input[bool]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixMicrosegPolicyListPolicyPortRangeArgs']]]] = None,
                 priority: Optional[pulumi.Input[int]] = None,
                 uuid: Optional[pulumi.Input[str]] = None,
                 watch: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] action: Action for the policy. Must be one of PERMIT or DENY.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dst_app_domains: List of App Domain UUIDs for the destination for the policy.
        :param pulumi.Input[str] name: Name of the policy.
        :param pulumi.Input[str] protocol: Protocol for the policy. Must be one of TCP, UDP, ICMP or ANY.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] src_app_domains: List of App Domain UUIDs for the source for the policy.
        :param pulumi.Input[bool] logging: Whether to enable logging for packets that match the policy. Type: Boolean.
        :param pulumi.Input[Sequence[pulumi.Input['AviatrixMicrosegPolicyListPolicyPortRangeArgs']]] port_ranges: List of port ranges for the policy. Cannot be used when `protocol` is "ICMP".
        :param pulumi.Input[int] priority: Priority for the policy. Default: 0. Type: Integer.
        :param pulumi.Input[str] uuid: UUID for the Policy.
        :param pulumi.Input[bool] watch: Whether to enforce the policy or only watch packets. If "true" packets are only watched. This allows you to observe if the traffic impacted by this rule causes any inadvertent issues (such as traffic being dropped). Type: Boolean.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "dst_app_domains", dst_app_domains)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "src_app_domains", src_app_domains)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)
        if watch is not None:
            pulumi.set(__self__, "watch", watch)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Action for the policy. Must be one of PERMIT or DENY.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="dstAppDomains")
    def dst_app_domains(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of App Domain UUIDs for the destination for the policy.
        """
        return pulumi.get(self, "dst_app_domains")

    @dst_app_domains.setter
    def dst_app_domains(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dst_app_domains", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Protocol for the policy. Must be one of TCP, UDP, ICMP or ANY.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="srcAppDomains")
    def src_app_domains(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of App Domain UUIDs for the source for the policy.
        """
        return pulumi.get(self, "src_app_domains")

    @src_app_domains.setter
    def src_app_domains(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "src_app_domains", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable logging for packets that match the policy. Type: Boolean.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixMicrosegPolicyListPolicyPortRangeArgs']]]]:
        """
        List of port ranges for the policy. Cannot be used when `protocol` is "ICMP".
        """
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AviatrixMicrosegPolicyListPolicyPortRangeArgs']]]]):
        pulumi.set(self, "port_ranges", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        Priority for the policy. Default: 0. Type: Integer.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[str]]:
        """
        UUID for the Policy.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uuid", value)

    @property
    @pulumi.getter
    def watch(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enforce the policy or only watch packets. If "true" packets are only watched. This allows you to observe if the traffic impacted by this rule causes any inadvertent issues (such as traffic being dropped). Type: Boolean.
        """
        return pulumi.get(self, "watch")

    @watch.setter
    def watch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "watch", value)


@pulumi.input_type
class AviatrixMicrosegPolicyListPolicyPortRangeArgs:
    def __init__(__self__, *,
                 lo: pulumi.Input[int],
                 hi: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] lo: Lower bound for the range of ports.
        :param pulumi.Input[int] hi: Upper bound for the range of ports. When not set, `lo` is the only port that matches the policy.
        """
        pulumi.set(__self__, "lo", lo)
        if hi is not None:
            pulumi.set(__self__, "hi", hi)

    @property
    @pulumi.getter
    def lo(self) -> pulumi.Input[int]:
        """
        Lower bound for the range of ports.
        """
        return pulumi.get(self, "lo")

    @lo.setter
    def lo(self, value: pulumi.Input[int]):
        pulumi.set(self, "lo", value)

    @property
    @pulumi.getter
    def hi(self) -> Optional[pulumi.Input[int]]:
        """
        Upper bound for the range of ports. When not set, `lo` is the only port that matches the policy.
        """
        return pulumi.get(self, "hi")

    @hi.setter
    def hi(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hi", value)


@pulumi.input_type
class AviatrixPrivateModeLbProxyArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] instance_id: Instance ID of the proxy.
        :param pulumi.Input[str] vpc_id: VPC ID of the proxy.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Instance ID of the proxy.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC ID of the proxy.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class AviatrixSite2CloudCaCertTagCaCertificateArgs:
    def __init__(__self__, *,
                 cert_content: pulumi.Input[str],
                 common_name: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 issuer_name: Optional[pulumi.Input[str]] = None,
                 unique_serial: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cert_content: Content of cert certificate to create only one cert. One CA cert only per file.
        :param pulumi.Input[str] common_name: Common name of created cert.
        :param pulumi.Input[str] expiration_time: Expiration time of created cert.
        :param pulumi.Input[str] id: Unique id of created cert.
        :param pulumi.Input[str] issuer_name: Issuer name of created cert.
        :param pulumi.Input[str] unique_serial: Unique serial of created cert.
        """
        pulumi.set(__self__, "cert_content", cert_content)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if issuer_name is not None:
            pulumi.set(__self__, "issuer_name", issuer_name)
        if unique_serial is not None:
            pulumi.set(__self__, "unique_serial", unique_serial)

    @property
    @pulumi.getter(name="certContent")
    def cert_content(self) -> pulumi.Input[str]:
        """
        Content of cert certificate to create only one cert. One CA cert only per file.
        """
        return pulumi.get(self, "cert_content")

    @cert_content.setter
    def cert_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "cert_content", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        Common name of created cert.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        Expiration time of created cert.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique id of created cert.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="issuerName")
    def issuer_name(self) -> Optional[pulumi.Input[str]]:
        """
        Issuer name of created cert.
        """
        return pulumi.get(self, "issuer_name")

    @issuer_name.setter
    def issuer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer_name", value)

    @property
    @pulumi.getter(name="uniqueSerial")
    def unique_serial(self) -> Optional[pulumi.Input[str]]:
        """
        Unique serial of created cert.
        """
        return pulumi.get(self, "unique_serial")

    @unique_serial.setter
    def unique_serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unique_serial", value)


@pulumi.input_type
class AviatrixTransitGatewayBgpLanInterfaceArgs:
    def __init__(__self__, *,
                 subnet: pulumi.Input[str],
                 vpc_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] subnet: A VPC Network address range selected from one of the available network ranges.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        """
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        A VPC Network address range selected from one of the available network ranges.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class AviatrixTransitGatewayHaBgpLanInterfaceArgs:
    def __init__(__self__, *,
                 subnet: pulumi.Input[str],
                 vpc_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] subnet: A VPC Network address range selected from one of the available network ranges.
        :param pulumi.Input[str] vpc_id: VPC-ID/VNet-Name of cloud provider.
        """
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[str]:
        """
        A VPC Network address range selected from one of the available network ranges.
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        VPC-ID/VNet-Name of cloud provider.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)


@pulumi.input_type
class AviatrixVpcPrivateSubnetArgs:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cidr: CIDR block.
        :param pulumi.Input[str] name: Name of this subnet.
        :param pulumi.Input[str] subnet_id: ID of this subnet.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR block.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this subnet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of this subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class AviatrixVpcPublicSubnetArgs:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cidr: CIDR block.
        :param pulumi.Input[str] name: Name of this subnet.
        :param pulumi.Input[str] subnet_id: ID of this subnet.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR block.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this subnet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of this subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class AviatrixVpcSubnetArgs:
    def __init__(__self__, *,
                 cidr: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cidr: CIDR block.
        :param pulumi.Input[str] name: Name of this subnet.
        :param pulumi.Input[str] region: Region of this subnet.
        :param pulumi.Input[str] subnet_id: ID of this subnet.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[pulumi.Input[str]]:
        """
        CIDR block.
        """
        return pulumi.get(self, "cidr")

    @cidr.setter
    def cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of this subnet.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of this subnet.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of this subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


@pulumi.input_type
class AviatrixVpnProfilePolicyArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 port: pulumi.Input[str],
                 proto: pulumi.Input[str],
                 target: pulumi.Input[str]):
        """
        :param pulumi.Input[str] action: Should be the opposite of the base rule for correct behavior. Valid values for action: "allow", "deny".
        :param pulumi.Input[str] port: Port to be allowed or denied. Valid values for port: a single port or a range of port numbers e.g.: "25", "25:1024". For "all" and "icmp", port should only be "0:65535".
        :param pulumi.Input[str] proto: Protocol to allow or deny. Valid values for protocol: "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        :param pulumi.Input[str] target: CIDR to be allowed or denied. Valid values for target: IPv4 CIDRs. Example: "10.30.0.0/16".
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "proto", proto)
        pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        Should be the opposite of the base rule for correct behavior. Valid values for action: "allow", "deny".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[str]:
        """
        Port to be allowed or denied. Valid values for port: a single port or a range of port numbers e.g.: "25", "25:1024". For "all" and "icmp", port should only be "0:65535".
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[str]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def proto(self) -> pulumi.Input[str]:
        """
        Protocol to allow or deny. Valid values for protocol: "all", "tcp", "udp", "icmp", "sctp", "rdp", "dccp".
        """
        return pulumi.get(self, "proto")

    @proto.setter
    def proto(self, value: pulumi.Input[str]):
        pulumi.set(self, "proto", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[str]:
        """
        CIDR to be allowed or denied. Valid values for target: IPv4 CIDRs. Example: "10.30.0.0/16".
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[str]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class ProviderIgnoreTagsArgs:
    def __init__(__self__, *,
                 key_prefixes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        if key_prefixes is not None:
            pulumi.set(__self__, "key_prefixes", key_prefixes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)

    @property
    @pulumi.getter(name="keyPrefixes")
    def key_prefixes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "key_prefixes")

    @key_prefixes.setter
    def key_prefixes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "key_prefixes", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)


@pulumi.input_type
class GetAviatrixFirenetFirewallInstanceAssociationArgs:
    def __init__(__self__, *,
                 attached: bool,
                 egress_interface: str,
                 firenet_gw_name: str,
                 firewall_name: str,
                 instance_id: str,
                 lan_interface: str,
                 management_interface: str,
                 vendor_type: str):
        """
        :param str firenet_gw_name: Name of the primary FireNet gateway.
        :param str firewall_name: Firewall instance name.
               * `lan_interface`- Lan interface ID.
        :param str instance_id: ID of Firewall instance.
        :param str management_interface: Management interface ID.
               * `egress_interface`- Egress interface ID.
               * `attached`- Switch to attach/detach firewall instance to/from fireNet.
        :param str vendor_type: Type of the firewall.
        """
        pulumi.set(__self__, "attached", attached)
        pulumi.set(__self__, "egress_interface", egress_interface)
        pulumi.set(__self__, "firenet_gw_name", firenet_gw_name)
        pulumi.set(__self__, "firewall_name", firewall_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "lan_interface", lan_interface)
        pulumi.set(__self__, "management_interface", management_interface)
        pulumi.set(__self__, "vendor_type", vendor_type)

    @property
    @pulumi.getter
    def attached(self) -> bool:
        return pulumi.get(self, "attached")

    @attached.setter
    def attached(self, value: bool):
        pulumi.set(self, "attached", value)

    @property
    @pulumi.getter(name="egressInterface")
    def egress_interface(self) -> str:
        return pulumi.get(self, "egress_interface")

    @egress_interface.setter
    def egress_interface(self, value: str):
        pulumi.set(self, "egress_interface", value)

    @property
    @pulumi.getter(name="firenetGwName")
    def firenet_gw_name(self) -> str:
        """
        Name of the primary FireNet gateway.
        """
        return pulumi.get(self, "firenet_gw_name")

    @firenet_gw_name.setter
    def firenet_gw_name(self, value: str):
        pulumi.set(self, "firenet_gw_name", value)

    @property
    @pulumi.getter(name="firewallName")
    def firewall_name(self) -> str:
        """
        Firewall instance name.
        * `lan_interface`- Lan interface ID.
        """
        return pulumi.get(self, "firewall_name")

    @firewall_name.setter
    def firewall_name(self, value: str):
        pulumi.set(self, "firewall_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of Firewall instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: str):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="lanInterface")
    def lan_interface(self) -> str:
        return pulumi.get(self, "lan_interface")

    @lan_interface.setter
    def lan_interface(self, value: str):
        pulumi.set(self, "lan_interface", value)

    @property
    @pulumi.getter(name="managementInterface")
    def management_interface(self) -> str:
        """
        Management interface ID.
        * `egress_interface`- Egress interface ID.
        * `attached`- Switch to attach/detach firewall instance to/from fireNet.
        """
        return pulumi.get(self, "management_interface")

    @management_interface.setter
    def management_interface(self, value: str):
        pulumi.set(self, "management_interface", value)

    @property
    @pulumi.getter(name="vendorType")
    def vendor_type(self) -> str:
        """
        Type of the firewall.
        """
        return pulumi.get(self, "vendor_type")

    @vendor_type.setter
    def vendor_type(self, value: str):
        pulumi.set(self, "vendor_type", value)


