# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nton']

package_data = \
{'': ['*'], 'nton': ['assets/exefs/*', 'assets/logo/*']}

install_requires = \
['appdirs>=1.4.4,<2.0.0', 'click>=8.1.3,<9.0.0']

entry_points = \
{'console_scripts': ['nton = nton.main:main']}

setup_kwargs = {
    'name': 'nton',
    'version': '1.0.1',
    'description': 'Nintendo Switch NRO to NSP Forwarder.',
    'long_description': '# NTON\n\nNintendo Switch NRO to NSP Forwarder for firmware 12.0.0 and newer.\n\nA forwarder lets you open a Homebrew NRO file from your SD card through the Nintendo Switch Home Screen instead\nof the Homebrew Launcher.\n\n![Preview of 4x Forwarders](https://user-images.githubusercontent.com/17136956/201314901-4a34a4dc-800b-44ba-beb8-333b6c37ebb6.jpg)  \n*Preview of 4x Forwarders made with NTON.*\n\nThis is more so a script for making NSPs using [mpham]\'s original Forwarder ROM [here][ROM].\nMy script is specifically aimed toward automated general homebrew NRO forwarding, not RetroArch Game Forwarding.\n\n## Changes\n\n1. The script was completely rewritten in Python.\n2. NSPs now save to a folder named `NTON` on your Desktop and are named to be more human-readable.\n3. `control.nacp` and the `icon_AmericanEnglish.dat` icon files are now automatically extracted from the NRO.\n4. The `icon_AmericanEnglish.dat` is now automatically re-formatted as JPEG and re-stripped where necessary.\n   Even though it\'s extracted from the NRO, it still does this. Not all NRO icon `dat` files are up to spec for NSPs.\n5. You now specify the publisher in the CLI call.\n6. The Title Name and Publisher is now automated. You can still override them manually.\n7. The path to the NRO must exist for automation to work. The best way is to insert your Switch\'s microSD card\n   and specify the drive letter for it in the call.\n8. NRO files are now verified/validated with `nstool` before being used.\n9. Paths to files are now checked and validated across the codebase in various ways to help reduce user error.\n10. The `prod.keys` can now be loaded from the common `~/.switch/prod.keys` path.\n\n## Installation\n\n1. Install the latest [ImageMagick] release. I recommend via [winget] or [chocolatey].\n2. Download the latest [hacBrewPack] and [nstool] binaries and place them within your current working directory, or\n   ideally in the `PATH` environment variable.\n3. Place your `prod.keys` at the root of the project folder or at `%USERPROFILE/.switch/prod.keys`. Make sure it\'s\n   up-to-date for the firmware version you\'re switch is on. You can get this file using [Lockpick_RCM].\n4. Run `pip install nton`. If you see any warnings about a path not being in your PATH environment variable, add it\n   or you wont be able to run `nton`.\n\n  [ImageMagick]: <https://imagemagick.org/script/download.php>\n  [winget]: <https://winget.run>\n  [chocolatey]: <https://chocolatey.org>\n  [hacBrewPack]: <https://github.com/The-4n/hacBrewPack>\n  [nstool]: <https://github.com/jakcron/nstool>\n  [Lockpick_RCM]: <https://github.com/shchmue/Lockpick_RCM>\n\n## Usage\n\nTake a look at `nton --help`, specifically `nton build --help`.  \nIf you simply want to take an NRO and get an NSP forwarder, simply run `nton build "<nro path>"`.\n\nNote that the NRO path MUST be on your Switch microSD card. Do not provide a path in your C:/ Drive or such.\nTwo different kinds of paths are used based on the initial file path, therefore it must be from your Switch microSD\ncard.\n\nE.g., to make a forwarder for the Homebrew Menu that\'s on your Switch\'s microSD at `D:\\hbmenu.nro`, simply run\n`nton build "D:/hbmenu.nro"`\n\nTake a look at `nton build --help` for advanced usage like changing the Icon, Title Name, and so on.\n\n## To-do\n\n- [X] Rewrite as a Python script to heavily improve the user experience and code.\n- [X] Combine the Drive letter and Path arguments and manually split them when they need to be separate instead.\n- [X] Automate name and publisher by extracting from the extracted `control.nacp`.\n- [ ] Force disable save data allocation. Fixed in [v3.3.5 of Nro2NSP](https://github.com/Root-MtX/Nro2Nsp/releases/tag/3.3.5).\n- [ ] Force enabling recording by editing the NROs extracted `control.nacp` at offset 0x3035 from 0 to 2 (forced).\n    Forced is a lot better than 1 (manual) as it allows the video to be saved. A way to enable screenshots should be done as well.\n    [SAK](https://github.com/dezem/SAK) has a way to do this.\n- [ ] Add support for direct RetroArch Game Forwarding.\n- [ ] Maybe a new GUI one day, and let you override the icons and such?\n\n## Troubleshooting\n\nBefore continuing try running the homebrew from the Homebrew Launcher and see if it works through there.\nIf it does not work through the Homebrew launcher either, then it was never the forwarder\'s fault and you should\ncheck on your NRO or application installation.\n\nPlease note that using Forwarders others have created has a good chance of not working on your system.\nThe location of the NRO on their system may differ from the location on your system, hence the NSP won\'t be able\nto load the homebrew.\n\n### The forwarder does not launch, "The software was closed because an error occurred."\n\nYou\'re sigpatches that allow non-signed software to launch is outdated or not set up correctly.\nThe `prod.keys` you used to create the NSP may also be outdated. Get new ones with [Lockpick_RCM] and\nmake sure you choose to get keys from whichever SysNAND or EmuNAND is actually on the latest firmware.\n\n### The forwarder starts loading but then crashes\n\nIf it gets to the black loading screen with the Nintendo Switch logo, but then crashes, you may be setting\nthe NRO path wrong when making the NSP. Make sure it starts with `/` and is an absolute path to an existing\nNRO file on your Switch\'s microSD card. The path you built for must be where the NRO file lies in your Switch\'s\nmicroSD card, not your PC.\n\n### The forwarder\'s icon is a \'?\'\n\nThe `icon_AmericanEnglish.dat` is not to the spec that Nintendo likes in some way. This is usually caused by the format of the\nimage not being a JPEG, or it has EXIF data or an embedded color space.\n\nI recommend stripping all EXIF metadata and saving without an Embed Color Space. You can do this quickly with ImageMagick,\n`magick mogrify -format jpg -resize 256x256 -strip "C:\\Users\\John\\Downloads\\icon.png"`.\n\n### The forwarder randomly stopped working after a while, I changed nothing!\n\nYou most likely updated your Switch\'s Firmware and need to update your sigpatches. If not, you may have deleted the NRO from\nyour Switch\'s microSD card or moved the NRO somewhere else. It cannot be moved as the built NSP loads the NRO at the specified\npath when you ran `build`.\n\nIt\'s also possible the firmware update has broken the [forwarder ROM][ROM] that is used and needs to be fixed.\nFirmware 9.0.0 and 12.0.0 are times the firmware has broken different forwarder ROMs in the past.\n\n## Credit\n\n- [Martin Pham (mpham)][mpham] for the original v12.0.0+ [forwarder ROM][ROM] and original batch script.\n- [meliodas2255] for recompiling the [forwarder ROM][ROM] for the latest hbl-loader as of May 2021 supporting RetroArch Forwarders and general Homebrew.\n\n  [mpham]: <https://gbatemp.net/members/mpham.537130>\n  [meliodas2255]: <https://gbatemp.net/members/meliodas2255.410353>\n  [ROM]: <https://gitlab.com/martinpham/NSP-Forwarder>\n\n## License\n\n[GNU General Public License, Version 3.0](LICENSE)\n',
    'author': 'rlaphoenix',
    'author_email': 'rlaphoenix@pm.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/rlaphoenix/nton',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
