# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['grimoirelab']

package_data = \
{'': ['*']}

install_requires = \
['cereslib>=0.3.6-rc.2',
 'graal>=0.4.3-rc.4',
 'grimoire-elk>=0.104.0-rc.7',
 'grimoirelab-panels>=0.2.0-rc.1',
 'grimoirelab-toolkit>=0.3.3-rc.1',
 'kidash>=0.5.3-rc.2',
 'perceval-mozilla>=0.3.6-rc.4',
 'perceval-opnfv>=0.2.6-rc.4',
 'perceval-puppet>=0.2.6-rc.4',
 'perceval-weblate>=0.2.6-rc.4',
 'perceval>=0.21.2-rc.4',
 'sirmordred>=0.6.0-rc.3',
 'sortinghat>=0.8.0-rc.8',
 'statsmodels>=0.13.2,<0.14.0']

entry_points = \
{'console_scripts': ['grimoirelab = grimoirelab.grimoirelab:main']}

setup_kwargs = {
    'name': 'grimoirelab',
    'version': '0.7.2',
    'description': 'Tool set for software development analytics',
    'long_description': '# GrimoireLab\n\n[![grimoirelab-showcase](https://user-images.githubusercontent.com/25265451/84442403-30dcce80-ac5b-11ea-9f5b-60266d875ebd.png "GrimoireLab | CHAOSS Bitergia Analytics")](https://chaoss.biterg.io/app/kibana#/dashboard/Overview)\n\nGrimoireLab is a [CHAOSS](https://chaoss.community) toolset for software development analytics. It includes a coordinated set of tools\nto retrieve data from systems used to support software development (repositories), store it in databases,\nenrich it by computing relevant metrics, and make it easy to run analytics and visualizations on it.\n\nYou can learn more about GrimoireLab in the [GrimoireLab tutorial](https://chaoss.github.io/grimoirelab-tutorial/),\nor visit the [GrimoireLab website](https://chaoss.github.io/grimoirelab).\n\nMetrics available in GrimoireLab are, in part, developed in the CHAOSS project. For more information regarding CHAOSS metrics, see the latest release at: https://chaoss.community/metrics/\n\n# Getting started\n\nTo ease the newcomer experience we are providing a [default setup](default-grimoirelab-settings)\nto analyze git activity for this repository. For this set up, there are several options to run GrimoireLab:\n\n## Using `docker-compose`\n\nRequirements:\n* **Software**: [git](https://git-scm.com/), [docker client](https://docs.docker.com/get-docker/) and [docker compose](https://docs.docker.com/compose/install/). An example of working configuration:\n```console\nroot@test-68b8628f:~# git --version\ngit version 2.17.1\nroot@test-68b8628f:~# docker --version\nDocker version 19.03.1, build 74b1e89\nroot@test-68b8628f:~# docker-compose --version\ndocker-compose version 1.22.0, build f46880fe\n```\n* **Hardware**: 2 CPU cores, 8GB memory RAM and [enough virtual memory for Elasticsearch](https://www.elastic.co/guide/en/elasticsearch/reference/current/vm-max-map-count.html) \n\nSteps:\n1. Clone this project:\n```console\nfoo@bar:~$ git clone https://github.com/chaoss/grimoirelab\n```\n2. Go to `docker-compose` folder and run the following command:\n```console\nfoo@bar:~$ cd grimoirelab/docker-compose\nfoo@bar:~/grimoirelab/docker-compose$ docker-compose up -d\n```\n\nYour dashboard will be ready after a while at `http://localhost:5601`. The waiting time depends on the amount of data to fetch from a repo, for small repositories you can expect your data to be visible in the dashboard after 10-15 minutes.\n\nMore details in the [docker-compose folder](./docker-compose/README.md).\n\n## Using `docker run`\n\nRequirements: \n* **Software**: [git](https://git-scm.com/) and [docker client](https://docs.docker.com/get-docker/). An example of working configuration:\n```console\nroot@test-68b8628f:~# git --version\ngit version 2.17.1\nroot@test-68b8628f:~# docker --version\nDocker version 19.03.1, build 74b1e89\n```\n* **Hardware**: 2 CPU cores, 8GB memory RAM and set\n* ElasticSearch and Kibana up and running.\n\nSteps:\n1. Clone this project:\n```console\n$ git clone https://github.com/chaoss/grimoirelab\n```\n2. Go to the project folder and run the following command:\n```console\nfoo@bar:~$ cd grimoirelab\nfoo@bar:~/grimoirelab $ docker run --net=host \\ \n    -v $(pwd)/default-grimoirelab-settings/projects.json:/home/grimoire/conf/projects.json \\\n    -v $(pwd)/default-grimoirelab-settings/setup-docker.cfg:/home/grimoire/conf/setup.cfg \\\n    -v $(pwd)/default-grimoirelab-settings/organizations.json:/home/grimoire/organizations.json \\\n    -v $(pwd)/default-grimoirelab-settings/identities.yml:/home/grimoire/conf/identities.yml \\\n    -t grimoirelab/grimoirelab\n```\n\nYour dashboard will be ready after a while at `http://localhost:5601`. The waiting time depends on the amount of data to fetch from a repo, for small repositories you can expect your data to be visible in the dashboard after 10-15 minutes.\n\nMore details in the [docker folder](./docker/README.md).\n\n# GrimoireLab components\n\nCurrently, GrimoireLab toolkit is organized in the following repositories:\n\n* Data retrieval related components:\n  * [Perceval](https://github.com/chaoss/grimoirelab-perceval): retrieval of data from data sources\n    * [Perceval (bundle for OPNFV)](https://github.com/chaoss/grimoirelab-perceval-opnfv)\n    * [Perceval (bundle for Mozilla)](https://github.com/chaoss/grimoirelab-perceval-mozilla)\n    * [Perceval (bundle for Puppet)](https://github.com/chaoss/grimoirelab-perceval-puppet)\n    * [Perceval (bundle for Weblate)](https://github.com/chaoss/grimoirelab-perceval-weblate)\n  * [Graal](https://github.com/chaoss/grimoirelab-graal): source data analysis with external tools\n  * [KingArthur](https://github.com/chaoss/grimoirelab-kingarthur): batch processing for massive retrieval\n* Data enrichment related components:\n  * [GrimoireElk](https://github.com/chaoss/grimoirelab-elk): storage and enrichment of data\n  * [Cereslib](https://github.com/chaoss/grimoirelab-cereslib): generic data processor\n  * [SortingHat](https://github.com/chaoss/grimoirelab-sortinghat): identity management\n* Data consumption related components:\n  * [Kibiter](https://github.com/chaoss/grimoirelab-kibiter): dashboard, downstream version of Kibana\n  * [Sigils](https://github.com/chaoss/grimoirelab-sigils): visualizations and dashboards\n  * [Kidash](https://github.com/chaoss/grimoirelab-kidash): visualizations and dashboards manager\n  * [Manuscripts](https://github.com/chaoss/grimoirelab-manuscripts): reporting\n* Platform management, orchestration, and common utils:\n  * [Mordred](https://github.com/chaoss/grimoirelab-mordred): orchestration\n  * [GrimoireLab Toolkit](https://github.com/chaoss/grimoirelab-toolkit): common utilities\n  * [Bestiary](https://github.com/chaoss/grimoirelab-bestiary): web-based user interface to manage repositories and projects for Mordred\n  * [Hatstall](https://github.com/chaoss/grimoirelab-hatstall): web-based user interface to manage SortingHat identities\n\nThere are also some [components built by the GrimoreLab community](community_components.md),\nwhich can be useful for you. Other related repositories are:\n* [GrimoireLab Tutorial](https://github.com/chaoss/grimoirelab-tutorial)\n* [GrimoireLab as a whole](https://github.com/chaoss/grimoirelab) (this repository)\n\n## Contents of this repository\n\nThis repository is for content relevant to GrimoireLab as a whole. For example:\n\n* Issues for new features or bug reports that affect more than one GrimoireLab module. In this case, let\'s open an issue here, and when implementing the fix or the feature, let´s comment about the specific tickets in the specific modules that are used. For example, when supporting a new datasource, we will need patches (at least) in `Perceval`, `GrimoireELK` and panels. In this case, we would open a feature request (or the user story) for the whole case, an issue (and later a pull request) in `Perceval` for the data retriever, same for `GrimoireELK` for the enriching code, and same for `panels` for the Kibiter panels.\n\n* Release notes for most GrimoireLab components (directory [releases](releases)).\n\n* Docker container for showcasing GrimoireLab (directory [docker](docker)).\nIncludes a Dockerfile and configuration files for the GrimoireLab containers\nthat can be used to demo the technology, and can be the basis for real\ndeployments. See more information in the [docker README.md file](docker/README.md).\n\n* If you feel more comfortable with `docker-compose`, the [docker-compose](docker-compose)\nfolder includes instructions and configuration files to deploy GrimoireLab using\n`docker-compose` command.\n\n* Source code of the GrimoireLab components is available in `src`. Each directory is a\nGit submodule, so its contents will not be available after cloning the repository. To\nfetch all the data, and get the latest version, you can run the following command:\n```console\n$ git submodule update --init --remote\n```\n\n* How releases of GrimoireLab are built and tested: [Building](BUILDING.md)\n\n## Citation\n\nIf you use GrimoireLab in your research papers, please refer to [GrimoireLab: A toolset for software development analytics](https://doi.org/10.7717/peerj-cs.601):\n\nAPA style:\n\n```\nDueñas S, Cosentino V, Gonzalez-Barahona JM, del Castillo San Felix A, Izquierdo-Cortazar D, Cañas-Díaz L, Pérez García-Plaza A. 2021. GrimoireLab: A toolset for software development analytics. PeerJ Computer Science 7:e601 https://doi.org/10.7717/peerj-cs.601\n```\n\nBibTeX / BibLaTeX:\n\n```\n@Article{duenas2021:grimoirelab,\n  author = \t {Dueñas, Santiago and Cosentino, Valerio and Gonzalez-Barahona, Jesus M. and del Castillo San Felix, Alvaro and Izquierdo-Cortazar,  Daniel and Cañas-Díaz, Luis and Pérez García-Plaza, Alberto},\n  title = \t {GrimoireLab: A toolset for software development analytics},\n  journaltitle = {PeerJ Computer Science},\n  date = \t {2021-07-09},\n  volume = \t 7,\n  number = \t {e601},\n  doi = \t {10.7717/peerj-cs.601},\n  url = \t {https://doi.org/10.7717/peerj-cs.601}}\n```\n\n# Contributing\n\nContributions are welcome, please check the [Contributing Guidelines](CONTRIBUTING.md).\n',
    'author': 'GrimoireLab Developers',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://chaoss.github.io/grimoirelab/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7.1,<4.0.0',
}


setup(**setup_kwargs)
