# Auto Survey Contributing Guide

Thank you for investing your time in contributing to our project! :sparkles:.

Read our [Code of Conduct](./CODE_OF_CONDUCT.md) to keep our community approachable and
respectable.

In this guide you will get an overview of the contribution workflow from opening an
issue, creating a PR, reviewing, and merging the PR.

## New Contributor Guide

To get an overview of the project, read the [README](README.md). Here are some
resources to help you get started with open source contributions:

- [Finding ways to contribute to open source on GitHub][1]
- [Set up Git][2]
- [GitHub flow][3]
- [Collaborating with pull requests][4]

## Getting Started

### Issues

#### Create a New Issue

If you spot a problem with the package, [search if an issue already exists][5]. If a
related issue doesn't exist, you can open a new issue using a relevant [issue form][6].

#### Solve an Issue

Scan through our [existing issues][6] to find one that interests you. You can narrow
down the search using `labels` as filters. See
[Labels](/contributing/how-to-use-labels.md) for more information. If you find an issue
to work on, you are welcome to open a PR with a fix.

### Make Changes

1. Fork the repository.
   - Using GitHub Desktop:
   - [Getting started with GitHub Desktop][7] will guide you through setting up
  Desktop. Once Desktop is set up, you can use it to [fork the repo][8].
   - Using the command line:
   - [Fork the repo][9] so that you can make your changes without affecting the
  original project until you're ready to merge them.
2. Run `make install` from within the repo to get set up
3. Create a working branch and start with your changes!

### Commit Your Update

Commit the changes once you are happy with them. See [Atom's contributing guide][10] to
know how to use emoji for commit messages.

Once your changes are ready, don't forget to [self-review](/contributing/self-review.md)
to speed up the review process :zap:

### Pull Request

When you're finished with the changes, create a pull request, also known as a PR.

- Fill the "Ready for review" template so that we can review your PR. This template
  helps reviewers understand your changes as well as the purpose of your pull request.
- Don't forget to [link PR to issue][11] if you are solving one.
- Enable the checkbox to [allow maintainer edits][12] so the branch can be updated for a
  merge.

Once you submit your PR, a team member will review your proposal. We may ask
questions or request for additional information.

- We may ask for changes to be made before a PR can be merged, either using [suggested
  changes][13] or pull request comments. You can apply suggested changes directly
  through the UI. You can make any other changes in your fork, then commit them to your
  branch.
- As you update your PR and apply changes, mark each conversation as [resolved][14].
- If you run into any merge issues, checkout this [git tutorial][15] to help you resolve
  merge conflicts and other issues.

### Your PR is merged

Congratulations :tada::tada: The Auto Survey team thanks you :sparkles:.

[1]: https://docs.github.com/en/get-started/exploring-projects-on-github/finding-ways-to-contribute-to-open-source-on-github
[2]: https://docs.github.com/en/get-started/quickstart/set-up-git
[3]: https://docs.github.com/en/get-started/quickstart/github-flow
[4]: https://docs.github.com/en/github/collaborating-with-pull-requests
[5]: https://docs.github.com/en/github/searching-for-information-on-github/searching-on-github/searching-issues-and-pull-requests#search-by-the-title-body-or-comments
[6]: https://github.com/alexandrainst/auto_survey/issues
[7]: https://docs.github.com/en/desktop/installing-and-configuring-github-desktop/getting-started-with-github-desktop
[8]: https://docs.github.com/en/desktop/contributing-and-collaborating-using-github-desktop/cloning-and-forking-repositories-from-github-desktop
[9]: https://docs.github.com/en/github/getting-started-with-github/fork-a-repo#fork-an-example-repository
[10]: https://github.com/atom/atom/blob/master/CONTRIBUTING.md#git-commit-messages
[11]: https://docs.github.com/en/issues/tracking-your-work-with-issues/linking-a-pull-request-to-an-issue
[12]: https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/allowing-changes-to-a-pull-request-branch-created-from-a-fork
[13]: https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/incorporating-feedback-in-your-pull-request
[14]: https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/commenting-on-a-pull-request#resolving-conversations
[15]: https://github.com/skills/resolve-merge-conflicts
