# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'DomainTag',
    'IntegrationConnectorOperator',
    'IntegrationFlowDefinition',
    'IntegrationIncrementalPullConfig',
    'IntegrationMarketoSourceProperties',
    'IntegrationObjectTypeMapping',
    'IntegrationS3SourceProperties',
    'IntegrationSalesforceSourceProperties',
    'IntegrationScheduledTriggerProperties',
    'IntegrationServiceNowSourceProperties',
    'IntegrationSourceConnectorProperties',
    'IntegrationSourceFlowConfig',
    'IntegrationTag',
    'IntegrationTask',
    'IntegrationTaskPropertiesMap',
    'IntegrationTriggerConfig',
    'IntegrationTriggerProperties',
    'IntegrationZendeskSourceProperties',
    'ObjectTypeField',
    'ObjectTypeFieldMap',
    'ObjectTypeKey',
    'ObjectTypeKeyMap',
    'ObjectTypeTag',
]

@pulumi.output_type
class DomainTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class IntegrationConnectorOperator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceNow":
            suggest = "service_now"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationConnectorOperator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationConnectorOperator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationConnectorOperator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 marketo: Optional['IntegrationMarketoConnectorOperator'] = None,
                 s3: Optional['IntegrationS3ConnectorOperator'] = None,
                 salesforce: Optional['IntegrationSalesforceConnectorOperator'] = None,
                 service_now: Optional['IntegrationServiceNowConnectorOperator'] = None,
                 zendesk: Optional['IntegrationZendeskConnectorOperator'] = None):
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if service_now is not None:
            pulumi.set(__self__, "service_now", service_now)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter
    def marketo(self) -> Optional['IntegrationMarketoConnectorOperator']:
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def s3(self) -> Optional['IntegrationS3ConnectorOperator']:
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['IntegrationSalesforceConnectorOperator']:
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="serviceNow")
    def service_now(self) -> Optional['IntegrationServiceNowConnectorOperator']:
        return pulumi.get(self, "service_now")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['IntegrationZendeskConnectorOperator']:
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class IntegrationFlowDefinition(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "flowName":
            suggest = "flow_name"
        elif key == "kmsArn":
            suggest = "kms_arn"
        elif key == "sourceFlowConfig":
            suggest = "source_flow_config"
        elif key == "triggerConfig":
            suggest = "trigger_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationFlowDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationFlowDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationFlowDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 flow_name: str,
                 kms_arn: str,
                 source_flow_config: 'outputs.IntegrationSourceFlowConfig',
                 tasks: Sequence['outputs.IntegrationTask'],
                 trigger_config: 'outputs.IntegrationTriggerConfig',
                 description: Optional[str] = None):
        pulumi.set(__self__, "flow_name", flow_name)
        pulumi.set(__self__, "kms_arn", kms_arn)
        pulumi.set(__self__, "source_flow_config", source_flow_config)
        pulumi.set(__self__, "tasks", tasks)
        pulumi.set(__self__, "trigger_config", trigger_config)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="flowName")
    def flow_name(self) -> str:
        return pulumi.get(self, "flow_name")

    @property
    @pulumi.getter(name="kmsArn")
    def kms_arn(self) -> str:
        return pulumi.get(self, "kms_arn")

    @property
    @pulumi.getter(name="sourceFlowConfig")
    def source_flow_config(self) -> 'outputs.IntegrationSourceFlowConfig':
        return pulumi.get(self, "source_flow_config")

    @property
    @pulumi.getter
    def tasks(self) -> Sequence['outputs.IntegrationTask']:
        return pulumi.get(self, "tasks")

    @property
    @pulumi.getter(name="triggerConfig")
    def trigger_config(self) -> 'outputs.IntegrationTriggerConfig':
        return pulumi.get(self, "trigger_config")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class IntegrationIncrementalPullConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datetimeTypeFieldName":
            suggest = "datetime_type_field_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationIncrementalPullConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationIncrementalPullConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationIncrementalPullConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 datetime_type_field_name: Optional[str] = None):
        if datetime_type_field_name is not None:
            pulumi.set(__self__, "datetime_type_field_name", datetime_type_field_name)

    @property
    @pulumi.getter(name="datetimeTypeFieldName")
    def datetime_type_field_name(self) -> Optional[str]:
        return pulumi.get(self, "datetime_type_field_name")


@pulumi.output_type
class IntegrationMarketoSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")


@pulumi.output_type
class IntegrationObjectTypeMapping(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class IntegrationS3SourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bucketName":
            suggest = "bucket_name"
        elif key == "bucketPrefix":
            suggest = "bucket_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationS3SourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationS3SourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationS3SourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket_name: str,
                 bucket_prefix: Optional[str] = None):
        pulumi.set(__self__, "bucket_name", bucket_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[str]:
        return pulumi.get(self, "bucket_prefix")


@pulumi.output_type
class IntegrationSalesforceSourceProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableDynamicFieldUpdate":
            suggest = "enable_dynamic_field_update"
        elif key == "includeDeletedRecords":
            suggest = "include_deleted_records"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationSalesforceSourceProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationSalesforceSourceProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationSalesforceSourceProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 object: str,
                 enable_dynamic_field_update: Optional[bool] = None,
                 include_deleted_records: Optional[bool] = None):
        pulumi.set(__self__, "object", object)
        if enable_dynamic_field_update is not None:
            pulumi.set(__self__, "enable_dynamic_field_update", enable_dynamic_field_update)
        if include_deleted_records is not None:
            pulumi.set(__self__, "include_deleted_records", include_deleted_records)

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="enableDynamicFieldUpdate")
    def enable_dynamic_field_update(self) -> Optional[bool]:
        return pulumi.get(self, "enable_dynamic_field_update")

    @property
    @pulumi.getter(name="includeDeletedRecords")
    def include_deleted_records(self) -> Optional[bool]:
        return pulumi.get(self, "include_deleted_records")


@pulumi.output_type
class IntegrationScheduledTriggerProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scheduleExpression":
            suggest = "schedule_expression"
        elif key == "dataPullMode":
            suggest = "data_pull_mode"
        elif key == "firstExecutionFrom":
            suggest = "first_execution_from"
        elif key == "scheduleEndTime":
            suggest = "schedule_end_time"
        elif key == "scheduleOffset":
            suggest = "schedule_offset"
        elif key == "scheduleStartTime":
            suggest = "schedule_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationScheduledTriggerProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationScheduledTriggerProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationScheduledTriggerProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 schedule_expression: str,
                 data_pull_mode: Optional['IntegrationScheduledTriggerPropertiesDataPullMode'] = None,
                 first_execution_from: Optional[float] = None,
                 schedule_end_time: Optional[float] = None,
                 schedule_offset: Optional[int] = None,
                 schedule_start_time: Optional[float] = None,
                 timezone: Optional[str] = None):
        pulumi.set(__self__, "schedule_expression", schedule_expression)
        if data_pull_mode is not None:
            pulumi.set(__self__, "data_pull_mode", data_pull_mode)
        if first_execution_from is not None:
            pulumi.set(__self__, "first_execution_from", first_execution_from)
        if schedule_end_time is not None:
            pulumi.set(__self__, "schedule_end_time", schedule_end_time)
        if schedule_offset is not None:
            pulumi.set(__self__, "schedule_offset", schedule_offset)
        if schedule_start_time is not None:
            pulumi.set(__self__, "schedule_start_time", schedule_start_time)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="scheduleExpression")
    def schedule_expression(self) -> str:
        return pulumi.get(self, "schedule_expression")

    @property
    @pulumi.getter(name="dataPullMode")
    def data_pull_mode(self) -> Optional['IntegrationScheduledTriggerPropertiesDataPullMode']:
        return pulumi.get(self, "data_pull_mode")

    @property
    @pulumi.getter(name="firstExecutionFrom")
    def first_execution_from(self) -> Optional[float]:
        return pulumi.get(self, "first_execution_from")

    @property
    @pulumi.getter(name="scheduleEndTime")
    def schedule_end_time(self) -> Optional[float]:
        return pulumi.get(self, "schedule_end_time")

    @property
    @pulumi.getter(name="scheduleOffset")
    def schedule_offset(self) -> Optional[int]:
        return pulumi.get(self, "schedule_offset")

    @property
    @pulumi.getter(name="scheduleStartTime")
    def schedule_start_time(self) -> Optional[float]:
        return pulumi.get(self, "schedule_start_time")

    @property
    @pulumi.getter
    def timezone(self) -> Optional[str]:
        return pulumi.get(self, "timezone")


@pulumi.output_type
class IntegrationServiceNowSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")


@pulumi.output_type
class IntegrationSourceConnectorProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceNow":
            suggest = "service_now"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationSourceConnectorProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationSourceConnectorProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationSourceConnectorProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 marketo: Optional['outputs.IntegrationMarketoSourceProperties'] = None,
                 s3: Optional['outputs.IntegrationS3SourceProperties'] = None,
                 salesforce: Optional['outputs.IntegrationSalesforceSourceProperties'] = None,
                 service_now: Optional['outputs.IntegrationServiceNowSourceProperties'] = None,
                 zendesk: Optional['outputs.IntegrationZendeskSourceProperties'] = None):
        if marketo is not None:
            pulumi.set(__self__, "marketo", marketo)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if salesforce is not None:
            pulumi.set(__self__, "salesforce", salesforce)
        if service_now is not None:
            pulumi.set(__self__, "service_now", service_now)
        if zendesk is not None:
            pulumi.set(__self__, "zendesk", zendesk)

    @property
    @pulumi.getter
    def marketo(self) -> Optional['outputs.IntegrationMarketoSourceProperties']:
        return pulumi.get(self, "marketo")

    @property
    @pulumi.getter
    def s3(self) -> Optional['outputs.IntegrationS3SourceProperties']:
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def salesforce(self) -> Optional['outputs.IntegrationSalesforceSourceProperties']:
        return pulumi.get(self, "salesforce")

    @property
    @pulumi.getter(name="serviceNow")
    def service_now(self) -> Optional['outputs.IntegrationServiceNowSourceProperties']:
        return pulumi.get(self, "service_now")

    @property
    @pulumi.getter
    def zendesk(self) -> Optional['outputs.IntegrationZendeskSourceProperties']:
        return pulumi.get(self, "zendesk")


@pulumi.output_type
class IntegrationSourceFlowConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectorType":
            suggest = "connector_type"
        elif key == "sourceConnectorProperties":
            suggest = "source_connector_properties"
        elif key == "connectorProfileName":
            suggest = "connector_profile_name"
        elif key == "incrementalPullConfig":
            suggest = "incremental_pull_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationSourceFlowConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationSourceFlowConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationSourceFlowConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connector_type: 'IntegrationConnectorType',
                 source_connector_properties: 'outputs.IntegrationSourceConnectorProperties',
                 connector_profile_name: Optional[str] = None,
                 incremental_pull_config: Optional['outputs.IntegrationIncrementalPullConfig'] = None):
        pulumi.set(__self__, "connector_type", connector_type)
        pulumi.set(__self__, "source_connector_properties", source_connector_properties)
        if connector_profile_name is not None:
            pulumi.set(__self__, "connector_profile_name", connector_profile_name)
        if incremental_pull_config is not None:
            pulumi.set(__self__, "incremental_pull_config", incremental_pull_config)

    @property
    @pulumi.getter(name="connectorType")
    def connector_type(self) -> 'IntegrationConnectorType':
        return pulumi.get(self, "connector_type")

    @property
    @pulumi.getter(name="sourceConnectorProperties")
    def source_connector_properties(self) -> 'outputs.IntegrationSourceConnectorProperties':
        return pulumi.get(self, "source_connector_properties")

    @property
    @pulumi.getter(name="connectorProfileName")
    def connector_profile_name(self) -> Optional[str]:
        return pulumi.get(self, "connector_profile_name")

    @property
    @pulumi.getter(name="incrementalPullConfig")
    def incremental_pull_config(self) -> Optional['outputs.IntegrationIncrementalPullConfig']:
        return pulumi.get(self, "incremental_pull_config")


@pulumi.output_type
class IntegrationTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class IntegrationTask(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceFields":
            suggest = "source_fields"
        elif key == "taskType":
            suggest = "task_type"
        elif key == "connectorOperator":
            suggest = "connector_operator"
        elif key == "destinationField":
            suggest = "destination_field"
        elif key == "taskProperties":
            suggest = "task_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTask. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTask.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTask.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_fields: Sequence[str],
                 task_type: 'IntegrationTaskType',
                 connector_operator: Optional['outputs.IntegrationConnectorOperator'] = None,
                 destination_field: Optional[str] = None,
                 task_properties: Optional[Sequence['outputs.IntegrationTaskPropertiesMap']] = None):
        pulumi.set(__self__, "source_fields", source_fields)
        pulumi.set(__self__, "task_type", task_type)
        if connector_operator is not None:
            pulumi.set(__self__, "connector_operator", connector_operator)
        if destination_field is not None:
            pulumi.set(__self__, "destination_field", destination_field)
        if task_properties is not None:
            pulumi.set(__self__, "task_properties", task_properties)

    @property
    @pulumi.getter(name="sourceFields")
    def source_fields(self) -> Sequence[str]:
        return pulumi.get(self, "source_fields")

    @property
    @pulumi.getter(name="taskType")
    def task_type(self) -> 'IntegrationTaskType':
        return pulumi.get(self, "task_type")

    @property
    @pulumi.getter(name="connectorOperator")
    def connector_operator(self) -> Optional['outputs.IntegrationConnectorOperator']:
        return pulumi.get(self, "connector_operator")

    @property
    @pulumi.getter(name="destinationField")
    def destination_field(self) -> Optional[str]:
        return pulumi.get(self, "destination_field")

    @property
    @pulumi.getter(name="taskProperties")
    def task_properties(self) -> Optional[Sequence['outputs.IntegrationTaskPropertiesMap']]:
        return pulumi.get(self, "task_properties")


@pulumi.output_type
class IntegrationTaskPropertiesMap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatorPropertyKey":
            suggest = "operator_property_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTaskPropertiesMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTaskPropertiesMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTaskPropertiesMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator_property_key: 'IntegrationOperatorPropertiesKeys',
                 property: str):
        pulumi.set(__self__, "operator_property_key", operator_property_key)
        pulumi.set(__self__, "property", property)

    @property
    @pulumi.getter(name="operatorPropertyKey")
    def operator_property_key(self) -> 'IntegrationOperatorPropertiesKeys':
        return pulumi.get(self, "operator_property_key")

    @property
    @pulumi.getter
    def property(self) -> str:
        return pulumi.get(self, "property")


@pulumi.output_type
class IntegrationTriggerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "triggerType":
            suggest = "trigger_type"
        elif key == "triggerProperties":
            suggest = "trigger_properties"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationTriggerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationTriggerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationTriggerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 trigger_type: 'IntegrationTriggerType',
                 trigger_properties: Optional['outputs.IntegrationTriggerProperties'] = None):
        pulumi.set(__self__, "trigger_type", trigger_type)
        if trigger_properties is not None:
            pulumi.set(__self__, "trigger_properties", trigger_properties)

    @property
    @pulumi.getter(name="triggerType")
    def trigger_type(self) -> 'IntegrationTriggerType':
        return pulumi.get(self, "trigger_type")

    @property
    @pulumi.getter(name="triggerProperties")
    def trigger_properties(self) -> Optional['outputs.IntegrationTriggerProperties']:
        return pulumi.get(self, "trigger_properties")


@pulumi.output_type
class IntegrationTriggerProperties(dict):
    def __init__(__self__, *,
                 scheduled: Optional['outputs.IntegrationScheduledTriggerProperties'] = None):
        if scheduled is not None:
            pulumi.set(__self__, "scheduled", scheduled)

    @property
    @pulumi.getter
    def scheduled(self) -> Optional['outputs.IntegrationScheduledTriggerProperties']:
        return pulumi.get(self, "scheduled")


@pulumi.output_type
class IntegrationZendeskSourceProperties(dict):
    def __init__(__self__, *,
                 object: str):
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")


@pulumi.output_type
class ObjectTypeField(dict):
    """
    Represents a field in a ProfileObjectType.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectTypeField. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectTypeField.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectTypeField.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_type: Optional['ObjectTypeFieldContentType'] = None,
                 source: Optional[str] = None,
                 target: Optional[str] = None):
        """
        Represents a field in a ProfileObjectType.
        :param 'ObjectTypeFieldContentType' content_type: The content type of the field. Used for determining equality when searching.
        :param str source: A field of a ProfileObject. For example: _source.FirstName, where "_source" is a ProfileObjectType of a Zendesk user and "FirstName" is a field in that ObjectType.
        :param str target: The location of the data in the standard ProfileObject model. For example: _profile.Address.PostalCode.
        """
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional['ObjectTypeFieldContentType']:
        """
        The content type of the field. Used for determining equality when searching.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        A field of a ProfileObject. For example: _source.FirstName, where "_source" is a ProfileObjectType of a Zendesk user and "FirstName" is a field in that ObjectType.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def target(self) -> Optional[str]:
        """
        The location of the data in the standard ProfileObject model. For example: _profile.Address.PostalCode.
        """
        return pulumi.get(self, "target")


@pulumi.output_type
class ObjectTypeFieldMap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectTypeField":
            suggest = "object_type_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectTypeFieldMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectTypeFieldMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectTypeFieldMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 object_type_field: Optional['outputs.ObjectTypeField'] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_type_field is not None:
            pulumi.set(__self__, "object_type_field", object_type_field)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectTypeField")
    def object_type_field(self) -> Optional['outputs.ObjectTypeField']:
        return pulumi.get(self, "object_type_field")


@pulumi.output_type
class ObjectTypeKey(dict):
    """
    An object that defines the Key element of a ProfileObject. A Key is a special element that can be used to search for a customer profile.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fieldNames":
            suggest = "field_names"
        elif key == "standardIdentifiers":
            suggest = "standard_identifiers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectTypeKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectTypeKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectTypeKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 field_names: Optional[Sequence[str]] = None,
                 standard_identifiers: Optional[Sequence['ObjectTypeKeyStandardIdentifiersItem']] = None):
        """
        An object that defines the Key element of a ProfileObject. A Key is a special element that can be used to search for a customer profile.
        :param Sequence[str] field_names: The reference for the key name of the fields map. 
        :param Sequence['ObjectTypeKeyStandardIdentifiersItem'] standard_identifiers: The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple PROFILE keys. PROFILE means that this key can be used to tie an object to a PROFILE. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it is only used for matching objects to profiles.
        """
        if field_names is not None:
            pulumi.set(__self__, "field_names", field_names)
        if standard_identifiers is not None:
            pulumi.set(__self__, "standard_identifiers", standard_identifiers)

    @property
    @pulumi.getter(name="fieldNames")
    def field_names(self) -> Optional[Sequence[str]]:
        """
        The reference for the key name of the fields map. 
        """
        return pulumi.get(self, "field_names")

    @property
    @pulumi.getter(name="standardIdentifiers")
    def standard_identifiers(self) -> Optional[Sequence['ObjectTypeKeyStandardIdentifiersItem']]:
        """
        The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple PROFILE keys. PROFILE means that this key can be used to tie an object to a PROFILE. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it is only used for matching objects to profiles.
        """
        return pulumi.get(self, "standard_identifiers")


@pulumi.output_type
class ObjectTypeKeyMap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "objectTypeKeyList":
            suggest = "object_type_key_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectTypeKeyMap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectTypeKeyMap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectTypeKeyMap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: Optional[str] = None,
                 object_type_key_list: Optional[Sequence['outputs.ObjectTypeKey']] = None):
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_type_key_list is not None:
            pulumi.set(__self__, "object_type_key_list", object_type_key_list)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectTypeKeyList")
    def object_type_key_list(self) -> Optional[Sequence['outputs.ObjectTypeKey']]:
        return pulumi.get(self, "object_type_key_list")


@pulumi.output_type
class ObjectTypeTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


