# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDocumentationVersionResult',
    'AwaitableGetDocumentationVersionResult',
    'get_documentation_version',
    'get_documentation_version_output',
]

@pulumi.output_type
class GetDocumentationVersionResult:
    def __init__(__self__, description=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the API documentation snapshot.
        """
        return pulumi.get(self, "description")


class AwaitableGetDocumentationVersionResult(GetDocumentationVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDocumentationVersionResult(
            description=self.description)


def get_documentation_version(documentation_version: Optional[str] = None,
                              rest_api_id: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDocumentationVersionResult:
    """
    A snapshot of the documentation of an API.


    :param str documentation_version: The version identifier of the API documentation snapshot.
    :param str rest_api_id: The identifier of the API.
    """
    __args__ = dict()
    __args__['documentationVersion'] = documentation_version
    __args__['restApiId'] = rest_api_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:apigateway:getDocumentationVersion', __args__, opts=opts, typ=GetDocumentationVersionResult).value

    return AwaitableGetDocumentationVersionResult(
        description=__ret__.description)


@_utilities.lift_output_func(get_documentation_version)
def get_documentation_version_output(documentation_version: Optional[pulumi.Input[str]] = None,
                                     rest_api_id: Optional[pulumi.Input[str]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDocumentationVersionResult]:
    """
    A snapshot of the documentation of an API.


    :param str documentation_version: The version identifier of the API documentation snapshot.
    :param str rest_api_id: The identifier of the API.
    """
    ...
