"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Chunk(google.protobuf.message.Message):
    """Represents a chunk of data sent by the transfer service. Includes fields for
    configuring the transfer parameters.

    Notation: (Read|Write) (→|←)
      X → Means client sending data to the server.
      X ← Means server sending data to the client.
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    class _Type:
        ValueType = typing.NewType('ValueType', builtins.int)
        V: typing_extensions.TypeAlias = ValueType
    class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Chunk._Type.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DATA: Chunk._Type.ValueType  # 0
        """Chunk containing transfer data."""

        START: Chunk._Type.ValueType  # 1
        """First chunk of a transfer (only sent by the client)."""

        PARAMETERS_RETRANSMIT: Chunk._Type.ValueType  # 2
        """Transfer parameters indicating that the transmitter should retransmit
        from the specified offset.
        """

        PARAMETERS_CONTINUE: Chunk._Type.ValueType  # 3
        """Transfer parameters telling the transmitter to continue sending up to
        index `offset + pending_bytes` of data. If the transmitter is already
        beyond `offset`, it does not have to rewind.
        """

        COMPLETION: Chunk._Type.ValueType  # 4
        """Sender of the chunk is terminating the transfer."""

        COMPLETION_ACK: Chunk._Type.ValueType  # 5
        """Acknowledge the completion of a transfer. Currently unused.
        TODO(konkers): Implement this behavior.
        """

        START_ACK: Chunk._Type.ValueType  # 6
        """Acknowledges a transfer start request, assigning a session ID for the
        transfer and optionally negotiating the protocol version. Sent from
        server to client.
        """

        START_ACK_CONFIRMATION: Chunk._Type.ValueType  # 7
        """Confirmation of a START_ACK's assigned session ID and negotiated
        parameters, sent by the client to the server. Initiates the data transfer
        proper.
        """

    class Type(_Type, metaclass=_TypeEnumTypeWrapper):
        pass

    DATA: Chunk.Type.ValueType  # 0
    """Chunk containing transfer data."""

    START: Chunk.Type.ValueType  # 1
    """First chunk of a transfer (only sent by the client)."""

    PARAMETERS_RETRANSMIT: Chunk.Type.ValueType  # 2
    """Transfer parameters indicating that the transmitter should retransmit
    from the specified offset.
    """

    PARAMETERS_CONTINUE: Chunk.Type.ValueType  # 3
    """Transfer parameters telling the transmitter to continue sending up to
    index `offset + pending_bytes` of data. If the transmitter is already
    beyond `offset`, it does not have to rewind.
    """

    COMPLETION: Chunk.Type.ValueType  # 4
    """Sender of the chunk is terminating the transfer."""

    COMPLETION_ACK: Chunk.Type.ValueType  # 5
    """Acknowledge the completion of a transfer. Currently unused.
    TODO(konkers): Implement this behavior.
    """

    START_ACK: Chunk.Type.ValueType  # 6
    """Acknowledges a transfer start request, assigning a session ID for the
    transfer and optionally negotiating the protocol version. Sent from
    server to client.
    """

    START_ACK_CONFIRMATION: Chunk.Type.ValueType  # 7
    """Confirmation of a START_ACK's assigned session ID and negotiated
    parameters, sent by the client to the server. Initiates the data transfer
    proper.
    """


    TRANSFER_ID_FIELD_NUMBER: builtins.int
    PENDING_BYTES_FIELD_NUMBER: builtins.int
    MAX_CHUNK_SIZE_BYTES_FIELD_NUMBER: builtins.int
    MIN_DELAY_MICROSECONDS_FIELD_NUMBER: builtins.int
    OFFSET_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    REMAINING_BYTES_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    WINDOW_END_OFFSET_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    PROTOCOL_VERSION_FIELD_NUMBER: builtins.int
    transfer_id: builtins.int
    """Represents the source or destination of the data. May be ephemeral or
    stable depending on the implementation. Sent in every request to identify
    the transfer target.

    LEGACY FIELD ONLY. Split into resource_id and session_id in transfer v2.

     Read → ID of transfer
     Read ← ID of transfer
    Write → ID of transfer
    Write ← ID of transfer
    """

    pending_bytes: builtins.int
    """Used by the receiver to indicate how many bytes it can accept. The
    transmitter sends this much data, divided into chunks no larger than
    max_chunk_size_bytes. The receiver then starts another window by sending
    request_bytes again with a new offset.

     Read → The client requests this many bytes to be sent.
     Read ← N/A
    Write → N/A
    Write ← The server requests this many bytes to be sent.
    """

    max_chunk_size_bytes: builtins.int
    """Maximum size of an individual chunk. The transmitter may send smaller
    chunks if required.

     Read → Set maximum size for subsequent chunks.
     Read ← N/A
    Write → N/A
    Write ← Set maximum size for subsequent chunks.
    """

    min_delay_microseconds: builtins.int
    """Minimum required delay between chunks. The transmitter may delay longer if
    desired.

     Read → Set minimum delay for subsequent chunks.
     Read ← N/A
    Write → N/A
    Write ← Set minimum delay for subsequent chunks.
    """

    offset: builtins.int
    """On writes, the offset of the data. On reads, the offset at which to read.

     Read → Read data starting at this offset.
     Read ← Offset of the data.
    Write → Offset of the data.
    Write ← Write data starting at this offset.
    """

    data: builtins.bytes
    """The data that was read or the data to write.

     Read → N/A
     Read ← Data read
    Write → Data to write
    Write ← N/A
    """

    remaining_bytes: builtins.int
    """Estimated bytes remaining to read/write. Optional except for the last data
    chunk, for which remaining_bytes must be set to 0.

    The sender can set remaining_bytes at the beginning of a read/write so that
    the receiver can track progress or cancel the transaction if the value is
    too large.

     Read → N/A
     Read ← Remaining bytes to read, excluding any data in this chunk. Set to
            0 for the last chunk.
    Write → Remaining bytes to write, excluding any data in is chunk. Set to
            0 for the last chunk.
    Write ← N/A
    """

    status: builtins.int
    """Pigweed status code indicating the completion of a transfer. This is only
    present in the final packet sent by either the transmitter or receiver.

    The possible status codes and their meanings are listed below:

      OK: Transfer completed successfully.
      DATA_LOSS: Transfer data could not be read/written (e.g. corruption).
      INVALID_ARGUMENT: Received malformed chunk.
      NOT_FOUND: The requested resource ID is not registered (read/write).
      OUT_OF_RANGE: The requested offset is larger than the data (read/write).
      RESOURCE_EXHAUSTED: Concurrent transfer limit reached.
      UNIMPLEMENTED: Resource ID does not support requested operation (e.g.
          trying to write to a read-only transfer).

     Read → Transfer complete.
     Read ← Transfer complete.
    Write → Transfer complete.
    Write ← Transfer complete.
    """

    window_end_offset: builtins.int
    """The offset up to which the transmitter can send data before waiting for the
    receiver to acknowledge.

     Read → Offset up to which the server can send without blocking.
     Read ← N/A
    Write → N/A
    Write ← Offset up to which the client can send without blocking.

    TODO(frolv): This will replace the pending_bytes field. Once all uses of
    transfer are migrated, that field should be removed.
    """

    type: global___Chunk.Type.ValueType
    """The type of this chunk. This field should only be processed when present.
    TODO(frolv): Update all users of pw_transfer and remove the optional
    semantics from this field.

     Read → Chunk type (start/parameters).
     Read ← Chunk type (data).
    Write → Chunk type (data).
    Write ← Chunk type (start/parameters).
    """

    resource_id: builtins.int
    """Unique identifier for the source or destination of transfer data. May be
    stable or ephemeral depending on the implementation. Only sent during the
    initial handshake phase of a version 2 or higher transfer.

     Read → ID of transferable resource
     Read ← ID of transferable resource
    Write → ID of transferable resource
    Write ← ID of transferable resource
    """

    session_id: builtins.int
    """Unique identifier for a specific transfer session. Assigned by a transfer
    service during the initial handshake phase, and persists for the remainder
    of that transfer operation.

     Read → ID of transfer session
     Read ← ID of transfer session
    Write → ID of transfer session
    Write ← ID of transfer session
    """

    protocol_version: builtins.int
    """The protocol version to use for this transfer. Only sent during the initial
    handshake phase of a version 2 or higher transfer to negotiate a common
    protocol version between the client and server.

     Read → Desired (START) or configured (START_ACK_CONFIRMATION) version.
     Read ← Configured protocol version (START_ACK).
    Write → Desired (START) or configured (START_ACK_CONFIRMATION) version.
    Write ← Configured protocol version (START_ACK).
    """

    def __init__(self,
        *,
        transfer_id: builtins.int = ...,
        pending_bytes: typing.Optional[builtins.int] = ...,
        max_chunk_size_bytes: typing.Optional[builtins.int] = ...,
        min_delay_microseconds: typing.Optional[builtins.int] = ...,
        offset: builtins.int = ...,
        data: builtins.bytes = ...,
        remaining_bytes: typing.Optional[builtins.int] = ...,
        status: typing.Optional[builtins.int] = ...,
        window_end_offset: builtins.int = ...,
        type: typing.Optional[global___Chunk.Type.ValueType] = ...,
        resource_id: typing.Optional[builtins.int] = ...,
        session_id: typing.Optional[builtins.int] = ...,
        protocol_version: typing.Optional[builtins.int] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["_max_chunk_size_bytes",b"_max_chunk_size_bytes","_min_delay_microseconds",b"_min_delay_microseconds","_pending_bytes",b"_pending_bytes","_protocol_version",b"_protocol_version","_remaining_bytes",b"_remaining_bytes","_resource_id",b"_resource_id","_session_id",b"_session_id","_status",b"_status","_type",b"_type","max_chunk_size_bytes",b"max_chunk_size_bytes","min_delay_microseconds",b"min_delay_microseconds","pending_bytes",b"pending_bytes","protocol_version",b"protocol_version","remaining_bytes",b"remaining_bytes","resource_id",b"resource_id","session_id",b"session_id","status",b"status","type",b"type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["_max_chunk_size_bytes",b"_max_chunk_size_bytes","_min_delay_microseconds",b"_min_delay_microseconds","_pending_bytes",b"_pending_bytes","_protocol_version",b"_protocol_version","_remaining_bytes",b"_remaining_bytes","_resource_id",b"_resource_id","_session_id",b"_session_id","_status",b"_status","_type",b"_type","data",b"data","max_chunk_size_bytes",b"max_chunk_size_bytes","min_delay_microseconds",b"min_delay_microseconds","offset",b"offset","pending_bytes",b"pending_bytes","protocol_version",b"protocol_version","remaining_bytes",b"remaining_bytes","resource_id",b"resource_id","session_id",b"session_id","status",b"status","transfer_id",b"transfer_id","type",b"type","window_end_offset",b"window_end_offset"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_max_chunk_size_bytes",b"_max_chunk_size_bytes"]) -> typing.Optional[typing_extensions.Literal["max_chunk_size_bytes"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_min_delay_microseconds",b"_min_delay_microseconds"]) -> typing.Optional[typing_extensions.Literal["min_delay_microseconds"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_pending_bytes",b"_pending_bytes"]) -> typing.Optional[typing_extensions.Literal["pending_bytes"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_protocol_version",b"_protocol_version"]) -> typing.Optional[typing_extensions.Literal["protocol_version"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_remaining_bytes",b"_remaining_bytes"]) -> typing.Optional[typing_extensions.Literal["remaining_bytes"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_resource_id",b"_resource_id"]) -> typing.Optional[typing_extensions.Literal["resource_id"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_session_id",b"_session_id"]) -> typing.Optional[typing_extensions.Literal["session_id"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_status",b"_status"]) -> typing.Optional[typing_extensions.Literal["status"]]: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing_extensions.Literal["_type",b"_type"]) -> typing.Optional[typing_extensions.Literal["type"]]: ...
global___Chunk = Chunk
