# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['observedstruct']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'observedstruct',
    'version': '0.1.0',
    'description': 'Observed structures that calls callback functions on changes.',
    'long_description': "# observedstruct\n\nObserved structures that calls your functions on changes.\n\n## Install\n\n`observedstruct` supports Python 3.7, 3.8, and 3.9.\n\n```\npip install observedstruct\n```\n\n## API\n\n### `observedstruct.ObservedOperation`\n\nThese are the operations tracked by the structures:\n\n- `ObservedOperation.Access`\n- `ObservedOperation.Add`\n- `ObservedOperation.Update`\n- `ObservedOperation.Remove`\n\nThese values are sent to the callbacks.\n\n### `get_item_for_reference(struct, reference)`\n\nFind an item inside a structure based on a reference list.\n\n### `observedstruct.ObservedDict`\n\n- `__init__(initial, *, pre_callbacks=None, post_callbacks=None)`\n\n`ObservedDict` can be instantiated with another `dict`, and it will recursively turn all nested dictionaries and lists into observed structs as well (by using `ObservedDict` and `ObservedList`). `pre_callbacks` are functions to be called before an operation takes place, and `post_callbacks` are functions to be called after an operation takes place.\n\n```python\nfrom observedstruct import ObservedDict\n\ndef pre_callback(struct, operation, reference, old_value, new_value):\n    pass\n\ndef post_callback(struct, operation, reference, old_value, new_value):\n    pass\n\nd = ObservedDict(\n    {'a': 1},\n    pre_callbacks=[pre_callback],\n    post_callbacks=[post_callback],\n)\nd['b'] = 2\n```\n\nCallbacks are called with:\n\n- `struct`: The structure in which the event is taking place. You can find the affected object in the structure by navigating to the reference list in `reference` starting from the `struct`.\n- `operation`: One of `ObservedOperation`.\n- `reference`: A list of references inside the structure that can be used to find the affected object. If the structure is a list, it will be an integer, and if it's a dictionary, it will the object used as key. It can be something like `['a', 0]` for a dictionary that contains key `a` which is a list, and the operation takes place at the first position in the list. You can use the utility function `get_item_for_reference` to find the object the reference refers to from inside callback functions.\n- `old_value`: The value that will be removed from the structure.\n- `new_value`: The value that will be added to the structure.\n\nThis class supports all operations a regular dictionary supports.\n\n### `observedstruct.ObservedList`\n\nSame as the `ObservedDict` class, but you instantiate this class with a `list`.\n\n## Limitations\n\nAn observed structure can only belong inside one other observed structure. To allow for the callback functions to be found and to be called with the correct references, each nested observed structure stores a reference to its parent and where it can be found in the parent. If an observed structure belongs to more than one parent, then it will have those attributes replaced and one of the parents won't be reachable from the child.\n\nCallbacks registered in nested structures will not be called. Once a structure belongs in another structure, only the callbacks from the root structure in the hierarchy are called. Because of this, the multiplication of lists does not work in `ObservedList`, since that would make several instances of a nested structure happen inside a list, and the reference would be wrong for at least one of the occurrences.\n\n## Development\n\nClone the source code from GitHub, have all supported Python interpreters in your `PATH` (we recommend that you use `pyenv` to manage different Python interpreters and environments) and create a new virtual environment with `poetry install`.\n\nRun the tests with:\n\n```\n./run all-tests\n```\n\nTo run a specific test:\n\n```\n./run test <test-address>\n```\n\nTo make sure your code complies with our quality standards, run:\n\n```\n./run quality\n```\n",
    'author': 'João Sampaio',
    'author_email': 'jpmelos@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/jpmelos/observedstruct',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<3.10',
}


setup(**setup_kwargs)
