# -*- coding: utf-8 -*-
import os
import sys
from io import open
from setuptools import setup
from setuptools import find_packages

here = os.path.abspath(os.path.dirname(__file__))

with open(os.path.join(here, 'README.md'), "r", encoding="utf-8") as fobj:
    long_description = fobj.read()

requires = [
    "pycryptodome",
    "pillow",
    "rsa",
]

if sys.version.startswith("2"):
    requires += [
        "funcsigs",
    ]

setup(
    name="fastutils",
    version="0.10.0",
    description="Collection of simple utils.",
    long_description=long_description,
    long_description_content_type='text/markdown',
    author="zencore",
    author_email="dobetter@zencore.cn",
    license="MIT",
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3 :: Only',
    ],
    keywords=['fastutils', 'listutils', 'dictutils', 'strutils', 'hashutils', 'aesutils', 'funcutils'],
    install_requires=requires,
    packages=find_packages(".", exclude=["tests"]),
)