从 selenium.webdriver.common.action_chains 导入 ActionChains
从 汉化通用 导入 _反向注入

类 〇动作链(ActionChains):
    """使鼠标移动、鼠标按钮动作、按键、右键菜单等低级交互自动化的方法"""

    套路 __init__(分身, 老司机, 持续时间=250):
        """新建动作链"""
        super().__init__(老司机, duration=持续时间)

    套路 完成(分身):
        """执行所有储存的动作"""
        分身.w3c_actions.perform()

    套路 重置动作(分身):
        "清除本地和远端已经储存的动作"
        分身.reset_actions()

    套路 点击(分身, 元素=空):
        "点击一个元素. 如果 '元素' 为空, 则在鼠标当前位置点击."
        返回 分身.click(元素)

    套路 点击并按住(分身, 元素=空):
        "在一个元素上点击鼠标左键并按住不放"
        返回 分身.click_and_hold(元素)

    套路 右键点击(分身, 元素=空):
        返回 分身.context_click(元素)

    套路 双击(分身, 元素=空):
        返回 分身.double_click(元素)

    套路 拖放(分身, 源, 目标):
        "在源元素上按住鼠标左键, 然后移至目标元素并释放鼠标键."
        分身.click_and_hold(源)
        分身.release(目标)
        返回 分身

    套路 拖放_偏移(分身, 源, x偏移, y偏移):
        "在源元素上按住鼠标左键, 然后移至目标偏移量并释放鼠标键."
        分身.click_and_hold(源)
        分身.move_by_offset(x偏移, y偏移)
        分身.release()
        return 分身

    套路 键按下(分身, 值, 元素=空):
        "发送一个组合键(Control/Alt/Shift), 但不释放"
        返回 分身.key_down(值, element=元素)

    套路 键弹起(分身, 值, 元素=空):
        "释放一个组合键"
        返回 分身.key_up(值, element=元素)

    套路 偏移(分身, x偏移, y偏移):
        "鼠标相对于当前位置移动一定的量"
        返回 分身.move_by_offset(x偏移, y偏移)

    套路 移至元素(分身, 目标元素):
        "鼠标移动到元素的中间"
        返回 分身.move_to_element(目标元素)

    套路 移至元素_偏移(分身, 目标元素, x偏移, y偏移):
        """鼠标移动到相对于指定元素偏移一定量的位置. x/y 偏移量相对于元素左上角而言.
        """
        返回 分身.move_to_element_with_offset(目标元素, x偏移, y偏移)

    套路 暂停(分身, 秒数):
        "在指定的秒数内暂停所有输入"
        返回 分身.pause(秒数)

    套路 释放(分身, 元素=空):
        "释放按在元素上的鼠标键"
        返回 分身.release(元素)

    套路 发送按键(分身, *按键):
        "发送按键至当前有焦点的元素"
        返回 分身.send_keys(*按键)

    套路 发送按键至元素(分身, 元素, *按键):
        "发送按键至一个元素"
        分身.click(元素)
        分身.send_keys(*按键)
        返回 分身

    套路 滚动至元素(分身, 元素):
        """如果元素在视口之外, 则将元素底部滚动至视口底部"""
        返回 分身.scroll_to_element(元素)

    套路 滚动一定量(分身, x距离, y距离):
        """滚动指定的量, 原点在视口左上角"""
        返回 分身.scroll_by_amount(x距离, y距离)

    套路 从指定原点滚动(分身, 滚动原点, x距离, y距离):
        """基于指定原点滚动指定的距离"""
        返回 分身.scroll_from_origin(滚动原点, x距离, y距离)

_反向注入(〇动作链, ActionChains)
