import { SecretValue } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Properties for a SlackTextract.
 *
 * @stability stable
 */
export interface SlackTextractProps {
    /**
     * The signing secret of the Slack app.
     *
     * @stability stable
     */
    readonly signingSecret: SecretValue;
    /**
     * The **bot** token of the Slack app.
     *
     * The following scopes are required: `chat:write` and `files:read`
     *
     * @stability stable
     */
    readonly botToken: SecretValue;
    /**
     * The application id of the Slack app.
     *
     * @stability stable
     */
    readonly appId: string;
}
/**
 * Extract text from images posted to Slack using Amazon Textract.
 *
 * @stability stable
 */
export declare class SlackTextract extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SlackTextractProps);
}
