"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackEvents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigatewayv2 = require("@aws-cdk/aws-apigatewayv2-alpha");
const integrations = require("@aws-cdk/aws-apigatewayv2-integrations-alpha");
const cdk = require("aws-cdk-lib");
const events = require("aws-cdk-lib/aws-events");
const logs = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const events_function_1 = require("./events-function");
/**
 * Send Slack events to Amazon EventBridge.
 *
 * @stability stable
 */
class SlackEvents extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.customEventBus) {
            this.eventBus = new events.EventBus(this, 'EventBus');
        }
        // Send event to the event bus
        const handler = new events_function_1.EventsFunction(this, 'handler', {
            logRetention: logs.RetentionDays.ONE_MONTH,
            environment: {
                SLACK_SIGNING_SECRET: props.signingSecret.toString(),
            },
        });
        if (this.eventBus) {
            handler.addEnvironment('EVENT_BUS_NAME', this.eventBus.eventBusName);
        }
        events.EventBus.grantAllPutEvents(handler);
        // HTTP API
        const httpApi = new apigatewayv2.HttpApi(this, 'SlackEventsApi', {
            defaultIntegration: new integrations.HttpLambdaIntegration('Integration', handler),
            apiName: props.apiName,
        });
        new cdk.CfnOutput(this, 'ApiEndpoint', {
            value: httpApi.apiEndpoint,
        });
    }
}
exports.SlackEvents = SlackEvents;
_a = JSII_RTTI_SYMBOL_1;
SlackEvents[_a] = { fqn: "cloudstructs.SlackEvents", version: "0.4.18" };
//# sourceMappingURL=data:application/json;base64,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