import * as cdk from 'aws-cdk-lib';
import * as events from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
/**
 * Properties for a SlackEvents.
 *
 * @stability stable
 */
export interface SlackEventsProps {
    /**
     * The signing secret of the Slack app.
     *
     * @stability stable
     */
    readonly signingSecret: cdk.SecretValue;
    /**
     * A name for the API Gateway resource.
     *
     * @default SlackEventsApi
     * @stability stable
     */
    readonly apiName?: string;
    /**
     * Whether to use a custom event bus.
     *
     * @default false
     * @stability stable
     */
    readonly customEventBus?: boolean;
}
/**
 * Send Slack events to Amazon EventBridge.
 *
 * @stability stable
 */
export declare class SlackEvents extends Construct {
    /**
     * The custom event bus where Slack events are sent.
     *
     * @stability stable
     */
    readonly eventBus?: events.EventBus;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: SlackEventsProps);
}
