"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SlackAppProvider = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const logs = require("aws-cdk-lib/aws-logs");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const provider_function_1 = require("./provider-function");
class SlackAppProvider extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.handler = new provider_function_1.ProviderFunction(this, 'handler', {
            logRetention: logs.RetentionDays.ONE_MONTH,
        });
        const provider = new cr.Provider(this, 'Resource', {
            onEventHandler: this.handler,
        });
        this.serviceToken = provider.serviceToken;
    }
    /**
     * Creates a stack-singleton resource provider
     */
    static getOrCreate(scope) {
        var _a;
        const stack = aws_cdk_lib_1.Stack.of(scope);
        const uid = 'SlackAppProvider';
        return (_a = stack.node.tryFindChild(uid)) !== null && _a !== void 0 ? _a : new SlackAppProvider(stack, uid);
    }
}
exports.SlackAppProvider = SlackAppProvider;
//# sourceMappingURL=data:application/json;base64,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