import * as ecs from 'aws-cdk-lib/aws-ecs';
import * as events from 'aws-cdk-lib/aws-events';
import { Construct } from 'constructs';
/**
 * Properties for a EcsServiceRoller.
 *
 * @stability stable
 */
export interface EcsServiceRollerProps {
    /**
     * The ECS cluster where the services run.
     *
     * @stability stable
     */
    readonly cluster: ecs.ICluster;
    /**
     * The ECS service for which tasks should be rolled.
     *
     * @stability stable
     */
    readonly service: ecs.IService;
    /**
     * The rule or schedule that should trigger a roll.
     *
     * @default - roll everyday at midnight
     * @stability stable
     */
    readonly trigger?: RollTrigger;
}
/**
 * The rule or schedule that should trigger a roll.
 *
 * @stability stable
 */
export declare abstract class RollTrigger {
    /**
     * Schedule that should trigger a roll.
     *
     * @stability stable
     */
    static fromSchedule(schedule: events.Schedule): RollTrigger;
    /**
     * Rule that should trigger a roll.
     *
     * @stability stable
     */
    static fromRule(rule: events.Rule): RollTrigger;
    /**
     * Roll schedule.
     *
     * @default - roll everyday at midnight
     * @stability stable
     */
    abstract readonly schedule?: events.Schedule;
    /**
     * Roll rule.
     *
     * @default - roll everyday at midnight
     * @stability stable
     */
    abstract readonly rule?: events.Rule;
}
/**
 * Roll your ECS service tasks on schedule or with a rule.
 *
 * @stability stable
 */
export declare class EcsServiceRoller extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: EcsServiceRollerProps);
}
