# Slack Test Notification

This script (`test_slack.py`) is used to post UI test results to Slack channels as part of the GitHub Actions workflow.

## How it works

1. **Triggered by GitHub Actions**: The script runs at the end of the `run-tests.yml` workflow
2. **Reads test results**: It reads the `test-summary.md` file generated by the test suite
3. **Posts to Slack**: It posts the test results along with PR information to all accessible Slack channels

## Configuration

The script requires the following environment variables to be set in GitHub repository secrets:

- `SLACK_BOT_TOKEN`: The Slack bot token for authentication

The following environment variables are automatically set by GitHub Actions:
- `GITHUB_PR_NUMBER`: Pull request number
- `GITHUB_PR_URL`: Pull request URL  
- `GITHUB_REPOSITORY`: Repository name

## Slack Bot Setup

To use this script, you need to:

1. Create a Slack app and bot in your workspace
2. Add the bot to the channels where you want notifications
3. Set the `SLACK_BOT_TOKEN` secret in your GitHub repository settings

## Message Format

The script posts a formatted message containing:
- PR number and link
- Repository name
- Complete test results summary (same content as GitHub comment)
- Test statistics (passed/failed/skipped)
- Links to artifacts and workflow run

## Dependencies

- `slack-sdk`: For Slack API communication
- `python-dotenv`: For environment variable handling

Both are automatically installed by the GitHub Actions workflow.
