/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.StringTokenizer;
import ucar.nc2.CDMNode;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.util.Indent;

public class Dimension
extends CDMNode
implements Comparable {
    public static Dimension VLEN = new Dimension("*", -1, false, false, true).setImmutable();
    private boolean isUnlimited = false;
    private boolean isVariableLength = false;
    private boolean isShared = true;
    private int length;
    private int hashCode = 0;

    public static String makeDimensionsString(List<Dimension> dimensions) {
        if (dimensions == null) {
            return "";
        }
        Formatter buf = new Formatter();
        for (int i = 0; i < dimensions.size(); ++i) {
            Dimension myd = dimensions.get(i);
            String dimName = myd.getShortName();
            if (i != 0) {
                buf.format(" ", new Object[0]);
            }
            if (myd.isVariableLength()) {
                buf.format("*", new Object[0]);
                continue;
            }
            if (myd.isShared()) {
                buf.format("%s", dimName);
                continue;
            }
            buf.format("%d", myd.getLength());
        }
        return buf.toString();
    }

    public static List<Dimension> makeDimensionsList(Group parentGroup, String dimString) throws IllegalArgumentException {
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        if (dimString == null || dimString.length() == 0) {
            return newDimensions;
        }
        StringTokenizer stoke = new StringTokenizer(dimString);
        while (stoke.hasMoreTokens()) {
            Dimension d;
            String dimName = stoke.nextToken();
            Dimension dimension = d = dimName.equals("*") ? VLEN : parentGroup.findDimension(dimName);
            if (d == null) {
                try {
                    int len = Integer.parseInt(dimName);
                    d = new Dimension(null, len, false, false, false);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Dimension " + dimName + " does not exist");
                }
            }
            newDimensions.add(d);
        }
        return newDimensions;
    }

    public static List<Dimension> makeDimensionsAnon(int[] shape) {
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        if (shape == null || shape.length == 0) {
            return newDimensions;
        }
        for (int s2 : shape) {
            newDimensions.add(new Dimension(null, s2, false, false, false));
        }
        return newDimensions;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUnlimited() {
        return this.isUnlimited;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public boolean isShared() {
        return this.isShared;
    }

    @Override
    public Group getGroup() {
        return this.getParentGroup();
    }

    public String makeFullName() {
        return super.getFullName();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Dimension)) {
            return false;
        }
        Dimension other = (Dimension)oo;
        Group g2 = this.getGroup();
        if (g2 != null && !g2.equals(other.getGroup())) {
            return false;
        }
        if (this.getShortName() == null && other.getShortName() != null) {
            return false;
        }
        if (this.getShortName() != null && !this.getShortName().equals(other.getShortName())) {
            return false;
        }
        return this.getLength() == other.getLength() && this.isUnlimited() == other.isUnlimited() && this.isVariableLength() == other.isVariableLength() && this.isShared() == other.isShared();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            Group g2 = this.getGroup();
            if (g2 != null) {
                result += 37 * result + g2.hashCode();
            }
            if (null != this.getShortName()) {
                result += 37 * result + this.getShortName().hashCode();
            }
            result += 37 * result + this.getLength();
            result += 37 * result + (this.isUnlimited() ? 0 : 1);
            result += 37 * result + (this.isVariableLength() ? 0 : 1);
            result += 37 * result + (this.isShared() ? 0 : 1);
            this.hashCode = result;
        }
        return this.hashCode;
    }

    @Override
    public void hashCodeShow(Indent indent) {
        System.out.printf("%sDim hash = %d%n", indent, this.hashCode());
        System.out.printf("%s shortName '%s' = %d%n", indent, this.getShortName(), this.getShortName() == null ? -1 : this.getShortName().hashCode());
        System.out.printf("%s getLength %s%n", indent, this.getLength());
        System.out.printf("%s isUnlimited %s%n", indent, this.isUnlimited());
        System.out.printf("%s isVariableLength %s%n", indent, this.isVariableLength());
        System.out.printf("%s isShared %s%n", indent, this.isShared());
        if (this.getGroup() != null) {
            System.out.printf("%s parentGroup %s = %d%n", indent, this.getGroup(), this.getGroup().hashCode());
        }
    }

    public String toString() {
        return this.writeCDL(false);
    }

    public int compareTo(Object o) {
        Dimension odim = (Dimension)o;
        String name = this.getShortName();
        return name.compareTo(odim.getShortName());
    }

    public String writeCDL(boolean strict) {
        Formatter f = new Formatter();
        this.writeCDL(f, new Indent(2), strict);
        return f.toString();
    }

    protected void writeCDL(Formatter out, Indent indent, boolean strict) {
        String name = strict ? NetcdfFile.makeValidCDLName(this.getShortName()) : this.getShortName();
        out.format("%s%s", indent, name);
        if (this.isUnlimited()) {
            out.format(" = UNLIMITED;   // (%d currently)", this.getLength());
        } else if (this.isVariableLength()) {
            out.format(" = UNKNOWN;", new Object[0]);
        } else {
            out.format(" = %d;", this.getLength());
        }
    }

    public Dimension(String name, int length) {
        this(name, length, true, false, false);
    }

    public Dimension(String name, int length, boolean isShared) {
        this(name, length, isShared, false, false);
    }

    public Dimension(String name, int length, boolean isShared, boolean isUnlimited, boolean isVariableLength) {
        super(name);
        this.isShared = isShared;
        this.isUnlimited = isUnlimited;
        this.isVariableLength = isVariableLength;
        if (isVariableLength && (isUnlimited || isShared)) {
            throw new IllegalArgumentException("variable length dimension cannot be shared or unlimited");
        }
        this.setLength(length);
        assert (name != null || !this.isShared);
    }

    public Dimension(String name, Dimension from) {
        super(name);
        this.length = from.length;
        this.isUnlimited = from.isUnlimited;
        this.isVariableLength = from.isVariableLength;
        this.isShared = from.isShared;
    }

    public void setUnlimited(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isUnlimited = b;
        this.setLength(this.length);
    }

    public void setVariableLength(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isVariableLength = b;
        if (b) {
            this.isShared = false;
            this.isUnlimited = false;
        }
        this.setLength(this.length);
    }

    public void setShared(boolean b) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.isShared = b;
        this.hashCode = 0;
    }

    public void setLength(int n) {
        if (this.immutable && !this.isUnlimited) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.isVariableLength) {
            if (n != -1) {
                throw new IllegalArgumentException("VariableLength Dimension length =" + n + " must be -1");
            }
        } else if (this.isUnlimited) {
            if (n < 0) {
                throw new IllegalArgumentException("Unlimited Dimension length =" + n + " must >= 0");
            }
        } else if (n < 1) {
            throw new IllegalArgumentException("Dimension length =" + n + " must be > 0");
        }
        this.length = n;
        this.hashCode = 0;
    }

    public String setName(String name) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (name.length() == 0) {
            name = null;
        }
        this.setShortName(name);
        this.hashCode = 0;
        return this.getShortName();
    }

    public void setGroup(Group g2) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.setParentGroup(g2);
        this.hashCode = 0;
    }

    public Dimension setImmutable() {
        this.immutable = true;
        return this;
    }
}

