/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.IMinMaxStore;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.Immersion;
import ome.xml.model.primitives.Timestamp;

public class DeltavisionReader
extends FormatReader {
    public static final int DV_MAGIC_BYTES_1 = 41152;
    public static final int DV_MAGIC_BYTES_2 = 49312;
    @Deprecated
    public static final String DATE_FORMAT = "E MMM d HH:mm:ss yyyy";
    public static final String[] DATE_FORMATS = new String[]{"E MMM d HH:mm:ss yyyy", "E MMM  d HH:mm:ss yyyy"};
    private static final short LITTLE_ENDIAN = -16224;
    private static final int HEADER_LENGTH = 1024;
    private static final int NEW_TYPE = 100;
    private static final int MAX_CHANNELS = 12;
    private static final String[] IMAGE_TYPES = new String[]{"normal", "Tilt-series", "Stereo tilt-series", "Averaged images", "Averaged stereo pairs"};
    private int extSize;
    protected int wSize;
    protected int zSize;
    protected int tSize;
    protected int panelSize;
    private int xTiles;
    private int yTiles;
    private boolean backwardsStageX = false;
    private boolean backwardsStageY = false;
    protected int numIntsPerSection;
    protected int numFloatsPerSection;
    protected DVExtHdrFields[] extHdrFields = null;
    private Double[] ndFilters;
    private int[] lengths;
    private String logFile;
    private String deconvolutionLogFile;
    private boolean truncatedFileFlag = false;
    private String imageSequence;
    private boolean newFileType = false;
    protected boolean positionInT = false;

    public DeltavisionReader() {
        super("Deltavision", new String[]{"dv", "r3d", "r3d_d3d", "dv.log", "r3d.log"});
        this.suffixNecessary = false;
        this.suffixSufficient = false;
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .dv, .r3d, or .d3d file and up to two optional .log files";
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (DeltavisionReader.checkSuffix(name, "dv.log") || DeltavisionReader.checkSuffix(name, "r3d.log") || name.endsWith("_log.txt")) {
            return true;
        }
        if (DeltavisionReader.checkSuffix(name, "pnl")) {
            return false;
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        boolean valid;
        if (new TiffParser(stream).isValidHeader()) {
            return false;
        }
        int blockLen = 212;
        if (!FormatTools.validStream(stream, 212, true)) {
            return false;
        }
        stream.seek(96L);
        stream.order(true);
        int magic = stream.readShort() & 0xFFFF;
        boolean bl = valid = magic == 41152 || magic == 49312;
        if (!valid) {
            return false;
        }
        stream.order(magic == 49312);
        stream.seek(208L);
        boolean isMap = stream.readString(4).trim().equals("MAP");
        if (isMap) {
            return false;
        }
        stream.seek(0L);
        int x = stream.readInt();
        int y = stream.readInt();
        int count = stream.readInt();
        return x > 0 && y > 0 && count > 0 && 1024L + (long)x * (long)y <= stream.length();
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        if (!noPixels) {
            files.add(this.currentId);
        }
        if (this.logFile != null) {
            files.add(this.logFile);
        }
        if (this.deconvolutionLogFile != null) {
            files.add(this.deconvolutionLogFile);
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int[] coords = this.getZCTCoords(no);
        long offset = this.getPlaneByteOffset(coords[0], coords[1], coords[2]);
        if (offset < this.in.length()) {
            this.in.seek(offset);
            this.readPlane(this.in, x, this.getSizeY() - h2 - y, w, h2, buf);
            byte[] tmp = new byte[w * FormatTools.getBytesPerPixel(this.getPixelType())];
            for (int row = 0; row < h2 / 2; ++row) {
                int src = row * tmp.length;
                int dest = (h2 - row - 1) * tmp.length;
                System.arraycopy(buf, src, tmp, 0, tmp.length);
                System.arraycopy(buf, dest, buf, src, tmp.length);
                System.arraycopy(tmp, 0, buf, dest, tmp.length);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tSize = 0;
            this.zSize = 0;
            this.wSize = 0;
            this.extSize = 0;
            this.panelSize = 0;
            this.numFloatsPerSection = 0;
            this.numIntsPerSection = 0;
            this.extHdrFields = null;
            this.ndFilters = null;
            this.deconvolutionLogFile = null;
            this.logFile = null;
            this.lengths = null;
            this.backwardsStageX = false;
            this.backwardsStageY = false;
            this.xTiles = 0;
            this.yTiles = 0;
            this.imageSequence = null;
            this.newFileType = false;
        }
    }

    public void setTruncatedFileFlag(boolean truncatedFileFlag) {
        FormatTools.assertId(this.currentId, false, 1);
        this.truncatedFileFlag = truncatedFileFlag;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (!DeltavisionReader.checkSuffix(id, "dv")) {
            if (DeltavisionReader.checkSuffix(id, "dv.log") || DeltavisionReader.checkSuffix(id, "r3d.log")) {
                id = id.substring(0, id.lastIndexOf("."));
            } else if (id.endsWith("_log.txt")) {
                id = id.substring(0, id.lastIndexOf("_")) + ".dv";
            }
            Location file2 = new Location(id).getAbsoluteFile();
            if (!file2.exists()) {
                Location dir = file2.getParentFile();
                String[] list = dir.list(true);
                String name = file2.getName();
                name = name.substring(0, name.lastIndexOf("."));
                for (String f : list) {
                    if (!DeltavisionReader.checkSuffix(f, "dv") || !f.startsWith(name)) continue;
                    id = new Location(dir, f).getAbsolutePath();
                    break;
                }
            }
        }
        super.initFile(id);
        this.findLogFiles();
        if (this.in != null) {
            this.in.close();
        }
        this.in = new RandomAccessInputStream(this.currentId);
        this.initPixels();
        MetadataLevel metadataLevel = this.metadataOptions.getMetadataLevel();
        if (metadataLevel != MetadataLevel.MINIMUM) {
            this.initExtraMetadata();
        }
    }

    protected void initPixels() throws FormatException, IOException {
        LOGGER.info("Reading header");
        MetadataStore store = this.makeFilterMetadata();
        this.in.seek(96L);
        this.in.order(true);
        boolean little = this.in.readShort() == -16224;
        this.in.order(little);
        this.in.seek(0L);
        int sizeX = this.in.readInt();
        int sizeY = this.in.readInt();
        int imageCount = this.in.readInt();
        int filePixelType = this.in.readInt();
        this.in.seek(160L);
        short fileType = this.in.readShort();
        this.in.seek(180L);
        int rawSizeT = this.in.readUnsignedShort();
        int numPanels = 0;
        if (fileType == 100) {
            this.in.seek(852L);
            int secondaryT = this.in.readInt();
            if (secondaryT > 0 && (rawSizeT <= 0 || rawSizeT == 65535)) {
                rawSizeT = secondaryT;
            }
            this.in.seek(880L);
            numPanels = this.in.readInt();
            this.in.seek(182L);
        }
        int sizeT = rawSizeT == 0 ? 1 : rawSizeT;
        short sequence = this.in.readShort();
        this.in.seek(92L);
        this.extSize = this.in.readInt();
        this.in.seek(196L);
        short rawSizeC = this.in.readShort();
        short sizeC = rawSizeC == 0 ? (short)1 : rawSizeC;
        this.imageSequence = this.getImageSequence(sequence);
        int sizeZ = imageCount / (sizeC * sizeT);
        LOGGER.info("Populating core metadata");
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.littleEndian = little;
        m3.sizeX = sizeX;
        m3.sizeY = sizeY;
        m3.imageCount = imageCount;
        if (numPanels > 0) {
            sizeZ /= numPanels;
            m3.imageCount /= numPanels;
        }
        String pixel = this.getPixelString(filePixelType);
        m3.pixelType = this.getPixelType(filePixelType);
        m3.dimensionOrder = "XY" + this.imageSequence.replaceAll("W", "C").replaceAll("P", "");
        int planeSize = this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType());
        int realPlaneCount = (int)((this.in.length() - 1024L - (long)this.extSize) / (long)planeSize);
        if (realPlaneCount < this.getImageCount() && !this.truncatedFileFlag) {
            LOGGER.debug("Truncated file");
            m3.imageCount = realPlaneCount;
            if (sizeZ == 1) {
                sizeT = realPlaneCount / sizeC;
            } else if (sizeT == 1) {
                sizeZ = realPlaneCount / sizeC;
                if (realPlaneCount % sizeC != 0) {
                    m3.imageCount = ++sizeZ * sizeC;
                }
            } else if (this.getDimensionOrder().indexOf(90) < this.getDimensionOrder().indexOf(84)) {
                sizeZ = realPlaneCount / (sizeC * sizeT);
                if (sizeZ == 0) {
                    sizeT = 1;
                    sizeZ = realPlaneCount / sizeC;
                    if (realPlaneCount % sizeC != 0) {
                        m3.imageCount = ++sizeZ * sizeC;
                    }
                }
                if (this.getImageCount() > sizeZ * sizeC * sizeT) {
                    m3.imageCount = imageCount;
                    sizeC = rawSizeC == 0 ? (short)1 : rawSizeC;
                    sizeT = rawSizeT == 0 ? 1 : rawSizeT;
                    sizeZ = this.getImageCount() / (sizeC * sizeT);
                }
            } else {
                sizeT = realPlaneCount / (sizeC * sizeZ);
            }
        }
        m3.sizeT = sizeT;
        m3.sizeC = sizeC;
        m3.sizeZ = sizeZ;
        m3.rgb = false;
        m3.interleaved = false;
        m3.metadataComplete = true;
        m3.indexed = false;
        m3.falseColor = false;
        this.in.seek(128L);
        this.numIntsPerSection = this.in.readShort();
        this.numFloatsPerSection = this.in.readShort();
        LOGGER.info("Reading extended header");
        this.setOffsetInfo(this.getSizeZ(), this.getSizeC(), this.getSizeT(), numPanels == 0 ? 1 : numPanels);
        this.extHdrFields = new DVExtHdrFields[imageCount];
        this.ndFilters = new Double[this.getSizeC()];
        ArrayList<Length> uniqueTileX = new ArrayList<Length>();
        ArrayList<Length> uniqueTileY = new ArrayList<Length>();
        int offset = 1024 + this.numIntsPerSection * 4;
        boolean hasZeroX = false;
        boolean hasZeroY = false;
        for (int i = 0; i < imageCount; ++i) {
            DVExtHdrFields hdr;
            this.in.seek(offset + this.getTotalPlaneHeaderSize() * i);
            this.extHdrFields[i] = hdr = new DVExtHdrFields(this.in);
            if (!uniqueTileX.contains(hdr.stageXCoord) && hdr.stageXCoord.value().floatValue() != 0.0f) {
                uniqueTileX.add(hdr.stageXCoord);
            } else if (hdr.stageXCoord.value().floatValue() == 0.0f) {
                hasZeroX = true;
            }
            if (!uniqueTileY.contains(hdr.stageYCoord) && hdr.stageYCoord.value().floatValue() != 0.0f) {
                uniqueTileY.add(hdr.stageYCoord);
                continue;
            }
            if (hdr.stageYCoord.value().floatValue() != 0.0f) continue;
            hasZeroY = true;
        }
        this.xTiles = uniqueTileX.size();
        this.yTiles = uniqueTileY.size();
        if (this.xTiles > 1 || this.yTiles > 1) {
            if (hasZeroX) {
                ++this.xTiles;
            }
            if (hasZeroY) {
                ++this.yTiles;
            }
        }
        if (this.xTiles > 1) {
            Number x0 = ((Length)uniqueTileX.get(0)).value(UNITS.REFERENCEFRAME);
            Number x1 = ((Length)uniqueTileX.get(1)).value(UNITS.REFERENCEFRAME);
            if (x1.floatValue() < x0.floatValue()) {
                this.backwardsStageX = true;
            }
        }
        if (this.yTiles > 1) {
            Number y0 = ((Length)uniqueTileY.get(0)).value(UNITS.REFERENCEFRAME);
            Number y1 = ((Length)uniqueTileY.get(1)).value(UNITS.REFERENCEFRAME);
            if (y1.floatValue() < y0.floatValue()) {
                this.backwardsStageY = true;
            }
        }
        int nStagePositions = this.xTiles * this.yTiles;
        if (this.positionInT && this.xTiles * this.yTiles != (nStagePositions = this.getSizeT())) {
            this.xTiles = nStagePositions;
            this.yTiles = 1;
            this.backwardsStageX = false;
            this.backwardsStageY = false;
        }
        if ((fileType != 100 || numPanels == 0) && nStagePositions > 0 && nStagePositions <= this.getSizeT()) {
            int t = this.getSizeT();
            m3.sizeT /= nStagePositions;
            if (this.getSizeT() * nStagePositions != t) {
                m3.sizeT = t;
                nStagePositions = 1;
            } else {
                m3.imageCount /= nStagePositions;
            }
        } else {
            this.newFileType = true;
            int n = nStagePositions = numPanels == 0 ? 1 : numPanels;
        }
        if (nStagePositions > 1) {
            CoreMetadata originalCore = (CoreMetadata)this.core.get(0);
            this.core.clear();
            for (int i = 0; i < nStagePositions; ++i) {
                this.core.add(new CoreMetadata(originalCore));
            }
        }
        this.lengths = new int[4];
        int lengthIndex = 0;
        int dimIndex = 0;
        while (lengthIndex < this.lengths.length) {
            char dim = this.imageSequence.charAt(dimIndex++);
            switch (dim) {
                case 'Z': {
                    this.lengths[lengthIndex++] = this.getSizeZ();
                    break;
                }
                case 'W': {
                    this.lengths[lengthIndex++] = this.getSizeC();
                    break;
                }
                case 'T': {
                    if (!this.newFileType) {
                        this.lengths[lengthIndex++] = this.getSeriesCount();
                    }
                    this.lengths[lengthIndex++] = this.getSizeT();
                    break;
                }
                case 'P': {
                    if (!this.newFileType) break;
                    this.lengths[lengthIndex++] = this.getSeriesCount();
                }
            }
        }
        LOGGER.info("Populating original metadata");
        this.addGlobalMeta("ImageWidth", sizeX);
        this.addGlobalMeta("ImageHeight", sizeY);
        this.addGlobalMeta("NumberOfImages", imageCount);
        this.addGlobalMeta("PixelType", pixel);
        this.addGlobalMeta("Number of timepoints", rawSizeT);
        this.addGlobalMeta("Number of panels", numPanels);
        this.addGlobalMeta("Image sequence", this.imageSequence);
        this.addGlobalMeta("Number of wavelengths", (int)rawSizeC);
        this.addGlobalMeta("Number of focal planes", sizeZ);
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            this.setSeries(series);
            for (int plane = 0; plane < this.getImageCount(); ++plane) {
                int[] coords = this.getZCTCoords(plane);
                DVExtHdrFields hdr = this.extHdrFields[this.getPlaneIndex(series, plane)];
                String prefix = "Extended header Z" + coords[0] + " W" + coords[1] + " T" + coords[2];
                for (Map.Entry<String, Object> entry : hdr.asMap().entrySet()) {
                    this.addSeriesMeta(prefix + ":" + entry.getKey(), entry.getValue());
                }
                this.addGlobalMetaList("X position for position", hdr.stageXCoord);
                this.addGlobalMetaList("Y position for position", hdr.stageYCoord);
                this.addGlobalMetaList("Z position for position", hdr.stageZCoord);
            }
        }
        this.setSeries(0);
        LOGGER.info("Populating OME metadata");
        MetadataTools.populatePixels(store, this, true);
        String instrumentID = MetadataTools.createLSID("Instrument", 0);
        store.setInstrumentID(instrumentID, 0);
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageInstrumentRef(instrumentID, i);
        }
    }

    protected void initExtraMetadata() throws FormatException, IOException {
        int series;
        boolean logFound;
        MetadataStore store = this.makeFilterMetadata();
        LOGGER.info("Reading header");
        this.in.seek(16L);
        int subImageStartX = this.in.readInt();
        int subImageStartY = this.in.readInt();
        int subImageStartZ = this.in.readInt();
        int pixelSamplingX = this.in.readInt();
        int pixelSamplingY = this.in.readInt();
        int pixelSamplingZ = this.in.readInt();
        float pixX = this.in.readFloat();
        float pixY = this.in.readFloat();
        float pixZ = this.in.readFloat();
        float xAxisAngle = this.in.readFloat();
        float yAxisAngle = this.in.readFloat();
        float zAxisAngle = this.in.readFloat();
        int xAxisSeq = this.in.readInt();
        int yAxisSeq = this.in.readInt();
        int zAxisSeq = this.in.readInt();
        float[] minWave = new float[12];
        float[] maxWave = new float[12];
        minWave[0] = this.in.readFloat();
        maxWave[0] = this.in.readFloat();
        float meanIntensity = this.in.readFloat();
        int spaceGroupNumber = this.in.readInt();
        this.in.seek(132L);
        short numSubResSets = this.in.readShort();
        short zAxisReductionQuotient = this.in.readShort();
        for (int i = 1; i <= 3; ++i) {
            minWave[i] = this.in.readFloat();
            maxWave[i] = this.in.readFloat();
        }
        short fileType = this.in.readShort();
        short lensID = this.in.readShort();
        this.in.seek(172L);
        minWave[4] = this.in.readFloat();
        maxWave[4] = this.in.readFloat();
        this.in.seek(184L);
        float xTiltAngle = this.in.readFloat();
        float yTiltAngle = this.in.readFloat();
        float zTiltAngle = this.in.readFloat();
        this.in.skipBytes(2);
        short[] waves = new short[12];
        for (int i = 0; i < 5; ++i) {
            waves[i] = this.in.readShort();
        }
        float xOrigin = this.in.readFloat();
        float yOrigin = this.in.readFloat();
        float zOrigin = this.in.readFloat();
        this.in.skipBytes(2);
        short numTitles = this.in.readShort();
        int titleCount = fileType < 100 ? 10 : 4;
        String[] title = new String[titleCount];
        for (int i = 0; i < title.length; ++i) {
            title[i] = this.in.readByteToString(80).replaceAll("\u0000", "");
        }
        String timestamp = null;
        if (fileType == 100) {
            int i;
            for (i = 5; i < 12; ++i) {
                minWave[i] = this.in.readFloat();
            }
            this.in.skipBytes(16);
            for (i = 5; i < 12; ++i) {
                maxWave[i] = this.in.readFloat();
            }
            this.in.skipBytes(16);
            this.in.skipBytes(28);
            this.in.skipBytes(16);
            for (i = 5; i < 12; ++i) {
                waves[i] = this.in.readShort();
            }
            this.in.seek(844L);
            long acqDate = (long)(this.in.readDouble() * 1000.0);
            if (acqDate > 0L) {
                timestamp = DateTools.convertDate(acqDate, 0);
            }
        }
        String imageType = fileType < IMAGE_TYPES.length ? IMAGE_TYPES[fileType] : "unknown";
        String imageDesc = title[0];
        if (imageDesc != null && imageDesc.length() == 0) {
            imageDesc = null;
        }
        LOGGER.info("Populating original metadata");
        this.addGlobalMeta("Sub-image starting point (X)", subImageStartX);
        this.addGlobalMeta("Sub-image starting point (Y)", subImageStartY);
        this.addGlobalMeta("Sub-image starting point (Z)", subImageStartZ);
        this.addGlobalMeta("Pixel sampling size (X)", pixelSamplingX);
        this.addGlobalMeta("Pixel sampling size (Y)", pixelSamplingY);
        this.addGlobalMeta("Pixel sampling size (Z)", pixelSamplingZ);
        this.addGlobalMeta("X element length (in um)", pixX);
        this.addGlobalMeta("Y element length (in um)", pixY);
        this.addGlobalMeta("Z element length (in um)", pixZ);
        this.addGlobalMeta("X axis angle", xAxisAngle);
        this.addGlobalMeta("Y axis angle", yAxisAngle);
        this.addGlobalMeta("Z axis angle", zAxisAngle);
        this.addGlobalMeta("Column axis sequence", xAxisSeq);
        this.addGlobalMeta("Row axis sequence", yAxisSeq);
        this.addGlobalMeta("Section axis sequence", zAxisSeq);
        this.addGlobalMeta("Image Type", imageType);
        this.addGlobalMeta("Lens ID Number", (int)lensID);
        this.addGlobalMeta("X axis tilt angle", xTiltAngle);
        this.addGlobalMeta("Y axis tilt angle", yTiltAngle);
        this.addGlobalMeta("Z axis tilt angle", zTiltAngle);
        for (int i = 0; i < waves.length; ++i) {
            this.addGlobalMeta("Wavelength " + (i + 1) + " (in nm)", waves[i]);
        }
        this.addGlobalMeta("X origin (in um)", xOrigin);
        this.addGlobalMeta("Y origin (in um)", yOrigin);
        this.addGlobalMeta("Z origin (in um)", zOrigin);
        this.addGlobalMeta("Valid titles", (int)numTitles);
        for (String t : title) {
            this.addGlobalMetaList("Title", t);
        }
        for (int i = 0; i < minWave.length; ++i) {
            this.addGlobalMeta("Wavelength " + (i + 1) + " min. intensity", minWave[i]);
            this.addGlobalMeta("Wavelength " + (i + 1) + " max. intensity", maxWave[i]);
        }
        this.addGlobalMeta("Wavelength 1 mean intensity", meanIntensity);
        this.addGlobalMeta("Space group number", spaceGroupNumber);
        this.addGlobalMeta("Number of Sub-resolution sets", numSubResSets);
        this.addGlobalMeta("Z axis reduction quotient", zAxisReductionQuotient);
        LOGGER.info("Populating OME metadata");
        for (int series2 = 0; series2 < this.getSeriesCount(); ++series2) {
            Double z;
            Length sizeZ;
            Double y;
            Length sizeY;
            Double x;
            Length sizeX;
            if (store instanceof IMinMaxStore) {
                IMinMaxStore minMaxStore = (IMinMaxStore)((Object)store);
                for (int i = 0; i < minWave.length; ++i) {
                    if (i >= this.getEffectiveSizeC()) continue;
                    minMaxStore.setChannelGlobalMinMax(i, minWave[i], maxWave[i], series2);
                }
            }
            if ((sizeX = FormatTools.getPhysicalSizeX(x = new Double(pixX))) != null) {
                store.setPixelsPhysicalSizeX(sizeX, series2);
            }
            if ((sizeY = FormatTools.getPhysicalSizeY(y = new Double(pixY))) != null) {
                store.setPixelsPhysicalSizeY(sizeY, series2);
            }
            if ((sizeZ = FormatTools.getPhysicalSizeZ(z = new Double(pixZ))) != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, series2);
            }
            store.setImageDescription(imageDesc, series2);
        }
        this.populateObjective(store, lensID);
        boolean bl = logFound = this.isGroupFiles() ? this.parseLogFile(store) : false;
        if (this.isGroupFiles() && this.deconvolutionLogFile != null && new Location(this.deconvolutionLogFile).exists()) {
            try (RandomAccessInputStream s2 = new RandomAccessInputStream(this.deconvolutionLogFile);){
                this.parseDeconvolutionLog(s2, store);
            }
        }
        if (timestamp != null) {
            for (series = 0; series < this.getSeriesCount(); ++series) {
                store.setImageAcquisitionDate(new Timestamp(timestamp), series);
            }
        }
        if (this.xTiles * this.yTiles > this.getSeriesCount()) {
            if (this.xTiles == this.getSeriesCount()) {
                this.yTiles = 1;
            } else if (this.yTiles == this.getSeriesCount()) {
                this.xTiles = 1;
            } else {
                this.xTiles = 1;
                this.yTiles = 1;
            }
        }
        if (this.getSeriesCount() == 1) {
            this.xTiles = 1;
            this.yTiles = 1;
            this.backwardsStageX = false;
            this.backwardsStageY = false;
        }
        for (series = 0; series < this.getSeriesCount(); ++series) {
            int seriesIndex = series;
            if (this.backwardsStageX || this.backwardsStageY) {
                int x = series % this.xTiles;
                int y = series / this.xTiles;
                int xIndex = this.backwardsStageX ? this.xTiles - x - 1 : x;
                int yIndex = this.backwardsStageY ? this.yTiles - y - 1 : y;
                seriesIndex = yIndex * this.xTiles + xIndex;
            }
            Double[] expTime = new Double[this.getSizeC()];
            for (int i = 0; i < this.getImageCount(); ++i) {
                int[] coords = this.getZCTCoords(i);
                DVExtHdrFields hdr = this.extHdrFields[this.getPlaneIndex(seriesIndex, i)];
                if (expTime[coords[1]] == null) {
                    expTime[coords[1]] = new Double(hdr.expTime);
                }
                store.setPlaneDeltaT(new Time(new Double(hdr.timeStampSeconds), UNITS.SECOND), series, i);
                store.setPlaneExposureTime(new Time(expTime[coords[1]], UNITS.SECOND), series, i);
                if (!logFound || this.getSeriesCount() > 1) {
                    store.setPlanePositionX(hdr.stageXCoord, series, i);
                    store.setPlanePositionY(hdr.stageYCoord, series, i);
                    store.setPlanePositionZ(hdr.stageZCoord, series, i);
                }
                if (coords[0] != 0 || coords[2] != 0) continue;
                int w = coords[1];
                Length emission = FormatTools.getEmissionWavelength(new Double(waves[w]));
                Length excitation = FormatTools.getExcitationWavelength(new Double(hdr.exWavelen));
                if (emission != null) {
                    store.setChannelEmissionWavelength(emission, series, w);
                }
                if (excitation != null) {
                    store.setChannelExcitationWavelength(excitation, series, w);
                }
                if (this.ndFilters[w] == null) {
                    this.ndFilters[w] = new Double(hdr.ndFilter);
                }
                store.setChannelNDFilter(this.ndFilters[w], series, w);
            }
        }
    }

    private String getPixelString(int filePixelType) {
        switch (filePixelType) {
            case 0: {
                return "8 bit unsigned integer";
            }
            case 1: {
                return "16 bit signed integer";
            }
            case 2: {
                return "32 bit floating point";
            }
            case 3: {
                return "16 bit complex";
            }
            case 4: {
                return "64 bit complex";
            }
            case 6: {
                return "16 bit unsigned integer";
            }
        }
        return "unknown";
    }

    private int getPixelType(int filePixelType) {
        switch (filePixelType) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 7;
            }
        }
        return 1;
    }

    private String getImageSequence(int imageSequence) {
        switch (imageSequence) {
            case 0: {
                return "ZTWP";
            }
            case 1: {
                return "WZTP";
            }
            case 2: {
                return "ZWTP";
            }
            case 3: {
                return "ZPWT";
            }
            case 4: {
                return "ZWPT";
            }
            case 5: {
                return "WZPT";
            }
            case 6: {
                return "WPTZ";
            }
            case 7: {
                return "PWTZ";
            }
            case 8: {
                return "PTWZ";
            }
            case 9: {
                return "PZWT";
            }
            case 10: {
                return "PWZT";
            }
            case 11: {
                return "WPZT";
            }
            case 12: {
                return "WTPZ";
            }
            case 13: {
                return "TWPZ";
            }
            case 14: {
                return "TPWZ";
            }
            case 65536: {
                return "WZTP";
            }
        }
        return "ZTWP";
    }

    private void setOffsetInfo(int numZSections, int numWaves, int numTimes, int numPanels) {
        int smallOffset = this.getTotalPlaneHeaderSize();
        int[] lens = new int[4];
        int zIndex = this.imageSequence.indexOf(90);
        int wIndex = this.imageSequence.indexOf(87);
        int tIndex = this.imageSequence.indexOf(84);
        int pIndex = this.imageSequence.indexOf(80);
        lens[zIndex] = numZSections;
        lens[wIndex] = numWaves;
        lens[tIndex] = numTimes;
        lens[pIndex] = numPanels;
        int[] sizes = new int[4];
        sizes[0] = smallOffset;
        for (int i = 1; i < sizes.length; ++i) {
            sizes[i] = sizes[i - 1] * lens[i - 1];
        }
        this.zSize = sizes[zIndex];
        this.wSize = sizes[wIndex];
        this.tSize = sizes[tIndex];
        this.panelSize = sizes[pIndex];
    }

    private int getTotalPlaneHeaderSize() {
        return (this.numIntsPerSection + this.numFloatsPerSection) * 4;
    }

    private int getPlaneIndex(int series, int plane) {
        int zIndex = this.imageSequence.indexOf(90);
        int wIndex = this.imageSequence.indexOf(87);
        int tIndex = this.imageSequence.indexOf(84);
        int pIndex = this.imageSequence.indexOf(80);
        int[] lens = new int[4];
        lens[zIndex] = this.getSizeZ();
        lens[wIndex] = this.getSizeC();
        lens[tIndex] = this.getSizeT();
        lens[pIndex] = this.getSeriesCount();
        int[] coords = this.getZCTCoords(plane);
        int[] realCoords = new int[4];
        realCoords[zIndex] = coords[0];
        realCoords[wIndex] = coords[1];
        realCoords[tIndex] = coords[2];
        realCoords[pIndex] = series;
        return FormatTools.positionToRaster(lens, realCoords);
    }

    public long getPlaneByteOffset(int currentZ, int currentW, int currentT) {
        FormatTools.assertId(this.currentId, true, 1);
        int[] newCoords = new int[4];
        int coordIndex = 0;
        int dimIndex = 2;
        String order = this.getDimensionOrder();
        int index = this.imageSequence.indexOf("P") + 2;
        String start = order.substring(0, index);
        String end = "";
        if (index < order.length()) {
            end = order.substring(index);
        }
        order = start + "P" + end;
        while (coordIndex < newCoords.length) {
            char dim = order.charAt(dimIndex++);
            switch (dim) {
                case 'Z': {
                    newCoords[coordIndex++] = currentZ;
                    break;
                }
                case 'C': {
                    newCoords[coordIndex++] = currentW;
                    break;
                }
                case 'T': {
                    if (!this.newFileType) {
                        newCoords[coordIndex++] = this.getSeries();
                    }
                    newCoords[coordIndex++] = currentT;
                    break;
                }
                case 'P': {
                    if (!this.newFileType) break;
                    newCoords[coordIndex++] = this.getSeries();
                }
            }
        }
        int planeIndex = FormatTools.positionToRaster(this.lengths, newCoords);
        long planeSize = FormatTools.getPlaneSize(this);
        long planeOffset = planeSize * (long)planeIndex;
        long offset = planeOffset + 1024L + (long)this.extSize;
        return offset;
    }

    private void findLogFiles() throws IOException {
        if (this.getCurrentFile().lastIndexOf(".") == -1) {
            this.logFile = null;
            this.deconvolutionLogFile = null;
            return;
        }
        if (this.getCurrentFile().endsWith("_D3D.dv")) {
            this.logFile = this.getCurrentFile();
            this.logFile = this.logFile.substring(0, this.logFile.indexOf("_D3D.dv")) + ".dv.log";
        } else {
            this.logFile = this.getCurrentFile() + ".log";
            if (!new Location(this.logFile).exists()) {
                this.logFile = this.getCurrentFile();
                this.logFile = this.logFile.substring(0, this.logFile.lastIndexOf(".")) + ".log";
            }
        }
        if (!new Location(this.logFile).exists()) {
            this.logFile = null;
        }
        int dot = this.getCurrentFile().lastIndexOf(".");
        String base = this.getCurrentFile().substring(0, dot);
        this.deconvolutionLogFile = base + "_log.txt";
        if (!new Location(this.deconvolutionLogFile).exists()) {
            this.deconvolutionLogFile = null;
        }
    }

    private boolean parseLogFile(MetadataStore store) throws FormatException, IOException {
        if (this.logFile == null || !new Location(this.logFile).exists()) {
            this.logFile = null;
            return false;
        }
        LOGGER.info("Parsing log file");
        String[] lines = DataTools.readFile(this.logFile).split("[\r\n]");
        String value = "";
        String prefix = "";
        int currentImage = 0;
        ArrayList<String> channelNames = new ArrayList<String>();
        ArrayList<Double> filters = new ArrayList<Double>();
        for (String line : lines) {
            int series;
            String key;
            int colon = line.indexOf(58);
            if (colon >= 0 && colon < line.length() - 1 && !line.startsWith("Created")) {
                key = line.substring(0, colon).trim();
                value = line.substring(colon + 1).trim();
                if (value.equals("") && !key.equals("")) {
                    prefix = key;
                }
                this.addGlobalMeta(prefix + " " + key, value);
                if (key.equals("Objective")) {
                    int space = value.indexOf(32);
                    if (space == -1) continue;
                    String manufacturer = value.substring(0, space);
                    String extra = value.substring(space + 1);
                    String[] tokens = extra.split(",");
                    store.setObjectiveManufacturer(manufacturer, 0, 0);
                    String magnification = "";
                    String na = "";
                    if (tokens.length >= 1) {
                        int start;
                        int end = tokens[0].indexOf(88);
                        if (end > 0) {
                            magnification = tokens[0].substring(0, end);
                        }
                        if ((start = tokens[0].indexOf(47)) >= 0) {
                            na = tokens[0].substring(start + 1);
                        }
                    }
                    try {
                        Double mag = new Double(magnification);
                        store.setObjectiveNominalMagnification(mag, 0, 0);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse magnification '{}'", (Object)magnification);
                    }
                    try {
                        store.setObjectiveLensNA(new Double(na), 0, 0);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse N.A. '{}'", (Object)na);
                    }
                    if (tokens.length >= 2) {
                        store.setObjectiveCorrection(MetadataTools.getCorrection(tokens[1]), 0, 0);
                    }
                    if (tokens.length <= 3) continue;
                    store.setObjectiveModel(tokens[3], 0, 0);
                    continue;
                }
                if (key.equalsIgnoreCase("Lens ID")) {
                    if (value.indexOf(44) != -1) {
                        value = value.substring(0, value.indexOf(44));
                    }
                    if (value.indexOf(32) != -1) {
                        value = value.substring(value.indexOf(32) + 1);
                    }
                    if (value.equals("null")) continue;
                    String objectiveID = "Objective:" + value;
                    store.setObjectiveID(objectiveID, 0, 0);
                    for (series = 0; series < this.getSeriesCount(); ++series) {
                        store.setObjectiveSettingsID(objectiveID, series);
                    }
                    store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
                    store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
                    continue;
                }
                if (key.equals("Pixel Size")) {
                    String[] pixelSizes = value.split(" ");
                    for (int q = 0; q < pixelSizes.length; ++q) {
                        Length sizeZ;
                        Length sizeY;
                        int series2;
                        Length sizeX;
                        Double size = null;
                        try {
                            size = new Double(pixelSizes[q].trim());
                        }
                        catch (NumberFormatException e) {
                            LOGGER.warn("Could not parse pixel size '{}'", (Object)pixelSizes[q].trim());
                        }
                        if (q == 0 && (sizeX = FormatTools.getPhysicalSizeX(size)) != null) {
                            for (series2 = 0; series2 < this.getSeriesCount(); ++series2) {
                                store.setPixelsPhysicalSizeX(sizeX, series2);
                            }
                        }
                        if (q == 1 && (sizeY = FormatTools.getPhysicalSizeY(size)) != null) {
                            for (series2 = 0; series2 < this.getSeriesCount(); ++series2) {
                                store.setPixelsPhysicalSizeY(sizeY, series2);
                            }
                        }
                        if (q != 2 || (sizeZ = FormatTools.getPhysicalSizeZ(size)) == null) continue;
                        for (series2 = 0; series2 < this.getSeriesCount(); ++series2) {
                            store.setPixelsPhysicalSizeZ(sizeZ, series2);
                        }
                    }
                    continue;
                }
                if (key.equals("Binning")) {
                    store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, 0);
                    String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                    store.setDetectorID(detectorID, 0, 0);
                    for (series = 0; series < this.getSeriesCount(); ++series) {
                        for (int c = 0; c < this.getSizeC(); ++c) {
                            store.setDetectorSettingsBinning(MetadataTools.getBinning(value), series, c);
                            store.setDetectorSettingsID(detectorID, series, c);
                        }
                    }
                    continue;
                }
                if (key.equals("Type")) {
                    store.setDetectorModel(value, 0, 0);
                    continue;
                }
                if (key.equals("Gain")) {
                    value = value.replaceAll("X", "");
                    try {
                        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                        store.setDetectorID(detectorID, 0, 0);
                        for (series = 0; series < this.getSeriesCount(); ++series) {
                            for (int c = 0; c < this.getSizeC(); ++c) {
                                store.setDetectorSettingsGain(new Double(value), series, c);
                                store.setDetectorSettingsID(detectorID, series, c);
                            }
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse gain '{}'", (Object)value);
                        continue;
                    }
                }
                if (key.equals("Speed")) {
                    value = value.replaceAll("KHz", "");
                    try {
                        double khz = Double.parseDouble(value);
                        String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                        store.setDetectorID(detectorID, 0, 0);
                        for (int series3 = 0; series3 < this.getSeriesCount(); ++series3) {
                            for (int c = 0; c < this.getSizeC(); ++c) {
                                store.setDetectorSettingsReadOutRate(new Frequency(khz, UNITS.KILOHERTZ), series3, c);
                                store.setDetectorSettingsID(detectorID, series3, c);
                            }
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse read-out rate '{}'", (Object)value);
                        continue;
                    }
                }
                if (key.equals("Temp Setting")) {
                    value = value.replaceAll("C", "").trim();
                    continue;
                }
                if (key.equals("EM filter")) {
                    if (channelNames.contains(value)) continue;
                    channelNames.add(value);
                    continue;
                }
                if (key.equals("ND filter")) {
                    value = value.replaceAll("%", "");
                    try {
                        double nd = Double.parseDouble(value) / 100.0;
                        if (filters.contains(nd)) continue;
                        filters.add(nd);
                    }
                    catch (NumberFormatException exc) {
                        if (!value.equals("BLANK")) {
                            LOGGER.warn("Could not parse ND filter '{}'", (Object)value);
                        }
                        filters.add(null);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.debug("", e);
                    }
                    continue;
                }
                if (!key.equals("Stage coordinates")) continue;
                if (value.length() > 1) {
                    value = value.substring(1, value.length() - 1);
                }
                String[] coords = value.split(",");
                for (int i = 0; i < coords.length; ++i) {
                    Length p = null;
                    try {
                        Double number = Double.valueOf(coords[i]);
                        p = new Length(number, UNITS.REFERENCEFRAME);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse stage coordinate '{}'", (Object)coords[i]);
                    }
                    if (currentImage >= this.getImageCount() || this.getSeriesCount() != 1) continue;
                    if (i == 0) {
                        store.setPlanePositionX(p, 0, currentImage);
                    }
                    if (i == 1) {
                        store.setPlanePositionY(p, 0, currentImage);
                    }
                    if (i != 2) continue;
                    store.setPlanePositionZ(p, 0, currentImage);
                }
                ++currentImage;
                continue;
            }
            if (line.startsWith("Image")) {
                prefix = line;
                continue;
            }
            if (line.startsWith("Created")) {
                String date;
                if (line.length() > 8) {
                    line = line.substring(8).trim();
                }
                if ((date = DateTools.formatDate(line, DATE_FORMATS)) != null) {
                    for (series = 0; series < this.getSeriesCount(); ++series) {
                        store.setImageAcquisitionDate(new Timestamp(date), series);
                    }
                    continue;
                }
                LOGGER.warn("Could not parse date '{}'", (Object)line);
                continue;
            }
            if (line.startsWith("#KEY")) {
                int split = (line = line.substring(line.indexOf(" ")).trim()).indexOf(":");
                if (split < 0) {
                    split = line.indexOf(" ");
                }
                key = line.substring(0, split).trim();
                value = line.substring(split + 1).trim();
                this.addGlobalMeta(key, value);
                continue;
            }
            if (line.endsWith(":")) {
                prefix = line.substring(0, line.length() - 1);
                continue;
            }
            if (line.startsWith("#") || line.replace("-", "").isEmpty() || prefix.isEmpty()) continue;
            this.addGlobalMetaList(prefix, line);
        }
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (c < channelNames.size()) {
                    store.setChannelName((String)channelNames.get(c), series, c);
                }
                if (c >= filters.size()) continue;
                this.ndFilters[c] = (Double)filters.get(c);
            }
        }
        return true;
    }

    private void parseDeconvolutionLog(RandomAccessInputStream s2, MetadataStore store) throws IOException {
        LOGGER.info("Parsing deconvolution log file");
        boolean doStatistics = false;
        int cc = 0;
        int tt = 0;
        String previousLine = null;
        while (s2.getFilePointer() < s2.length() - 1L) {
            int index;
            String line = s2.readLine();
            if (line == null || line.length() == 0) continue;
            if (doStatistics) {
                String[] keys = line.split("  ");
                ArrayList<String> realKeys = new ArrayList<String>();
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = keys[i].trim();
                    if (keys[i].isEmpty()) continue;
                    realKeys.add(keys[i]);
                }
                keys = realKeys.toArray(new String[0]);
                s2.readLine();
                line = s2.readLine().trim();
                while (line != null && line.length() != 0) {
                    String[] values = line.split(" ");
                    ArrayList<String> realValues = new ArrayList<String>();
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].trim();
                        if (values[i].isEmpty()) continue;
                        realValues.add(values[i]);
                    }
                    values = realValues.toArray(new String[0]);
                    try {
                        if (values.length > 0) {
                            int zz = Integer.parseInt(values[0]) - 1;
                            int index2 = this.getIndex(zz, cc, tt);
                            for (int i = 1; i < keys.length; ++i) {
                                this.addGlobalMeta("Plane " + index2 + " " + keys[i], values[i]);
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse Z position '{}'", (Object)values[0]);
                    }
                    catch (IllegalArgumentException iae) {
                        LOGGER.debug("", iae);
                    }
                    line = s2.readLine().trim();
                }
            } else {
                int index3 = line.indexOf(".\t");
                if (index3 != -1) {
                    String key = line.substring(0, index3).trim();
                    String value = line.substring(index3 + 2).trim();
                    while (key.endsWith(".")) {
                        key = key.substring(0, key.length() - 1);
                    }
                    if (previousLine != null && (previousLine.endsWith("Deconvolution Results:") || previousLine.endsWith("open OTF"))) {
                        this.addGlobalMeta(previousLine + " " + key, value);
                    } else {
                        this.addGlobalMeta(key, value);
                    }
                }
            }
            if (line.indexOf("correcting time point\t") != -1 && (index = line.indexOf("time point\t") + 11) > 10) {
                String t = line.substring(index, line.indexOf(",", index));
                try {
                    tt = Integer.parseInt(t) - 1;
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Could not parse timepoint '{}'", (Object)t);
                }
                index = line.indexOf("wavelength\t") + 11;
                if (index > 10) {
                    String c = line.substring(index, line.indexOf(".", index));
                    try {
                        cc = Integer.parseInt(c) - 1;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.warn("Could not parse channel position '{}'", (Object)c);
                    }
                }
            }
            if (line.length() > 0 && line.indexOf(46) == -1) {
                previousLine = line;
            }
            doStatistics = line.endsWith("- reading image data...");
        }
    }

    private void readWavelength(int channel, MetadataStore store) throws FormatException, IOException {
        float min2 = this.in.readFloat();
        float max = this.in.readFloat();
        this.addGlobalMeta("Wavelength " + (channel + 1) + " min. intensity", min2);
        this.addGlobalMeta("Wavelength " + (channel + 1) + " max. intensity", max);
        if (store instanceof IMinMaxStore) {
            ((IMinMaxStore)((Object)store)).setChannelGlobalMinMax(channel, min2, max, 0);
        }
    }

    protected void populateObjective(MetadataStore store, int lensID) throws FormatException {
        Double lensNA = null;
        Double workingDistance = null;
        Immersion immersion = MetadataTools.getImmersion("Other");
        Correction correction = MetadataTools.getCorrection("Other");
        String manufacturer = null;
        String model = null;
        double magnification = 0.0;
        if (lensID >= 10000 && lensID <= 32000) {
            if (lensID < 12000) {
                manufacturer = "Olympus";
            } else if (lensID < 14000) {
                manufacturer = "Nikon";
            } else if (lensID < 16000) {
                manufacturer = "Zeiss";
            } else if (lensID < 18000) {
                manufacturer = "Leica";
            } else if (lensID < 20000) {
                manufacturer = "APLLC";
            }
            magnification = (double)(lensID % 1000 - lensID % 100) / 10.0;
            if (magnification == 0.0) {
                magnification = 100.0;
            }
        }
        switch (lensID) {
            case 2001: {
                lensNA = 1.15;
                immersion = MetadataTools.getImmersion("Water");
                break;
            }
            case 10100: {
                lensNA = 0.3;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LP134";
                correction = MetadataTools.getCorrection("Achromat");
                break;
            }
            case 10101: {
                lensNA = 0.4;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LB331";
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 10102: {
                lensNA = 0.3;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LP134";
                break;
            }
            case 10103: {
                lensNA = 0.13;
                magnification = 4.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LP124";
                break;
            }
            case 10104: {
                lensNA = 0.4;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LB331";
                correction = MetadataTools.getCorrection("UV");
                break;
            }
            case 10105: {
                lensNA = 0.4;
                magnification = 10.0;
                workingDistance = 3.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LP331";
                correction = MetadataTools.getCorrection("UV");
                break;
            }
            case 10106: {
                lensNA = 0.16;
                magnification = 4.0;
                workingDistance = 13.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB822";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10107: {
                lensNA = 0.4;
                magnification = 10.0;
                workingDistance = 3.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB823";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10108: {
                lensNA = 0.25;
                magnification = 10.0;
                workingDistance = 9.8;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UC243";
                correction = MetadataTools.getCorrection("Achromat");
                break;
            }
            case 10109: {
                lensNA = 0.3;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB532";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 10110: {
                lensNA = 0.13;
                magnification = 4.0;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 10111: {
                lensNA = 0.08;
                magnification = 2.0;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 10112: {
                lensNA = 0.13;
                magnification = 4.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB522";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 10113: {
                lensNA = 0.04;
                magnification = 1.25;
                workingDistance = 5.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB920";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10114: {
                lensNA = 0.08;
                magnification = 2.0;
                workingDistance = 6.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB921";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10115: {
                lensNA = 0.4;
                magnification = 10.0;
                workingDistance = 3.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-U2B823";
                break;
            }
            case 10116: {
                lensNA = 0.16;
                magnification = 4.0;
                workingDistance = 13.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-U2B822";
                break;
            }
            case 10117: {
                lensNA = 0.4;
                magnification = 10.0;
                workingDistance = 3.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-U2B824";
                break;
            }
            case 10200: {
                lensNA = 0.4;
                magnification = 20.0;
                workingDistance = 3.0;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("Achromat");
                break;
            }
            case 10201: {
                lensNA = 0.65;
                magnification = 20.0;
                workingDistance = 1.03;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LB343";
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 10202: {
                lensNA = 0.4;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LP146";
                break;
            }
            case 10203: {
                lensNA = 0.8;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-LB342";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10204: {
                lensNA = 0.7;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-LB341";
                correction = MetadataTools.getCorrection("UV");
                break;
            }
            case 10205: {
                lensNA = 0.75;
                magnification = 20.0;
                workingDistance = 0.55;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB765";
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 10206: {
                lensNA = 0.5;
                magnification = 20.0;
                workingDistance = 0.55;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UC525";
                break;
            }
            case 10207: {
                lensNA = 0.4;
                magnification = 20.0;
                workingDistance = 3.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UC145";
                correction = MetadataTools.getCorrection("Achromat");
                break;
            }
            case 10208: {
                lensNA = 0.5;
                magnification = 20.0;
                workingDistance = 0.55;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB525";
                break;
            }
            case 10209: {
                lensNA = 0.4;
                magnification = 20.0;
                workingDistance = 6.9;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UC345";
                break;
            }
            case 10210: {
                lensNA = 0.4;
                magnification = 20.0;
                workingDistance = 6.9;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB345";
                break;
            }
            case 10211: {
                lensNA = 0.75;
                magnification = 20.0;
                workingDistance = 0.65;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-U2B825";
                break;
            }
            case 10212: {
                lensNA = 0.45;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-U2C375";
                break;
            }
            case 10213: {
                lensNA = 0.5;
                magnification = 20.0;
                workingDistance = 2.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-U2C525";
                break;
            }
            case 10214: {
                lensNA = 0.75;
                magnification = 20.0;
                workingDistance = 0.55;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB765R";
                break;
            }
            case 10215: {
                lensNA = 0.45;
                magnification = 20.0;
                workingDistance = 6.6;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-U2B375";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 10400: {
                lensNA = 0.55;
                magnification = 40.0;
                workingDistance = 2.04;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("Achromat");
                break;
            }
            case 10401: {
                lensNA = 0.85;
                magnification = 40.0;
                workingDistance = 0.25;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 10402: {
                lensNA = 1.3;
                magnification = 40.0;
                workingDistance = 0.12;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-LB356";
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 10403: {
                lensNA = 1.35;
                magnification = 40.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB768";
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 10404: {
                lensNA = 0.85;
                magnification = 40.0;
                workingDistance = 0.2;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB827";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10405: {
                lensNA = 0.95;
                magnification = 40.0;
                workingDistance = 0.14;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB927";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10406: {
                lensNA = 1.0;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB828";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10407: {
                lensNA = 0.75;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB527";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 10408: {
                lensNA = 0.6;
                magnification = 40.0;
                workingDistance = 2.15;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB347";
                break;
            }
            case 10409: {
                lensNA = 0.6;
                magnification = 40.0;
                workingDistance = 2.15;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UC347";
                break;
            }
            case 10410: {
                lensNA = 1.15;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Water");
                model = "1-UB769";
                break;
            }
            case 10411: {
                lensNA = 0.75;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UC527";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 10412: {
                lensNA = 1.35;
                magnification = 40.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 10413: {
                lensNA = 1.15;
                magnification = 40.0;
                workingDistance = 0.26;
                immersion = MetadataTools.getImmersion("Water");
                model = "1-UB769R";
                break;
            }
            case 10414: {
                lensNA = 0.6;
                magnification = 40.0;
                workingDistance = 2.7;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-U2B377";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 10415: {
                lensNA = 1.35;
                magnification = 40.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B768";
                break;
            }
            case 10416: {
                lensNA = 1.3;
                magnification = 40.0;
                workingDistance = 0.2;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B530";
                break;
            }
            case 10000: {
                lensNA = 1.3;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-LB393";
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 10001: {
                lensNA = 1.3;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-LB392";
                correction = MetadataTools.getCorrection("UV");
                break;
            }
            case 10002: {
                lensNA = 1.4;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB935";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10003: {
                lensNA = 1.35;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB836";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10004: {
                lensNA = 1.3;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB535";
                break;
            }
            case 10005: {
                lensNA = 1.35;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10006: {
                lensNA = 1.4;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10007: {
                lensNA = 1.4;
                magnification = 100.0;
                workingDistance = 0.13;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B836";
                break;
            }
            case 10008: {
                lensNA = 1.3;
                magnification = 100.0;
                workingDistance = 0.2;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B5352";
                break;
            }
            case 10009: {
                lensNA = 1.3;
                magnification = 100.0;
                workingDistance = 0.2;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B5362";
                break;
            }
            case 10010: {
                lensNA = 1.45;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB617R";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10011: {
                lensNA = 1.49;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B725";
                break;
            }
            case 10012: {
                lensNA = 0.95;
                magnification = 100.0;
                workingDistance = 0.2;
                immersion = MetadataTools.getImmersion("Air");
                model = "XXXXXXXX";
                break;
            }
            case 11500: {
                lensNA = 1.45;
                magnification = 150.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B618";
                break;
            }
            case 10600: {
                lensNA = 1.4;
                magnification = 60.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Oil");
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 10601: {
                lensNA = 1.4;
                magnification = 60.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-LB751";
                correction = MetadataTools.getCorrection("UV");
                break;
            }
            case 10602: {
                lensNA = 1.4;
                magnification = 60.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB932";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10603: {
                lensNA = 1.2;
                magnification = 60.0;
                workingDistance = 0.25;
                immersion = MetadataTools.getImmersion("Water");
                model = "1-UB891";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10604: {
                lensNA = 1.2;
                magnification = 60.0;
                workingDistance = 0.25;
                immersion = MetadataTools.getImmersion("Water");
                break;
            }
            case 10605: {
                lensNA = 0.7;
                magnification = 60.0;
                workingDistance = 1.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UB351";
                break;
            }
            case 10606: {
                lensNA = 0.7;
                magnification = 60.0;
                workingDistance = 1.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "1-UC351";
                break;
            }
            case 10607: {
                lensNA = 1.4;
                magnification = 60.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UC932";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10608: {
                lensNA = 1.25;
                magnification = 60.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB532";
                break;
            }
            case 10609: {
                lensNA = 1.4;
                magnification = 60.0;
                workingDistance = 0.15;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-UB933";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10610: {
                lensNA = 1.4;
                magnification = 60.0;
                workingDistance = 0.15;
                immersion = MetadataTools.getImmersion("Oil");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10611: {
                lensNA = 1.2;
                magnification = 60.0;
                workingDistance = 0.25;
                immersion = MetadataTools.getImmersion("Water");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10612: {
                lensNA = 1.42;
                magnification = 60.0;
                workingDistance = 0.15;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B933";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10613: {
                lensNA = 1.45;
                magnification = 60.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B616";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 10614: {
                lensNA = 1.49;
                magnification = 60.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B617";
                break;
            }
            case 10615: {
                lensNA = 1.3;
                magnification = 60.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Other");
                break;
            }
            case 10616: {
                lensNA = 1.2;
                magnification = 60.0;
                workingDistance = 0.28;
                immersion = MetadataTools.getImmersion("Water");
                model = "1-U2B893S";
                break;
            }
            case 10617: {
                lensNA = 1.49;
                magnification = 60.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "1-U2B720";
                break;
            }
            case 12201: {
                lensNA = 0.75;
                magnification = 20.0;
                workingDistance = 1.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "93104";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12202: {
                lensNA = 0.75;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Multi");
                model = "93146";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12203: {
                lensNA = 0.45;
                magnification = 20.0;
                workingDistance = 7.4;
                immersion = MetadataTools.getImmersion("Air");
                model = "93150";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12204: {
                lensNA = 0.45;
                magnification = 20.0;
                workingDistance = 4.5;
                immersion = MetadataTools.getImmersion("Air");
                model = "MUE01200/92777";
                break;
            }
            case 12205: {
                lensNA = 0.5;
                magnification = 20.0;
                workingDistance = 2.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRH00200/93135";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12206: {
                lensNA = 0.45;
                magnification = 20.0;
                workingDistance = 7.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRH08230";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12207: {
                lensNA = 0.75;
                magnification = 20.0;
                workingDistance = 1.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRD00201, MRD00205";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12208: {
                lensNA = 0.75;
                magnification = 20.0;
                workingDistance = 1.0;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("SuperFluor");
                break;
            }
            case 12401: {
                lensNA = 1.3;
                magnification = 40.0;
                workingDistance = 0.16;
                immersion = MetadataTools.getImmersion("Oil");
                model = "85028";
                break;
            }
            case 12402: {
                lensNA = 1.3;
                magnification = 40.0;
                workingDistance = 0.22;
                immersion = MetadataTools.getImmersion("Oil");
                model = "85004";
                break;
            }
            case 12403: {
                lensNA = 0.75;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "140508";
                break;
            }
            case 12404: {
                lensNA = 1.3;
                magnification = 40.0;
                workingDistance = 0.22;
                immersion = MetadataTools.getImmersion("Oil");
                break;
            }
            case 12405: {
                lensNA = 0.95;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12406: {
                lensNA = 1.0;
                magnification = 40.0;
                workingDistance = 0.16;
                immersion = MetadataTools.getImmersion("Oil");
                break;
            }
            case 12407: {
                lensNA = 0.6;
                magnification = 40.0;
                workingDistance = 3.2;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12408: {
                lensNA = 0.6;
                magnification = 40.0;
                workingDistance = 2.7;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRH08430";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12409: {
                lensNA = 0.95;
                magnification = 40.0;
                workingDistance = 0.14;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRD00400";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12410: {
                lensNA = 0.65;
                magnification = 40.0;
                workingDistance = 0.48;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12411: {
                lensNA = 0.95;
                magnification = 40.0;
                workingDistance = 0.14;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRD00405";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12412: {
                lensNA = 0.9;
                magnification = 40.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRF00400";
                break;
            }
            case 12413: {
                lensNA = 0.75;
                magnification = 40.0;
                workingDistance = 0.66;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12600: {
                lensNA = 1.4;
                magnification = 60.0;
                workingDistance = 0.17;
                immersion = MetadataTools.getImmersion("Oil");
                model = "85020";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12601: {
                lensNA = 1.4;
                magnification = 60.0;
                workingDistance = 0.21;
                immersion = MetadataTools.getImmersion("Oil");
                model = "93108";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12602: {
                lensNA = 1.2;
                magnification = 60.0;
                workingDistance = 0.22;
                immersion = MetadataTools.getImmersion("Water");
                model = "93109";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12603: {
                lensNA = 0.95;
                magnification = 60.0;
                workingDistance = 0.15;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRD00600";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12604: {
                lensNA = 0.7;
                magnification = 60.0;
                workingDistance = 1.5;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRH08630";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12605: {
                lensNA = 0.95;
                magnification = 60.0;
                workingDistance = 0.15;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRD00605";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12606: {
                lensNA = 0.85;
                magnification = 60.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRH00602";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12000: {
                lensNA = 1.4;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "85025";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12001: {
                lensNA = 1.3;
                magnification = 100.0;
                workingDistance = 0.14;
                immersion = MetadataTools.getImmersion("Oil");
                model = "85005";
                break;
            }
            case 12002: {
                lensNA = 1.3;
                magnification = 100.0;
                workingDistance = 0.13;
                immersion = MetadataTools.getImmersion("Glycerol");
                model = "78821";
                correction = MetadataTools.getCorrection("UV");
                break;
            }
            case 12003: {
                lensNA = 1.4;
                magnification = 100.0;
                workingDistance = 0.13;
                immersion = MetadataTools.getImmersion("Oil");
                model = "93110";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12004: {
                lensNA = 1.3;
                magnification = 100.0;
                workingDistance = 0.2;
                immersion = MetadataTools.getImmersion("Oil");
                model = "93129";
                break;
            }
            case 12005: {
                lensNA = 0.9;
                magnification = 100.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRH00900";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12101: {
                lensNA = 0.1;
                magnification = 2.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "202294";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12102: {
                lensNA = 0.2;
                magnification = 4.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "108388";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12103: {
                lensNA = 0.2;
                magnification = 4.0;
                workingDistance = 15.7;
                immersion = MetadataTools.getImmersion("Air");
                model = "93102";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12104: {
                lensNA = 0.45;
                magnification = 10.0;
                workingDistance = 4.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "93103";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12105: {
                lensNA = 0.3;
                magnification = 10.0;
                workingDistance = 16.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "93134";
                correction = MetadataTools.getCorrection("PlanFluor");
                break;
            }
            case 12106: {
                lensNA = 0.5;
                magnification = 10.0;
                workingDistance = 1.2;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRF00100/93126";
                correction = MetadataTools.getCorrection("SuperFluor");
                break;
            }
            case 12107: {
                lensNA = 0.25;
                magnification = 10.0;
                workingDistance = 10.5;
                immersion = MetadataTools.getImmersion("Air");
                model = "93183";
                correction = MetadataTools.getCorrection("Achromat");
                break;
            }
            case 12108: {
                lensNA = 0.25;
                magnification = 10.0;
                workingDistance = 6.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "93161";
                correction = MetadataTools.getCorrection("Achromat");
                break;
            }
            case 12109: {
                lensNA = 0.1;
                magnification = 2.0;
                workingDistance = 8.5;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRD00020, MRD00025";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12110: {
                lensNA = 0.2;
                magnification = 4.0;
                workingDistance = 20.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRD00041, MRD00045";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 12111: {
                lensNA = 0.45;
                magnification = 10.0;
                workingDistance = 4.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRD00101, MRD00105";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14001: {
                lensNA = 1.4;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 07 08 (02)";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14002: {
                lensNA = 1.3;
                magnification = 100.0;
                workingDistance = 0.1;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 07 86";
                break;
            }
            case 14003: {
                lensNA = 1.4;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 07 80 (02)";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14004: {
                lensNA = 1.3;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "46 19 46 - 9903";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14005: {
                lensNA = 1.4;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 07 86 (02)";
                break;
            }
            case 14006: {
                lensNA = 1.3;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                break;
            }
            case 14601: {
                lensNA = 1.4;
                magnification = 63.0;
                workingDistance = 0.09;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 07 60 (03)";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14602: {
                lensNA = 1.4;
                magnification = 63.0;
                workingDistance = 0.09;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 07 62 (02)";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14603: {
                lensNA = 0.9;
                magnification = 63.0;
                immersion = MetadataTools.getImmersion("Water");
                model = "44 00 69";
                break;
            }
            case 14604: {
                lensNA = 1.2;
                magnification = 63.0;
                workingDistance = 0.09;
                immersion = MetadataTools.getImmersion("Water");
                model = "44 06 68";
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 14401: {
                lensNA = 1.3;
                magnification = 40.0;
                workingDistance = 0.14;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 02 55 (01)";
                correction = MetadataTools.getCorrection("Fluar");
                break;
            }
            case 14402: {
                lensNA = 1.0;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 07 51";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14403: {
                lensNA = 1.2;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Water");
                model = "44 00 52";
                correction = MetadataTools.getCorrection("Apo");
                break;
            }
            case 14404: {
                lensNA = 0.75;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 03 51";
                correction = MetadataTools.getCorrection("PlanNeofluar");
                break;
            }
            case 14405: {
                lensNA = 1.3;
                magnification = 40.0;
                workingDistance = 0.15;
                immersion = MetadataTools.getImmersion("Oil");
                model = "44 04 50";
                correction = MetadataTools.getCorrection("PlanNeofluar");
                break;
            }
            case 14406: {
                lensNA = 0.6;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 08 65";
                break;
            }
            case 14407: {
                lensNA = 1.3;
                magnification = 40.0;
                immersion = MetadataTools.getImmersion("Oil");
                correction = MetadataTools.getCorrection("PlanNeofluar");
                break;
            }
            case 14301: {
                lensNA = 0.8;
                magnification = 25.0;
                workingDistance = 0.8;
                immersion = MetadataTools.getImmersion("Multi");
                model = "44 05 44";
                correction = MetadataTools.getCorrection("PlanNeofluar");
                break;
            }
            case 14302: {
                lensNA = 0.8;
                magnification = 25.0;
                workingDistance = 0.8;
                immersion = MetadataTools.getImmersion("Multi");
                model = "44 05 42";
                correction = MetadataTools.getCorrection("PlanNeofluar");
                break;
            }
            case 14303: {
                lensNA = 0.8;
                magnification = 25.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 05 45";
                correction = MetadataTools.getCorrection("PlanNeofluar");
                break;
            }
            case 14201: {
                lensNA = 0.5;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 03 41 (01)";
                correction = MetadataTools.getCorrection("PlanNeofluar");
                break;
            }
            case 14202: {
                lensNA = 0.6;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 06 40";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14203: {
                lensNA = 0.75;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 06 49";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14204: {
                lensNA = 0.75;
                magnification = 20.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 01 45";
                correction = MetadataTools.getCorrection("Fluar");
                break;
            }
            case 14101: {
                lensNA = 0.3;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 03 30";
                correction = MetadataTools.getCorrection("PlanNeofluar");
                break;
            }
            case 14102: {
                lensNA = 0.25;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 01 31";
                break;
            }
            case 14103: {
                lensNA = 0.25;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 00 31";
                break;
            }
            case 14104: {
                lensNA = 0.45;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 06 39";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 14105: {
                lensNA = 0.16;
                magnification = 5.0;
                immersion = MetadataTools.getImmersion("Air");
                model = "44 06 20";
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 18101: {
                lensNA = 0.2;
                magnification = 4.0;
                workingDistance = 3.33;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 18102: {
                lensNA = 0.2;
                magnification = 2.46;
                workingDistance = 2.883;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 18103: {
                lensNA = 0.2;
                magnification = 4.0;
                workingDistance = 2.883;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 18104: {
                lensNA = 0.45;
                magnification = 6.15;
                workingDistance = 2.883;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 18105: {
                lensNA = 0.45;
                magnification = 10.0;
                workingDistance = 2.883;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanApo");
                break;
            }
            case 18106: {
                lensNA = 0.1;
                magnification = 1.0;
                workingDistance = 24.0;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 18107: {
                lensNA = 0.15;
                magnification = 10.0;
                workingDistance = 15.0;
                immersion = MetadataTools.getImmersion("Air");
                correction = MetadataTools.getCorrection("PlanFluor");
                manufacturer = "Nikon";
                break;
            }
            case 18108: {
                magnification = 20.0;
                lensNA = 0.75;
                correction = MetadataTools.getCorrection("PlanApo");
                manufacturer = "Nikon";
                break;
            }
            case 18109: {
                magnification = 40.0;
                lensNA = 0.95;
                correction = MetadataTools.getCorrection("PlanApo");
                manufacturer = "Nikon";
                break;
            }
            case 18110: {
                magnification = 40.0;
                lensNA = 0.6;
                correction = MetadataTools.getCorrection("PlanFluor");
                manufacturer = "Nikon";
                break;
            }
            case 18111: {
                magnification = 4.0;
                lensNA = 0.2;
                correction = MetadataTools.getCorrection("PlanApo");
                manufacturer = "Nikon";
                break;
            }
            case 18201: {
                lensNA = 0.55;
                magnification = 20.0;
                workingDistance = 13.0;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 18202: {
                lensNA = 0.5;
                magnification = 20.0;
                workingDistance = 13.0;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 18204: {
                lensNA = 0.45;
                magnification = 20.0;
                workingDistance = 4.5;
                immersion = MetadataTools.getImmersion("Air");
                model = "MUE01200/92777";
                break;
            }
            case 18205: {
                lensNA = 0.5;
                magnification = 20.0;
                workingDistance = 2.1;
                immersion = MetadataTools.getImmersion("Air");
                model = "MRH00200/93135";
                break;
            }
            case 18206: {
                lensNA = 0.55;
                magnification = 20.0;
                workingDistance = 2.1;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 18207: {
                lensNA = 0.45;
                magnification = 20.0;
                workingDistance = 7.4;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 18208: {
                lensNA = 0.75;
                magnification = 20.0;
                workingDistance = 1.0;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 18401: {
                lensNA = 0.65;
                magnification = 40.0;
                workingDistance = 0.48;
                immersion = MetadataTools.getImmersion("Air");
                break;
            }
            case 20007: {
                lensNA = 1.4;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                manufacturer = "Applied Precision";
                break;
            }
            case 1: {
                lensNA = 0.25;
                magnification = 10.0;
                immersion = MetadataTools.getImmersion("Air");
                manufacturer = "Zeiss";
                break;
            }
            case 2: {
                lensNA = 0.5;
                magnification = 25.0;
                immersion = MetadataTools.getImmersion("Air");
                manufacturer = "Zeiss";
                break;
            }
            case 3: {
                lensNA = 1.0;
                magnification = 50.0;
                immersion = MetadataTools.getImmersion("Oil");
                manufacturer = "Zeiss";
                break;
            }
            case 4: {
                lensNA = 1.25;
                magnification = 63.0;
                immersion = MetadataTools.getImmersion("Oil");
                manufacturer = "Zeiss";
                break;
            }
            case 5: {
                lensNA = 1.3;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                manufacturer = "Zeiss";
                break;
            }
            case 6: {
                lensNA = 1.3;
                magnification = 100.0;
                immersion = MetadataTools.getImmersion("Oil");
                correction = MetadataTools.getCorrection("Neofluor");
                break;
            }
            case 7: {
                lensNA = 1.4;
                magnification = 63.0;
                immersion = MetadataTools.getImmersion("Oil");
                correction = MetadataTools.getCorrection("PlanApo");
                manufacturer = "Leitz";
                break;
            }
            case 8: {
                lensNA = 1.2;
                magnification = 63.0;
                immersion = MetadataTools.getImmersion("Water");
                break;
            }
            case 9: {
                lensNA = 0.4;
                magnification = 10.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Air");
                manufacturer = "Olympus";
                break;
            }
            case 10: {
                lensNA = 0.8;
                magnification = 20.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Oil");
                manufacturer = "Olympus";
                break;
            }
            case 11: {
                lensNA = 1.3;
                magnification = 40.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Oil");
                manufacturer = "Olympus";
                break;
            }
            case 12: {
                lensNA = 1.4;
                magnification = 60.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Oil");
                manufacturer = "Olympus";
                break;
            }
            case 13: {
                lensNA = 1.4;
                magnification = 100.0;
                workingDistance = 0.3;
                immersion = MetadataTools.getImmersion("Oil");
                manufacturer = "Nikon";
                break;
            }
            default: {
                LOGGER.warn("Unrecognized lens ID {}; objective information may be incorrect", (Object)lensID);
            }
        }
        String objectiveID = "Objective:" + lensID;
        store.setObjectiveID(objectiveID, 0, 0);
        for (int series = 0; series < this.getSeriesCount(); ++series) {
            store.setObjectiveSettingsID(objectiveID, series);
        }
        store.setObjectiveLensNA(lensNA, 0, 0);
        store.setObjectiveImmersion(immersion, 0, 0);
        store.setObjectiveCorrection(correction, 0, 0);
        store.setObjectiveManufacturer(manufacturer, 0, 0);
        store.setObjectiveModel(model, 0, 0);
        store.setObjectiveNominalMagnification(magnification, 0, 0);
        if (workingDistance != null) {
            store.setObjectiveWorkingDistance(new Length(workingDistance, UNITS.MILLIMETER), 0, 0);
        }
    }

    private static class DVExtHdrFields {
        public float photosensorReading;
        public float timeStampSeconds;
        public Length stageXCoord;
        public Length stageYCoord;
        public Length stageZCoord;
        public float minInten;
        public float maxInten;
        public float expTime;
        public float ndFilter;
        public float exWavelen;
        public float emWavelen;
        public float intenScaling;
        public float energyConvFactor;

        public Map<String, Object> asMap() {
            HashMap<String, Object> rv = new HashMap<String, Object>();
            rv.put("photosensorReading", Float.valueOf(this.photosensorReading));
            rv.put("timeStampSeconds", Float.valueOf(this.timeStampSeconds));
            rv.put("stageXCoord", this.stageXCoord);
            rv.put("stageYCoord", this.stageYCoord);
            rv.put("stageZCoord", this.stageZCoord);
            rv.put("minInten", Float.valueOf(this.minInten));
            rv.put("maxInten", Float.valueOf(this.maxInten));
            rv.put("expTime", Float.valueOf(this.expTime));
            rv.put("ndFilter", Float.valueOf(this.ndFilter));
            rv.put("exWavelen", Float.valueOf(this.exWavelen));
            rv.put("emWavelen", Float.valueOf(this.emWavelen));
            rv.put("intenScaling", Float.valueOf(this.intenScaling));
            rv.put("energyConvFactor", Float.valueOf(this.energyConvFactor));
            return rv;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("photosensorReading: ");
            sb.append(this.photosensorReading);
            sb.append("\ntimeStampSeconds: ");
            sb.append(this.timeStampSeconds);
            sb.append("\nstageXCoord: ");
            sb.append(this.stageXCoord);
            sb.append("\nstageYCoord: ");
            sb.append(this.stageYCoord);
            sb.append("\nstageZCoord: ");
            sb.append(this.stageZCoord);
            sb.append("\nminInten: ");
            sb.append(this.minInten);
            sb.append("\nmaxInten: ");
            sb.append(this.maxInten);
            sb.append("\nexpTime: ");
            sb.append(this.expTime);
            sb.append("\nndFilter: ");
            sb.append(this.ndFilter);
            sb.append("\nexWavelen: ");
            sb.append(this.exWavelen);
            sb.append("\nemWavelen: ");
            sb.append(this.emWavelen);
            sb.append("\nintenScaling: ");
            sb.append(this.intenScaling);
            sb.append("\nenergyConvFactor: ");
            sb.append(this.energyConvFactor);
            return sb.toString();
        }

        private DVExtHdrFields(RandomAccessInputStream in) {
            try {
                this.photosensorReading = in.readFloat();
                this.timeStampSeconds = in.readFloat();
                this.stageXCoord = new Length(Float.valueOf(in.readFloat()), UNITS.REFERENCEFRAME);
                this.stageYCoord = new Length(Float.valueOf(in.readFloat()), UNITS.REFERENCEFRAME);
                this.stageZCoord = new Length(Float.valueOf(in.readFloat()), UNITS.REFERENCEFRAME);
                this.minInten = in.readFloat();
                this.maxInten = in.readFloat();
                in.skipBytes(4);
                this.expTime = in.readFloat();
                this.ndFilter = in.readFloat();
                this.exWavelen = in.readFloat();
                this.emWavelen = in.readFloat();
                this.intenScaling = in.readFloat();
                this.energyConvFactor = in.readFloat();
                if (this.ndFilter >= 1.0f) {
                    this.ndFilter /= 100.0f;
                }
            }
            catch (IOException e) {
                LOGGER.debug("Could not parse extended header", e);
            }
        }
    }
}

