/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class ARFReader
extends FormatReader {
    private static final long PIXELS_OFFSET = 524L;

    public ARFReader() {
        super("ARF", "arf");
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        byte endian1 = stream.readByte();
        byte endian2 = stream.readByte();
        return (endian1 == 1 && endian2 == 0 || endian1 == 0 && endian2 == 1) && stream.readString(2).equals("AR");
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(524L + (long)(no * FormatTools.getPlaneSize(this)));
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        boolean little;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Reading file header");
        byte endian1 = this.in.readByte();
        byte endian2 = this.in.readByte();
        if (endian1 == 1 && endian2 == 0) {
            little = true;
        } else if (endian1 == 0 && endian2 == 1) {
            little = false;
        } else {
            throw new FormatException("Undefined endianness");
        }
        this.in.order(little);
        this.in.skipBytes(2);
        int version = this.in.readUnsignedShort();
        int width = this.in.readUnsignedShort();
        int height = this.in.readUnsignedShort();
        int bitsPerPixel = this.in.readUnsignedShort();
        int numImages = version == 2 ? this.in.readUnsignedShort() : 1;
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeX = width;
        m3.sizeY = height;
        m3.sizeZ = 1;
        m3.sizeC = 1;
        m3.sizeT = numImages;
        int bpp = bitsPerPixel / 8;
        if (bitsPerPixel % 8 != 0) {
            ++bpp;
        }
        m3.pixelType = FormatTools.pixelTypeFromBytes(bpp, false, false);
        m3.bitsPerPixel = bitsPerPixel;
        m3.imageCount = numImages;
        m3.dimensionOrder = "XYCZT";
        m3.orderCertain = true;
        m3.littleEndian = little;
        m3.rgb = false;
        m3.interleaved = false;
        m3.indexed = false;
        m3.metadataComplete = true;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.addGlobalMeta("Endianness", little ? "little" : "big");
            this.addGlobalMeta("Version", version);
            this.addGlobalMeta("Width", width);
            this.addGlobalMeta("Height", height);
            this.addGlobalMeta("Bits per pixel", bitsPerPixel);
            this.addGlobalMeta("Image count", numImages);
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

