/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5CompoundMemberMapping;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5MemberByteifyer;
import ch.systemsx.cisd.hdf5.HDF5ValueObjectByteifyer;
import ch.systemsx.cisd.hdf5.MatrixUtils;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFNativeData;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;

class HDF5CompoundMemberByteifyerShortFactory
implements HDF5CompoundByteifyerFactory.IHDF5CompoundMemberBytifyerFactory {
    private static Map<Class<?>, Rank> classToRankMap = new IdentityHashMap();

    static {
        Rank[] rankArray = Rank.values();
        int n = rankArray.length;
        int n2 = 0;
        while (n2 < n) {
            Rank r = rankArray[n2];
            classToRankMap.put(r.getClazz(), r);
            ++n2;
        }
    }

    HDF5CompoundMemberByteifyerShortFactory() {
    }

    @Override
    public boolean canHandle(Class<?> clazz, HDF5CompoundMemberInformation memberInfoOrNull) {
        Rank rankOrNull = classToRankMap.get(clazz);
        if (memberInfoOrNull != null) {
            HDF5DataTypeInformation typeInfo = memberInfoOrNull.getType();
            if (rankOrNull == null || typeInfo.getDataClass() != HDF5DataClass.INTEGER || typeInfo.getElementSize() != 2) {
                return false;
            }
            return rankOrNull.anyRank() || rankOrNull.getRank() == typeInfo.getDimensions().length || rankOrNull.isScalar() && typeInfo.getDimensions().length == 1 && typeInfo.getDimensions()[0] == 1;
        }
        return rankOrNull != null;
    }

    @Override
    public Class<?> tryGetOverrideJavaType(HDF5DataClass dataClass, int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
        return null;
    }

    @Override
    public HDF5MemberByteifyer createBytifyer(HDF5CompoundByteifyerFactory.AccessType accessType, Field fieldOrNull, HDF5CompoundMemberMapping member, HDF5CompoundMemberInformation compoundMemberInfoOrNull, HDF5EnumerationType enumTypeOrNull, Class<?> memberClazz, int index, int offset, int memOffset, HDF5ValueObjectByteifyer.IFileAccessProvider fileInfoProvider) {
        int[] nArray;
        int len;
        String memberName = member.getMemberName();
        Rank rank = classToRankMap.get(memberClazz);
        int n = compoundMemberInfoOrNull != null ? compoundMemberInfoOrNull.getType().getNumberOfElements() : (len = rank.isScalar() ? 1 : member.getMemberTypeLength());
        if (rank.isScalar()) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            nArray = member.getMemberTypeDimensions();
        }
        int[] dimensions = nArray;
        int storageTypeId = member.getStorageDataTypeId();
        int memberTypeId = rank.isScalar() ? (member.isUnsigned() ? HDF5Constants.H5T_STD_U16LE : HDF5Constants.H5T_STD_I16LE) : (storageTypeId < 0 ? fileInfoProvider.getArrayTypeId(member.isUnsigned() ? HDF5Constants.H5T_STD_U16LE : HDF5Constants.H5T_STD_I16LE, dimensions) : storageTypeId);
        switch (accessType) {
            case FIELD: {
                return this.createByteifyerForField(fieldOrNull, memberName, offset, memOffset, dimensions, len, memberTypeId, rank, member.tryGetTypeVariant());
            }
            case MAP: {
                return this.createByteifyerForMap(memberName, offset, memOffset, dimensions, len, memberTypeId, rank, member.tryGetTypeVariant());
            }
            case LIST: {
                return this.createByteifyerForList(memberName, index, offset, memOffset, dimensions, len, memberTypeId, rank, member.tryGetTypeVariant());
            }
            case ARRAY: {
                return this.createByteifyerForArray(memberName, index, offset, memOffset, dimensions, len, memberTypeId, rank, member.tryGetTypeVariant());
            }
        }
        throw new Error("Unknown access type");
    }

    private HDF5MemberByteifyer createByteifyerForField(final Field field, final String memberName, int offset, int memOffset, final int[] dimensions, final int len, final int memberTypeId, final Rank rank, HDF5DataTypeVariant typeVariant) {
        ReflectionUtils.ensureAccessible(field);
        return new HDF5MemberByteifyer(field, memberName, 2 * len, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return 2;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return memberTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                switch (rank) {
                    case SCALAR: {
                        return HDFNativeData.shortToByte(field.getShort(obj));
                    }
                    case ARRAY1D: {
                        return HDFNativeData.shortToByte((short[])field.get(obj));
                    }
                    case ARRAY2D: {
                        short[][] array = (short[][])field.get(obj);
                        MatrixUtils.checkMatrixDimensions(memberName, dimensions, array);
                        return HDFNativeData.shortToByte(MatrixUtils.flatten(array));
                    }
                    case ARRAYMD: {
                        MDShortArray array = (MDShortArray)field.get(obj);
                        MatrixUtils.checkMDArrayDimensions(memberName, dimensions, array);
                        return HDFNativeData.shortToByte(array.getAsFlatArray());
                    }
                }
                throw new Error("Unknown rank.");
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                switch (rank) {
                    case SCALAR: {
                        field.setShort(obj, HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory));
                        break;
                    }
                    case ARRAY1D: {
                        field.set(obj, HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len));
                        break;
                    }
                    case ARRAY2D: {
                        short[] array = HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len);
                        field.set(obj, MatrixUtils.shapen(array, dimensions));
                        break;
                    }
                    case ARRAYMD: {
                        short[] array = HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len);
                        field.set(obj, new MDShortArray(array, dimensions));
                        break;
                    }
                    default: {
                        throw new Error("Unknown rank.");
                    }
                }
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForMap(final String memberName, int offset, int memOffset, final int[] dimensions, final int len, final int memberTypeId, final Rank rank, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 2 * len, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return 2;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return memberTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                switch (rank) {
                    case SCALAR: {
                        return HDFNativeData.shortToByte(((Number)HDF5CompoundByteifyerFactory.getMap(obj, memberName)).shortValue());
                    }
                    case ARRAY1D: {
                        return HDFNativeData.shortToByte((short[])HDF5CompoundByteifyerFactory.getMap(obj, memberName));
                    }
                    case ARRAY2D: {
                        short[][] array = (short[][])HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                        MatrixUtils.checkMatrixDimensions(memberName, dimensions, array);
                        return HDFNativeData.shortToByte(MatrixUtils.flatten(array));
                    }
                    case ARRAYMD: {
                        MDShortArray array = (MDShortArray)HDF5CompoundByteifyerFactory.getMap(obj, memberName);
                        MatrixUtils.checkMDArrayDimensions(memberName, dimensions, array);
                        return HDFNativeData.shortToByte(array.getAsFlatArray());
                    }
                }
                throw new Error("Unknown rank.");
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                switch (rank) {
                    case SCALAR: {
                        HDF5CompoundByteifyerFactory.putMap(obj, memberName, HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory));
                        break;
                    }
                    case ARRAY1D: {
                        HDF5CompoundByteifyerFactory.putMap(obj, memberName, HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len));
                        break;
                    }
                    case ARRAY2D: {
                        short[] array = HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len);
                        HDF5CompoundByteifyerFactory.putMap(obj, memberName, MatrixUtils.shapen(array, dimensions));
                        break;
                    }
                    case ARRAYMD: {
                        short[] array = HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len);
                        HDF5CompoundByteifyerFactory.putMap(obj, memberName, new MDShortArray(array, dimensions));
                        break;
                    }
                    default: {
                        throw new Error("Unknown rank.");
                    }
                }
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForList(final String memberName, final int index, int offset, int memOffset, final int[] dimensions, final int len, final int memberTypeId, final Rank rank, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 2 * len, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return 2;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return memberTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                switch (rank) {
                    case SCALAR: {
                        return HDFNativeData.shortToByte(((Number)HDF5CompoundByteifyerFactory.getList(obj, index)).shortValue());
                    }
                    case ARRAY1D: {
                        return HDFNativeData.shortToByte((short[])HDF5CompoundByteifyerFactory.getList(obj, index));
                    }
                    case ARRAY2D: {
                        short[][] array = (short[][])HDF5CompoundByteifyerFactory.getList(obj, index);
                        MatrixUtils.checkMatrixDimensions(memberName, dimensions, array);
                        return HDFNativeData.shortToByte(MatrixUtils.flatten(array));
                    }
                    case ARRAYMD: {
                        MDShortArray array = (MDShortArray)HDF5CompoundByteifyerFactory.getList(obj, index);
                        MatrixUtils.checkMDArrayDimensions(memberName, dimensions, array);
                        return HDFNativeData.shortToByte(array.getAsFlatArray());
                    }
                }
                throw new Error("Unknown rank.");
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                switch (rank) {
                    case SCALAR: {
                        HDF5CompoundByteifyerFactory.setList(obj, index, HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory));
                        break;
                    }
                    case ARRAY1D: {
                        HDF5CompoundByteifyerFactory.putMap(obj, memberName, HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len));
                        break;
                    }
                    case ARRAY2D: {
                        short[] array = HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len);
                        HDF5CompoundByteifyerFactory.setList(obj, index, MatrixUtils.shapen(array, dimensions));
                        break;
                    }
                    case ARRAYMD: {
                        short[] array = HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len);
                        HDF5CompoundByteifyerFactory.setList(obj, index, new MDShortArray(array, dimensions));
                        break;
                    }
                    default: {
                        throw new Error("Unknown rank.");
                    }
                }
            }
        };
    }

    private HDF5MemberByteifyer createByteifyerForArray(final String memberName, final int index, int offset, int memOffset, final int[] dimensions, final int len, final int memberTypeId, final Rank rank, HDF5DataTypeVariant typeVariant) {
        return new HDF5MemberByteifyer(null, memberName, 2 * len, offset, memOffset, false, typeVariant){

            @Override
            int getElementSize() {
                return 2;
            }

            @Override
            protected int getMemberStorageTypeId() {
                return memberTypeId;
            }

            @Override
            protected int getMemberNativeTypeId() {
                return -1;
            }

            @Override
            public byte[] byteify(int compoundDataTypeId, Object obj) throws IllegalAccessException {
                switch (rank) {
                    case SCALAR: {
                        return HDFNativeData.shortToByte(((Number)HDF5CompoundByteifyerFactory.getArray(obj, index)).shortValue());
                    }
                    case ARRAY1D: {
                        return HDFNativeData.shortToByte((short[])HDF5CompoundByteifyerFactory.getArray(obj, index));
                    }
                    case ARRAY2D: {
                        short[][] array = (short[][])HDF5CompoundByteifyerFactory.getArray(obj, index);
                        MatrixUtils.checkMatrixDimensions(memberName, dimensions, array);
                        return HDFNativeData.shortToByte(MatrixUtils.flatten(array));
                    }
                    case ARRAYMD: {
                        MDShortArray array = (MDShortArray)HDF5CompoundByteifyerFactory.getArray(obj, index);
                        MatrixUtils.checkMDArrayDimensions(memberName, dimensions, array);
                        return HDFNativeData.shortToByte(array.getAsFlatArray());
                    }
                }
                throw new Error("Unknown rank.");
            }

            @Override
            public void setFromByteArray(int compoundDataTypeId, Object obj, byte[] byteArr, int arrayOffset) throws IllegalAccessException {
                switch (rank) {
                    case SCALAR: {
                        HDF5CompoundByteifyerFactory.setArray(obj, index, HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory));
                        break;
                    }
                    case ARRAY1D: {
                        HDF5CompoundByteifyerFactory.setArray(obj, index, HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len));
                        break;
                    }
                    case ARRAY2D: {
                        short[] array = HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len);
                        HDF5CompoundByteifyerFactory.setArray(obj, index, MatrixUtils.shapen(array, dimensions));
                        break;
                    }
                    case ARRAYMD: {
                        short[] array = HDFNativeData.byteToShort(byteArr, arrayOffset + this.offsetInMemory, len);
                        HDF5CompoundByteifyerFactory.setArray(obj, index, new MDShortArray(array, dimensions));
                        break;
                    }
                    default: {
                        throw new Error("Unknown rank.");
                    }
                }
            }
        };
    }

    private static enum Rank {
        SCALAR(Short.TYPE, 0),
        ARRAY1D(short[].class, 1),
        ARRAY2D(short[][].class, 2),
        ARRAYMD(MDShortArray.class, -1);

        private final Class<?> clazz;
        private final int rank;

        private Rank(Class<?> clazz, int rank) {
            this.clazz = clazz;
            this.rank = rank;
        }

        int getRank() {
            return this.rank;
        }

        boolean isScalar() {
            return this.rank == 0;
        }

        boolean anyRank() {
            return this.rank == -1;
        }

        Class<?> getClazz() {
            return this.clazz;
        }
    }
}

