# Generated by Django 2.1.1 on 2018-10-07 19:34

from django.db import migrations, models
import django.db.models.deletion


def update_sellerpart_fk(apps, schema_editor):
    Part = apps.get_model('bom', 'Part')
    SellerPart = apps.get_model('bom', 'SellerPart')
    ManufacturerPart = apps.get_model('bom', 'ManufacturerPart')

    for sp in SellerPart.objects.all():
        (mp, created) = ManufacturerPart.objects.get_or_create(part=sp.part, manufacturer_part_number=sp.part.manufacturer_part_number, manufacturer=sp.part.manufacturer)
        sp.manufacturer_part = mp
        sp.save()

    for p in Part.objects.all():
        (mp, created) = ManufacturerPart.objects.get_or_create(part=p, manufacturer_part_number=p.manufacturer_part_number, manufacturer=p.manufacturer)


class Migration(migrations.Migration):

    dependencies = [
        ('bom', '0004_auto_20180911_0011'),
    ]

    operations = [
        migrations.CreateModel(
            name='ManufacturerPart',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('manufacturer_part_number', models.CharField(blank=True, default='', max_length=128)),
                ('manufacturer', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.PROTECT, to='bom.Manufacturer')),
                ('part', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bom.Part')),
            ],
        ),
        migrations.AddField(
            model_name='sellerpart',
            name='manufacturer_part',
            field=models.ForeignKey(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='bom.ManufacturerPart'),
        ),
        migrations.RunPython(update_sellerpart_fk),
        migrations.AlterField(
            model_name='sellerpart',
            name='manufacturer_part',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bom.ManufacturerPart'),
        ),
        migrations.AlterUniqueTogether(
            name='sellerpart',
            unique_together={('seller', 'manufacturer_part', 'minimum_order_quantity', 'unit_cost')},
        ),
        migrations.AlterUniqueTogether(
            name='manufacturerpart',
            unique_together={('part', 'manufacturer_part_number', 'manufacturer')},
        ),
    ]
