/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.lib;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.storage.StorageLevel;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.Logging;
import org.graphframes.Logging$class;
import org.graphframes.lib.ConnectedComponents;
import org.graphframes.lib.ConnectedComponents$;
import org.graphframes.lib.GraphXConversions$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;

public final class ConnectedComponents$
implements Logging {
    public static final ConnectedComponents$ MODULE$;
    private final String COMPONENT;
    private final String ORIG_ID;
    private final String MIN_NBR;
    private final String CNT;
    private final String org$graphframes$lib$ConnectedComponents$$CHECKPOINT_NAME_PREFIX;
    private final String ALGO_GRAPHX;
    private final String org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES;
    private final String[] supportedAlgorithms;
    private final transient Logger org$graphframes$Logging$$logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConnectedComponents$();
    }

    private Logger org$graphframes$Logging$$logger$lzycompute() {
        ConnectedComponents$ connectedComponents$ = this;
        synchronized (connectedComponents$) {
            if (!this.bitmap$trans$0) {
                this.org$graphframes$Logging$$logger = Logging$class.org$graphframes$Logging$$logger(this);
                this.bitmap$trans$0 = true;
            }
            return this.org$graphframes$Logging$$logger;
        }
    }

    @Override
    public Logger org$graphframes$Logging$$logger() {
        return this.bitmap$trans$0 ? this.org$graphframes$Logging$$logger : this.org$graphframes$Logging$$logger$lzycompute();
    }

    @Override
    public void logDebug(Function0<String> s) {
        Logging$class.logDebug(this, s);
    }

    @Override
    public void logWarn(Function0<String> s) {
        Logging$class.logWarn(this, s);
    }

    @Override
    public void logInfo(Function0<String> s) {
        Logging$class.logInfo(this, s);
    }

    @Override
    public void logTrace(Function0<String> s) {
        Logging$class.logTrace(this, s);
    }

    private String COMPONENT() {
        return this.COMPONENT;
    }

    private String ORIG_ID() {
        return this.ORIG_ID;
    }

    private String MIN_NBR() {
        return this.MIN_NBR;
    }

    private String CNT() {
        return this.CNT;
    }

    public String org$graphframes$lib$ConnectedComponents$$CHECKPOINT_NAME_PREFIX() {
        return this.org$graphframes$lib$ConnectedComponents$$CHECKPOINT_NAME_PREFIX;
    }

    private String ALGO_GRAPHX() {
        return this.ALGO_GRAPHX;
    }

    public String org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES() {
        return this.org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES;
    }

    public String[] supportedAlgorithms() {
        return this.supportedAlgorithms;
    }

    private Dataset<Row> symmetrize(Dataset<Row> ee) {
        String EDGE = "_edge";
        return ee.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())})), functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).as(GraphFrame$.MODULE$.DST())}))}))).as(EDGE)})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EDGE, GraphFrame$.MODULE$.SRC()}))).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{EDGE, GraphFrame$.MODULE$.DST()}))).as(GraphFrame$.MODULE$.DST())}));
    }

    private GraphFrame prepare(GraphFrame graph) {
        Dataset vertices = graph.indexedVertices().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_ID()).as(GraphFrame$.MODULE$.ID()), functions$.MODULE$.col(GraphFrame$.MODULE$.ATTR())}));
        Dataset edges = graph.indexedEdges().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_SRC()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_DST()).as(GraphFrame$.MODULE$.DST())}));
        Dataset orderedEdges = edges.filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$bang$eq$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.minValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.SRC()), this.maxValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.DST())})).distinct();
        return GraphFrame$.MODULE$.apply((Dataset<Row>)vertices, (Dataset<Row>)orderedEdges);
    }

    private Dataset<Row> minNbrs(Dataset<Row> ee) {
        return this.symmetrize(ee).groupBy(GraphFrame$.MODULE$.SRC(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(this.MIN_NBR()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count("*").as(this.CNT())})).withColumn(this.MIN_NBR(), this.minValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(this.MIN_NBR())));
    }

    private Column minValue(Column x, Column y) {
        return functions$.MODULE$.when(x.$less((Object)y), (Object)x).otherwise((Object)y);
    }

    private Column maxValue(Column x, Column y) {
        return functions$.MODULE$.when(x.$greater((Object)y), (Object)x).otherwise((Object)y);
    }

    private Dataset<Row> skewedJoin(Dataset<Row> edges, Dataset<Row> minNbrs, int broadcastThreshold, String logPrefix) {
        Set hubs = Predef$.MODULE$.longArrayOps((long[])minNbrs.filter(functions$.MODULE$.col(this.CNT()).$greater((Object)BoxesRunTime.boxToInteger((int)broadcastThreshold))).select(GraphFrame$.MODULE$.SRC(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(edges.sqlContext().implicits().newLongEncoder()).collect()).toSet();
        return GraphFrame$.MODULE$.skewedJoin(edges, minNbrs, GraphFrame$.MODULE$.SRC(), hubs, logPrefix, ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
    }

    public Dataset<Row> run(GraphFrame graph) {
        return new ConnectedComponents(graph).run();
    }

    private Dataset<Row> runGraphX(GraphFrame graph) {
        Graph components = org.apache.spark.graphx.lib.ConnectedComponents$.MODULE$.run(graph.cachedTopologyGraphX(), ClassTag$.MODULE$.Unit(), ClassTag$.MODULE$.Unit());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_lib_ConnectedComponents$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.graphx")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.graphx.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("org.apache.spark.graphx.package").asModule().moduleClass(), "VertexId"), (List)Nil$.MODULE$);
            }

            public Org_graphframes_lib_ConnectedComponents$$typecreator1$1() {
            }
        }
        return GraphXConversions$.MODULE$.fromGraphX(graph, components, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.COMPONENT()}))), GraphXConversions$.MODULE$.fromGraphX$default$4(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_graphframes_lib_ConnectedComponents$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Unit()).vertices();
    }

    /*
     * WARNING - void declaration
     */
    public Dataset<Row> org$graphframes$lib$ConnectedComponents$$run(GraphFrame graph, String algorithm, int broadcastThreshold, int checkpointInterval, StorageLevel intermediateStorageLevel) {
        Tuple2 tuple2;
        None$ none$;
        boolean shouldCheckpoint;
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])this.supportedAlgorithms()).contains((Object)algorithm), (Function0)new Serializable(algorithm){
            public static final long serialVersionUID = 0L;
            private final String algorithm$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Supported algorithms are {", "}, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])ConnectedComponents$.MODULE$.supportedAlgorithms()).mkString(", "), this.algorithm$1}));
            }
            {
                this.algorithm$1 = algorithm$1;
            }
        });
        String string = algorithm;
        String string2 = this.ALGO_GRAPHX();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.runGraphX(graph);
        }
        String runId = (String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(8);
        String logPrefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[CC ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{runId}));
        this.logInfo((Function0<String>)new Serializable(runId, logPrefix){
            public static final long serialVersionUID = 0L;
            private final String runId$1;
            private final String logPrefix$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Start connected components with run ID ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPrefix$1, this.runId$1}));
            }
            {
                this.runId$1 = runId$1;
                this.logPrefix$1 = logPrefix$1;
            }
        });
        SQLContext sqlContext = graph.sqlContext();
        SparkContext sc = sqlContext.sparkContext();
        boolean bl = shouldCheckpoint = checkpointInterval > 0;
        if (shouldCheckpoint) {
            String dir = (String)sc.getCheckpointDir().map((Function1)new Serializable(runId){
                public static final long serialVersionUID = 0L;
                private final String runId$1;

                public final String apply(String d) {
                    return new Path(d, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ConnectedComponents$.MODULE$.org$graphframes$lib$ConnectedComponents$$CHECKPOINT_NAME_PREFIX(), this.runId$1}))).toString();
                }
                {
                    this.runId$1 = runId$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new IOException("Checkpoint directory is not set. Please set it first using sc.setCheckpointDir().");
                }
            });
            this.logInfo((Function0<String>)new Serializable(checkpointInterval, logPrefix, dir){
                public static final long serialVersionUID = 0L;
                private final int checkpointInterval$1;
                private final String logPrefix$1;
                private final String dir$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Using ", " for checkpointing with interval ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPrefix$1, this.dir$1, BoxesRunTime.boxToInteger((int)this.checkpointInterval$1)}));
                }
                {
                    this.checkpointInterval$1 = checkpointInterval$1;
                    this.logPrefix$1 = logPrefix$1;
                    this.dir$1 = dir$1;
                }
            });
            none$ = new Some((Object)dir);
        } else {
            this.logInfo((Function0<String>)new Serializable(checkpointInterval, logPrefix){
                public static final long serialVersionUID = 0L;
                private final int checkpointInterval$1;
                private final String logPrefix$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Checkpointing is disabled because checkpointInterval=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPrefix$1, BoxesRunTime.boxToInteger((int)this.checkpointInterval$1)}));
                }
                {
                    this.checkpointInterval$1 = checkpointInterval$1;
                    this.logPrefix$1 = logPrefix$1;
                }
            });
            none$ = None$.MODULE$;
        }
        None$ checkpointDir = none$;
        this.logInfo((Function0<String>)new Serializable(logPrefix){
            public static final long serialVersionUID = 0L;
            private final String logPrefix$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Preparing the graph for connected component computation ..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPrefix$1}));
            }
            {
                this.logPrefix$1 = logPrefix$1;
            }
        });
        GraphFrame g = this.prepare(graph);
        Dataset<Row> vv = g.vertices();
        Dataset ee = g.edges().persist(intermediateStorageLevel);
        long numEdges = ee.count();
        this.logInfo((Function0<String>)new Serializable(logPrefix, numEdges){
            public static final long serialVersionUID = 0L;
            private final String logPrefix$1;
            private final long numEdges$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Found ", " edges after preparation."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPrefix$1, BoxesRunTime.boxToLong((long)this.numEdges$1)}));
            }
            {
                this.logPrefix$1 = logPrefix$1;
                this.numEdges$1 = numEdges$1;
            }
        });
        boolean converged = false;
        IntRef iteration = IntRef.create((int)1);
        Object prevSum = null;
        while (true) {
            BigDecimal bigDecimal;
            Tuple2 tuple22;
            void var20_19;
            void var11_11;
            void var8_8;
            Dataset dataset;
            if (converged) {
                this.logInfo((Function0<String>)new Serializable(logPrefix, iteration){
                    public static final long serialVersionUID = 0L;
                    private final String logPrefix$1;
                    private final IntRef iteration$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Connected components converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPrefix$1, BoxesRunTime.boxToInteger((int)(this.iteration$1.elem - 1))}));
                    }
                    {
                        this.logPrefix$1 = logPrefix$1;
                        this.iteration$1 = iteration$1;
                    }
                });
                this.logInfo((Function0<String>)new Serializable(logPrefix){
                    public static final long serialVersionUID = 0L;
                    private final String logPrefix$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Join and return component assignments with original vertex IDs."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPrefix$1}));
                    }
                    {
                        this.logPrefix$1 = logPrefix$1;
                    }
                });
                return vv.join(ee, vv.apply(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)ee.apply(GraphFrame$.MODULE$.DST())), "left_outer").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{vv.apply(GraphFrame$.MODULE$.ATTR()), functions$.MODULE$.when(ee.apply(GraphFrame$.MODULE$.SRC()).isNull(), (Object)vv.apply(GraphFrame$.MODULE$.ID())).otherwise((Object)ee.apply(GraphFrame$.MODULE$.SRC())).as(this.COMPONENT())})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{GraphFrame$.MODULE$.ATTR()}))), functions$.MODULE$.col(this.COMPONENT())}));
            }
            Dataset minNbrs1 = this.minNbrs((Dataset<Row>)dataset).persist(intermediateStorageLevel);
            dataset = this.skewedJoin((Dataset<Row>)dataset, (Dataset<Row>)minNbrs1, broadcastThreshold, (String)var8_8).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.DST())})).distinct().persist(intermediateStorageLevel);
            Dataset minNbrs2 = dataset.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.SRC())})).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(this.MIN_NBR()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count("*").as(this.CNT())})).persist(intermediateStorageLevel);
            dataset = this.skewedJoin((Dataset<Row>)dataset, (Dataset<Row>)minNbrs2, broadcastThreshold, (String)var8_8).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())})).filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())));
            dataset = dataset.union(minNbrs2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).as(GraphFrame$.MODULE$.DST())}))).distinct();
            if (var11_11 != false && var20_19.elem % checkpointInterval == 0) {
                Object object;
                void var9_9;
                void var12_13;
                String out = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_13.get(), BoxesRunTime.boxToInteger((int)var20_19.elem)}));
                dataset.write().parquet(out);
                dataset = var9_9.read().parquet(out);
                if (var20_19.elem > checkpointInterval) {
                    void var10_10;
                    Path path = new Path(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_13.get(), BoxesRunTime.boxToInteger((int)(var20_19.elem - checkpointInterval))})));
                    object = BoxesRunTime.boxToBoolean((boolean)path.getFileSystem(var10_10.hadoopConfiguration()).delete(path, true));
                } else {
                    object = BoxedUnit.UNIT;
                }
                System.gc();
            }
            dataset.persist(intermediateStorageLevel);
            tuple2 = (Tuple2)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).cast((DataType)new DecimalType(20, 0))), functions$.MODULE$.count("*")})).rdd().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<BigDecimal, Object> apply(Row r) {
                    return new Tuple2(r.getAs(0), (Object)BoxesRunTime.boxToLong((long)r.getLong(1)));
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).first();
            if (tuple2 == null) break;
            BigDecimal currSum = (BigDecimal)tuple2._1();
            long cnt = tuple2._2$mcJ$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)currSum, (Object)BoxesRunTime.boxToLong((long)cnt));
            BigDecimal currSum2 = (BigDecimal)tuple23._1();
            long cnt2 = tuple23._2$mcJ$sp();
            if (cnt2 != 0L && currSum2 == null) {
                throw new ArithmeticException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |The total sum of edge src IDs is used to determine convergence during iterations.\n             |However, the total sum at iteration ", " exceeded 30 digits (1e30),\n             |which should happen only if the graph contains more than 200 billion edges.\n             |If not, please file a bug report at https://github.com/graphframes/graphframes/issues.\n            "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)var20_19.elem)})))).stripMargin());
            }
            this.logInfo((Function0<String>)new Serializable((String)var8_8, (IntRef)var20_19, currSum2){
                public static final long serialVersionUID = 0L;
                private final String logPrefix$1;
                private final IntRef iteration$1;
                private final BigDecimal currSum$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Sum of assigned components in iteration ", ": ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.logPrefix$1, BoxesRunTime.boxToInteger((int)this.iteration$1.elem), this.currSum$1}));
                }
                {
                    this.logPrefix$1 = logPrefix$1;
                    this.iteration$1 = iteration$1;
                    this.currSum$1 = currSum$1;
                }
            });
            if (BoxesRunTime.equalsNumNum((Number)currSum2, (Number)bigDecimal)) {
                boolean bl2 = true;
            } else {
                bigDecimal = currSum2;
            }
            ++var20_19.elem;
        }
        throw new MatchError((Object)tuple2);
    }

    private ConnectedComponents$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.COMPONENT = "component";
        this.ORIG_ID = "orig_id";
        this.MIN_NBR = "min_nbr";
        this.CNT = "cnt";
        this.org$graphframes$lib$ConnectedComponents$$CHECKPOINT_NAME_PREFIX = "connected-components";
        this.ALGO_GRAPHX = "graphx";
        this.org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES = "graphframes";
        this.supportedAlgorithms = (String[])((Object[])new String[]{this.ALGO_GRAPHX(), this.org$graphframes$lib$ConnectedComponents$$ALGO_GRAPHFRAMES()});
    }
}

