"""
Generated workload for a full workload using delay profiles.
"""

import random
import sys

from batsim.sched.workloads import generate_workload
from batsim.sched.profiles import Profiles


def delay_workload(w):
    r = random.Random()
    r.seed(0)

    last_subtime = 0

    job_classes = [
        lambda: (400, 32, Profiles.Delay(r.randint(350, 390))),
        lambda: (250, 16, Profiles.Delay(r.randint(150, 245))),
        lambda: (80, 8, Profiles.Delay(r.randint(35, 55))),
        lambda: (40, 2, Profiles.Delay(r.randint(28, 32))),
        lambda: (90, 4, Profiles.Delay(r.randint(75, 88))),
    ]

    jobs = job_classes[:]
    while len(jobs) < 30:
        jobs.append(
            r.choices(
                job_classes, [r + 0.25 for r in range(0, len(job_classes))])
            [0])
    r.shuffle(jobs)

    classes = {}

    for i, job in enumerate(jobs):
        job_class = job()
        classes[job_class[1]] = classes.setdefault(job_class[1], 0) + 1

        subtime = last_subtime = r.uniform(
            last_subtime, last_subtime + 1 + i // 10)
        w.new_job(subtime=subtime, walltime=job_class[0],
                  res=job_class[1], profile=job_class[2])

    print("Generated job classes: {}".format(classes), file=sys.stderr)


generate_workload(
    delay_workload, nb_res=32,
    description="This is a full test workload generated by a python script using batsim.sched.workloads")
