"""
Generated workload for a simple workload using delay and sequence profiles with nested
delays.
"""

from batsim.sched.workloads import generate_workload
from batsim.sched.profiles import Profiles


def complex_profile():
    def if_timeout():
        yield Profiles.Delay(1, ret=2)

    def if_failed():
        yield Profiles.Delay(1, ret=1)

    def if_success():
        yield Profiles.Delay(10)

    yield Profiles.Delay(5)
    yield Profiles.Delay(10)
    yield Profiles.Send({"msg": "Some message"})
    yield Profiles.Receive.if_recv("OK", if_success, if_failed, if_timeout)


def generated_test_workload(w):
    j1 = w.new_job(subtime=0, walltime=10, res=4, profile=Profiles.Delay(5),
                   comment="Test comment")
    j2 = w.new_job(subtime=0, walltime=10, res=4, profile=Profiles.Delay(5))
    j3 = w.new_job(
        id=10,
        subtime=0,
        walltime=10,
        res=4,
        profile=Profiles.Delay(5))
    j4 = w.new_job(subtime=0, walltime=10, res=4, profile=Profiles.Delay(5))

    w.new_job(
        walltime=30, res=4, deps=[j1.id, j2.id, j3.id, j4.id, "42", 43],
        profile=Profiles.Sequence(
            [Profiles.Delay(5),
             Profiles.Delay(5),
             Profiles.Delay(10),
             Profiles.Delay(5)]))

    w.new_job(
        walltime=200,
        res=16,
        profile=Profiles.profile_from_generator(complex_profile))

    w.new_job(
        id=42,
        subtime=200,
        walltime=10,
        res=32,
        profile=Profiles.Delay(5))
    w.new_job(
        id=43,
        subtime=200,
        walltime=10,
        res=32,
        profile=Profiles.Delay(5))


generate_workload(
    generated_test_workload, nb_res=32,
    description="This is a simple test workload generated by a python script using batsim.sched.workloads")
