from ctypes import Array as ctypes_Array
from _ctypes import _CData
from collections.abc import Mapping, MutableMapping
from numbers import Real
from selectors import _PollLikeSelector
from threading import Lock
from typing import ClassVar, List, Optional, Protocol, Tuple, TypeVar, Union

from ._util.wintypes_extra import WSAPOLLFD

T = TypeVar('T')
_SelectorKey = Tuple[Union[_Fileobj, int], int, int, T]

POLLERR: int
POLLHUP: int
POLLIN: int
POLLNVAL: int
POLLOUT: int
POLLPRI: int
POLLRDBAND: int
POLLRDNORM: int
POLLWRBAND: int
POLLWRNORM: int

class _Fileobj(Protocol):
    def fileno(self) -> int: ...

class wsapoll:
    __slots__ = ['__impl', '__fd_to_key', '__buffer']
    _registered: MutableMapping[int, int]
    __impl: ctypes_Array[WSAPOLLFD]
    __impl_uptodate: bool
    __buffer: _CData
    __lock: Lock
    def __init__(self, sizehint: int=...) -> None: ...
    def __repr__(self) -> str: ...

    def register(self, fd: Union[_Fileobj, int], eventmask: int=...) -> None: ...
    def modify(self, fd: Union[_Fileobj, int], eventmask: int) -> None: ...
    def unregister(self, fd: Union[_Fileobj, int]) -> None: ...
    def poll(self, timeout: Optional[Real]=None) -> List[Tuple[int, int]]: ...

    def _poll(self, timeout: int=-1) -> List[Tuple[int, int]]: ...
    def _clear(self) -> None: ...
    def __check_maybe_affected(self) -> bool: ...
    def __update_impl(self) -> None: ...

class WSAPollSelector(_PollLikeSelector):
    def register(self, fileobj: Union[_Fileobj, int], events: int, data: T=None) -> _SelectorKey: ...
    def unregister(self, fileobj: Union[_Fileobj, int]) -> _SelectorKey: ...
    def modify(self, fileobj: Union[_Fileobj, int], events: int, data: T=None) -> _SelectorKey: ...
    def select(self, timeout: Optional[Real]=None) -> List[Tuple[_SelectorKey, int]]: ...
    def close(self) -> None: ...
    def get_key(self, Union[_Fileobj, int]) -> _SelectorKey: ...
    def get_map(self) -> Mapping[Union[_Fileobj, int], _SelectorKey]: ...

    _selector_cls: ClassVar[...]  # type: ignore
    _EVENT_READ: ClassVar[int]
    _EVENT_WRITE: ClassVar[int]
