import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::IoTAnalytics::Channel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html
 */
export interface CfnChannelProps {
    /**
     * `AWS::IoTAnalytics::Channel.ChannelName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html#cfn-iotanalytics-channel-channelname
     */
    readonly channelName: string;
    /**
     * `AWS::IoTAnalytics::Channel.ChannelStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html#cfn-iotanalytics-channel-channelstorage
     */
    readonly channelStorage?: CfnChannel.ChannelStorageProperty | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Channel.RetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html#cfn-iotanalytics-channel-retentionperiod
     */
    readonly retentionPeriod?: CfnChannel.RetentionPeriodProperty | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Channel.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html#cfn-iotanalytics-channel-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Channel`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html
 */
export declare class CfnChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTAnalytics::Channel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnChannel;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoTAnalytics::Channel.ChannelName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html#cfn-iotanalytics-channel-channelname
     */
    channelName: string;
    /**
     * `AWS::IoTAnalytics::Channel.ChannelStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html#cfn-iotanalytics-channel-channelstorage
     */
    channelStorage: CfnChannel.ChannelStorageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Channel.RetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html#cfn-iotanalytics-channel-retentionperiod
     */
    retentionPeriod: CfnChannel.RetentionPeriodProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Channel.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html#cfn-iotanalytics-channel-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTAnalytics::Channel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Channel`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-channelstorage.html
     */
    interface ChannelStorageProperty {
        /**
         * `CfnChannel.ChannelStorageProperty.CustomerManagedS3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-channelstorage.html#cfn-iotanalytics-channel-channelstorage-customermanageds3
         */
        readonly customerManagedS3?: CfnChannel.CustomerManagedS3Property | cdk.IResolvable;
        /**
         * `CfnChannel.ChannelStorageProperty.ServiceManagedS3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-channelstorage.html#cfn-iotanalytics-channel-channelstorage-servicemanageds3
         */
        readonly serviceManagedS3?: CfnChannel.ServiceManagedS3Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Channel`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-customermanageds3.html
     */
    interface CustomerManagedS3Property {
        /**
         * `CfnChannel.CustomerManagedS3Property.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-customermanageds3.html#cfn-iotanalytics-channel-customermanageds3-bucket
         */
        readonly bucket: string;
        /**
         * `CfnChannel.CustomerManagedS3Property.KeyPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-customermanageds3.html#cfn-iotanalytics-channel-customermanageds3-keyprefix
         */
        readonly keyPrefix?: string;
        /**
         * `CfnChannel.CustomerManagedS3Property.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-customermanageds3.html#cfn-iotanalytics-channel-customermanageds3-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Channel`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-retentionperiod.html
     */
    interface RetentionPeriodProperty {
        /**
         * `CfnChannel.RetentionPeriodProperty.NumberOfDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-retentionperiod.html#cfn-iotanalytics-channel-retentionperiod-numberofdays
         */
        readonly numberOfDays?: number;
        /**
         * `CfnChannel.RetentionPeriodProperty.Unlimited`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-retentionperiod.html#cfn-iotanalytics-channel-retentionperiod-unlimited
         */
        readonly unlimited?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Channel`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Channel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-channel.html
 */
export declare namespace CfnChannel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-channel-servicemanageds3.html
     */
    interface ServiceManagedS3Property {
    }
}
/**
 * Properties for defining a `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export interface CfnDatasetProps {
    /**
     * `AWS::IoTAnalytics::Dataset.Actions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-actions
     */
    readonly actions: Array<CfnDataset.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Dataset.DatasetName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-datasetname
     */
    readonly datasetName: string;
    /**
     * `AWS::IoTAnalytics::Dataset.ContentDeliveryRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-contentdeliveryrules
     */
    readonly contentDeliveryRules?: Array<CfnDataset.DatasetContentDeliveryRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Dataset.LateDataRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-latedatarules
     */
    readonly lateDataRules?: Array<CfnDataset.LateDataRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Dataset.RetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-retentionperiod
     */
    readonly retentionPeriod?: CfnDataset.RetentionPeriodProperty | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Dataset.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::IoTAnalytics::Dataset.Triggers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-triggers
     */
    readonly triggers?: Array<CfnDataset.TriggerProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Dataset.VersioningConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-versioningconfiguration
     */
    readonly versioningConfiguration?: CfnDataset.VersioningConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare class CfnDataset extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTAnalytics::Dataset";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataset;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoTAnalytics::Dataset.Actions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-actions
     */
    actions: Array<CfnDataset.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Dataset.DatasetName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-datasetname
     */
    datasetName: string;
    /**
     * `AWS::IoTAnalytics::Dataset.ContentDeliveryRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-contentdeliveryrules
     */
    contentDeliveryRules: Array<CfnDataset.DatasetContentDeliveryRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Dataset.LateDataRules`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-latedatarules
     */
    lateDataRules: Array<CfnDataset.LateDataRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Dataset.RetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-retentionperiod
     */
    retentionPeriod: CfnDataset.RetentionPeriodProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Dataset.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::IoTAnalytics::Dataset.Triggers`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-triggers
     */
    triggers: Array<CfnDataset.TriggerProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Dataset.VersioningConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html#cfn-iotanalytics-dataset-versioningconfiguration
     */
    versioningConfiguration: CfnDataset.VersioningConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::IoTAnalytics::Dataset`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDatasetProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html
     */
    interface ActionProperty {
        /**
         * `CfnDataset.ActionProperty.ActionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-actionname
         */
        readonly actionName: string;
        /**
         * `CfnDataset.ActionProperty.ContainerAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-containeraction
         */
        readonly containerAction?: CfnDataset.ContainerActionProperty | cdk.IResolvable;
        /**
         * `CfnDataset.ActionProperty.QueryAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-action.html#cfn-iotanalytics-dataset-action-queryaction
         */
        readonly queryAction?: CfnDataset.QueryActionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html
     */
    interface ContainerActionProperty {
        /**
         * `CfnDataset.ContainerActionProperty.ExecutionRoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-executionrolearn
         */
        readonly executionRoleArn: string;
        /**
         * `CfnDataset.ContainerActionProperty.Image`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-image
         */
        readonly image: string;
        /**
         * `CfnDataset.ContainerActionProperty.ResourceConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-resourceconfiguration
         */
        readonly resourceConfiguration: CfnDataset.ResourceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataset.ContainerActionProperty.Variables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-containeraction.html#cfn-iotanalytics-dataset-containeraction-variables
         */
        readonly variables?: Array<CfnDataset.VariableProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html
     */
    interface DatasetContentDeliveryRuleProperty {
        /**
         * `CfnDataset.DatasetContentDeliveryRuleProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html#cfn-iotanalytics-dataset-datasetcontentdeliveryrule-destination
         */
        readonly destination: CfnDataset.DatasetContentDeliveryRuleDestinationProperty | cdk.IResolvable;
        /**
         * `CfnDataset.DatasetContentDeliveryRuleProperty.EntryName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryrule.html#cfn-iotanalytics-dataset-datasetcontentdeliveryrule-entryname
         */
        readonly entryName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html
     */
    interface DatasetContentDeliveryRuleDestinationProperty {
        /**
         * `CfnDataset.DatasetContentDeliveryRuleDestinationProperty.IotEventsDestinationConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html#cfn-iotanalytics-dataset-datasetcontentdeliveryruledestination-ioteventsdestinationconfiguration
         */
        readonly iotEventsDestinationConfiguration?: CfnDataset.IotEventsDestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataset.DatasetContentDeliveryRuleDestinationProperty.S3DestinationConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentdeliveryruledestination.html#cfn-iotanalytics-dataset-datasetcontentdeliveryruledestination-s3destinationconfiguration
         */
        readonly s3DestinationConfiguration?: CfnDataset.S3DestinationConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentversionvalue.html
     */
    interface DatasetContentVersionValueProperty {
        /**
         * `CfnDataset.DatasetContentVersionValueProperty.DatasetName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-datasetcontentversionvalue.html#cfn-iotanalytics-dataset-datasetcontentversionvalue-datasetname
         */
        readonly datasetName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html
     */
    interface DeltaTimeProperty {
        /**
         * `CfnDataset.DeltaTimeProperty.OffsetSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html#cfn-iotanalytics-dataset-deltatime-offsetseconds
         */
        readonly offsetSeconds: number;
        /**
         * `CfnDataset.DeltaTimeProperty.TimeExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatime.html#cfn-iotanalytics-dataset-deltatime-timeexpression
         */
        readonly timeExpression: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatimesessionwindowconfiguration.html
     */
    interface DeltaTimeSessionWindowConfigurationProperty {
        /**
         * `CfnDataset.DeltaTimeSessionWindowConfigurationProperty.TimeoutInMinutes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-deltatimesessionwindowconfiguration.html#cfn-iotanalytics-dataset-deltatimesessionwindowconfiguration-timeoutinminutes
         */
        readonly timeoutInMinutes: number;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-filter.html
     */
    interface FilterProperty {
        /**
         * `CfnDataset.FilterProperty.DeltaTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-filter.html#cfn-iotanalytics-dataset-filter-deltatime
         */
        readonly deltaTime?: CfnDataset.DeltaTimeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html
     */
    interface GlueConfigurationProperty {
        /**
         * `CfnDataset.GlueConfigurationProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html#cfn-iotanalytics-dataset-glueconfiguration-databasename
         */
        readonly databaseName: string;
        /**
         * `CfnDataset.GlueConfigurationProperty.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-glueconfiguration.html#cfn-iotanalytics-dataset-glueconfiguration-tablename
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html
     */
    interface IotEventsDestinationConfigurationProperty {
        /**
         * `CfnDataset.IotEventsDestinationConfigurationProperty.InputName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html#cfn-iotanalytics-dataset-ioteventsdestinationconfiguration-inputname
         */
        readonly inputName: string;
        /**
         * `CfnDataset.IotEventsDestinationConfigurationProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-ioteventsdestinationconfiguration.html#cfn-iotanalytics-dataset-ioteventsdestinationconfiguration-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html
     */
    interface LateDataRuleProperty {
        /**
         * `CfnDataset.LateDataRuleProperty.RuleConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html#cfn-iotanalytics-dataset-latedatarule-ruleconfiguration
         */
        readonly ruleConfiguration: CfnDataset.LateDataRuleConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataset.LateDataRuleProperty.RuleName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedatarule.html#cfn-iotanalytics-dataset-latedatarule-rulename
         */
        readonly ruleName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedataruleconfiguration.html
     */
    interface LateDataRuleConfigurationProperty {
        /**
         * `CfnDataset.LateDataRuleConfigurationProperty.DeltaTimeSessionWindowConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-latedataruleconfiguration.html#cfn-iotanalytics-dataset-latedataruleconfiguration-deltatimesessionwindowconfiguration
         */
        readonly deltaTimeSessionWindowConfiguration?: CfnDataset.DeltaTimeSessionWindowConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-outputfileurivalue.html
     */
    interface OutputFileUriValueProperty {
        /**
         * `CfnDataset.OutputFileUriValueProperty.FileName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-outputfileurivalue.html#cfn-iotanalytics-dataset-outputfileurivalue-filename
         */
        readonly fileName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html
     */
    interface QueryActionProperty {
        /**
         * `CfnDataset.QueryActionProperty.Filters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html#cfn-iotanalytics-dataset-queryaction-filters
         */
        readonly filters?: Array<CfnDataset.FilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataset.QueryActionProperty.SqlQuery`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-queryaction.html#cfn-iotanalytics-dataset-queryaction-sqlquery
         */
        readonly sqlQuery: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html
     */
    interface ResourceConfigurationProperty {
        /**
         * `CfnDataset.ResourceConfigurationProperty.ComputeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html#cfn-iotanalytics-dataset-resourceconfiguration-computetype
         */
        readonly computeType: string;
        /**
         * `CfnDataset.ResourceConfigurationProperty.VolumeSizeInGB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-resourceconfiguration.html#cfn-iotanalytics-dataset-resourceconfiguration-volumesizeingb
         */
        readonly volumeSizeInGb: number;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html
     */
    interface RetentionPeriodProperty {
        /**
         * `CfnDataset.RetentionPeriodProperty.NumberOfDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html#cfn-iotanalytics-dataset-retentionperiod-numberofdays
         */
        readonly numberOfDays: number;
        /**
         * `CfnDataset.RetentionPeriodProperty.Unlimited`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-retentionperiod.html#cfn-iotanalytics-dataset-retentionperiod-unlimited
         */
        readonly unlimited: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html
     */
    interface S3DestinationConfigurationProperty {
        /**
         * `CfnDataset.S3DestinationConfigurationProperty.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-bucket
         */
        readonly bucket: string;
        /**
         * `CfnDataset.S3DestinationConfigurationProperty.GlueConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-glueconfiguration
         */
        readonly glueConfiguration?: CfnDataset.GlueConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataset.S3DestinationConfigurationProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-key
         */
        readonly key: string;
        /**
         * `CfnDataset.S3DestinationConfigurationProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-s3destinationconfiguration.html#cfn-iotanalytics-dataset-s3destinationconfiguration-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnDataset.ScheduleProperty.ScheduleExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-schedule.html#cfn-iotanalytics-dataset-schedule-scheduleexpression
         */
        readonly scheduleExpression: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html
     */
    interface TriggerProperty {
        /**
         * `CfnDataset.TriggerProperty.Schedule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html#cfn-iotanalytics-dataset-trigger-schedule
         */
        readonly schedule?: CfnDataset.ScheduleProperty | cdk.IResolvable;
        /**
         * `CfnDataset.TriggerProperty.TriggeringDataset`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-trigger.html#cfn-iotanalytics-dataset-trigger-triggeringdataset
         */
        readonly triggeringDataset?: CfnDataset.TriggeringDatasetProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-triggeringdataset.html
     */
    interface TriggeringDatasetProperty {
        /**
         * `CfnDataset.TriggeringDatasetProperty.DatasetName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-triggeringdataset.html#cfn-iotanalytics-dataset-triggeringdataset-datasetname
         */
        readonly datasetName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html
     */
    interface VariableProperty {
        /**
         * `CfnDataset.VariableProperty.DatasetContentVersionValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-datasetcontentversionvalue
         */
        readonly datasetContentVersionValue?: CfnDataset.DatasetContentVersionValueProperty | cdk.IResolvable;
        /**
         * `CfnDataset.VariableProperty.DoubleValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-doublevalue
         */
        readonly doubleValue?: number;
        /**
         * `CfnDataset.VariableProperty.OutputFileUriValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-outputfileurivalue
         */
        readonly outputFileUriValue?: CfnDataset.OutputFileUriValueProperty | cdk.IResolvable;
        /**
         * `CfnDataset.VariableProperty.StringValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-stringvalue
         */
        readonly stringValue?: string;
        /**
         * `CfnDataset.VariableProperty.VariableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-variable.html#cfn-iotanalytics-dataset-variable-variablename
         */
        readonly variableName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Dataset`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Dataset
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-dataset.html
 */
export declare namespace CfnDataset {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html
     */
    interface VersioningConfigurationProperty {
        /**
         * `CfnDataset.VersioningConfigurationProperty.MaxVersions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html#cfn-iotanalytics-dataset-versioningconfiguration-maxversions
         */
        readonly maxVersions?: number;
        /**
         * `CfnDataset.VersioningConfigurationProperty.Unlimited`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-dataset-versioningconfiguration.html#cfn-iotanalytics-dataset-versioningconfiguration-unlimited
         */
        readonly unlimited?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export interface CfnDatastoreProps {
    /**
     * `AWS::IoTAnalytics::Datastore.DatastoreName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorename
     */
    readonly datastoreName?: string;
    /**
     * `AWS::IoTAnalytics::Datastore.DatastorePartitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorepartitions
     */
    readonly datastorePartitions?: CfnDatastore.DatastorePartitionsProperty | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Datastore.DatastoreStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorestorage
     */
    readonly datastoreStorage?: CfnDatastore.DatastoreStorageProperty | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Datastore.FileFormatConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-fileformatconfiguration
     */
    readonly fileFormatConfiguration?: CfnDatastore.FileFormatConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Datastore.RetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-retentionperiod
     */
    readonly retentionPeriod?: CfnDatastore.RetentionPeriodProperty | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Datastore.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare class CfnDatastore extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTAnalytics::Datastore";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDatastore;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoTAnalytics::Datastore.DatastoreName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorename
     */
    datastoreName: string | undefined;
    /**
     * `AWS::IoTAnalytics::Datastore.DatastorePartitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorepartitions
     */
    datastorePartitions: CfnDatastore.DatastorePartitionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Datastore.DatastoreStorage`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-datastorestorage
     */
    datastoreStorage: CfnDatastore.DatastoreStorageProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Datastore.FileFormatConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-fileformatconfiguration
     */
    fileFormatConfiguration: CfnDatastore.FileFormatConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Datastore.RetentionPeriod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-retentionperiod
     */
    retentionPeriod: CfnDatastore.RetentionPeriodProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTAnalytics::Datastore.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html#cfn-iotanalytics-datastore-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTAnalytics::Datastore`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDatastoreProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html
     */
    interface ColumnProperty {
        /**
         * `CfnDatastore.ColumnProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html#cfn-iotanalytics-datastore-column-name
         */
        readonly name: string;
        /**
         * `CfnDatastore.ColumnProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-column.html#cfn-iotanalytics-datastore-column-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html
     */
    interface CustomerManagedS3Property {
        /**
         * `CfnDatastore.CustomerManagedS3Property.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-bucket
         */
        readonly bucket: string;
        /**
         * `CfnDatastore.CustomerManagedS3Property.KeyPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-keyprefix
         */
        readonly keyPrefix?: string;
        /**
         * `CfnDatastore.CustomerManagedS3Property.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3.html#cfn-iotanalytics-datastore-customermanageds3-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html
     */
    interface CustomerManagedS3StorageProperty {
        /**
         * `CfnDatastore.CustomerManagedS3StorageProperty.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html#cfn-iotanalytics-datastore-customermanageds3storage-bucket
         */
        readonly bucket: string;
        /**
         * `CfnDatastore.CustomerManagedS3StorageProperty.KeyPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-customermanageds3storage.html#cfn-iotanalytics-datastore-customermanageds3storage-keyprefix
         */
        readonly keyPrefix?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html
     */
    interface DatastorePartitionProperty {
        /**
         * `CfnDatastore.DatastorePartitionProperty.Partition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html#cfn-iotanalytics-datastore-datastorepartition-partition
         */
        readonly partition?: CfnDatastore.PartitionProperty | cdk.IResolvable;
        /**
         * `CfnDatastore.DatastorePartitionProperty.TimestampPartition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartition.html#cfn-iotanalytics-datastore-datastorepartition-timestamppartition
         */
        readonly timestampPartition?: CfnDatastore.TimestampPartitionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartitions.html
     */
    interface DatastorePartitionsProperty {
        /**
         * `CfnDatastore.DatastorePartitionsProperty.Partitions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorepartitions.html#cfn-iotanalytics-datastore-datastorepartitions-partitions
         */
        readonly partitions?: Array<CfnDatastore.DatastorePartitionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html
     */
    interface DatastoreStorageProperty {
        /**
         * `CfnDatastore.DatastoreStorageProperty.CustomerManagedS3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-customermanageds3
         */
        readonly customerManagedS3?: CfnDatastore.CustomerManagedS3Property | cdk.IResolvable;
        /**
         * `CfnDatastore.DatastoreStorageProperty.IotSiteWiseMultiLayerStorage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-iotsitewisemultilayerstorage
         */
        readonly iotSiteWiseMultiLayerStorage?: CfnDatastore.IotSiteWiseMultiLayerStorageProperty | cdk.IResolvable;
        /**
         * `CfnDatastore.DatastoreStorageProperty.ServiceManagedS3`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-datastorestorage.html#cfn-iotanalytics-datastore-datastorestorage-servicemanageds3
         */
        readonly serviceManagedS3?: CfnDatastore.ServiceManagedS3Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html
     */
    interface FileFormatConfigurationProperty {
        /**
         * `CfnDatastore.FileFormatConfigurationProperty.JsonConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html#cfn-iotanalytics-datastore-fileformatconfiguration-jsonconfiguration
         */
        readonly jsonConfiguration?: CfnDatastore.JsonConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDatastore.FileFormatConfigurationProperty.ParquetConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-fileformatconfiguration.html#cfn-iotanalytics-datastore-fileformatconfiguration-parquetconfiguration
         */
        readonly parquetConfiguration?: CfnDatastore.ParquetConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-iotsitewisemultilayerstorage.html
     */
    interface IotSiteWiseMultiLayerStorageProperty {
        /**
         * `CfnDatastore.IotSiteWiseMultiLayerStorageProperty.CustomerManagedS3Storage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-iotsitewisemultilayerstorage.html#cfn-iotanalytics-datastore-iotsitewisemultilayerstorage-customermanageds3storage
         */
        readonly customerManagedS3Storage?: CfnDatastore.CustomerManagedS3StorageProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-jsonconfiguration.html
     */
    interface JsonConfigurationProperty {
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-parquetconfiguration.html
     */
    interface ParquetConfigurationProperty {
        /**
         * `CfnDatastore.ParquetConfigurationProperty.SchemaDefinition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-parquetconfiguration.html#cfn-iotanalytics-datastore-parquetconfiguration-schemadefinition
         */
        readonly schemaDefinition?: CfnDatastore.SchemaDefinitionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-partition.html
     */
    interface PartitionProperty {
        /**
         * `CfnDatastore.PartitionProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-partition.html#cfn-iotanalytics-datastore-partition-attributename
         */
        readonly attributeName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html
     */
    interface RetentionPeriodProperty {
        /**
         * `CfnDatastore.RetentionPeriodProperty.NumberOfDays`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html#cfn-iotanalytics-datastore-retentionperiod-numberofdays
         */
        readonly numberOfDays?: number;
        /**
         * `CfnDatastore.RetentionPeriodProperty.Unlimited`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-retentionperiod.html#cfn-iotanalytics-datastore-retentionperiod-unlimited
         */
        readonly unlimited?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-schemadefinition.html
     */
    interface SchemaDefinitionProperty {
        /**
         * `CfnDatastore.SchemaDefinitionProperty.Columns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-schemadefinition.html#cfn-iotanalytics-datastore-schemadefinition-columns
         */
        readonly columns?: Array<CfnDatastore.ColumnProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-servicemanageds3.html
     */
    interface ServiceManagedS3Property {
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Datastore`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Datastore
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-datastore.html
 */
export declare namespace CfnDatastore {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html
     */
    interface TimestampPartitionProperty {
        /**
         * `CfnDatastore.TimestampPartitionProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html#cfn-iotanalytics-datastore-timestamppartition-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnDatastore.TimestampPartitionProperty.TimestampFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-datastore-timestamppartition.html#cfn-iotanalytics-datastore-timestamppartition-timestampformat
         */
        readonly timestampFormat?: string;
    }
}
/**
 * Properties for defining a `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export interface CfnPipelineProps {
    /**
     * `AWS::IoTAnalytics::Pipeline.PipelineActivities`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html#cfn-iotanalytics-pipeline-pipelineactivities
     */
    readonly pipelineActivities: Array<CfnPipeline.ActivityProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Pipeline.PipelineName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html#cfn-iotanalytics-pipeline-pipelinename
     */
    readonly pipelineName: string;
    /**
     * `AWS::IoTAnalytics::Pipeline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html#cfn-iotanalytics-pipeline-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare class CfnPipeline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTAnalytics::Pipeline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPipeline;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoTAnalytics::Pipeline.PipelineActivities`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html#cfn-iotanalytics-pipeline-pipelineactivities
     */
    pipelineActivities: Array<CfnPipeline.ActivityProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::IoTAnalytics::Pipeline.PipelineName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html#cfn-iotanalytics-pipeline-pipelinename
     */
    pipelineName: string;
    /**
     * `AWS::IoTAnalytics::Pipeline.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html#cfn-iotanalytics-pipeline-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTAnalytics::Pipeline`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPipelineProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html
     */
    interface ActivityProperty {
        /**
         * `CfnPipeline.ActivityProperty.AddAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-addattributes
         */
        readonly addAttributes?: CfnPipeline.AddAttributesProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.Channel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-channel
         */
        readonly channel?: CfnPipeline.ChannelProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.Datastore`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-datastore
         */
        readonly datastore?: CfnPipeline.DatastoreProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.DeviceRegistryEnrich`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-deviceregistryenrich
         */
        readonly deviceRegistryEnrich?: CfnPipeline.DeviceRegistryEnrichProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.DeviceShadowEnrich`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-deviceshadowenrich
         */
        readonly deviceShadowEnrich?: CfnPipeline.DeviceShadowEnrichProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.Filter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-filter
         */
        readonly filter?: CfnPipeline.FilterProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.Lambda`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-lambda
         */
        readonly lambda?: CfnPipeline.LambdaProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.Math`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-math
         */
        readonly math?: CfnPipeline.MathProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.RemoveAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-removeattributes
         */
        readonly removeAttributes?: CfnPipeline.RemoveAttributesProperty | cdk.IResolvable;
        /**
         * `CfnPipeline.ActivityProperty.SelectAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-activity.html#cfn-iotanalytics-pipeline-activity-selectattributes
         */
        readonly selectAttributes?: CfnPipeline.SelectAttributesProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-addattributes.html
     */
    interface AddAttributesProperty {
        /**
         * `CfnPipeline.AddAttributesProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-addattributes.html#cfn-iotanalytics-pipeline-addattributes-attributes
         */
        readonly attributes: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnPipeline.AddAttributesProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-addattributes.html#cfn-iotanalytics-pipeline-addattributes-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.AddAttributesProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-addattributes.html#cfn-iotanalytics-pipeline-addattributes-next
         */
        readonly next?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-channel.html
     */
    interface ChannelProperty {
        /**
         * `CfnPipeline.ChannelProperty.ChannelName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-channel.html#cfn-iotanalytics-pipeline-channel-channelname
         */
        readonly channelName: string;
        /**
         * `CfnPipeline.ChannelProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-channel.html#cfn-iotanalytics-pipeline-channel-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.ChannelProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-channel.html#cfn-iotanalytics-pipeline-channel-next
         */
        readonly next?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-datastore.html
     */
    interface DatastoreProperty {
        /**
         * `CfnPipeline.DatastoreProperty.DatastoreName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-datastore.html#cfn-iotanalytics-pipeline-datastore-datastorename
         */
        readonly datastoreName: string;
        /**
         * `CfnPipeline.DatastoreProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-datastore.html#cfn-iotanalytics-pipeline-datastore-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceregistryenrich.html
     */
    interface DeviceRegistryEnrichProperty {
        /**
         * `CfnPipeline.DeviceRegistryEnrichProperty.Attribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceregistryenrich.html#cfn-iotanalytics-pipeline-deviceregistryenrich-attribute
         */
        readonly attribute: string;
        /**
         * `CfnPipeline.DeviceRegistryEnrichProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceregistryenrich.html#cfn-iotanalytics-pipeline-deviceregistryenrich-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.DeviceRegistryEnrichProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceregistryenrich.html#cfn-iotanalytics-pipeline-deviceregistryenrich-next
         */
        readonly next?: string;
        /**
         * `CfnPipeline.DeviceRegistryEnrichProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceregistryenrich.html#cfn-iotanalytics-pipeline-deviceregistryenrich-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnPipeline.DeviceRegistryEnrichProperty.ThingName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceregistryenrich.html#cfn-iotanalytics-pipeline-deviceregistryenrich-thingname
         */
        readonly thingName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceshadowenrich.html
     */
    interface DeviceShadowEnrichProperty {
        /**
         * `CfnPipeline.DeviceShadowEnrichProperty.Attribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceshadowenrich.html#cfn-iotanalytics-pipeline-deviceshadowenrich-attribute
         */
        readonly attribute: string;
        /**
         * `CfnPipeline.DeviceShadowEnrichProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceshadowenrich.html#cfn-iotanalytics-pipeline-deviceshadowenrich-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.DeviceShadowEnrichProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceshadowenrich.html#cfn-iotanalytics-pipeline-deviceshadowenrich-next
         */
        readonly next?: string;
        /**
         * `CfnPipeline.DeviceShadowEnrichProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceshadowenrich.html#cfn-iotanalytics-pipeline-deviceshadowenrich-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnPipeline.DeviceShadowEnrichProperty.ThingName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-deviceshadowenrich.html#cfn-iotanalytics-pipeline-deviceshadowenrich-thingname
         */
        readonly thingName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-filter.html
     */
    interface FilterProperty {
        /**
         * `CfnPipeline.FilterProperty.Filter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-filter.html#cfn-iotanalytics-pipeline-filter-filter
         */
        readonly filter: string;
        /**
         * `CfnPipeline.FilterProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-filter.html#cfn-iotanalytics-pipeline-filter-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.FilterProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-filter.html#cfn-iotanalytics-pipeline-filter-next
         */
        readonly next?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-lambda.html
     */
    interface LambdaProperty {
        /**
         * `CfnPipeline.LambdaProperty.BatchSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-lambda.html#cfn-iotanalytics-pipeline-lambda-batchsize
         */
        readonly batchSize: number;
        /**
         * `CfnPipeline.LambdaProperty.LambdaName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-lambda.html#cfn-iotanalytics-pipeline-lambda-lambdaname
         */
        readonly lambdaName: string;
        /**
         * `CfnPipeline.LambdaProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-lambda.html#cfn-iotanalytics-pipeline-lambda-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.LambdaProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-lambda.html#cfn-iotanalytics-pipeline-lambda-next
         */
        readonly next?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-math.html
     */
    interface MathProperty {
        /**
         * `CfnPipeline.MathProperty.Attribute`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-math.html#cfn-iotanalytics-pipeline-math-attribute
         */
        readonly attribute: string;
        /**
         * `CfnPipeline.MathProperty.Math`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-math.html#cfn-iotanalytics-pipeline-math-math
         */
        readonly math: string;
        /**
         * `CfnPipeline.MathProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-math.html#cfn-iotanalytics-pipeline-math-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.MathProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-math.html#cfn-iotanalytics-pipeline-math-next
         */
        readonly next?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-removeattributes.html
     */
    interface RemoveAttributesProperty {
        /**
         * `CfnPipeline.RemoveAttributesProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-removeattributes.html#cfn-iotanalytics-pipeline-removeattributes-attributes
         */
        readonly attributes: string[];
        /**
         * `CfnPipeline.RemoveAttributesProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-removeattributes.html#cfn-iotanalytics-pipeline-removeattributes-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.RemoveAttributesProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-removeattributes.html#cfn-iotanalytics-pipeline-removeattributes-next
         */
        readonly next?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTAnalytics::Pipeline`.
 *
 * @external
 * @cloudformationResource AWS::IoTAnalytics::Pipeline
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotanalytics-pipeline.html
 */
export declare namespace CfnPipeline {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-selectattributes.html
     */
    interface SelectAttributesProperty {
        /**
         * `CfnPipeline.SelectAttributesProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-selectattributes.html#cfn-iotanalytics-pipeline-selectattributes-attributes
         */
        readonly attributes: string[];
        /**
         * `CfnPipeline.SelectAttributesProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-selectattributes.html#cfn-iotanalytics-pipeline-selectattributes-name
         */
        readonly name: string;
        /**
         * `CfnPipeline.SelectAttributesProperty.Next`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotanalytics-pipeline-selectattributes.html#cfn-iotanalytics-pipeline-selectattributes-next
         */
        readonly next?: string;
    }
}
