[![Python versions](https://img.shields.io/pypi/pyversions/disnake-debug.svg)](https://pypi.python.org/pypi/disnake-debug)
[![License](https://img.shields.io/pypi/l/disnake-debug.svg)](https://github.com/CaedenPH/disnake-debug/blob/master/LICENSE)
[![Status](https://img.shields.io/pypi/status/disnake-debug.svg)](https://pypi.python.org/pypi/disnake-debug)
[![Issues](https://img.shields.io/github/issues/CaedenPH/disnake-debug.svg?colorB=3333ff)](https://github.com/CaedenPH/disnake-debug/issues)
[![Commit activity](https://img.shields.io/github/commit-activity/w/CaedenPH/disnake-debug.svg)](https://github.com/CaedenPH/disnake-debug/commits)


<h1 align="center">
<sub>
    <img src="data:image/png;base64,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" height="36">
</sub>
&nbsp;
disnake-debug
</h1>
<p align="center">
<sup>
a debugging and utility extension for disnake bots
</sup>
<br>
</p>

***

disnake-debug is an extension for bot developers that enables rapid prototyping, experimentation, and debugging of features for bots.
features include easy blacklisting, dynamically change bot avatar and name, pause and unpause the bot (stop it from responding to commands until unpaused), evaluate code (normal, return and dir), leave guilds, speak as the bot, view invokes and view bot statistics

One of disnake-debug's core philosophies is to be dynamic and easy-to-use. Here's the two step install:

> 1. Download disnake-debug on the command line using pip:
> ```bash
> pip install -U disnake-debug
> ```
> 2. Load the extension in your bot code before it runs:
> ```python
> bot.load_extension('disnake-debug')
> ```
> That's it!

How to use debug:

> Once the extension is loaded and the bot is online you can just run the debug command 
> If your prefix is . you would run `.debug`

How to configure the database (sqlite) location:
> In your .env, put `DATABASE_PATH=your_path`
> Make sure there is a database.db file in your_path

Configure the embed colors:
> In your .env replace `EMBED_COLOR` with a hex color
> `EMBED_COLOR` is automatically created and added to your `.env`

Simple bot example with disnake-debug:

> ```py
> from dotenv import load_dotenv # import load_dotenv to load your .env file
> from os import environ # import environ 
> from disnake import Intents # import intents
> from disnake.ext.commands import Bot # import Bot class
>
> bot = Bot(
>    command_prefix=".", # your command prefix
>    owner_ids=[298043305927639041], # put your owner id in here
>    intents=Intents.all() # so you can see users (required for blacklist)
> )
> bot.load_extension("disnake-debug") # load debug extension. one command and that is debug
> 
> @bot.event
> async def on_ready() -> None:
>    print(f"Logged in as {bot.user}")
>
> if __name__ == "__main__":
>    load_dotenv()
>    bot.run(environ["TOKEN"])
> ```