May 6, 2019.
Cambridge, MA.

# End of Semester Plan

It is time to wrap up my SayTeX development. This has been a fun and rewarding project to work on, teaching me formal grammars (even though they did not end up being used) as well as how to package and distribute Python projects.

There are a couple of things that still need to be done, listed below:

- Finish up all layers. In addition to all layers listed in blogpost 3, I want to add a layer that can recognize "f of x" as "f(x)". Also, make the "over" better so that it recognizes parenthesis and function expressions which honestly shouldn't be that hard (again, it is only heuristics, which is why a formal grammar would not have been the perfect choice anyway)
- Implement the configuration file in a better way, in order for it to be easily modifiable by a user who just installs SayTeX using PyPI (should the layer options be in a configuration file or should they be supplied as parameters to Saytex initialization? I think having a default in the configuration and then being able to disable or enable certain layers in the initialization sounds like a good mix, but I'm not entirely sure).
- Write some more tests.
- Package this version (not 1.0 yet)
- Update the demo website to use the new version, and have it show both the natural language input, the saytex version, the latex version, and the displayed equation. Remove the wolfram alpha part because that should not be necessary anymore. Maybe use KaTeX instead of MathJax since the performance might be better making for a better demo.
- Write some good documentation in Read the docs, which should be possible by combining a lot of stuff that I've already written in a lot of different places, as well as adding some new usage instructions for the python package. Have one section that describes the general idea (with the saytex language thing) and then one which describes how to use saytex.
- Try to fix the github repository to ignore the microsoft speech api file so that the project is listed as python since it is indeed python and not javascript at all.
- Finally, fix the website. Take cues from katex.org, since their website is really nice. Link to installation instructions, demo on separate page, github and documentation. Maybe don't need separation of the demo into an api and a frontend if we just do flask on the frontend since it's after all just a demo. Yeah, I could just have that point to the demo.saytex.xyz/api/blablabla which can live on the same server.
- Update the README (what should it include? take cues from other projects).
- Test everything once more. Both the unit tests and maybe do some integration tests as well, either automated or hand made.
- Finally, release version 1.0.0 to the world, on pypi and on github. Make sure everything is clean and nice and no typos.
- All done! SayTeX has become a mature project!