# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GetFlowResult',
    'AwaitableGetFlowResult',
    'get_flow',
    'get_flow_output',
]

@pulumi.output_type
class GetFlowResult:
    def __init__(__self__, flow_arn=None, flow_availability_zone=None, source=None, source_failover_config=None):
        if flow_arn and not isinstance(flow_arn, str):
            raise TypeError("Expected argument 'flow_arn' to be a str")
        pulumi.set(__self__, "flow_arn", flow_arn)
        if flow_availability_zone and not isinstance(flow_availability_zone, str):
            raise TypeError("Expected argument 'flow_availability_zone' to be a str")
        pulumi.set(__self__, "flow_availability_zone", flow_availability_zone)
        if source and not isinstance(source, dict):
            raise TypeError("Expected argument 'source' to be a dict")
        pulumi.set(__self__, "source", source)
        if source_failover_config and not isinstance(source_failover_config, dict):
            raise TypeError("Expected argument 'source_failover_config' to be a dict")
        pulumi.set(__self__, "source_failover_config", source_failover_config)

    @property
    @pulumi.getter(name="flowArn")
    def flow_arn(self) -> Optional[str]:
        """
        The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
        """
        return pulumi.get(self, "flow_arn")

    @property
    @pulumi.getter(name="flowAvailabilityZone")
    def flow_availability_zone(self) -> Optional[str]:
        """
        The Availability Zone that you want to create the flow in. These options are limited to the Availability Zones within the current AWS.(ReadOnly)
        """
        return pulumi.get(self, "flow_availability_zone")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.FlowSource']:
        """
        The source of the flow.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceFailoverConfig")
    def source_failover_config(self) -> Optional['outputs.FlowFailoverConfig']:
        """
        The source failover config of the flow.
        """
        return pulumi.get(self, "source_failover_config")


class AwaitableGetFlowResult(GetFlowResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlowResult(
            flow_arn=self.flow_arn,
            flow_availability_zone=self.flow_availability_zone,
            source=self.source,
            source_failover_config=self.source_failover_config)


def get_flow(flow_arn: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlowResult:
    """
    Resource schema for AWS::MediaConnect::Flow


    :param str flow_arn: The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
    """
    __args__ = dict()
    __args__['flowArn'] = flow_arn
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aws-native:mediaconnect:getFlow', __args__, opts=opts, typ=GetFlowResult).value

    return AwaitableGetFlowResult(
        flow_arn=__ret__.flow_arn,
        flow_availability_zone=__ret__.flow_availability_zone,
        source=__ret__.source,
        source_failover_config=__ret__.source_failover_config)


@_utilities.lift_output_func(get_flow)
def get_flow_output(flow_arn: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlowResult]:
    """
    Resource schema for AWS::MediaConnect::Flow


    :param str flow_arn: The Amazon Resource Name (ARN), a unique identifier for any AWS resource, of the flow.
    """
    ...
