# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 runtime_environment: pulumi.Input[str],
                 service_execution_role: pulumi.Input[str],
                 application_configuration: Optional[pulumi.Input['ApplicationConfigurationArgs']] = None,
                 application_description: Optional[pulumi.Input[str]] = None,
                 application_mode: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationTagArgs']]]] = None):
        """
        The set of arguments for constructing a Application resource.
        """
        pulumi.set(__self__, "runtime_environment", runtime_environment)
        pulumi.set(__self__, "service_execution_role", service_execution_role)
        if application_configuration is not None:
            pulumi.set(__self__, "application_configuration", application_configuration)
        if application_description is not None:
            pulumi.set(__self__, "application_description", application_description)
        if application_mode is not None:
            pulumi.set(__self__, "application_mode", application_mode)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="runtimeEnvironment")
    def runtime_environment(self) -> pulumi.Input[str]:
        return pulumi.get(self, "runtime_environment")

    @runtime_environment.setter
    def runtime_environment(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime_environment", value)

    @property
    @pulumi.getter(name="serviceExecutionRole")
    def service_execution_role(self) -> pulumi.Input[str]:
        return pulumi.get(self, "service_execution_role")

    @service_execution_role.setter
    def service_execution_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_execution_role", value)

    @property
    @pulumi.getter(name="applicationConfiguration")
    def application_configuration(self) -> Optional[pulumi.Input['ApplicationConfigurationArgs']]:
        return pulumi.get(self, "application_configuration")

    @application_configuration.setter
    def application_configuration(self, value: Optional[pulumi.Input['ApplicationConfigurationArgs']]):
        pulumi.set(self, "application_configuration", value)

    @property
    @pulumi.getter(name="applicationDescription")
    def application_description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "application_description")

    @application_description.setter
    def application_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_description", value)

    @property
    @pulumi.getter(name="applicationMode")
    def application_mode(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "application_mode")

    @application_mode.setter
    def application_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_mode", value)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationTagArgs']]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationTagArgs']]]]):
        pulumi.set(self, "tags", value)


warnings.warn("""Application is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class Application(pulumi.CustomResource):
    warnings.warn("""Application is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configuration: Optional[pulumi.Input[pulumi.InputType['ApplicationConfigurationArgs']]] = None,
                 application_description: Optional[pulumi.Input[str]] = None,
                 application_mode: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 runtime_environment: Optional[pulumi.Input[str]] = None,
                 service_execution_role: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::KinesisAnalyticsV2::Application

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::KinesisAnalyticsV2::Application

        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configuration: Optional[pulumi.Input[pulumi.InputType['ApplicationConfigurationArgs']]] = None,
                 application_description: Optional[pulumi.Input[str]] = None,
                 application_mode: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 runtime_environment: Optional[pulumi.Input[str]] = None,
                 service_execution_role: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApplicationTagArgs']]]]] = None,
                 __props__=None):
        pulumi.log.warn("""Application is deprecated: Application is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["application_configuration"] = application_configuration
            __props__.__dict__["application_description"] = application_description
            __props__.__dict__["application_mode"] = application_mode
            __props__.__dict__["application_name"] = application_name
            if runtime_environment is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_environment'")
            __props__.__dict__["runtime_environment"] = runtime_environment
            if service_execution_role is None and not opts.urn:
                raise TypeError("Missing required property 'service_execution_role'")
            __props__.__dict__["service_execution_role"] = service_execution_role
            __props__.__dict__["tags"] = tags
        super(Application, __self__).__init__(
            'aws-native:kinesisanalyticsv2:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = ApplicationArgs.__new__(ApplicationArgs)

        __props__.__dict__["application_configuration"] = None
        __props__.__dict__["application_description"] = None
        __props__.__dict__["application_mode"] = None
        __props__.__dict__["application_name"] = None
        __props__.__dict__["runtime_environment"] = None
        __props__.__dict__["service_execution_role"] = None
        __props__.__dict__["tags"] = None
        return Application(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationConfiguration")
    def application_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationConfiguration']]:
        return pulumi.get(self, "application_configuration")

    @property
    @pulumi.getter(name="applicationDescription")
    def application_description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "application_description")

    @property
    @pulumi.getter(name="applicationMode")
    def application_mode(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "application_mode")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="runtimeEnvironment")
    def runtime_environment(self) -> pulumi.Output[str]:
        return pulumi.get(self, "runtime_environment")

    @property
    @pulumi.getter(name="serviceExecutionRole")
    def service_execution_role(self) -> pulumi.Output[str]:
        return pulumi.get(self, "service_execution_role")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationTag']]]:
        return pulumi.get(self, "tags")

