# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AliasRoutingStrategy',
    'BuildS3Location',
    'FleetCertificateConfiguration',
    'FleetIpPermission',
    'FleetLocationCapacity',
    'FleetLocationConfiguration',
    'FleetResourceCreationLimitPolicy',
    'FleetRuntimeConfiguration',
    'FleetServerProcess',
    'GameServerGroupAutoScalingPolicy',
    'GameServerGroupInstanceDefinition',
    'GameServerGroupLaunchTemplate',
    'GameServerGroupTag',
    'GameServerGroupTargetTrackingConfiguration',
    'GameSessionQueueDestination',
    'GameSessionQueueFilterConfiguration',
    'GameSessionQueuePlayerLatencyPolicy',
    'GameSessionQueuePriorityConfiguration',
    'GameSessionQueueTag',
    'MatchmakingConfigurationGameProperty',
    'MatchmakingConfigurationTag',
    'MatchmakingRuleSetTag',
    'ScriptS3Location',
    'ScriptTag',
]

@pulumi.output_type
class AliasRoutingStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fleetId":
            suggest = "fleet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasRoutingStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasRoutingStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasRoutingStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: 'AliasRoutingStrategyType',
                 fleet_id: Optional[str] = None,
                 message: Optional[str] = None):
        """
        :param 'AliasRoutingStrategyType' type: Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        :param str fleet_id: A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        :param str message: The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        pulumi.set(__self__, "type", type)
        if fleet_id is not None:
            pulumi.set(__self__, "fleet_id", fleet_id)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def type(self) -> 'AliasRoutingStrategyType':
        """
        Simple routing strategy. The alias resolves to one specific fleet. Use this type when routing to active fleets.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> Optional[str]:
        """
        A unique identifier for a fleet that the alias points to. If you specify SIMPLE for the Type property, you must specify this property.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        The message text to be used with a terminal routing strategy. If you specify TERMINAL for the Type property, you must specify this property.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class BuildS3Location(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "objectVersion":
            suggest = "object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 role_arn: str,
                 object_version: Optional[str] = None):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[str]:
        return pulumi.get(self, "object_version")


@pulumi.output_type
class FleetCertificateConfiguration(dict):
    """
    Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateType":
            suggest = "certificate_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetCertificateConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetCertificateConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetCertificateConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_type: 'FleetCertificateConfigurationCertificateType'):
        """
        Information about the use of a TLS/SSL certificate for a fleet. TLS certificate generation is enabled at the fleet level, with one certificate generated for the fleet. When this feature is enabled, the certificate can be retrieved using the GameLift Server SDK call GetInstanceCertificate. All instances in a fleet share the same certificate.
        """
        pulumi.set(__self__, "certificate_type", certificate_type)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> 'FleetCertificateConfigurationCertificateType':
        return pulumi.get(self, "certificate_type")


@pulumi.output_type
class FleetIpPermission(dict):
    """
    A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fromPort":
            suggest = "from_port"
        elif key == "ipRange":
            suggest = "ip_range"
        elif key == "toPort":
            suggest = "to_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetIpPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetIpPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetIpPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 from_port: int,
                 ip_range: str,
                 protocol: 'FleetIpPermissionProtocol',
                 to_port: int):
        """
        A range of IP addresses and port settings that allow inbound traffic to connect to server processes on an Amazon GameLift hosting resource. New game sessions that are started on the fleet are assigned an IP address/port number combination, which must fall into the fleet's allowed ranges. For fleets created with a custom game server, the ranges reflect the server's game session assignments. For Realtime Servers fleets, Amazon GameLift automatically opens two port ranges, one for TCP messaging and one for UDP, for use by the Realtime servers.
        :param int from_port: A starting value for a range of allowed port numbers.
        :param str ip_range: A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        :param 'FleetIpPermissionProtocol' protocol: The network communication protocol used by the fleet.
        :param int to_port: An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "ip_range", ip_range)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> int:
        """
        A starting value for a range of allowed port numbers.
        """
        return pulumi.get(self, "from_port")

    @property
    @pulumi.getter(name="ipRange")
    def ip_range(self) -> str:
        """
        A range of allowed IP addresses. This value must be expressed in CIDR notation. Example: "000.000.000.000/[subnet mask]" or optionally the shortened version "0.0.0.0/[subnet mask]".
        """
        return pulumi.get(self, "ip_range")

    @property
    @pulumi.getter
    def protocol(self) -> 'FleetIpPermissionProtocol':
        """
        The network communication protocol used by the fleet.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> int:
        """
        An ending value for a range of allowed port numbers. Port numbers are end-inclusive. This value must be higher than FromPort.
        """
        return pulumi.get(self, "to_port")


@pulumi.output_type
class FleetLocationCapacity(dict):
    """
    Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "desiredEC2Instances":
            suggest = "desired_ec2_instances"
        elif key == "maxSize":
            suggest = "max_size"
        elif key == "minSize":
            suggest = "min_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetLocationCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetLocationCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetLocationCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 desired_ec2_instances: int,
                 max_size: int,
                 min_size: int):
        """
        Current resource capacity settings in a specified fleet or location. The location value might refer to a fleet's remote location or its home Region.
        :param int desired_ec2_instances: The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        :param int max_size: The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        :param int min_size: The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        pulumi.set(__self__, "desired_ec2_instances", desired_ec2_instances)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)

    @property
    @pulumi.getter(name="desiredEC2Instances")
    def desired_ec2_instances(self) -> int:
        """
        The number of EC2 instances you want to maintain in the specified fleet location. This value must fall between the minimum and maximum size limits.
        """
        return pulumi.get(self, "desired_ec2_instances")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> int:
        """
        The maximum value that is allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "1". Once the fleet is active, you can change this value.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> int:
        """
        The minimum value allowed for the fleet's instance count for a location. When creating a new fleet, GameLift automatically sets this value to "0". After the fleet is active, you can change this value.
        """
        return pulumi.get(self, "min_size")


@pulumi.output_type
class FleetLocationConfiguration(dict):
    """
    A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationCapacity":
            suggest = "location_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetLocationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetLocationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetLocationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: str,
                 location_capacity: Optional['outputs.FleetLocationCapacity'] = None):
        """
        A remote location where a multi-location fleet can deploy EC2 instances for game hosting.
        """
        pulumi.set(__self__, "location", location)
        if location_capacity is not None:
            pulumi.set(__self__, "location_capacity", location_capacity)

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationCapacity")
    def location_capacity(self) -> Optional['outputs.FleetLocationCapacity']:
        return pulumi.get(self, "location_capacity")


@pulumi.output_type
class FleetResourceCreationLimitPolicy(dict):
    """
    A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

    The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "newGameSessionsPerCreator":
            suggest = "new_game_sessions_per_creator"
        elif key == "policyPeriodInMinutes":
            suggest = "policy_period_in_minutes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetResourceCreationLimitPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetResourceCreationLimitPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetResourceCreationLimitPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 new_game_sessions_per_creator: Optional[int] = None,
                 policy_period_in_minutes: Optional[int] = None):
        """
        A policy that limits the number of game sessions a player can create on the same fleet. This optional policy gives game owners control over how players can consume available game server resources. A resource creation policy makes the following statement: "An individual player can create a maximum number of new game sessions within a specified time period".

        The policy is evaluated when a player tries to create a new game session. For example, assume you have a policy of 10 new game sessions and a time period of 60 minutes. On receiving a CreateGameSession request, Amazon GameLift checks that the player (identified by CreatorId) has created fewer than 10 game sessions in the past 60 minutes.
        :param int new_game_sessions_per_creator: The maximum number of game sessions that an individual can create during the policy period.
        :param int policy_period_in_minutes: The time span used in evaluating the resource creation limit policy.
        """
        if new_game_sessions_per_creator is not None:
            pulumi.set(__self__, "new_game_sessions_per_creator", new_game_sessions_per_creator)
        if policy_period_in_minutes is not None:
            pulumi.set(__self__, "policy_period_in_minutes", policy_period_in_minutes)

    @property
    @pulumi.getter(name="newGameSessionsPerCreator")
    def new_game_sessions_per_creator(self) -> Optional[int]:
        """
        The maximum number of game sessions that an individual can create during the policy period.
        """
        return pulumi.get(self, "new_game_sessions_per_creator")

    @property
    @pulumi.getter(name="policyPeriodInMinutes")
    def policy_period_in_minutes(self) -> Optional[int]:
        """
        The time span used in evaluating the resource creation limit policy.
        """
        return pulumi.get(self, "policy_period_in_minutes")


@pulumi.output_type
class FleetRuntimeConfiguration(dict):
    """
    A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

    The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

    An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gameSessionActivationTimeoutSeconds":
            suggest = "game_session_activation_timeout_seconds"
        elif key == "maxConcurrentGameSessionActivations":
            suggest = "max_concurrent_game_session_activations"
        elif key == "serverProcesses":
            suggest = "server_processes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetRuntimeConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetRuntimeConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetRuntimeConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 game_session_activation_timeout_seconds: Optional[int] = None,
                 max_concurrent_game_session_activations: Optional[int] = None,
                 server_processes: Optional[Sequence['outputs.FleetServerProcess']] = None):
        """
        A collection of server process configurations that describe the processes to run on each instance in a fleet. All fleets must have a runtime configuration. Each instance in the fleet maintains server processes as specified in the runtime configuration, launching new ones as existing processes end. Each instance regularly checks for an updated runtime configuration makes adjustments as called for.

        The runtime configuration enables the instances in a fleet to run multiple processes simultaneously. Potential scenarios are as follows: (1) Run multiple processes of a single game server executable to maximize usage of your hosting resources. (2) Run one or more processes of different executables, such as your game server and a metrics tracking program. (3) Run multiple processes of a single game server but with different launch parameters, for example to run one process on each instance in debug mode.

        An Amazon GameLift instance is limited to 50 processes running simultaneously. A runtime configuration must specify fewer than this limit. To calculate the total number of processes specified in a runtime configuration, add the values of the ConcurrentExecutions parameter for each ServerProcess object in the runtime configuration.
        :param int game_session_activation_timeout_seconds: The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        :param int max_concurrent_game_session_activations: The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        :param Sequence['FleetServerProcess'] server_processes: A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        if game_session_activation_timeout_seconds is not None:
            pulumi.set(__self__, "game_session_activation_timeout_seconds", game_session_activation_timeout_seconds)
        if max_concurrent_game_session_activations is not None:
            pulumi.set(__self__, "max_concurrent_game_session_activations", max_concurrent_game_session_activations)
        if server_processes is not None:
            pulumi.set(__self__, "server_processes", server_processes)

    @property
    @pulumi.getter(name="gameSessionActivationTimeoutSeconds")
    def game_session_activation_timeout_seconds(self) -> Optional[int]:
        """
        The maximum amount of time (in seconds) that a game session can remain in status ACTIVATING. If the game session is not active before the timeout, activation is terminated and the game session status is changed to TERMINATED.
        """
        return pulumi.get(self, "game_session_activation_timeout_seconds")

    @property
    @pulumi.getter(name="maxConcurrentGameSessionActivations")
    def max_concurrent_game_session_activations(self) -> Optional[int]:
        """
        The maximum number of game sessions with status ACTIVATING to allow on an instance simultaneously. This setting limits the amount of instance resources that can be used for new game activations at any one time.
        """
        return pulumi.get(self, "max_concurrent_game_session_activations")

    @property
    @pulumi.getter(name="serverProcesses")
    def server_processes(self) -> Optional[Sequence['outputs.FleetServerProcess']]:
        """
        A collection of server process configurations that describe which server processes to run on each instance in a fleet.
        """
        return pulumi.get(self, "server_processes")


@pulumi.output_type
class FleetServerProcess(dict):
    """
    A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "concurrentExecutions":
            suggest = "concurrent_executions"
        elif key == "launchPath":
            suggest = "launch_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FleetServerProcess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FleetServerProcess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FleetServerProcess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 concurrent_executions: int,
                 launch_path: str,
                 parameters: Optional[str] = None):
        """
        A set of instructions for launching server processes on each instance in a fleet. Each instruction set identifies the location of the server executable, optional launch parameters, and the number of server processes with this configuration to maintain concurrently on the instance. Server process configurations make up a fleet's RuntimeConfiguration.
        :param int concurrent_executions: The number of server processes that use this configuration to run concurrently on an instance.
        :param str launch_path: The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:
               
               Windows (for custom game builds only): C:\game. Example: "C:\game\MyGame\server.exe"
               
               Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        :param str parameters: An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        pulumi.set(__self__, "concurrent_executions", concurrent_executions)
        pulumi.set(__self__, "launch_path", launch_path)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="concurrentExecutions")
    def concurrent_executions(self) -> int:
        """
        The number of server processes that use this configuration to run concurrently on an instance.
        """
        return pulumi.get(self, "concurrent_executions")

    @property
    @pulumi.getter(name="launchPath")
    def launch_path(self) -> str:
        """
        The location of the server executable in a custom game build or the name of the Realtime script file that contains the Init() function. Game builds and Realtime scripts are installed on instances at the root:

        Windows (for custom game builds only): C:\game. Example: "C:\game\MyGame\server.exe"

        Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
        """
        return pulumi.get(self, "launch_path")

    @property
    @pulumi.getter
    def parameters(self) -> Optional[str]:
        """
        An optional list of parameters to pass to the server executable or Realtime script on launch.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class GameServerGroupAutoScalingPolicy(dict):
    """
    Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetTrackingConfiguration":
            suggest = "target_tracking_configuration"
        elif key == "estimatedInstanceWarmup":
            suggest = "estimated_instance_warmup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupAutoScalingPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupAutoScalingPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupAutoScalingPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_tracking_configuration: 'outputs.GameServerGroupTargetTrackingConfiguration',
                 estimated_instance_warmup: Optional[float] = None):
        """
        Configuration settings to define a scaling policy for the Auto Scaling group that is optimized for game hosting
        """
        pulumi.set(__self__, "target_tracking_configuration", target_tracking_configuration)
        if estimated_instance_warmup is not None:
            pulumi.set(__self__, "estimated_instance_warmup", estimated_instance_warmup)

    @property
    @pulumi.getter(name="targetTrackingConfiguration")
    def target_tracking_configuration(self) -> 'outputs.GameServerGroupTargetTrackingConfiguration':
        return pulumi.get(self, "target_tracking_configuration")

    @property
    @pulumi.getter(name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> Optional[float]:
        return pulumi.get(self, "estimated_instance_warmup")


@pulumi.output_type
class GameServerGroupInstanceDefinition(dict):
    """
    An allowed instance type for your game server group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupInstanceDefinition. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupInstanceDefinition.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupInstanceDefinition.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: str,
                 weighted_capacity: Optional[str] = None):
        """
        An allowed instance type for your game server group.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[str]:
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class GameServerGroupLaunchTemplate(dict):
    """
    The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupLaunchTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupLaunchTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupLaunchTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_id: Optional[str] = None,
                 launch_template_name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        The EC2 launch template that contains configuration settings and game server code to be deployed to all instances in the game server group.
        """
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[str]:
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[str]:
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        return pulumi.get(self, "version")


@pulumi.output_type
class GameServerGroupTag(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The key for a developer-defined key:value pair for tagging an AWS resource.
        :param str value: The value for a developer-defined key:value pair for tagging an AWS resource.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key for a developer-defined key:value pair for tagging an AWS resource.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value for a developer-defined key:value pair for tagging an AWS resource.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GameServerGroupTargetTrackingConfiguration(dict):
    """
    Settings for a target-based scaling policy applied to Auto Scaling group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameServerGroupTargetTrackingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameServerGroupTargetTrackingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameServerGroupTargetTrackingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float):
        """
        Settings for a target-based scaling policy applied to Auto Scaling group.
        """
        pulumi.set(__self__, "target_value", target_value)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        return pulumi.get(self, "target_value")


@pulumi.output_type
class GameSessionQueueDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationArn":
            suggest = "destination_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueueDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueueDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueueDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_arn: Optional[str] = None):
        if destination_arn is not None:
            pulumi.set(__self__, "destination_arn", destination_arn)

    @property
    @pulumi.getter(name="destinationArn")
    def destination_arn(self) -> Optional[str]:
        return pulumi.get(self, "destination_arn")


@pulumi.output_type
class GameSessionQueueFilterConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedLocations":
            suggest = "allowed_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueueFilterConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueueFilterConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueueFilterConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_locations: Optional[Sequence[str]] = None):
        if allowed_locations is not None:
            pulumi.set(__self__, "allowed_locations", allowed_locations)

    @property
    @pulumi.getter(name="allowedLocations")
    def allowed_locations(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "allowed_locations")


@pulumi.output_type
class GameSessionQueuePlayerLatencyPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumIndividualPlayerLatencyMilliseconds":
            suggest = "maximum_individual_player_latency_milliseconds"
        elif key == "policyDurationSeconds":
            suggest = "policy_duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueuePlayerLatencyPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueuePlayerLatencyPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueuePlayerLatencyPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 maximum_individual_player_latency_milliseconds: Optional[int] = None,
                 policy_duration_seconds: Optional[int] = None):
        if maximum_individual_player_latency_milliseconds is not None:
            pulumi.set(__self__, "maximum_individual_player_latency_milliseconds", maximum_individual_player_latency_milliseconds)
        if policy_duration_seconds is not None:
            pulumi.set(__self__, "policy_duration_seconds", policy_duration_seconds)

    @property
    @pulumi.getter(name="maximumIndividualPlayerLatencyMilliseconds")
    def maximum_individual_player_latency_milliseconds(self) -> Optional[int]:
        return pulumi.get(self, "maximum_individual_player_latency_milliseconds")

    @property
    @pulumi.getter(name="policyDurationSeconds")
    def policy_duration_seconds(self) -> Optional[int]:
        return pulumi.get(self, "policy_duration_seconds")


@pulumi.output_type
class GameSessionQueuePriorityConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationOrder":
            suggest = "location_order"
        elif key == "priorityOrder":
            suggest = "priority_order"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GameSessionQueuePriorityConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GameSessionQueuePriorityConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GameSessionQueuePriorityConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location_order: Optional[Sequence[str]] = None,
                 priority_order: Optional[Sequence[str]] = None):
        if location_order is not None:
            pulumi.set(__self__, "location_order", location_order)
        if priority_order is not None:
            pulumi.set(__self__, "priority_order", priority_order)

    @property
    @pulumi.getter(name="locationOrder")
    def location_order(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "location_order")

    @property
    @pulumi.getter(name="priorityOrder")
    def priority_order(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "priority_order")


@pulumi.output_type
class GameSessionQueueTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class MatchmakingConfigurationGameProperty(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class MatchmakingConfigurationTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class MatchmakingRuleSetTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ScriptS3Location(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "roleArn":
            suggest = "role_arn"
        elif key == "objectVersion":
            suggest = "object_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScriptS3Location. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScriptS3Location.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScriptS3Location.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 key: str,
                 role_arn: str,
                 object_version: Optional[str] = None):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "role_arn", role_arn)
        if object_version is not None:
            pulumi.set(__self__, "object_version", object_version)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> str:
        return pulumi.get(self, "role_arn")

    @property
    @pulumi.getter(name="objectVersion")
    def object_version(self) -> Optional[str]:
        return pulumi.get(self, "object_version")


@pulumi.output_type
class ScriptTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


