# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodegroupArgs', 'Nodegroup']

@pulumi.input_type
class NodegroupArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[str],
                 node_role: pulumi.Input[str],
                 subnets: pulumi.Input[Sequence[pulumi.Input[str]]],
                 ami_type: Optional[pulumi.Input[str]] = None,
                 capacity_type: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 force_update_enabled: Optional[pulumi.Input[bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[Any] = None,
                 launch_template: Optional[pulumi.Input['NodegroupLaunchTemplateSpecificationArgs']] = None,
                 nodegroup_name: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 remote_access: Optional[pulumi.Input['NodegroupRemoteAccessArgs']] = None,
                 scaling_config: Optional[pulumi.Input['NodegroupScalingConfigArgs']] = None,
                 tags: Optional[Any] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input['NodegroupTaintArgs']]]] = None,
                 update_config: Optional[pulumi.Input['NodegroupUpdateConfigArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Nodegroup resource.
        :param pulumi.Input[str] cluster_name: Name of the cluster to create the node group in.
        :param pulumi.Input[str] node_role: The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: The subnets to use for the Auto Scaling group that is created for your node group.
        :param pulumi.Input[str] ami_type: The AMI type for your node group.
        :param pulumi.Input[str] capacity_type: The capacity type of your managed node group.
        :param pulumi.Input[int] disk_size: The root device disk size (in GiB) for your node group instances.
        :param pulumi.Input[bool] force_update_enabled: Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Specify the instance types for a node group.
        :param Any labels: The Kubernetes labels to be applied to the nodes in the node group when they are created.
        :param pulumi.Input['NodegroupLaunchTemplateSpecificationArgs'] launch_template: An object representing a node group's launch template specification.
        :param pulumi.Input[str] nodegroup_name: The unique name to give your node group.
        :param pulumi.Input[str] release_version: The AMI version of the Amazon EKS-optimized AMI to use with your node group.
        :param pulumi.Input['NodegroupRemoteAccessArgs'] remote_access: The remote access (SSH) configuration to use with your node group.
        :param pulumi.Input['NodegroupScalingConfigArgs'] scaling_config: The scaling configuration details for the Auto Scaling group that is created for your node group.
        :param Any tags: The metadata, as key-value pairs, to apply to the node group to assist with categorization and organization. Follows same schema as Labels for consistency.
        :param pulumi.Input[Sequence[pulumi.Input['NodegroupTaintArgs']]] taints: The Kubernetes taints to be applied to the nodes in the node group when they are created.
        :param pulumi.Input['NodegroupUpdateConfigArgs'] update_config: The node group update configuration.
        :param pulumi.Input[str] version: The Kubernetes version to use for your managed nodes.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "node_role", node_role)
        pulumi.set(__self__, "subnets", subnets)
        if ami_type is not None:
            pulumi.set(__self__, "ami_type", ami_type)
        if capacity_type is not None:
            pulumi.set(__self__, "capacity_type", capacity_type)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if force_update_enabled is not None:
            pulumi.set(__self__, "force_update_enabled", force_update_enabled)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_template is not None:
            pulumi.set(__self__, "launch_template", launch_template)
        if nodegroup_name is not None:
            pulumi.set(__self__, "nodegroup_name", nodegroup_name)
        if release_version is not None:
            pulumi.set(__self__, "release_version", release_version)
        if remote_access is not None:
            pulumi.set(__self__, "remote_access", remote_access)
        if scaling_config is not None:
            pulumi.set(__self__, "scaling_config", scaling_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)
        if update_config is not None:
            pulumi.set(__self__, "update_config", update_config)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        Name of the cluster to create the node group in.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> pulumi.Input[str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
        """
        return pulumi.get(self, "node_role")

    @node_role.setter
    def node_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_role", value)

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The subnets to use for the Auto Scaling group that is created for your node group.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI type for your node group.
        """
        return pulumi.get(self, "ami_type")

    @ami_type.setter
    def ami_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ami_type", value)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> Optional[pulumi.Input[str]]:
        """
        The capacity type of your managed node group.
        """
        return pulumi.get(self, "capacity_type")

    @capacity_type.setter
    def capacity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_type", value)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The root device disk size (in GiB) for your node group instances.
        """
        return pulumi.get(self, "disk_size")

    @disk_size.setter
    def disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size", value)

    @property
    @pulumi.getter(name="forceUpdateEnabled")
    def force_update_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
        """
        return pulumi.get(self, "force_update_enabled")

    @force_update_enabled.setter
    def force_update_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_update_enabled", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specify the instance types for a node group.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[Any]:
        """
        The Kubernetes labels to be applied to the nodes in the node group when they are created.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[Any]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> Optional[pulumi.Input['NodegroupLaunchTemplateSpecificationArgs']]:
        """
        An object representing a node group's launch template specification.
        """
        return pulumi.get(self, "launch_template")

    @launch_template.setter
    def launch_template(self, value: Optional[pulumi.Input['NodegroupLaunchTemplateSpecificationArgs']]):
        pulumi.set(self, "launch_template", value)

    @property
    @pulumi.getter(name="nodegroupName")
    def nodegroup_name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name to give your node group.
        """
        return pulumi.get(self, "nodegroup_name")

    @nodegroup_name.setter
    def nodegroup_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nodegroup_name", value)

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[pulumi.Input[str]]:
        """
        The AMI version of the Amazon EKS-optimized AMI to use with your node group.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_version", value)

    @property
    @pulumi.getter(name="remoteAccess")
    def remote_access(self) -> Optional[pulumi.Input['NodegroupRemoteAccessArgs']]:
        """
        The remote access (SSH) configuration to use with your node group.
        """
        return pulumi.get(self, "remote_access")

    @remote_access.setter
    def remote_access(self, value: Optional[pulumi.Input['NodegroupRemoteAccessArgs']]):
        pulumi.set(self, "remote_access", value)

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> Optional[pulumi.Input['NodegroupScalingConfigArgs']]:
        """
        The scaling configuration details for the Auto Scaling group that is created for your node group.
        """
        return pulumi.get(self, "scaling_config")

    @scaling_config.setter
    def scaling_config(self, value: Optional[pulumi.Input['NodegroupScalingConfigArgs']]):
        pulumi.set(self, "scaling_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[Any]:
        """
        The metadata, as key-value pairs, to apply to the node group to assist with categorization and organization. Follows same schema as Labels for consistency.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[Any]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def taints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodegroupTaintArgs']]]]:
        """
        The Kubernetes taints to be applied to the nodes in the node group when they are created.
        """
        return pulumi.get(self, "taints")

    @taints.setter
    def taints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodegroupTaintArgs']]]]):
        pulumi.set(self, "taints", value)

    @property
    @pulumi.getter(name="updateConfig")
    def update_config(self) -> Optional[pulumi.Input['NodegroupUpdateConfigArgs']]:
        """
        The node group update configuration.
        """
        return pulumi.get(self, "update_config")

    @update_config.setter
    def update_config(self, value: Optional[pulumi.Input['NodegroupUpdateConfigArgs']]):
        pulumi.set(self, "update_config", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Kubernetes version to use for your managed nodes.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class Nodegroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_type: Optional[pulumi.Input[str]] = None,
                 capacity_type: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 force_update_enabled: Optional[pulumi.Input[bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[Any] = None,
                 launch_template: Optional[pulumi.Input[pulumi.InputType['NodegroupLaunchTemplateSpecificationArgs']]] = None,
                 node_role: Optional[pulumi.Input[str]] = None,
                 nodegroup_name: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 remote_access: Optional[pulumi.Input[pulumi.InputType['NodegroupRemoteAccessArgs']]] = None,
                 scaling_config: Optional[pulumi.Input[pulumi.InputType['NodegroupScalingConfigArgs']]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[Any] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodegroupTaintArgs']]]]] = None,
                 update_config: Optional[pulumi.Input[pulumi.InputType['NodegroupUpdateConfigArgs']]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource schema for AWS::EKS::Nodegroup

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ami_type: The AMI type for your node group.
        :param pulumi.Input[str] capacity_type: The capacity type of your managed node group.
        :param pulumi.Input[str] cluster_name: Name of the cluster to create the node group in.
        :param pulumi.Input[int] disk_size: The root device disk size (in GiB) for your node group instances.
        :param pulumi.Input[bool] force_update_enabled: Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Specify the instance types for a node group.
        :param Any labels: The Kubernetes labels to be applied to the nodes in the node group when they are created.
        :param pulumi.Input[pulumi.InputType['NodegroupLaunchTemplateSpecificationArgs']] launch_template: An object representing a node group's launch template specification.
        :param pulumi.Input[str] node_role: The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
        :param pulumi.Input[str] nodegroup_name: The unique name to give your node group.
        :param pulumi.Input[str] release_version: The AMI version of the Amazon EKS-optimized AMI to use with your node group.
        :param pulumi.Input[pulumi.InputType['NodegroupRemoteAccessArgs']] remote_access: The remote access (SSH) configuration to use with your node group.
        :param pulumi.Input[pulumi.InputType['NodegroupScalingConfigArgs']] scaling_config: The scaling configuration details for the Auto Scaling group that is created for your node group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: The subnets to use for the Auto Scaling group that is created for your node group.
        :param Any tags: The metadata, as key-value pairs, to apply to the node group to assist with categorization and organization. Follows same schema as Labels for consistency.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodegroupTaintArgs']]]] taints: The Kubernetes taints to be applied to the nodes in the node group when they are created.
        :param pulumi.Input[pulumi.InputType['NodegroupUpdateConfigArgs']] update_config: The node group update configuration.
        :param pulumi.Input[str] version: The Kubernetes version to use for your managed nodes.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodegroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource schema for AWS::EKS::Nodegroup

        :param str resource_name: The name of the resource.
        :param NodegroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodegroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ami_type: Optional[pulumi.Input[str]] = None,
                 capacity_type: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 disk_size: Optional[pulumi.Input[int]] = None,
                 force_update_enabled: Optional[pulumi.Input[bool]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[Any] = None,
                 launch_template: Optional[pulumi.Input[pulumi.InputType['NodegroupLaunchTemplateSpecificationArgs']]] = None,
                 node_role: Optional[pulumi.Input[str]] = None,
                 nodegroup_name: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 remote_access: Optional[pulumi.Input[pulumi.InputType['NodegroupRemoteAccessArgs']]] = None,
                 scaling_config: Optional[pulumi.Input[pulumi.InputType['NodegroupScalingConfigArgs']]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[Any] = None,
                 taints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodegroupTaintArgs']]]]] = None,
                 update_config: Optional[pulumi.Input[pulumi.InputType['NodegroupUpdateConfigArgs']]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodegroupArgs.__new__(NodegroupArgs)

            __props__.__dict__["ami_type"] = ami_type
            __props__.__dict__["capacity_type"] = capacity_type
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["disk_size"] = disk_size
            __props__.__dict__["force_update_enabled"] = force_update_enabled
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["labels"] = labels
            __props__.__dict__["launch_template"] = launch_template
            if node_role is None and not opts.urn:
                raise TypeError("Missing required property 'node_role'")
            __props__.__dict__["node_role"] = node_role
            __props__.__dict__["nodegroup_name"] = nodegroup_name
            __props__.__dict__["release_version"] = release_version
            __props__.__dict__["remote_access"] = remote_access
            __props__.__dict__["scaling_config"] = scaling_config
            if subnets is None and not opts.urn:
                raise TypeError("Missing required property 'subnets'")
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["tags"] = tags
            __props__.__dict__["taints"] = taints
            __props__.__dict__["update_config"] = update_config
            __props__.__dict__["version"] = version
            __props__.__dict__["arn"] = None
        super(Nodegroup, __self__).__init__(
            'aws-native:eks:Nodegroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Nodegroup':
        """
        Get an existing Nodegroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = NodegroupArgs.__new__(NodegroupArgs)

        __props__.__dict__["ami_type"] = None
        __props__.__dict__["arn"] = None
        __props__.__dict__["capacity_type"] = None
        __props__.__dict__["cluster_name"] = None
        __props__.__dict__["disk_size"] = None
        __props__.__dict__["force_update_enabled"] = None
        __props__.__dict__["instance_types"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["launch_template"] = None
        __props__.__dict__["node_role"] = None
        __props__.__dict__["nodegroup_name"] = None
        __props__.__dict__["release_version"] = None
        __props__.__dict__["remote_access"] = None
        __props__.__dict__["scaling_config"] = None
        __props__.__dict__["subnets"] = None
        __props__.__dict__["tags"] = None
        __props__.__dict__["taints"] = None
        __props__.__dict__["update_config"] = None
        __props__.__dict__["version"] = None
        return Nodegroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="amiType")
    def ami_type(self) -> pulumi.Output[Optional[str]]:
        """
        The AMI type for your node group.
        """
        return pulumi.get(self, "ami_type")

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> pulumi.Output[Optional[str]]:
        """
        The capacity type of your managed node group.
        """
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        Name of the cluster to create the node group in.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> pulumi.Output[Optional[int]]:
        """
        The root device disk size (in GiB) for your node group instances.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="forceUpdateEnabled")
    def force_update_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Force the update if the existing node group's pods are unable to be drained due to a pod disruption budget issue.
        """
        return pulumi.get(self, "force_update_enabled")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specify the instance types for a node group.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Any]]:
        """
        The Kubernetes labels to be applied to the nodes in the node group when they are created.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> pulumi.Output[Optional['outputs.NodegroupLaunchTemplateSpecification']]:
        """
        An object representing a node group's launch template specification.
        """
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="nodeRole")
    def node_role(self) -> pulumi.Output[str]:
        """
        The Amazon Resource Name (ARN) of the IAM role to associate with your node group.
        """
        return pulumi.get(self, "node_role")

    @property
    @pulumi.getter(name="nodegroupName")
    def nodegroup_name(self) -> pulumi.Output[Optional[str]]:
        """
        The unique name to give your node group.
        """
        return pulumi.get(self, "nodegroup_name")

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> pulumi.Output[Optional[str]]:
        """
        The AMI version of the Amazon EKS-optimized AMI to use with your node group.
        """
        return pulumi.get(self, "release_version")

    @property
    @pulumi.getter(name="remoteAccess")
    def remote_access(self) -> pulumi.Output[Optional['outputs.NodegroupRemoteAccess']]:
        """
        The remote access (SSH) configuration to use with your node group.
        """
        return pulumi.get(self, "remote_access")

    @property
    @pulumi.getter(name="scalingConfig")
    def scaling_config(self) -> pulumi.Output[Optional['outputs.NodegroupScalingConfig']]:
        """
        The scaling configuration details for the Auto Scaling group that is created for your node group.
        """
        return pulumi.get(self, "scaling_config")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        The subnets to use for the Auto Scaling group that is created for your node group.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Any]]:
        """
        The metadata, as key-value pairs, to apply to the node group to assist with categorization and organization. Follows same schema as Labels for consistency.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> pulumi.Output[Optional[Sequence['outputs.NodegroupTaint']]]:
        """
        The Kubernetes taints to be applied to the nodes in the node group when they are created.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="updateConfig")
    def update_config(self) -> pulumi.Output[Optional['outputs.NodegroupUpdateConfig']]:
        """
        The node group update configuration.
        """
        return pulumi.get(self, "update_config")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[str]]:
        """
        The Kubernetes version to use for your managed nodes.
        """
        return pulumi.get(self, "version")

